/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.xml.link;

import com.harrand.coreclasses.xml.IXmlCtrl;
import com.harrand.sketch.core.Link;
import com.harrand.sketch.relation.line.LineAnchorRectFinder;
import com.harrand.sketch.relation.line.LineRole;
import com.harrand.sketch.relation.line.PositionableLine;
import com.harrand.sketch.relation.rect.LinkRect;
import com.harrand.util.XmlHelper;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class PositionableLineXmlCtrl
implements IXmlCtrl {
    public static final String POSITIONABLE_LINE_NM = "positionableLine";
    public static final String POSITIONABLE_LINES_NM = "positionableLines";
    public static final String LINE_ROLE_NM = "lineRole";
    public static final String X1_NM = "x1";
    public static final String Y1_NM = "y1";
    public static final String X2_NM = "x2";
    public static final String Y2_NM = "y2";

    public Element asXmlElement(Document doc, List<PositionableLine> lines) {
        Element elmLines = doc.createElement(POSITIONABLE_LINES_NM);
        for (PositionableLine line : lines) {
            Element elmLine = doc.createElement(POSITIONABLE_LINE_NM);
            XmlHelper.setAttr(elmLine, X1_NM, (int)line.getX1());
            XmlHelper.setAttr(elmLine, Y1_NM, (int)line.getY1());
            XmlHelper.setAttr(elmLine, X2_NM, (int)line.getX2());
            XmlHelper.setAttr(elmLine, Y2_NM, (int)line.getY2());
            elmLine.setAttribute(LINE_ROLE_NM, line.getLineRole().toString());
            elmLines.appendChild(elmLine);
        }
        return elmLines;
    }

    public static List<PositionableLine> fromXml(Link link, Element elmPositionableLines) {
        LineAnchorRectFinder anchorRectFinder = new LineAnchorRectFinder();
        ArrayList<PositionableLine> lines = new ArrayList<PositionableLine>();
        NodeList elms = elmPositionableLines.getElementsByTagName(POSITIONABLE_LINE_NM);
        for (int i = 0; i < elms.getLength(); ++i) {
            Element elmLine = (Element)elms.item(i);
            int x1 = XmlHelper.getAttrInt(elmLine, X1_NM);
            int y1 = XmlHelper.getAttrInt(elmLine, Y1_NM);
            Point2D.Double p1 = new Point2D.Double(x1, y1);
            int x2 = XmlHelper.getAttrInt(elmLine, X2_NM);
            int y2 = XmlHelper.getAttrInt(elmLine, Y2_NM);
            Point2D.Double p2 = new Point2D.Double(x2, y2);
            String lineRoleText = elmLine.getAttribute(LINE_ROLE_NM);
            LineRole lineRole = LineRole.valueOf(lineRoleText);
            LinkRect linkRect = anchorRectFinder.getAnchorRect(link, lineRole);
            PositionableLine line = new PositionableLine(p1, p2, linkRect, lineRole);
            lines.add(line);
        }
        return lines;
    }
}

