/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.xml.link;

import com.harrand.coreclasses.xml.IXmlCtrl;
import com.harrand.dbwrench.diagram.ForeignKeyGlyph;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.xml.link.PositionableLineXmlCtrl;
import com.harrand.sketch.core.Diagram;
import com.harrand.sketch.core.Link;
import com.harrand.sketch.linkStrategies.positioner.ILinkPositioner;
import com.harrand.sketch.linkStrategies.right_angle.positioner.user.LinkLineExtractor;
import com.harrand.sketch.linkStrategies.right_angle.positioner.user.OneLineUserLinkPositioner;
import com.harrand.sketch.linkStrategies.right_angle.positioner.user.ThreeLineUserLinkPositioner;
import com.harrand.sketch.linkStrategies.right_angle.positioner.user.TwoLineUserLinkPositioner;
import com.harrand.sketch.relation.line.PositionableLine;
import com.harrand.util.LogUtil;
import com.harrand.util.XmlHelper;
import java.util.List;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Deprecated
public final class LinkXmlCtrl
implements IXmlCtrl {
    private PositionableLineXmlCtrl positionableLineXmlCtrl = new PositionableLineXmlCtrl();
    public static final String LINK_NM = "link";
    public static final String POSITIONER_NM = "positioner";

    public Element asXmlElement(Document doc, ForeignKeyGlyph fkGlyph) {
        Element elmGlyph = doc.createElement(LINK_NM);
        this.setLinkPositioner(elmGlyph, fkGlyph);
        LinkLineExtractor lineExtractor = new LinkLineExtractor();
        List<PositionableLine> lines = lineExtractor.getPositionableLines(fkGlyph);
        Element elmLines = this.positionableLineXmlCtrl.asXmlElement(doc, lines);
        elmGlyph.appendChild(elmLines);
        return elmGlyph;
    }

    public static ForeignKeyGlyph fromXml(Element element, Database db, Diagram diagram) {
        String positionerClassName = element.getAttribute(POSITIONER_NM);
        ILinkPositioner positioner = LinkXmlCtrl.getPositioner(positionerClassName);
        ForeignKeyGlyph newGlyph = null;
        try {
            newGlyph.setDirtyTracker(db);
            newGlyph.setLinkPositioner(positioner);
            newGlyph.setShapes(LinkXmlCtrl.getLines(newGlyph, element));
        }
        catch (Exception e) {
            LogUtil.logErr("FkGlyphXmlCtrl.fromXml.error: " + e.getMessage());
        }
        return newGlyph;
    }

    private static ILinkPositioner getPositioner(String positionerClassName) {
        if (positionerClassName.equalsIgnoreCase(OneLineUserLinkPositioner.class.getSimpleName())) {
            return new OneLineUserLinkPositioner();
        }
        if (positionerClassName.equalsIgnoreCase(TwoLineUserLinkPositioner.class.getSimpleName())) {
            return new TwoLineUserLinkPositioner();
        }
        if (positionerClassName.equalsIgnoreCase(ThreeLineUserLinkPositioner.class.getSimpleName())) {
            return new ThreeLineUserLinkPositioner();
        }
        return null;
    }

    private static List getLines(Link link, Element elmLink) {
        PositionableLineXmlCtrl positionableLineXmlCtrl = new PositionableLineXmlCtrl();
        Element elmLines = XmlHelper.getFirstElementByTagName(elmLink, "positionableLines");
        return null;
    }

    private void setLinkPositioner(Element elmGlyph, ForeignKeyGlyph fkGlyph) throws DOMException {
        ILinkPositioner linkPositioner = fkGlyph.getLinkPositioner();
        String positionerClassName = linkPositioner != null ? linkPositioner.getClass().getSimpleName() : "";
        elmGlyph.setAttribute(POSITIONER_NM, positionerClassName);
    }
}

