/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.xml.link;

import com.harrand.sketch.relation.rect.LinkRect;
import com.harrand.util.XmlHelper;
import java.awt.geom.Rectangle2D;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class LinkRectXmlCtrl {
    public static final String TAG_NM = "linkRect";
    public static final String NAME_NM = "name";
    public static final String X_NM = "x";
    public static final String Y_NM = "y";
    public static final String W_NM = "w";
    public static final String H_NM = "h";

    public Element asXmlElement(Document doc, LinkRect linkRect) {
        Element elm = doc.createElement(TAG_NM);
        elm.setAttribute(NAME_NM, linkRect.getName());
        XmlHelper.setAttr(elm, X_NM, (int)linkRect.getX());
        XmlHelper.setAttr(elm, Y_NM, (int)linkRect.getY());
        XmlHelper.setAttr(elm, W_NM, (int)linkRect.getWidth());
        XmlHelper.setAttr(elm, H_NM, (int)linkRect.getHeight());
        return elm;
    }

    public static LinkRect fromXml(Element elm) {
        double x = XmlHelper.getAttrInt(elm, X_NM);
        double y = XmlHelper.getAttrInt(elm, Y_NM);
        double h = XmlHelper.getAttrInt(elm, H_NM);
        double w = XmlHelper.getAttrInt(elm, W_NM);
        Rectangle2D.Double rect = new Rectangle2D.Double(x, y, h, w);
        String name = elm.getAttribute(NAME_NM);
        LinkRect linkRect = new LinkRect(rect, name);
        return linkRect;
    }
}

