/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.xml.converter;

import com.harrand.coreclasses.display.BasicColorable;
import com.harrand.coreclasses.element.Cardinality;
import com.harrand.coreclasses.element.StringPair;
import com.harrand.coreclasses.element.Version;
import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.rename.Rename;
import com.harrand.coreclasses.rename.RenameChain;
import com.harrand.coreclasses.rename.RenameContext;
import com.harrand.coreclasses.rename.RenameMgr;
import com.harrand.dbwrench.diagram.DbTableGlyph;
import com.harrand.dbwrench.diagram.DbVerbosity;
import com.harrand.dbwrench.diagram.ForeignKeyGlyph;
import com.harrand.dbwrench.diagram.KeyToKeyStrategy;
import com.harrand.dbwrench.doc.DbDocOptionMgr;
import com.harrand.dbwrench.jdbc.BasicTypesSvr;
import com.harrand.dbwrench.jdbc.DataType;
import com.harrand.dbwrench.object.Column;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.ForeignKey;
import com.harrand.dbwrench.object.Index;
import com.harrand.dbwrench.object.PrimaryKey;
import com.harrand.dbwrench.object.Proc;
import com.harrand.dbwrench.object.Schema;
import com.harrand.dbwrench.object.Sequence;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrench.object.Trigger;
import com.harrand.dbwrench.object.View;
import com.harrand.dbwrench.object.index.IIndexColumn;
import com.harrand.dbwrench.xml.converter.FontConvPre132;
import com.harrand.sketch.core.Diagram;
import com.harrand.sketch.core.RenderConfig;
import com.harrand.sketch.core.VerbosityConfig;
import com.harrand.sketch.linkStrategies.LinkStrategy;
import com.harrand.sketch.linkStrategies.OffsetDirect;
import com.harrand.util.LogUtil;
import com.harrand.util.Validator;
import com.harrand.util.XmlHelper;
import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DbXmlPre134 {
    private Version fromVersion_;
    public static final String NAME = "nm";
    public static final String ID = "id";
    public static final String VERSION = "ver";
    public static final String COMMENT = "Cm";
    public static final String FILE_NM = "flnm";
    public static final String SQL = "Sql";
    public static final String SRC = "src";
    public static final String BK_COLOR = "bkCl";
    public static final String SCHEMA = "sch";
    public static final String DB = "Db";
    public static final String DOC_FLDR = "DocFolder";
    public static final String DEF_TBL_OPTS = "DefTblOpts";
    public static final String VER_LBL = "VerLbl";
    public static final String VER_NOTES = "VerNotes";
    public static final String CURRENT_VER_STR = "1.3.4";
    public static final String TBL_KEY = "Tbl";
    public static final String USER_SORT = "UsSo";
    public static final String TBL_OPTS = "TblOpts";
    public static final String COL_KEY = "Cl";
    public static final String NULLABLE = "nu";
    public static final String AUTO = "au";
    public static final String DEFAULT = "df";
    public static final String DT = "DT";
    public static final String DT_DESC = "ds";
    public static final String DT_ID = "id";
    public static final String LENGTH = "ln";
    public static final String SCALE = "sc";
    public static final String SIGNED = "sg";
    public static final String ENUMS = "en";
    public static final String IDX = "Idx";
    public static final String CLUSTERED = "clu";
    public static final String UNIQUE = "unq";
    public static final String COL_NAMES = "ClNs";
    public static final String TRG = "Trg";
    public static final String DEL = "del";
    public static final String INS = "ins";
    public static final String UPD = "upd";
    public static final String EXEC_BEFORE = "exBe";
    public static final String EACH_ROW = "eaRow";
    public static final String PK = "Pk";
    public static final String PK_COL_NAMES = "ClNs";
    public static final String FK = "Fk";
    public static final String FK_NAME = "Name";
    public static final String PAR_TBL = "PrTb";
    public static final String CHD_TBL = "CdTb";
    public static final String COL_PAIR = "ClPr";
    public static final String PAR_COL = "prCl";
    public static final String CHD_COL = "cdCl";
    public static final String PAR_LK_COL_NM = "prLkCl";
    public static final String DEL_ACT = "deAc";
    public static final String ZERO = "zr";
    public static final String ONE = "oe";
    public static final String MANY = "mn";
    public static final String RNM_CHAIN_XML = "RnmCh";
    public static final String OBJ_CLS_XML = "ObjCls";
    public static final String PAR_CLS_XML = "ParCls";
    public static final String PAR_NM_XML = "ParNme";
    public static final String RNM_MGR_XML = "RnmMgr";
    public static final String NEXT_RNM_ID_XML = "NxRnmId";
    public static final Version ADJUSTABLE_FONT_VER = new Version("1.3.2");
    public static final String DIAGRAM = "Dgm";
    public static final String RENDER_CFG = "RnCf";
    public static final String ZOOM = "zm";
    public static final String LINK_STRATEGY = "lkStgy";
    public static final String FONT_SIZE = "FtSz";
    public static final String VB_CFG = "VbCfg";
    public static final String FLAG = "Fg";
    public static final String KEY = "ky";
    public static final String VALUE = "vl";
    public static final String DB_TBL_GLYPH = "TbGl";
    public static final String X = "x";
    public static final String Y = "y";
    public static final String TBL = "tbl";
    public static final String FK_GLYPH = "FkGl";
    public static final String PROC = "Proc";
    public static final String SEQ = "Seq";
    public static final String INCR = "incr";
    public static final String VIEW = "View";

    public DbXmlPre134(Version fromVersion) {
        this.fromVersion_ = fromVersion;
    }

    public Database getDatabase(Element element) {
        String name = element.getAttribute(NAME);
        Database newDb = null;
        try {
            int i;
            newDb = new Database(name);
            newDb.setVersionLabel(XmlHelper.getFirstElementValue(element, VER_LBL));
            newDb.setVersionNotes(XmlHelper.getFirstElementValue(element, VER_NOTES));
            newDb.setDefaultTableOpts(XmlHelper.getFirstElementValue(element, DEF_TBL_OPTS));
            String docFilePath = XmlHelper.getFirstElementValue(element, DOC_FLDR);
            newDb.setDocFolder(new File(docFilePath));
            String fileName = element.getAttribute(FILE_NM);
            if (Validator.isStringValid(fileName)) {
                newDb.setFileName(fileName);
            }
            Element elmDocOptionMgr = XmlHelper.getFirstElementByTagName(element, DbDocOptionMgr.clazz());
            DbDocOptionMgr docOptionMgr = DbDocOptionMgr.fromXml(elmDocOptionMgr, newDb);
            newDb.setDocOptionMagr(docOptionMgr);
            Element elmRenameMgr = XmlHelper.getFirstElementByTagName(element, RNM_MGR_XML);
            if (elmRenameMgr != null) {
                RenameMgr renameMgr = this.getRenameMgr(elmRenameMgr);
                newDb.setRenameMgr(renameMgr);
            }
            String tagName = "";
            this.loadDefaultSchema(newDb, element);
            tagName = FK;
            NodeList list = element.getElementsByTagName(tagName);
            for (i = 0; i < list.getLength(); ++i) {
                ForeignKey fk = this.getForiegnKey(newDb, (Element)list.item(i));
                Table chdTbl = fk.getChdTbl();
                chdTbl.add(fk);
            }
            tagName = DIAGRAM;
            list = element.getElementsByTagName(tagName);
            for (i = 0; i < list.getLength(); ++i) {
                newDb.add(this.getDiagram(newDb, (Element)list.item(i)));
            }
        }
        catch (Exception e) {
            LogUtil.logErr("DbXmlPre134.getDb.error: " + e.getMessage());
        }
        return newDb;
    }

    private void loadDefaultSchema(Database db, Element element) {
        Schema schema = db.getSchema("schemaA");
        try {
            int i;
            String tagName = "";
            tagName = TBL_KEY;
            NodeList list = element.getElementsByTagName(tagName);
            for (i = 0; i < list.getLength(); ++i) {
                Element tblElement = (Element)list.item(i);
                Table tbl = this.getTable(tblElement);
                schema.add(tbl);
            }
            tagName = VIEW;
            list = element.getElementsByTagName(tagName);
            for (i = 0; i < list.getLength(); ++i) {
                schema.add(this.getView((Element)list.item(i)));
            }
            tagName = PROC;
            list = element.getElementsByTagName(tagName);
            for (i = 0; i < list.getLength(); ++i) {
                schema.add(this.getProc((Element)list.item(i)));
            }
            tagName = SEQ;
            list = element.getElementsByTagName(tagName);
            for (i = 0; i < list.getLength(); ++i) {
                schema.add(this.getSequence((Element)list.item(i)));
            }
        }
        catch (Exception e) {
            LogUtil.logErr("DbXmlPre134.loadSchema.error: " + e.getMessage());
        }
    }

    private Table getTable(Element element) {
        String name = element.getAttribute(NAME);
        Table newTbl = null;
        try {
            int i;
            newTbl = new Table(name);
            Object className = null;
            boolean userSort = XmlHelper.getAttrBoolFromInt(element, USER_SORT);
            newTbl.setUseManualSort(userSort);
            String comment = XmlHelper.getConditionComment(element);
            newTbl.setComment(comment);
            Element elmTableOpts = XmlHelper.getFirstElementByTagName(element, TBL_OPTS);
            String tableOpts = elmTableOpts != null ? XmlHelper.getElementValue(elmTableOpts) : "";
            newTbl.setTableOptions(tableOpts);
            String tagName = COL_KEY;
            NodeList list = element.getElementsByTagName(tagName);
            for (i = 0; i < list.getLength(); ++i) {
                newTbl.add(this.getColumn((Element)list.item(i)));
            }
            list = element.getElementsByTagName(PK);
            if (list.getLength() > 0) {
                newTbl.setPrimaryKey(this.getPrimaryKey((Element)list.item(0)));
            }
            tagName = IDX;
            list = element.getElementsByTagName(tagName);
            for (i = 0; i < list.getLength(); ++i) {
                newTbl.add(this.getIndex(newTbl, (Element)list.item(i)));
            }
            tagName = TRG;
            list = element.getElementsByTagName(tagName);
            for (i = 0; i < list.getLength(); ++i) {
                newTbl.add(this.getTrigger((Element)list.item(i)));
            }
        }
        catch (Exception e) {
            LogUtil.logErr("DbXmlPre134.getTable.err: " + e.getMessage());
        }
        return newTbl;
    }

    private Column getColumn(Element element) {
        String lengthStr;
        String name = element.getAttribute(NAME);
        boolean isNullable = XmlHelper.getAttrBoolFromInt(element, NULLABLE);
        boolean isAutoNumber = XmlHelper.getAttrBoolFromInt(element, AUTO);
        String defaultStr = element.getAttribute(DEFAULT);
        Element elmDataType = XmlHelper.getFirstElementByTagName(element, DT);
        int dataTypeId = XmlHelper.getAttrInt(elmDataType, "id");
        if (dataTypeId == -4) {
            dataTypeId = 2004;
        }
        if (dataTypeId == -1) {
            dataTypeId = 703;
        }
        DataType dataType = BasicTypesSvr.instance().getType(dataTypeId);
        boolean signed = XmlHelper.getAttrBoolFromInt(elmDataType, SIGNED);
        String enums = elmDataType.getAttribute(ENUMS);
        Integer length = null;
        Integer scale = null;
        if (dataType.isLengthUsed() && StrHelper.isInteger(lengthStr = elmDataType.getAttribute(LENGTH))) {
            length = new Integer(lengthStr);
        }
        if (dataType.isScaleUsed()) {
            String scaleStr = elmDataType.getAttribute(SCALE);
            scale = StrHelper.isInteger(scaleStr) ? new Integer(scaleStr) : new Integer(0);
        }
        String comment = XmlHelper.getConditionComment(element);
        Column newColumn = null;
        try {
            newColumn = new Column(name, dataTypeId, length, isNullable, isAutoNumber, defaultStr, scale, comment, signed, enums);
        }
        catch (Exception e) {
            LogUtil.logErr("DbXmlPre134.getColumn.error: " + e.getMessage());
        }
        return newColumn;
    }

    private Index getIndex(Table table, Element element) {
        String name = element.getAttribute(NAME);
        boolean unique = XmlHelper.getAttrBoolFromInt(element, UNIQUE);
        boolean clustered = XmlHelper.getAttrBoolFromInt(element, CLUSTERED);
        String colNameCsv = XmlHelper.getFirstElementValue(element, "ClNs");
        ArrayList<IIndexColumn> lcolumns = new ArrayList<IIndexColumn>();
        ArrayList<String> colNames = new ArrayList<String>(Arrays.asList(colNameCsv.split(", ")));
        for (Object e : colNames) {
            String colNm = e.toString();
            Column column = table.getColumn(colNm);
            lcolumns.add(column);
        }
        Index newIdx = null;
        try {
            newIdx = new Index(name, lcolumns, clustered, unique);
        }
        catch (Exception exception) {
            LogUtil.logErr("DbXmlPre134.getIndex.error: " + exception.getMessage());
        }
        return newIdx;
    }

    private Trigger getTrigger(Element element) {
        String name = element.getAttribute(NAME);
        boolean del = XmlHelper.getAttrBoolFromInt(element, DEL);
        boolean ins = XmlHelper.getAttrBoolFromInt(element, INS);
        boolean upd = XmlHelper.getAttrBoolFromInt(element, UPD);
        boolean execBefore = XmlHelper.getAttrBoolFromInt(element, EXEC_BEFORE);
        boolean eachRow = XmlHelper.getAttrBoolFromInt(element, EACH_ROW);
        String sql = XmlHelper.getFirstElementValue(element, SQL);
        Trigger newTrg = null;
        try {
            newTrg = new Trigger(name, del, ins, upd, sql, execBefore, eachRow);
        }
        catch (Exception e) {
            LogUtil.logErr("DbXmlPre134.getTrigger.error: " + e.getMessage());
        }
        return newTrg;
    }

    private PrimaryKey getPrimaryKey(Element element) {
        String name = element.getAttribute(NAME);
        String colNameCsv = element.getAttribute("ClNs");
        ArrayList<String> columnNames = new ArrayList<String>(Arrays.asList(colNameCsv.split(", ")));
        PrimaryKey newPk = null;
        try {
            newPk = new PrimaryKey(name, columnNames);
        }
        catch (Exception e) {
            LogUtil.logErr("DbXmlPre134.getPk.error: " + e.getMessage());
        }
        return newPk;
    }

    private ForeignKey getForiegnKey(Database db, Element element) {
        String name = element.getAttribute(NAME);
        String parLinkCol = element.getAttribute(PAR_LK_COL_NM);
        int delActId = XmlHelper.getAttrInt(element, DEL_ACT);
        Schema schema = db.getSchema("schemaA");
        Element elmParTbl = XmlHelper.getFirstElementByTagName(element, PAR_TBL);
        String parTblNm = elmParTbl.getAttribute(NAME);
        Table parTbl = schema.getTable(parTblNm);
        Element elmChdTbl = XmlHelper.getFirstElementByTagName(element, CHD_TBL);
        String chdTblNm = elmChdTbl.getAttribute(NAME);
        Table chdTbl = schema.getTable(chdTblNm);
        boolean chdZero = XmlHelper.getAttrBoolFromInt(elmChdTbl, ZERO);
        boolean chdOne = XmlHelper.getAttrBoolFromInt(elmChdTbl, ONE);
        boolean chdMany = XmlHelper.getAttrBoolFromInt(elmChdTbl, MANY);
        Cardinality chdCardi = new Cardinality(chdZero, chdOne, chdMany);
        ArrayList<StringPair> fkCols = new ArrayList<StringPair>();
        String tagName = COL_PAIR;
        NodeList list = element.getElementsByTagName(tagName);
        for (int i = 0; i < list.getLength(); ++i) {
            Element elmColPair = (Element)list.item(i);
            String parCol = elmColPair.getAttribute(PAR_COL);
            String chdCol = elmColPair.getAttribute(CHD_COL);
            fkCols.add(new StringPair(parCol, chdCol));
        }
        String comment = XmlHelper.getConditionComment(element);
        ForeignKey newFk = null;
        try {
            newFk = new ForeignKey(name, parTbl, chdTbl, fkCols, delActId, 3, comment, chdCardi, parLinkCol);
        }
        catch (Exception e) {
            LogUtil.logErr("DbXmlPre134.getFk.error: " + e.getMessage());
        }
        return newFk;
    }

    private RenameMgr getRenameMgr(Element elmMgr) {
        int nextRnmId = XmlHelper.getAttrInt(elmMgr, NEXT_RNM_ID_XML);
        ArrayList<RenameChain> newChains = new ArrayList<RenameChain>();
        NodeList nl = elmMgr.getElementsByTagName(RNM_CHAIN_XML);
        for (int i = 0; i < nl.getLength(); ++i) {
            Element elmChain = (Element)nl.item(i);
            newChains.add(this.getRenameChain(elmChain));
        }
        RenameMgr newMgr = new RenameMgr(nextRnmId, newChains);
        return newMgr;
    }

    private RenameChain getRenameChain(Element elmChain) {
        String supCls;
        String supNm;
        String objCls = XmlHelper.getAttrNullable(elmChain, OBJ_CLS_XML);
        String parNm = XmlHelper.getAttrNullable(elmChain, PAR_NM_XML);
        String parCls = XmlHelper.getAttrNullable(elmChain, PAR_CLS_XML);
        if (parCls.equalsIgnoreCase(Table.getClassName())) {
            supNm = "schemaA";
            supCls = Schema.getClassName();
        } else {
            parNm = "schemaA";
            parCls = Schema.getClassName();
            supNm = "";
            supCls = "";
        }
        RenameContext ctx = new RenameContext(objCls, parNm, parCls, supNm, supCls);
        RenameChain newChain = new RenameChain(ctx);
        NodeList nl = elmChain.getElementsByTagName("Rnm");
        for (int i = nl.getLength() - 1; i >= 0; --i) {
            Element elmRnm = (Element)nl.item(i);
            newChain.addRename(Rename.fromXml(elmRnm));
        }
        return newChain;
    }

    private Diagram getDiagram(Database db, Element element) {
        String name = element.getAttribute(NAME);
        Element elmRc = XmlHelper.getFirstElementByTagName(element, RENDER_CFG);
        RenderConfig rc = this.getRc(db, elmRc);
        Diagram newDiagram = new Diagram(name, rc);
        ArrayList glyphs = new ArrayList();
        NodeList nl = element.getElementsByTagName(DB_TBL_GLYPH);
        for (int i = 0; i < nl.getLength(); ++i) {
            this.addDbTableGlyph((Element)nl.item(i), db, newDiagram);
        }
        ArrayList<ForeignKeyGlyph> links = new ArrayList<ForeignKeyGlyph>();
        nl = element.getElementsByTagName(FK_GLYPH);
        for (int i = 0; i < nl.getLength(); ++i) {
            links.add(this.getFkGlyph((Element)nl.item(i), db));
        }
        if (this.fromVersion_ != null && this.fromVersion_.compareTo(ADJUSTABLE_FONT_VER) < 0) {
            this.convertOldFont(rc, glyphs, name);
        }
        try {
            if (links != null) {
                newDiagram.initLinks(links);
            }
        }
        catch (Exception e) {
            LogUtil.logErr("DbXmlPre134.getDiagram.error: " + e.getMessage());
        }
        return newDiagram;
    }

    public RenderConfig getRc(Database db, Element element) {
        String zmStr = element.getAttribute(ZOOM);
        Element elmVbCfg = XmlHelper.getFirstElementByTagName(element, VB_CFG);
        VerbosityConfig vbCfg = this.getVbConfig(elmVbCfg);
        DbVerbosity dbVbCfg = new DbVerbosity(vbCfg.getShowFlagsMap());
        String lastLinkStrategryName_ = element.getAttribute(LINK_STRATEGY);
        LinkStrategy strategy = new OffsetDirect();
        if (lastLinkStrategryName_.equals("KeyToKeyStrategy")) {
            strategy = new KeyToKeyStrategy(db);
        }
        int fontSize = this.getFontSize(element);
        RenderConfig newRc = null;
        try {
            double zmLevel = Double.parseDouble(zmStr);
            newRc = new RenderConfig(zmLevel, strategy, (VerbosityConfig)dbVbCfg);
            String family = "Verdana";
            Font font = new Font(family, 0, fontSize);
            newRc.setFont(font);
        }
        catch (Exception e) {
            LogUtil.logErr("VerbosityConfigXmlCtr.fromXml.error: " + e.getMessage());
        }
        return newRc;
    }

    private int getFontSize(Element elmRc) {
        int fontSize = 11;
        boolean hasFontSize = elmRc.hasAttribute(FONT_SIZE);
        if (hasFontSize) {
            fontSize = XmlHelper.getAttrInt(elmRc, FONT_SIZE);
        }
        return fontSize;
    }

    private VerbosityConfig getVbConfig(Element element) {
        TreeMap<String, Boolean> map = new TreeMap<String, Boolean>();
        String tagName = FLAG;
        NodeList list = element.getElementsByTagName(tagName);
        for (int i = 0; i < list.getLength(); ++i) {
            Element elmFlag = (Element)list.item(i);
            String key = elmFlag.getAttribute(KEY);
            boolean value = XmlHelper.getAttrBoolFromInt(elmFlag, VALUE);
            map.put(key, new Boolean(value));
        }
        VerbosityConfig newVbCfg = null;
        try {
            newVbCfg = new VerbosityConfig(map);
        }
        catch (Exception e) {
            LogUtil.logErr("VerbosityConfigXmlCtr.fromXml.error: " + e.getMessage());
        }
        return newVbCfg;
    }

    private void convertOldFont(RenderConfig rc, List glyphs, String diagramNm) {
        FontConvPre132 conv = new FontConvPre132();
        conv.convert(rc, glyphs, diagramNm);
    }

    private void addDbTableGlyph(Element element, Database db, Diagram diagram) {
        String tblName = element.getAttribute(TBL);
        Schema schema = db.getSchema("schemaA");
        Table table = schema.getTable(tblName);
        int x = XmlHelper.getAttrInt(element, X);
        int y = XmlHelper.getAttrInt(element, Y);
        Point start = new Point(x, y);
        Color bkColor = BasicColorable.fromXmlHexString(element, BK_COLOR);
        try {
            DbTableGlyph newGlyph = new DbTableGlyph(start, table, diagram);
            newGlyph.setColor("MainBox", bkColor);
            diagram.addGlyph(newGlyph);
        }
        catch (Exception e) {
            e.printStackTrace();
            LogUtil.logErr("DbXmlPre134.getDbTblGlyph.error: " + e.getMessage());
        }
    }

    private ForeignKeyGlyph getFkGlyph(Element element, Database db) {
        String fkNm = element.getAttribute(NAME);
        Schema schema = db.getSchema("schemaA");
        ForeignKey fk = null;
        Iterator it = schema.values(Table.getClassName()).iterator();
        while (it.hasNext() && fk == null) {
            Table tbl = (Table)it.next();
            if (!tbl.contains("ForeignKey", fkNm)) continue;
            fk = tbl.getForeignKey(fkNm);
        }
        Color bkColor = BasicColorable.fromXmlHexString(element, BK_COLOR);
        if (fk == null) {
            LogUtil.logMsg("DbXmlPre134.fk not found: " + fkNm);
        }
        ForeignKeyGlyph newGlyph = null;
        try {
            newGlyph = new ForeignKeyGlyph(fk, null, Color.BLACK);
            newGlyph.setColor("BackColor", bkColor);
            newGlyph.setDirtyTracker(db);
        }
        catch (Exception e) {
            LogUtil.logErr("DbXmlPre134.getFkGlyph.error: " + e.getMessage());
        }
        return newGlyph;
    }

    private Proc getProc(Element element) {
        String name = element.getAttribute(NAME);
        String src = XmlHelper.getFirstElementValue(element, SRC);
        String comment = XmlHelper.getConditionComment(element);
        Proc newProc = null;
        try {
            newProc = new Proc(src, comment, name);
        }
        catch (Exception e) {
            LogUtil.logErr("DbXmlPre134.getProc.error: " + e.getMessage());
        }
        return newProc;
    }

    private Sequence getSequence(Element element) {
        String name = element.getAttribute(NAME);
        int incr = XmlHelper.getAttrInt(element, INCR);
        String comment = XmlHelper.getConditionComment(element);
        Sequence newSeq = null;
        try {
            newSeq = new Sequence(name, incr, comment);
        }
        catch (Exception e) {
            LogUtil.logErr("DbXmlPre134.getSeq.error: " + e.getMessage());
        }
        return newSeq;
    }

    private View getView(Element element) {
        String name = element.getAttribute(NAME);
        String sql = XmlHelper.getFirstElementValue(element, SQL);
        View newView = null;
        try {
            newView = new View(name, sql);
        }
        catch (Exception e) {
            LogUtil.logErr("DbXmlPre134.getView.error: " + e.getMessage());
        }
        return newView;
    }
}

