/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.xml;

import com.harrand.coreclasses.xml.IXmlCtrl;
import com.harrand.dbwrench.object.Trigger;
import com.harrand.util.LogUtil;
import com.harrand.util.XmlHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TriggerXmlCtrl
implements IXmlCtrl {
    public static final String TRG = "Trg";
    public static final String DEL = "del";
    public static final String INS = "ins";
    public static final String UPD = "upd";
    public static final String EXEC_BEFORE = "exBe";
    public static final String EACH_ROW = "eaRow";

    public Element asXmlElement(Document doc, Trigger trg) {
        Element elmTrg = doc.createElement(TRG);
        elmTrg.setAttribute("nm", trg.getName());
        XmlHelper.setAttrBoolAsInt(elmTrg, DEL, trg.getFireOnDeleteFlag());
        XmlHelper.setAttrBoolAsInt(elmTrg, INS, trg.getFireOnInsertFlag());
        XmlHelper.setAttrBoolAsInt(elmTrg, UPD, trg.getFireOnUpdateFlag());
        XmlHelper.setAttrBoolAsInt(elmTrg, EXEC_BEFORE, trg.getExecBefore());
        XmlHelper.setAttrBoolAsInt(elmTrg, EACH_ROW, trg.getForEachRow());
        XmlHelper.addElementSimple(doc, elmTrg, "Sql", trg.getSql());
        return elmTrg;
    }

    public static Trigger fromXml(Element element) {
        String name = element.getAttribute("nm");
        boolean del = XmlHelper.getAttrBoolFromInt(element, DEL);
        boolean ins = XmlHelper.getAttrBoolFromInt(element, INS);
        boolean upd = XmlHelper.getAttrBoolFromInt(element, UPD);
        boolean execBefore = XmlHelper.getAttrBoolFromInt(element, EXEC_BEFORE);
        boolean eachRow = XmlHelper.getAttrBoolFromInt(element, EACH_ROW);
        String sql = XmlHelper.getFirstElementValue(element, "Sql");
        Trigger newTrg = null;
        try {
            newTrg = new Trigger(name, del, ins, upd, sql, execBefore, eachRow);
        }
        catch (Exception e) {
            LogUtil.logErr("TriggerXmlCtr.fromXml.error: " + e.getMessage());
        }
        return newTrg;
    }
}

