/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.xml;

import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.xml.IXmlCtrl;
import com.harrand.dbwrench.naming.DbwNameBldrSvr;
import com.harrand.dbwrench.naming.UniqueConstraintNameBldr;
import com.harrand.dbwrench.object.Column;
import com.harrand.dbwrench.object.ForeignKey;
import com.harrand.dbwrench.object.Index;
import com.harrand.dbwrench.object.PrimaryKey;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrench.object.Trigger;
import com.harrand.dbwrench.object.table.constraint.ColumnsRequiredException;
import com.harrand.dbwrench.object.table.constraint.UniqueConstraint;
import com.harrand.dbwrench.object.transfer.SchemaTransferHistory;
import com.harrand.dbwrench.xml.ColumnXmlCtrl;
import com.harrand.dbwrench.xml.FkXmlCtrl;
import com.harrand.dbwrench.xml.IndexXmlCtrl;
import com.harrand.dbwrench.xml.PkXmlCtrl;
import com.harrand.dbwrench.xml.TriggerXmlCtrl;
import com.harrand.dbwrench.xml.table.UniqueConstraintXmlCtrl;
import com.harrand.dbwrench.xml.transfer.SchemaTransferHistoryXmlCtrl;
import com.harrand.util.LogUtil;
import com.harrand.util.XmlHelper;
import java.util.ArrayList;
import java.util.Iterator;
import org.openide.util.Exceptions;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class TableXmlCtrl
implements IXmlCtrl {
    private final ColumnXmlCtrl colCtrl_ = new ColumnXmlCtrl();
    private final PkXmlCtrl pkCtrl_ = new PkXmlCtrl();
    private final FkXmlCtrl fkCtrl_ = new FkXmlCtrl();
    private final IndexXmlCtrl idxCtrl_ = new IndexXmlCtrl();
    private final TriggerXmlCtrl trgCtrl_ = new TriggerXmlCtrl();
    private final UniqueConstraintXmlCtrl ucCtrl = new UniqueConstraintXmlCtrl();
    public static final String TBL = "Tbl";
    public static final String USER_SORT = "UsSo";
    public static final String TBL_OPTS = "TblOpts";
    public static final String UNIQUE_CONSTRAINTS_NM = "UniqueConstraints";

    public Element asXmlElement(Document doc, Table table) {
        PrimaryKey pk;
        Element elmTbl = doc.createElement(TBL);
        elmTbl.setAttribute("nm", table.getName());
        XmlHelper.setAttrBoolAsInt(elmTbl, USER_SORT, table.getUseManualSort());
        XmlHelper.addConditionCommentElm(doc, elmTbl, table.getComment());
        String tblOptsStr = table.getTableOptions();
        if (tblOptsStr != null) {
            XmlHelper.addElementSimple(doc, elmTbl, TBL_OPTS, tblOptsStr);
        }
        if ((pk = table.getPrimaryKey()) != null) {
            elmTbl.appendChild(this.pkCtrl_.asXmlElement(doc, pk));
        }
        Iterator it = table.values(Column.getClassName()).iterator();
        while (it.hasNext()) {
            elmTbl.appendChild(this.colCtrl_.asXmlElement(doc, (Column)it.next()));
        }
        it = table.values("ForeignKey").iterator();
        while (it.hasNext()) {
            elmTbl.appendChild(this.fkCtrl_.asXmlElement(doc, (ForeignKey)it.next()));
        }
        it = table.values(Index.getClassName()).iterator();
        while (it.hasNext()) {
            elmTbl.appendChild(this.idxCtrl_.asXmlElement(doc, table, (Index)it.next()));
        }
        it = table.values(Trigger.getClassName()).iterator();
        while (it.hasNext()) {
            elmTbl.appendChild(this.trgCtrl_.asXmlElement(doc, (Trigger)it.next()));
        }
        Element elmUCs = XmlHelper.createElementSimple(doc, UNIQUE_CONSTRAINTS_NM, "");
        it = table.values(UniqueConstraint.getClassName()).iterator();
        while (it.hasNext()) {
            elmUCs.appendChild(this.ucCtrl.asXmlElement(doc, (UniqueConstraint)it.next()));
        }
        elmTbl.appendChild(elmUCs);
        SchemaTransferHistoryXmlCtrl historyCtrl = new SchemaTransferHistoryXmlCtrl();
        SchemaTransferHistory history = table.getSchemaTransferHistory();
        Element elmTransHistory = historyCtrl.asXmlElement(doc, history);
        XmlHelper.appendChildSafe(elmTbl, elmTransHistory);
        return elmTbl;
    }

    public Table fromXml(Element element) {
        String name = element.getAttribute("nm");
        Table newTbl = null;
        try {
            int i;
            newTbl = new Table(name);
            boolean userSort = XmlHelper.getAttrBoolFromInt(element, USER_SORT);
            newTbl.setUseManualSort(userSort);
            String comment = XmlHelper.getConditionComment(element);
            newTbl.setComment(comment);
            Element elmTableOpts = XmlHelper.getFirstElementByTagName(element, TBL_OPTS);
            String tableOpts = elmTableOpts != null ? XmlHelper.getElementValue(elmTableOpts) : "";
            newTbl.setTableOptions(tableOpts);
            String tagName = "Cl";
            NodeList list = element.getElementsByTagName(tagName);
            for (i = 0; i < list.getLength(); ++i) {
                newTbl.add(ColumnXmlCtrl.fromXml((Element)list.item(i)));
            }
            list = element.getElementsByTagName("Pk");
            if (list.getLength() > 0) {
                newTbl.setPrimaryKey(PkXmlCtrl.fromXml((Element)list.item(0)));
            }
            tagName = "Idx";
            list = element.getElementsByTagName(tagName);
            for (i = 0; i < list.getLength(); ++i) {
                newTbl.add(IndexXmlCtrl.fromXml(newTbl, (Element)list.item(i)));
            }
            tagName = "Trg";
            list = element.getElementsByTagName(tagName);
            for (i = 0; i < list.getLength(); ++i) {
                newTbl.add(TriggerXmlCtrl.fromXml((Element)list.item(i)));
            }
            Element groupElm = XmlHelper.getFirstElementByTagName(element, UNIQUE_CONSTRAINTS_NM);
            if (groupElm != null) {
                tagName = "UnCon";
                list = groupElm.getElementsByTagName(tagName);
                for (int i2 = 0; i2 < list.getLength(); ++i2) {
                    Element itemElm = (Element)list.item(i2);
                    newTbl.add(UniqueConstraintXmlCtrl.fromXml(itemElm, newTbl));
                }
            }
            this.convertColumnUCs(newTbl);
            Element elmHistory = XmlHelper.getFirstElementByTagName(element, "SchTrHis");
            if (elmHistory != null) {
                SchemaTransferHistoryXmlCtrl historyCtrl = new SchemaTransferHistoryXmlCtrl();
                SchemaTransferHistory history = historyCtrl.fromXml(elmHistory, newTbl);
                newTbl.setSchemaTransferHistory(history);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LogUtil.logErr("TableXmlCtr.fromXml.err: " + e.getMessage());
        }
        return newTbl;
    }

    private void convertColumnUCs(Table tbl) {
        UniqueConstraintNameBldr nmBldr = (UniqueConstraintNameBldr)DbwNameBldrSvr.instance().getNameBldr("UniqueConstraintNameBldr");
        for (Column col : tbl.getColumns()) {
            if (!col.getUnique()) continue;
            try {
                ArrayList<Column> cols = new ArrayList<Column>();
                cols.add(col);
                UniqueConstraint attemptUC = new UniqueConstraint(tbl, cols, "tempNm");
                String builtNm = nmBldr.getFormedName(attemptUC);
                attemptUC.setName(builtNm);
                boolean alreadyExists = false;
                for (UniqueConstraint ucAlready : tbl.getUniqueConstraints()) {
                    String alreadyColStr;
                    String attemptColStr = StrHelper.getCsvNamed(cols);
                    boolean sameCols = attemptColStr.equalsIgnoreCase(alreadyColStr = StrHelper.getCsvNamed(ucAlready.getColumns()));
                    if (!sameCols) continue;
                    alreadyExists = true;
                }
                if (alreadyExists) continue;
                tbl.add(attemptUC);
                col.setUnique(false);
            }
            catch (ColumnsRequiredException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }
}

