/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.xml;

import com.harrand.coreclasses.xml.IXmlCtrl;
import com.harrand.dbwrench.object.CustomType;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.Proc;
import com.harrand.dbwrench.object.Schema;
import com.harrand.dbwrench.object.Sequence;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrench.object.View;
import com.harrand.dbwrench.xml.CustomTypeXmlCtrl;
import com.harrand.dbwrench.xml.ProcXmlCtrl;
import com.harrand.dbwrench.xml.SeqXmlCtrl;
import com.harrand.dbwrench.xml.TableXmlCtrl;
import com.harrand.dbwrench.xml.ViewXmlCtrl;
import com.harrand.util.LogUtil;
import com.harrand.util.XmlHelper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SchemaXmlCtrl
implements IXmlCtrl {
    private final TableXmlCtrl tblXmlCtrl_ = new TableXmlCtrl();
    private final ProcXmlCtrl procXmlCtrl_ = new ProcXmlCtrl();
    private final SeqXmlCtrl seqXmlCtrl_ = new SeqXmlCtrl();
    private final ViewXmlCtrl viewXmlCtrl_ = new ViewXmlCtrl();
    private final CustomTypeXmlCtrl typeXmlCtrl_ = new CustomTypeXmlCtrl();
    public static final String SCHEMA = "Sch";

    public Element asXmlElement(Document doc, Schema schema) {
        Element elmSchema = doc.createElement(SCHEMA);
        elmSchema.setAttribute("nm", schema.getName());
        elmSchema.setAttribute("Cm", schema.getComment());
        Iterator it = schema.values(Table.getClassName()).iterator();
        while (it.hasNext()) {
            elmSchema.appendChild(this.tblXmlCtrl_.asXmlElement(doc, (Table)it.next()));
        }
        it = schema.values(Proc.getClassName()).iterator();
        while (it.hasNext()) {
            elmSchema.appendChild(this.procXmlCtrl_.asXmlElement(doc, (Proc)it.next()));
        }
        it = schema.values(View.getClassName()).iterator();
        while (it.hasNext()) {
            elmSchema.appendChild(this.viewXmlCtrl_.asXmlElement(doc, (View)it.next()));
        }
        it = schema.values(Sequence.getClassName()).iterator();
        while (it.hasNext()) {
            elmSchema.appendChild(this.seqXmlCtrl_.asXmlElement(doc, (Sequence)it.next()));
        }
        ArrayList<CustomType> types = new ArrayList<CustomType>();
        it = schema.values(CustomType.getClassName()).iterator();
        while (it.hasNext()) {
            types.add((CustomType)it.next());
        }
        elmSchema.appendChild(this.typeXmlCtrl_.asXmlElement(doc, types));
        return elmSchema;
    }

    public Schema fromXml(Element element, Database db) {
        return null;
    }

    public void addSchemasDTsFirst(Database db, List<Element> schElms) {
        for (Element elmSch : schElms) {
            this.addSchemaWithTypes(db, elmSch);
        }
        for (Element elmSch : schElms) {
            this.addRemaingSchObjs(db, elmSch);
        }
    }

    private void addSchemaWithTypes(Database db, Element elmSch) {
        String name = elmSch.getAttribute("nm");
        String cmmStr = elmSch.getAttribute("Cm");
        Schema schema = new Schema(name);
        if (db != null) {
            db.add(schema);
        }
        schema.setComment(cmmStr);
        this.addCustomTypes(elmSch, schema);
    }

    private void addCustomTypes(Element elmSch, Schema newSchema) {
        Element elmTypes = XmlHelper.getFirstElementByTagName(elmSch, "CustomTypes");
        if (elmTypes != null) {
            List<CustomType> types = CustomTypeXmlCtrl.fromXml(elmTypes);
            for (CustomType type : types) {
                newSchema.add(type);
            }
        }
    }

    private void addRemaingSchObjs(Database db, Element elmSch) {
        String schNm = elmSch.getAttribute("nm");
        Schema sch = db.getSchema(schNm);
        try {
            int i;
            String tagName = "";
            tagName = "Tbl";
            NodeList list = elmSch.getElementsByTagName(tagName);
            for (i = 0; i < list.getLength(); ++i) {
                Element tblElement = (Element)list.item(i);
                Table tbl = this.tblXmlCtrl_.fromXml(tblElement);
                sch.add(tbl);
            }
            tagName = "View";
            list = elmSch.getElementsByTagName(tagName);
            for (i = 0; i < list.getLength(); ++i) {
                sch.add(ViewXmlCtrl.fromXml((Element)list.item(i)));
            }
            tagName = "Proc";
            list = elmSch.getElementsByTagName(tagName);
            for (i = 0; i < list.getLength(); ++i) {
                sch.add(ProcXmlCtrl.fromXml((Element)list.item(i)));
            }
            tagName = "Seq";
            list = elmSch.getElementsByTagName(tagName);
            for (i = 0; i < list.getLength(); ++i) {
                sch.add(SeqXmlCtrl.fromXml((Element)list.item(i)));
            }
        }
        catch (Exception e) {
            LogUtil.logErr("SchemaXmlCtr.fromXml.error: " + e.getMessage());
        }
    }
}

