/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.xml;

import com.harrand.coreclasses.element.Cardinality;
import com.harrand.coreclasses.element.StringPair;
import com.harrand.coreclasses.xml.IXmlCtrl;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.ForeignKey;
import com.harrand.dbwrench.object.Schema;
import com.harrand.dbwrench.object.Table;
import com.harrand.util.LogUtil;
import com.harrand.util.XmlHelper;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class FkXmlCtrl
implements IXmlCtrl {
    public static final String FK = "Fk";
    public static final String PAR_TBL = "PrTb";
    public static final String CHD_TBL = "CdTb";
    public static final String COL_PAIR = "ClPr";
    public static final String PAR_COL = "prCl";
    public static final String CHD_COL = "cdCl";
    public static final String PAR_LK_COL_NM = "prLkCl";
    public static final String DEL_ACT = "deAc";
    public static final String UPD_ACT = "upAc";
    public static final String ZERO = "zr";
    public static final String ONE = "oe";
    public static final String MANY = "mn";
    public static final String SCHEMA = "sch";

    public Element asXmlElement(Document doc, ForeignKey fk) {
        Element elmFk = doc.createElement(FK);
        elmFk.setAttribute("nm", fk.getName());
        elmFk.setAttribute(PAR_LK_COL_NM, fk.getParentLinkColNm());
        XmlHelper.setAttr(elmFk, DEL_ACT, fk.getDeleteActionId());
        XmlHelper.setAttr(elmFk, UPD_ACT, fk.getUpdateActionId());
        Element elmParTbl = doc.createElement(PAR_TBL);
        Table parTbl = fk.getParTbl();
        elmParTbl.setAttribute("nm", parTbl.getName());
        elmParTbl.setAttribute(SCHEMA, parTbl.getSchema().getName());
        Cardinality parCardi = fk.getParentCardinality();
        XmlHelper.setAttrBoolAsInt(elmParTbl, ZERO, parCardi.getAllowZero());
        XmlHelper.setAttrBoolAsInt(elmParTbl, ONE, parCardi.getAllowOne());
        XmlHelper.setAttrBoolAsInt(elmParTbl, MANY, parCardi.getAllowMany());
        elmFk.appendChild(elmParTbl);
        Element elmChdTbl = doc.createElement(CHD_TBL);
        Table chdTbl = fk.getChdTbl();
        elmChdTbl.setAttribute("nm", chdTbl.getName());
        elmChdTbl.setAttribute(SCHEMA, chdTbl.getSchema().getName());
        Cardinality chdCardi = fk.getChildCardinality();
        XmlHelper.setAttrBoolAsInt(elmChdTbl, ZERO, chdCardi.getAllowZero());
        XmlHelper.setAttrBoolAsInt(elmChdTbl, ONE, chdCardi.getAllowOne());
        XmlHelper.setAttrBoolAsInt(elmChdTbl, MANY, chdCardi.getAllowMany());
        elmFk.appendChild(elmChdTbl);
        List fkCols = fk.getColumns();
        for (StringPair pair : fkCols) {
            String parCol = pair.getStrA();
            String chdCol = pair.getStrB();
            Element elmColPair = doc.createElement(COL_PAIR);
            elmColPair.setAttribute(PAR_COL, parCol);
            elmColPair.setAttribute(CHD_COL, chdCol);
            elmFk.appendChild(elmColPair);
        }
        XmlHelper.addConditionCommentElm(doc, elmFk, fk.getComment());
        return elmFk;
    }

    public static ForeignKey fromXml(Database db, Element element) {
        String name = element.getAttribute("nm");
        String parLinkCol = element.getAttribute(PAR_LK_COL_NM);
        int delActId = XmlHelper.getAttrInt(element, DEL_ACT);
        boolean hasUpdAction = element.hasAttribute(UPD_ACT);
        int updActId = hasUpdAction ? XmlHelper.getAttrInt(element, UPD_ACT) : 3;
        Element elmParTbl = XmlHelper.getFirstElementByTagName(element, PAR_TBL);
        Schema schema = db.getSchema(elmParTbl.getAttribute(SCHEMA));
        String parTblNm = elmParTbl.getAttribute("nm");
        Table parTbl = schema.getTable(parTblNm);
        boolean parZero = XmlHelper.getAttrBoolFromInt(elmParTbl, ZERO);
        boolean parOne = XmlHelper.getAttrBoolFromInt(elmParTbl, ONE);
        boolean parMany = XmlHelper.getAttrBoolFromInt(elmParTbl, MANY);
        Cardinality parCardi = new Cardinality(parZero, parOne, parMany);
        Element elmChdTbl = XmlHelper.getFirstElementByTagName(element, CHD_TBL);
        schema = db.getSchema(elmChdTbl.getAttribute(SCHEMA));
        String chdTblNm = elmChdTbl.getAttribute("nm");
        Table chdTbl = schema.getTable(chdTblNm);
        boolean chdZero = XmlHelper.getAttrBoolFromInt(elmChdTbl, ZERO);
        boolean chdOne = XmlHelper.getAttrBoolFromInt(elmChdTbl, ONE);
        boolean chdMany = XmlHelper.getAttrBoolFromInt(elmChdTbl, MANY);
        Cardinality chdCardi = new Cardinality(chdZero, chdOne, chdMany);
        ArrayList<StringPair> fkCols = new ArrayList<StringPair>();
        String tagName = COL_PAIR;
        NodeList list = element.getElementsByTagName(tagName);
        for (int i = 0; i < list.getLength(); ++i) {
            Element elmColPair = (Element)list.item(i);
            String parCol = elmColPair.getAttribute(PAR_COL);
            String chdCol = elmColPair.getAttribute(CHD_COL);
            fkCols.add(new StringPair(parCol, chdCol));
        }
        String comment = XmlHelper.getConditionComment(element);
        ForeignKey newFk = null;
        try {
            newFk = new ForeignKey(name, parTbl, chdTbl, fkCols, delActId, updActId, comment, chdCardi, parLinkCol);
        }
        catch (Exception e) {
            LogUtil.logErr("FkXmlCtr.fromXml.error: " + e.getMessage());
        }
        return newFk;
    }
}

