/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.xml;

import com.harrand.coreclasses.display.BasicColorable;
import com.harrand.coreclasses.element.Cardinality;
import com.harrand.coreclasses.element.StringPair;
import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.zoom.Zoom;
import com.harrand.dbwrench.diagram.DbTableGlyph;
import com.harrand.dbwrench.diagram.DbVerbosity;
import com.harrand.dbwrench.diagram.DbwGlyphStore;
import com.harrand.dbwrench.diagram.ForeignKeyGlyph;
import com.harrand.dbwrench.diagram.KeyToKeyStrategy;
import com.harrand.dbwrench.doc.DbDocOptionMgr;
import com.harrand.dbwrench.jdbc.BasicTypesSvr;
import com.harrand.dbwrench.jdbc.DataType;
import com.harrand.dbwrench.object.Column;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.ForeignKey;
import com.harrand.dbwrench.object.Index;
import com.harrand.dbwrench.object.PrimaryKey;
import com.harrand.dbwrench.object.Proc;
import com.harrand.dbwrench.object.Schema;
import com.harrand.dbwrench.object.Sequence;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrench.object.Trigger;
import com.harrand.dbwrench.object.View;
import com.harrand.dbwrench.object.index.IIndexColumn;
import com.harrand.sketch.core.Diagram;
import com.harrand.sketch.core.IGlyphStore;
import com.harrand.sketch.core.RenderConfig;
import com.harrand.sketch.core.VerbosityConfig;
import com.harrand.sketch.linkStrategies.LinkStrategy;
import com.harrand.sketch.linkStrategies.OffsetDirect;
import com.harrand.util.LogUtil;
import com.harrand.util.XmlHelper;
import java.awt.Color;
import java.awt.Point;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DbXmlReaderPre130 {
    public static final String XML_NAME = "Name";
    public static final String XML_DOC_FOLDER = "DocFolder";
    public static final String XML_VERSION_LABEL = "VersionLabel";
    public static final String XML_VERSION_NOTES = "VersionNotes";
    public static final String XML_DEF_TABLE_OPTS = "DefaultTableOpts";
    public static final String COL_SORT = "ColSort";
    public static final String SORT_ALPHA = "Alpha";
    public static final String SORT_USER = "User";
    public static final String COMMENT_XML = "Comment";
    public static final String TABLE_OPT_XML = "TableOptions";
    public static final String HD_DATA_TYPE = "Data Type";
    public static final String HD_LENGTH = "Length";
    public static final String HD_SCALE = "Scale";
    public static final String HD_NULLABLE = "Nullable";
    public static final String HD_AUTONUMBER = "Auto Number";
    public static final String XML_AUTONUMBER = "AutoNumber";
    public static final String XML_ENUM_VALUES = "EnumValues";
    public static final String HD_SIGNED = "Signed";
    public static final String HD_UNSIGNED = "Unsigned";
    public static final String HD_ENUM_VALUES = "ENUM Values";
    public static final String HD_DEFAULT = "Default";
    public static final String HD_CHECK = "Check";
    public static final String HD_DATA_TYPE_PACKED = "DataType";
    public static final String HD_COLUMNS = "Columns";
    public static final String HD_CLUSTERED = "Clustered";
    public static final String HD_UNIQUE = "Unique";
    public static final String HD_COLUMN_NAME = "ColumnName";
    public static final String HD_ON_DELETE_PACKED = "OnDelete";
    public static final String HD_ON_INSERT_PACKED = "OnInsert";
    public static final String HD_ON_UPDATE_PACKED = "OnUpdate";
    public static final String XML_EXEC_BEFORE = "ExecBefore";
    public static final String XML_FOR_EACH_ROW = "ForEachRow";
    public static final String HD_PARENT_TABLE = "Parent Table";
    public static final String HD_CHILD_TABLE = "Child Table";
    public static final String HD_PARENT_COLS = "Parent Columns";
    public static final String HD_CHILD_COLS = "Child Columns";
    public static final String HD_PARENT_RELATIONS = "Parent Relations";
    public static final String HD_CHILD_RELATIONS = "Child Relations";
    public static final String HD_PARENT_CARDINALITY = "Parent Cardinality";
    public static final String HD_CHILD_CARDINALITY = "Child Cardinality";
    public static final String HD_PARENT_TABLE_PACKED = "ParentTable";
    public static final String HD_CHILD_TABLE_PACKED = "ChildTable";
    public static final String HD_DELETE_ACTION = "Delete Action";
    public static final String XML_DELETE_ACTION = "DeleteAction";
    public static final String XML_PARENT_LINK_COL_NM = "ParentLinkColNm";
    public static final String XML_PLURAL = "ForeignKeyGlyphs";
    public static final String BACK_COLOR = "BackColor";
    public static final String HD_KEY_COLUMN_PACKED = "KeyColumn";
    public static final String HD_SQL = "SQL";
    public static final String HD_SRC = "Src";
    public static final String HD_INCREMENT = "Increment";

    public Database getDatabase(Element elmDb) {
        long start = System.currentTimeMillis();
        String lname = XmlHelper.getElementValue(XmlHelper.getFirstElementByTagName(elmDb, XML_NAME));
        Database database = null;
        try {
            int i;
            database = new Database(lname);
            Schema schema = database.getSchema("schemaA");
            String className = Table.getClassName();
            NodeList list = elmDb.getElementsByTagName(className);
            for (i = 0; i < list.getLength(); ++i) {
                schema.add(this.getTable((Element)list.item(i)));
            }
            className = View.getClassName();
            list = elmDb.getElementsByTagName(className);
            for (i = 0; i < list.getLength(); ++i) {
                schema.add(this.getView((Element)list.item(i)));
            }
            className = Proc.getClassName();
            list = elmDb.getElementsByTagName(className);
            for (i = 0; i < list.getLength(); ++i) {
                schema.add(this.getProc((Element)list.item(i)));
            }
            className = Sequence.getClassName();
            list = elmDb.getElementsByTagName(className);
            for (i = 0; i < list.getLength(); ++i) {
                schema.add(this.getSequence((Element)list.item(i)));
            }
            className = ForeignKey.getClassName();
            list = elmDb.getElementsByTagName(className);
            for (i = 0; i < list.getLength(); ++i) {
                ForeignKey fk = this.getForiegnKey(database, (Element)list.item(i));
                Table chdTbl = fk.getChdTbl();
                chdTbl.add(fk);
            }
            DbwGlyphStore glyphStore = new DbwGlyphStore(database);
            className = Diagram.getClassName();
            list = elmDb.getElementsByTagName(className);
            for (int i2 = 0; i2 < list.getLength(); ++i2) {
                Element elmDiagram = (Element)list.item(i2);
                database.add(this.getDiagram(elmDiagram, database, glyphStore));
            }
            String docPath = XmlHelper.getFirstElementValue(elmDb, XML_DOC_FOLDER);
            File docFolder = new File(Database.getDefaultFolder());
            if (docPath.length() > 0) {
                docFolder = new File(docPath);
            } else if (database.getFolder() != null) {
                docFolder = new File(database.getFolder());
            }
            database.setDocFolder(docFolder);
            Element elmDocOptionMgr = XmlHelper.getFirstElementByTagName(elmDb, DbDocOptionMgr.clazz());
            DbDocOptionMgr docOptionMgr = elmDocOptionMgr != null ? DbDocOptionMgr.fromXml(elmDocOptionMgr, database) : new DbDocOptionMgr(database);
            database.setDocOptionMagr(docOptionMgr);
            String defTableOpts = XmlHelper.getFirstElementValue(elmDb, XML_DEF_TABLE_OPTS);
            database.setDefaultTableOpts(defTableOpts);
            String versionLabel = XmlHelper.getFirstElementValue(elmDb, XML_VERSION_LABEL);
            database.setVersionLabel(versionLabel);
            String versionNotes = XmlHelper.getFirstElementValue(elmDb, XML_VERSION_NOTES);
            database.setVersionNotes(versionNotes);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(e.getMessage());
        }
        return database;
    }

    private Table getTable(Element elmTable) {
        String lname = XmlHelper.getElementValue(XmlHelper.getFirstElementByTagName(elmTable, XML_NAME));
        Table table = null;
        try {
            int i;
            Element elmComment;
            table = new Table(lname);
            String className = null;
            String sortStr = elmTable.getAttribute(COL_SORT);
            if (sortStr.equals(SORT_USER)) {
                table.setUseManualSort(true);
            }
            String lComment = (elmComment = XmlHelper.getFirstElementByTagName(elmTable, COMMENT_XML)) != null ? XmlHelper.getElementValue(elmComment) : "";
            table.setComment(lComment);
            Element elmTableOpts = XmlHelper.getFirstElementByTagName(elmTable, TABLE_OPT_XML);
            String lTableOpts = elmTableOpts != null ? XmlHelper.getElementValue(elmTableOpts) : "";
            table.setTableOptions(lTableOpts);
            className = Column.getClassName();
            NodeList list = elmTable.getElementsByTagName(className);
            for (i = 0; i < list.getLength(); ++i) {
                table.add(this.getColumn((Element)list.item(i)));
            }
            list = elmTable.getElementsByTagName("PrimaryKey");
            if (list.getLength() > 0) {
                table.setPrimaryKey(this.getPrimaryKey((Element)list.item(0)));
            }
            className = Index.getClassName();
            list = elmTable.getElementsByTagName(className);
            for (i = 0; i < list.getLength(); ++i) {
                table.add(this.getIndex(table, (Element)list.item(i)));
            }
            className = Trigger.getClassName();
            list = elmTable.getElementsByTagName(className);
            for (i = 0; i < list.getLength(); ++i) {
                table.add(this.getTrigger((Element)list.item(i)));
            }
        }
        catch (Exception e) {
            StrHelper.throwProgExcept(e.getMessage());
        }
        return table;
    }

    private Column getColumn(Element elmColumn) {
        String llengthStr;
        DataType dataType;
        Integer llength = null;
        Integer lscale = null;
        String lname = XmlHelper.getElementValue(XmlHelper.getFirstElementByTagName(elmColumn, XML_NAME));
        Element elmComment = XmlHelper.getFirstElementByTagName(elmColumn, COMMENT_XML);
        String lComment = elmComment != null ? XmlHelper.getElementValue(elmComment) : "";
        int ldataTypeId = XmlHelper.getElementValueInt(XmlHelper.getFirstElementByTagName(elmColumn, HD_DATA_TYPE_PACKED));
        if (ldataTypeId == -4) {
            ldataTypeId = 2004;
        }
        if (ldataTypeId == -1) {
            ldataTypeId = 703;
        }
        if ((dataType = BasicTypesSvr.instance().getType(ldataTypeId)).isLengthUsed() && StrHelper.isInteger(llengthStr = XmlHelper.getElementValue(XmlHelper.getFirstElementByTagName(elmColumn, HD_LENGTH)))) {
            llength = new Integer(llengthStr);
        }
        if (dataType.isScaleUsed()) {
            String lscaleStr = elmColumn.getAttribute(HD_SCALE);
            lscale = StrHelper.isInteger(lscaleStr) ? new Integer(lscaleStr) : new Integer(0);
        }
        boolean lnullable = XmlHelper.getElementValueBoolean(XmlHelper.getFirstElementByTagName(elmColumn, HD_NULLABLE));
        boolean lautoNumber = XmlHelper.getElementValueBoolean(XmlHelper.getFirstElementByTagName(elmColumn, XML_AUTONUMBER));
        boolean lsigned = elmColumn.hasAttribute(HD_SIGNED) ? XmlHelper.getAttrBool(elmColumn, HD_SIGNED) : true;
        String ldefault = XmlHelper.getElementValue(XmlHelper.getFirstElementByTagName(elmColumn, HD_DEFAULT));
        Element elmEnum = XmlHelper.getFirstElementByTagName(elmColumn, XML_ENUM_VALUES);
        String lenumCsv = elmEnum != null ? XmlHelper.getElementValue(elmEnum) : "";
        String lcheck = XmlHelper.getElementValue(XmlHelper.getFirstElementByTagName(elmColumn, HD_CHECK));
        Column column = null;
        try {
            column = new Column(lname, ldataTypeId, llength, lnullable, lautoNumber, ldefault, lscale, lComment, lsigned, lenumCsv);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        return column;
    }

    private Index getIndex(Table table, Element elmIdx) {
        Vector<IIndexColumn> lcolumns = new Vector<IIndexColumn>();
        String lname = XmlHelper.getElementValue(XmlHelper.getFirstElementByTagName(elmIdx, XML_NAME));
        boolean lclusteredFlag = XmlHelper.getElementValueBoolean(XmlHelper.getFirstElementByTagName(elmIdx, HD_CLUSTERED));
        boolean lunique = XmlHelper.getElementValueBoolean(XmlHelper.getFirstElementByTagName(elmIdx, HD_UNIQUE));
        NodeList list = elmIdx.getElementsByTagName(HD_COLUMN_NAME);
        for (int i = 0; i < list.getLength(); ++i) {
            String colNm = XmlHelper.getElementValue((Element)list.item(i));
            Column column = table.getColumn(colNm);
            lcolumns.add(column);
        }
        Index index = null;
        try {
            index = new Index(lname, lcolumns, lclusteredFlag, lunique);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        return index;
    }

    private Trigger getTrigger(Element elmTrg) {
        String lname = XmlHelper.getElementValue(XmlHelper.getFirstElementByTagName(elmTrg, XML_NAME));
        boolean lfireOnDeleteFlag = XmlHelper.getElementValueBoolean(XmlHelper.getFirstElementByTagName(elmTrg, HD_ON_DELETE_PACKED));
        boolean lfireOnInsertFlag = XmlHelper.getElementValueBoolean(XmlHelper.getFirstElementByTagName(elmTrg, HD_ON_INSERT_PACKED));
        boolean lfireOnUpdateFlag = XmlHelper.getElementValueBoolean(XmlHelper.getFirstElementByTagName(elmTrg, HD_ON_UPDATE_PACKED));
        boolean lexecBefore = XmlHelper.getAttrBool(elmTrg, XML_EXEC_BEFORE);
        boolean lforEachRow = XmlHelper.getAttrBool(elmTrg, XML_FOR_EACH_ROW);
        String lSql = XmlHelper.getElementValue(XmlHelper.getFirstElementByTagName(elmTrg, "Sql"));
        Trigger trigger = null;
        try {
            trigger = new Trigger(lname, lfireOnDeleteFlag, lfireOnInsertFlag, lfireOnUpdateFlag, lSql, lexecBefore, lforEachRow);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        return trigger;
    }

    private PrimaryKey getPrimaryKey(Element elmPk) {
        ArrayList<String> columnNames = new ArrayList<String>();
        String name = XmlHelper.getElementValue(XmlHelper.getFirstElementByTagName(elmPk, XML_NAME));
        NodeList list = elmPk.getElementsByTagName(HD_KEY_COLUMN_PACKED);
        for (int i = 0; i < list.getLength(); ++i) {
            Element currentColumnName = (Element)list.item(i);
            columnNames.add(XmlHelper.getElementValue(currentColumnName));
        }
        PrimaryKey primaryKey = null;
        try {
            primaryKey = new PrimaryKey(name, columnNames);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        return primaryKey;
    }

    private ForeignKey getForiegnKey(Database db, Element elmFk) {
        HashMap lColumns = new HashMap();
        String lname = XmlHelper.getElementValue(XmlHelper.getFirstElementByTagName(elmFk, XML_NAME));
        Schema schema = db.getSchema("schemaA");
        Element elmParent = XmlHelper.getFirstElementByTagName(elmFk, HD_PARENT_TABLE_PACKED);
        String parTblNm = XmlHelper.getElementValue(elmParent);
        Table parTbl = schema.getTable(parTblNm);
        Cardinality lParentCardi = ForeignKey.getXmlCardinality(elmParent, 0);
        Element elmChild = XmlHelper.getFirstElementByTagName(elmFk, HD_CHILD_TABLE_PACKED);
        String chdTblNm = XmlHelper.getElementValue(elmChild);
        Table chdTbl = schema.getTable(chdTblNm);
        Cardinality lChildCardi = ForeignKey.getXmlCardinality(elmChild, 1);
        String lParentLinkColNm = elmFk.getAttribute(XML_PARENT_LINK_COL_NM);
        int deleteAction = elmFk.hasAttribute(XML_DELETE_ACTION) ? XmlHelper.getAttrInt(elmFk, XML_DELETE_ACTION) : 3;
        Element elmComment = XmlHelper.getFirstElementByTagName(elmFk, COMMENT_XML);
        String lComment = elmComment != null ? XmlHelper.getElementValue(elmComment) : "";
        ArrayList<StringPair> fkCols = new ArrayList<StringPair>();
        NodeList nl = elmFk.getElementsByTagName("ColumnPair");
        for (int i = 0; i < nl.getLength(); ++i) {
            Element elmPair = (Element)nl.item(i);
            String parent = XmlHelper.getElementValue(XmlHelper.getFirstElementByTagName(elmPair, "Parent"));
            String child = XmlHelper.getElementValue(XmlHelper.getFirstElementByTagName(elmPair, "Child"));
            if (lParentLinkColNm.length() == 0) {
                lParentLinkColNm = new String(parent);
            }
            fkCols.add(new StringPair(parent, child));
        }
        ForeignKey foreignKey = null;
        try {
            foreignKey = new ForeignKey(lname, parTbl, chdTbl, fkCols, deleteAction, 3, lComment, lChildCardi, lParentLinkColNm);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        return foreignKey;
    }

    private Diagram getDiagram(Element elmDiagram, Database db, IGlyphStore glyphStore) {
        Diagram newDiagram;
        ArrayList lGlyphs = new ArrayList();
        List storedLinks = null;
        String lName = XmlHelper.getElementValue(XmlHelper.getFirstElementByTagName(elmDiagram, XML_NAME));
        if (glyphStore != null) {
            RenderConfig config = this.getRenderConfig(elmDiagram, db);
            newDiagram = new Diagram(lName, config);
            this.addStoredGlyphs(elmDiagram, db, newDiagram);
            storedLinks = this.getStoredLinks(elmDiagram, db);
        } else {
            RenderConfig config = this.getRenderConfig(elmDiagram, db);
            newDiagram = new Diagram(lName, config);
        }
        if (storedLinks != null) {
            newDiagram.initLinks(storedLinks);
        }
        return newDiagram;
    }

    private void addStoredGlyphs(Element elmDiagram, Database db, Diagram diagram) {
        ArrayList glyphs = new ArrayList();
        NodeList nl = elmDiagram.getElementsByTagName(DbTableGlyph.getClassName());
        for (int i = 0; i < nl.getLength(); ++i) {
            this.addDbTableGlyph((Element)nl.item(i), db, diagram);
        }
    }

    private DbTableGlyph addDbTableGlyph(Element elmDbTableGlyph, Database db, Diagram diagram) {
        String lTableName = XmlHelper.getElementValue(XmlHelper.getFirstElementByTagName(elmDbTableGlyph, "TableName"));
        int x = (int)Double.parseDouble(XmlHelper.getElementValue(XmlHelper.getFirstElementByTagName(elmDbTableGlyph, "X")));
        int y = (int)Double.parseDouble(XmlHelper.getElementValue(XmlHelper.getFirstElementByTagName(elmDbTableGlyph, "Y")));
        Point lStart = new Point(x, y);
        Schema schema = db.getSchema("schemaA");
        Table table = schema.getTable(lTableName);
        DbTableGlyph newGlyph = new DbTableGlyph(lStart, table, diagram);
        diagram.addGlyph(newGlyph);
        Element elmColorable = XmlHelper.getFirstElementByTagName(elmDbTableGlyph, BasicColorable.clazz());
        if (elmColorable != null) {
            BasicColorable colorable = BasicColorable.fromXml(elmColorable);
            for (String key : colorable.getKeys()) {
                Color color = colorable.getColor(key);
                newGlyph.setColor(key, color);
            }
        }
        return newGlyph;
    }

    public static ForeignKeyGlyph getFkGlyph(Element element, Database db) {
        String lFkName = element.getAttribute(XML_NAME);
        Color lBackColor = BasicColorable.fromXmlHexString(element, BACK_COLOR);
        ForeignKey lfk = null;
        Schema schDef = db.getSchema("schemaA");
        for (Table tbl : schDef.values(Table.getClassName())) {
            if (!tbl.contains(ForeignKey.getClassName(), lFkName)) continue;
            lfk = tbl.getForeignKey(lFkName);
        }
        if (lfk == null) {
            LogUtil.logErr("DbXmlReaderPre130 could not find fk: " + lFkName);
        }
        ForeignKeyGlyph newFkGlyph = new ForeignKeyGlyph(lfk, null, Color.BLACK);
        newFkGlyph.setColor(BACK_COLOR, lBackColor);
        newFkGlyph.setDirtyTracker(db);
        return newFkGlyph;
    }

    private Proc getProc(Element elmProc) {
        String lname = XmlHelper.getElementValue(XmlHelper.getFirstElementByTagName(elmProc, XML_NAME));
        String lComment = XmlHelper.getElementValue(XmlHelper.getFirstElementByTagName(elmProc, COMMENT_XML));
        String lSrc = XmlHelper.getElementValue(XmlHelper.getFirstElementByTagName(elmProc, HD_SRC));
        Proc proc = null;
        proc = new Proc(lSrc, lComment, lname);
        return proc;
    }

    private Sequence getSequence(Element elmSeq) {
        String lname = elmSeq.getAttribute(XML_NAME);
        int lincrement = XmlHelper.getAttrInt(elmSeq, HD_INCREMENT);
        if (lincrement == 0) {
            lincrement = 1;
        }
        String lComment = XmlHelper.getElementValue(XmlHelper.getFirstElementByTagName(elmSeq, COMMENT_XML));
        Sequence sequence = new Sequence(lname, lincrement, lComment);
        return sequence;
    }

    private View getView(Element elmView) {
        String lname = XmlHelper.getElementValue(XmlHelper.getFirstElementByTagName(elmView, XML_NAME));
        String lSql = XmlHelper.getElementValue(XmlHelper.getFirstElementByTagName(elmView, HD_SQL));
        View view = null;
        try {
            view = new View(lname, lSql);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        return view;
    }

    public RenderConfig getRenderConfig(Element elmDiagram, Database db) {
        String strategyName;
        Element elmRc = XmlHelper.getFirstElementByTagName(elmDiagram, RenderConfig.getClassName());
        Zoom zoom = this.getZoom(XmlHelper.getFirstElementByTagName(elmRc, Zoom.getClassName()));
        DbVerbosity dbVb = new DbVerbosity(this.getVbCfgXmlTreeSet(elmRc));
        Element elmStrategy = XmlHelper.getFirstElementByTagName(elmDiagram, "LinkStrategy");
        LinkStrategy strategy = new OffsetDirect();
        if (elmStrategy != null && (strategyName = XmlHelper.getElementValue(elmStrategy)).equals("KeyToKeyStrategy")) {
            strategy = new KeyToKeyStrategy(db);
        }
        return new RenderConfig(zoom, strategy, (VerbosityConfig)dbVb);
    }

    public List getStoredLinks(Element elmDiagram, Database db) {
        ArrayList<ForeignKeyGlyph> links = new ArrayList<ForeignKeyGlyph>();
        Element elmLinks = XmlHelper.getFirstElementByTagName(elmDiagram, "Links");
        if (elmLinks != null) {
            NodeList nl = elmLinks.getElementsByTagName(ForeignKeyGlyph.getClassName());
            for (int i = 0; i < nl.getLength(); ++i) {
                links.add(DbXmlReaderPre130.getFkGlyph((Element)nl.item(i), db));
            }
        }
        return links;
    }

    private TreeMap getVbCfgXmlTreeSet(Element element) {
        TreeMap<String, Boolean> map = new TreeMap<String, Boolean>();
        NodeList nl = element.getElementsByTagName("ShowFlag");
        for (int i = 0; i < nl.getLength(); ++i) {
            Element elmFlag = (Element)nl.item(i);
            String key = XmlHelper.getElementValue(XmlHelper.getFirstElementByTagName(elmFlag, "Key"));
            boolean value = XmlHelper.getElementValueBoolean(XmlHelper.getFirstElementByTagName(elmFlag, "Value"));
            map.put(key, new Boolean(value));
        }
        return map;
    }

    public Zoom getZoom(Element element) {
        double lLevel = XmlHelper.getElementValueDouble(XmlHelper.getFirstElementByTagName(element, "Level"));
        Zoom zoom = new Zoom(lLevel);
        return zoom;
    }
}

