/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.xml;

import com.harrand.coreclasses.dataEntry.OpenEditorVO;
import com.harrand.coreclasses.element.Version;
import com.harrand.coreclasses.rename.RenameMgr;
import com.harrand.coreclasses.xml.IXmlCtrl;
import com.harrand.coreclasses.xml.TreePathXmlCtrl;
import com.harrand.dbwrench.diagram.DbwGlyphStore;
import com.harrand.dbwrench.doc.DbDocOptionMgr;
import com.harrand.dbwrench.jdbc.DataTypeSvr;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.ForeignKey;
import com.harrand.dbwrench.object.Schema;
import com.harrand.dbwrench.object.SqlTextStore;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrench.xml.DbXmlReaderPre130;
import com.harrand.dbwrench.xml.DiagramXmlCtrl;
import com.harrand.dbwrench.xml.FkXmlCtrl;
import com.harrand.dbwrench.xml.OpenEditorXmlCtrl;
import com.harrand.dbwrench.xml.SchemaXmlCtrl;
import com.harrand.dbwrench.xml.SqlTextStoreXmlCtrl;
import com.harrand.dbwrench.xml.converter.DbXmlPre134;
import com.harrand.sketch.core.Diagram;
import com.harrand.util.LogUtil;
import com.harrand.util.Validator;
import com.harrand.util.XmlHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DbXmlCtrl
implements IXmlCtrl {
    private final SchemaXmlCtrl schemaXmlCtrl_;
    private final FkXmlCtrl fkXmlCtrl_;
    private final DiagramXmlCtrl diagramXmlCtrl_;
    private final OpenEditorXmlCtrl openEditorXmlCtrl_;
    private final TreePathXmlCtrl expPathXmlCtrl_ = new TreePathXmlCtrl();
    private final SqlTextStoreXmlCtrl sqlTestStoreXmlCtrl = new SqlTextStoreXmlCtrl();
    public static final String DB = "Db";
    public static final String DOC_FLDR = "DocFolder";
    public static final String DEF_TBL_OPTS = "DefTblOpts";
    public static final String VER_LBL = "VerLbl";
    public static final String VER_NOTES = "VerNotes";
    public static final String SCHEMA_VER_STR = "1.3.4";
    public static final String CURRENT_VER_STR = "1.3.4";

    public DbXmlCtrl() {
        this.schemaXmlCtrl_ = new SchemaXmlCtrl();
        this.fkXmlCtrl_ = new FkXmlCtrl();
        this.diagramXmlCtrl_ = new DiagramXmlCtrl();
        this.openEditorXmlCtrl_ = new OpenEditorXmlCtrl();
    }

    public Element asXmlElement(Document doc, Database db) {
        Element elmDb = doc.createElement(DB);
        elmDb.setAttribute("nm", db.getName());
        elmDb.setAttribute("flnm", db.getFileName());
        elmDb.setAttribute("ver", "1.3.4");
        XmlHelper.addElementSimple(doc, elmDb, VER_LBL, db.getVersionLabel());
        XmlHelper.addElementSimple(doc, elmDb, VER_NOTES, db.getVersionNotes());
        XmlHelper.addElementSimple(doc, elmDb, DEF_TBL_OPTS, db.getDefaultTableOpts());
        XmlHelper.addElementSimple(doc, elmDb, DOC_FLDR, db.getDocFolder().getPath());
        Iterator it = db.values(Schema.getClassName()).iterator();
        while (it.hasNext()) {
            elmDb.appendChild(this.schemaXmlCtrl_.asXmlElement(doc, (Schema)it.next()));
        }
        it = db.values(Diagram.getClassName()).iterator();
        while (it.hasNext()) {
            elmDb.appendChild(this.diagramXmlCtrl_.asXmlElement(doc, (Diagram)it.next()));
        }
        RenameMgr renameMgr = db.getRenameMgr();
        elmDb.appendChild(renameMgr.asXmlElement(doc));
        DbDocOptionMgr docOptionMgr = (DbDocOptionMgr)db.getDocOptionMgr();
        XmlHelper.addForeignElement(doc, elmDb, docOptionMgr.asXmlElement());
        elmDb.appendChild(this.openEditorXmlCtrl_.asXmlElement(doc, db.getOpenEditors()));
        elmDb.appendChild(this.expPathXmlCtrl_.asXmlElement(doc, db.getExplorerPaths()));
        elmDb.appendChild(this.sqlTestStoreXmlCtrl.asXmlElement(doc, db.getSqlTextStore()));
        return elmDb;
    }

    public Database fromXml(Element element) {
        String versionStr = element.getAttribute("ver");
        if (versionStr.length() > 0) {
            Version version = new Version(versionStr);
            Version verSchema = new Version("1.3.4");
            if (version.compareTo(verSchema) < 0) {
                return this.fromXmlPre134(element, version);
            }
            return this.fromXmlCurrent(element);
        }
        return this.fromXmlPre130(element);
    }

    private Database fromXmlCurrent(Element element) {
        String name = element.getAttribute("nm");
        String versionStr = element.getAttribute("ver");
        Version version = new Version(versionStr);
        this.diagramXmlCtrl_.setFromVersion(version);
        Database newDb = null;
        try {
            newDb = new Database(name);
            DataTypeSvr.setDb(newDb);
            newDb.getNotifyMgr().setEnabled(false);
            newDb.setVersionLabel(XmlHelper.getFirstElementValue(element, VER_LBL));
            newDb.setVersionNotes(XmlHelper.getFirstElementValue(element, VER_NOTES));
            newDb.setDefaultTableOpts(XmlHelper.getFirstElementValue(element, DEF_TBL_OPTS));
            String docFilePath = XmlHelper.getFirstElementValue(element, DOC_FLDR);
            newDb.setDocFolder(new File(docFilePath));
            String fileName = element.getAttribute("flnm");
            if (Validator.isStringValid(fileName)) {
                newDb.setFileName(fileName);
            }
            Element elmDocOptionMgr = XmlHelper.getFirstElementByTagName(element, DbDocOptionMgr.clazz());
            DbDocOptionMgr docOptionMgr = DbDocOptionMgr.fromXml(elmDocOptionMgr, newDb);
            newDb.setDocOptionMagr(docOptionMgr);
            Element elmRenameMgr = XmlHelper.getFirstElementByTagName(element, "RnmMgr");
            if (elmRenameMgr != null) {
                RenameMgr renameMgr = RenameMgr.fromXml(elmRenameMgr);
                newDb.setRenameMgr(renameMgr);
            }
            String tagName = "";
            newDb.remove(Schema.getClassName(), "schemaA");
            tagName = "Sch";
            ArrayList<Element> fkElements = new ArrayList<Element>();
            NodeList list = element.getElementsByTagName(tagName);
            List<Element> schElms = XmlHelper.getAsGenericsList(list);
            this.schemaXmlCtrl_.addSchemasDTsFirst(newDb, schElms);
            for (Element elmSch : schElms) {
                NodeList tblList = elmSch.getElementsByTagName("Tbl");
                for (int j = 0; j < tblList.getLength(); ++j) {
                    Element elmTbl = (Element)tblList.item(j);
                    NodeList fkNodes = elmTbl.getElementsByTagName("Fk");
                    for (int k = 0; k < fkNodes.getLength(); ++k) {
                        fkElements.add((Element)fkNodes.item(k));
                    }
                }
            }
            for (Element elmFk : fkElements) {
                ForeignKey fk = FkXmlCtrl.fromXml(newDb, elmFk);
                Table chdTbl = fk.getChdTbl();
                chdTbl.add(fk);
            }
            tagName = "Dgm";
            list = element.getElementsByTagName(tagName);
            DbwGlyphStore glyphStore = new DbwGlyphStore(newDb);
            for (int i = 0; i < list.getLength(); ++i) {
                newDb.add(this.diagramXmlCtrl_.fromXml((Element)list.item(i), glyphStore));
            }
            Element elmOpenEditors = XmlHelper.getFirstElementByTagName(element, "OpenEditors");
            List<OpenEditorVO> openEditors = OpenEditorXmlCtrl.fromXml(newDb, elmOpenEditors);
            newDb.setOpenEditors(openEditors);
            Element elmExpPaths = XmlHelper.getFirstElementByTagName(element, "TreePaths");
            List<String> paths = TreePathXmlCtrl.fromXml(elmExpPaths);
            newDb.setExplorerPaths(paths);
            Element elmSqlTexts = XmlHelper.getFirstElementByTagName(element, "SqlTexts");
            if (elmSqlTexts != null) {
                SqlTextStore store = SqlTextStoreXmlCtrl.fromXml(elmSqlTexts);
                newDb.setSqlTextStore(store);
            }
        }
        catch (Exception e) {
            LogUtil.printStackTrace(e);
            LogUtil.logErr("DatabaseXmlCtr.fromXml.error: " + e.getMessage());
        }
        newDb.getNotifyMgr().setEnabled(true);
        return newDb;
    }

    private Database fromXmlPre130(Element element) {
        DbXmlReaderPre130 olderReader = new DbXmlReaderPre130();
        return olderReader.getDatabase(element);
    }

    private Database fromXmlPre134(Element element, Version version) {
        DbXmlPre134 olderReader = new DbXmlPre134(version);
        return olderReader.getDatabase(element);
    }
}

