/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.translate;

import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.script.IConnectionConfig;
import com.harrand.dbwrench.jdbc.Dbms;
import com.harrand.dbwrench.jdbc.JdbcConfig;
import com.harrand.dbwrench.translate.IQuery;
import com.harrand.dbwrench.translate.IQueryTranslator;
import com.harrand.dbwrench.translate.SqlQuery;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public final class MsSqlSvrQueryTranslator
implements IQueryTranslator {
    private String inputStr_;
    private List params_;
    private Map commandTexts_ = new TreeMap();
    private Map commandIds_ = new TreeMap();

    public MsSqlSvrQueryTranslator() {
        this.initCommandMaps();
    }

    @Override
    public int getDbmsId() {
        return 3;
    }

    @Override
    public IQuery getMatchingQuery(String inputStr, IConnectionConfig config) {
        this.inputStr_ = StrHelper.cleanParameterizedInput(inputStr);
        IQuery query = null;
        JdbcConfig jdbcConfig = (JdbcConfig)config;
        Iterator it = this.commandTexts_.keySet().iterator();
        while (it.hasNext() && query == null) {
            Object idObj = it.next();
            String text = (String)this.commandTexts_.get(idObj);
            if (!this.startsWith(text)) continue;
            List paramsLocal = this.parseParams(this.inputStr_, text);
            int id = (Integer)idObj;
            query = this.getQuery(id, paramsLocal, jdbcConfig);
        }
        return query;
    }

    @Override
    public boolean needsTranslation(Dbms toDbms) {
        return toDbms.getId() != 3;
    }

    @Override
    public IQuery translate(IQuery query, IConnectionConfig config) {
        JdbcConfig jdbcConfig = (JdbcConfig)config;
        return this.getQuery(query.getId(), query.getParams(), jdbcConfig);
    }

    private IQuery getQuery(int queryId, List params, JdbcConfig config) {
        IQuery query = null;
        this.setParams(params);
        switch (queryId) {
            case 1: {
                query = this.getParameterlessQuery(queryId, config);
                break;
            }
            case 2: {
                query = this.getParameterlessQuery(queryId, config);
                break;
            }
            case 4: {
                query = this.getOneParameterQuery(queryId);
                break;
            }
            case 5: {
                query = this.getOneParameterQuery(queryId);
                break;
            }
            case 6: {
                query = this.getOneParameterQuery(queryId);
                break;
            }
            case 7: {
                query = this.getOneParameterQuery(queryId);
                break;
            }
            case 8: {
                query = this.getOneParameterQuery(queryId);
                break;
            }
            case 10: {
                query = this.getParameterlessQuery(queryId, config);
                break;
            }
            case 9: {
                query = this.getParameterlessQuery(queryId, config);
                break;
            }
            default: {
                query = null;
            }
        }
        return query;
    }

    private void setParams(List params) {
        this.params_ = params;
    }

    private List parseParams(String inputStr, String commandPortion) {
        String paramStr = this.inputStr_.substring(commandPortion.length(), inputStr.length());
        String trimmed = paramStr.trim();
        ArrayList<String> params = new ArrayList<String>(Arrays.asList(trimmed.split(" ")));
        return params;
    }

    private boolean startsWith(String startString) {
        String lc = this.inputStr_.toLowerCase();
        return lc.startsWith(startString);
    }

    private IQuery getParameterlessQuery(int commandId, JdbcConfig config) {
        String commandDesc = (String)this.commandTexts_.get(new Integer(commandId));
        if (commandId == 2) {
            commandDesc = commandDesc + " @table_type = \"'TABLE'\"";
        }
        return new SqlQuery(commandId, commandDesc, new ArrayList(), commandDesc);
    }

    private IQuery getOneParameterQuery(int commandId) {
        String commandDesc = (String)this.commandTexts_.get(new Integer(commandId));
        String sql = commandDesc + " " + (String)this.params_.get(0);
        return new SqlQuery(commandId, sql, this.params_, commandDesc);
    }

    private void initCommandMaps() {
        this.commandTexts_.put(new Integer(1), "sp_helpdb");
        this.commandTexts_.put(new Integer(2), "sp_tables");
        this.commandTexts_.put(new Integer(4), "sp_columns");
        this.commandTexts_.put(new Integer(5), "sp_helpindex");
        this.commandTexts_.put(new Integer(6), "sp_pkeys");
        this.commandTexts_.put(new Integer(7), "sp_fkeys");
        this.commandTexts_.put(new Integer(8), "sp_helptrigger");
        this.commandTexts_.put(new Integer(10), "sp_tables @table_type = \"'VIEW'\"");
        this.commandTexts_.put(new Integer(9), "sp_helpuser");
    }
}

