/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.testData;

import com.harrand.coreclasses.element.Version;
import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.dbwrench.jdbc.JdbcConfig;
import com.harrand.dbwrench.object.Column;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.ForeignKey;
import com.harrand.dbwrench.object.Index;
import com.harrand.dbwrench.object.PrimaryKey;
import com.harrand.dbwrench.object.Schema;
import com.harrand.dbwrench.object.Table;
import com.harrand.util.LogUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TransactionData {
    private JdbcConfig config_;
    private int dbmsId_;
    private Version version_;
    public static final String SCH_NM = "testSch";
    public static final String DB_NM = "TxnTest";
    public static final String DB_A_KEY = "A";
    public static final String DB_B_KEY = "B";
    public static final String TBL_CMPY_NM = "Company";
    public static final String TBL_PLANE_NM = "Plane";
    public static final String TBL_FAIL_NM = "TableFail";
    public static final String TBL_B_CMM_NEW = "new Comment on TblB";
    public static final String ID_NM = "Id";
    public static final String NM_NM = "Name";
    public static final String CREATE_BY_NM = "CreateBy";
    public static final String CREATE_DT_NM = "CreateDate";
    public static final String ID_PLANE_CMPY_NM = "IdCompany";
    public static final String NEW_COL_A_NM = "newCol.A";
    public static final String CMPY_CITY_NM = "City";
    public static final String PLANE_CLASS_NM = "Classification";
    public static final String IDX_NM_A_NM = "IdxNameA";
    public static final String FK_PLANE_CMPY_NM = "fkPlaneCompany";

    public Map getDatabases() {
        HashMap<String, Database> dbs = new HashMap<String, Database>();
        Database dbA = new Database(DB_NM);
        Database dbB = new Database(DB_NM);
        this.addCommonItems(dbA);
        this.addCommonItems(dbB);
        this.addUpdateItems(dbB);
        dbs.put(DB_A_KEY, dbA);
        dbs.put(DB_B_KEY, dbB);
        return dbs;
    }

    private void addCommonItems(Database db) {
        db.remove(Schema.getClassName(), "schemaA");
        Schema schTest = new Schema(SCH_NM);
        db.add(schTest);
        schTest.add(this.getCompanyTable());
        schTest.add(this.getPlaneTable());
        this.addFks(db);
    }

    private Table getCompanyTable() {
        Table table = new Table(TBL_CMPY_NM);
        table.setUseManualSort(true);
        try {
            Column idCol = new Column(ID_NM, 4, null, false);
            Column nmCol = new Column(NM_NM, 12, new Integer(50), false);
            Column cityCol = new Column(CMPY_CITY_NM, 12, new Integer(50), true);
            Column createByCol = new Column(CREATE_BY_NM, 12, new Integer(50), true);
            Column createDateCol = new Column(CREATE_DT_NM, 700, null, true);
            table.add(idCol);
            table.add(nmCol);
            table.add(cityCol);
            table.add(createByCol);
            table.add(createDateCol);
            ArrayList<String> pkCols = new ArrayList<String>();
            pkCols.add(ID_NM);
            PrimaryKey pk = new PrimaryKey("pkCompany", pkCols);
            table.setPrimaryKey(pk);
        }
        catch (Exception e) {
            LogUtil.printStackTrace(e);
        }
        return table;
    }

    private Table getPlaneTable() {
        Table table = new Table(TBL_PLANE_NM);
        table.setUseManualSort(true);
        try {
            Column idCol = new Column(ID_NM, 4, null, false);
            Column nmCol = new Column(NM_NM, 12, new Integer(50), false);
            Column classCol = new Column(PLANE_CLASS_NM, 12, new Integer(50), true);
            Column idACol = new Column(ID_PLANE_CMPY_NM, 4, null, true);
            Column createByCol = new Column(CREATE_BY_NM, 12, new Integer(50), false);
            Column createDateCol = new Column(CREATE_DT_NM, 700, null, true);
            table.add(idCol);
            table.add(nmCol);
            table.add(classCol);
            table.add(idACol);
            table.add(createByCol);
            table.add(createDateCol);
            ArrayList<String> pkCols = new ArrayList<String>();
            pkCols.add(ID_NM);
            PrimaryKey pk = new PrimaryKey("pkPlane", pkCols);
            table.setPrimaryKey(pk);
        }
        catch (Exception e) {
            LogUtil.printStackTrace(e);
        }
        return table;
    }

    private Table getFailTable() {
        Table table = new Table(TBL_FAIL_NM);
        try {
            Column idCol = new Column(ID_NM, 4, null, false);
            Column nmCol = new Column(NM_NM, 12, new Integer(50), false);
            Column createDateCol = new Column(CREATE_DT_NM, 700, null, true, false, "nowab()", null, "");
            Column createByCol = new Column(CREATE_BY_NM, 12, new Integer(50), false);
            table.add(idCol);
            table.add(nmCol);
            table.add(createDateCol);
            table.add(createDateCol);
            ArrayList<String> pkCols = new ArrayList<String>();
            pkCols.add(ID_NM);
            PrimaryKey pk = new PrimaryKey("pkFail", pkCols);
            table.setPrimaryKey(pk);
            Index clusteredA = new Index("idxClustA", nmCol, false, false);
            table.add(clusteredA);
            Index clusteredB = new Index("idxClustB", createByCol, true, false);
            table.add(clusteredB);
        }
        catch (Exception e) {
            LogUtil.printStackTrace(e);
        }
        return table;
    }

    private void addFks(Database db) {
        Schema schDef = db.getSchema(SCH_NM);
        Table tblCompany = schDef.getTable(TBL_CMPY_NM);
        Table tblPlane = schDef.getTable(TBL_PLANE_NM);
        ForeignKey fkPlaneCompany = new ForeignKey(FK_PLANE_CMPY_NM, tblCompany, tblPlane, ID_NM, ID_PLANE_CMPY_NM);
        tblPlane.add(fkPlaneCompany);
    }

    public List getInsertDataSqls(String dbKey) {
        ArrayList sqlList = new ArrayList();
        if (dbKey.equals(DB_A_KEY)) {
            sqlList.addAll(this.getCompanyInsertSql());
            sqlList.addAll(this.getPlaneInsertSql());
        }
        return sqlList;
    }

    private void addUpdateItems(Database db) {
        try {
            Schema schDef = db.getSchema(SCH_NM);
            Table tblCompany = schDef.getTable(TBL_CMPY_NM);
            Column newColA = new Column(NEW_COL_A_NM, 2, new Integer(13), true, false, "", new Integer(5), "");
            tblCompany.add(newColA);
            Column nameCol = tblCompany.getColumn(NM_NM);
            Index idxNmA = new Index(IDX_NM_A_NM, nameCol, false, false);
            tblCompany.add(idxNmA);
            Column newNmCol = new Column(NM_NM, 12, new Integer(99), false);
            Table tblB = schDef.getTable(TBL_PLANE_NM);
            Column oldNmCol = tblB.getColumn(NM_NM);
            ITestResult result = tblB.updateItem(oldNmCol, newNmCol);
            tblB.setComment(TBL_B_CMM_NEW);
            schDef.add(this.getFailTable());
        }
        catch (Exception e) {
            LogUtil.printStackTrace(e);
        }
    }

    private List getCompanyInsertSql() {
        String insertStr = this.getInsertString(TBL_CMPY_NM);
        String prefix = insertStr + "(" + ID_NM + ", " + NM_NM + ", " + CMPY_CITY_NM + ", " + CREATE_BY_NM + ", " + CREATE_DT_NM + ") VALUES\n\t";
        ArrayList<String> sqlList = new ArrayList<String>();
        sqlList.add(prefix + "(1, 'Sukhoi', 'Moscow', 'HarnekR', '2006-3-12 01:30:45')");
        sqlList.add(prefix + "(2, 'MIG', 'St. Petersburg', 'SlaidJ', '2006-3-19 02:30:45')");
        sqlList.add(prefix + "(3, 'North American', 'Denver', 'ShawnM', '2006-3-29 03:30:45')");
        sqlList.add(prefix + "(4, 'Douglas', 'Long Beach', 'ShawnM', '2006-4-09 04:30:45')");
        sqlList.add(prefix + "(5, 'Boeing', 'Chicage', 'AnthonyJ', '2006-4-12 05:30:45')");
        return sqlList;
    }

    private List getPlaneInsertSql() {
        String insertStr = this.getInsertString(TBL_PLANE_NM);
        String prefix = insertStr + "(" + ID_NM + ", " + NM_NM + ", " + PLANE_CLASS_NM + ", " + ID_PLANE_CMPY_NM + ", " + CREATE_BY_NM + ", " + CREATE_DT_NM + ") VALUES\n\t";
        ArrayList<String> sqlList = new ArrayList<String>();
        sqlList.add(prefix + "(1, 'SU-25', 'Fighter', 1, 'SlaidJ', '2006-3-12 01:30:45')");
        sqlList.add(prefix + "(2, 'MIG-29', 'Fighter', 2, 'SlaidJ', '2006-3-19 02:30:45')");
        sqlList.add(prefix + "(3, 'P51', 'Fighter', 3, 'Ahn', '2006-3-29 03:30:45')");
        sqlList.add(prefix + "(4, 'DC10', 'Transport', 4, 'Ahn', '2006-4-09 04:30:45')");
        sqlList.add(prefix + "(5, '747-400', 'Civilian', 5, 'AnthonyJ', '2006-4-12 05:30:45')");
        return sqlList;
    }

    private String getInsertString(String tableName) {
        return "INSERT INTO " + tableName + "\n\t";
    }
}

