/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.testData;

import com.harrand.coreclasses.dataEntry.BasicNameBuilder;
import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.dbwrench.jdbc.BasicTypesSvr;
import com.harrand.dbwrench.object.Column;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.ForeignKey;
import com.harrand.dbwrench.object.Index;
import com.harrand.dbwrench.object.PrimaryKey;
import com.harrand.dbwrench.object.Schema;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrench.object.index.IIndexColumn;
import com.harrand.dbwrench.object.table.constraint.UniqueConstraint;
import com.harrand.dbwrench.template.BasicColumnTemplate;
import com.harrand.dbwrench.template.GeneratedColumnTemplate;
import com.harrand.util.LogUtil;
import java.util.ArrayList;

public final class NamingTestData {
    public static final String PREFIX = "pre";
    public static final String SEPARATOR = "_";
    public static final String SUFFIX = "suf";
    public static final String UC_TEST_NM = "ucTestNm";
    public static final boolean USE_TABLE_NM = true;
    public static final boolean USE_COLUMN_NMS = true;
    public static final String TAB_NAME_NM = "TableName";
    public static final String TAB_CHILD_NM = "ChildTable";
    public static final String TAB_PARENT_NM = "ParentTable";
    public static final String COL_NAME_NM = "ColumnName";
    public static final String COL_ONE_NM = "ColumnOne";
    public static final String COL_TWO_NM = "ColumnTwo";
    public static final String COL_CHILD_NM = "ChildColumn";
    public static final String COL_PARENT_NM = "ParentColumn";
    public static final String IDX_TEST_NM = "TestIndex";
    public static final String PK_TEST_NM = "TestPk";
    public static final String FK_TEST_NM = "TestFk";
    public static final String BASE_NAME = "Base";
    public static final String COL_NAME = "colA";
    public static final String COL_DATA_TYPE_DESC = "VarChar";
    public static final Integer COL_LENGTH = new Integer(12);
    public static final Integer COL_SCALE = new Integer(3);
    public static final boolean COL_NULLABLE = true;
    public static final boolean COL_AUTO_NUMBER = false;
    public static final String COL_DEFAULT = "(default)";
    public static final String COL_COMMENT = "colA Comment";

    public static Database getTestDb() {
        Database db = new Database("NamingTestDb");
        Schema schDef = db.getSchema("schemaA");
        Table tabName = new Table(TAB_NAME_NM);
        Table tabChild = new Table(TAB_CHILD_NM);
        Table tabParent = new Table(TAB_PARENT_NM);
        ITestResult result = schDef.add(tabName);
        result = schDef.add(tabChild);
        result = schDef.add(tabParent);
        try {
            Column colName = new Column(COL_NAME_NM, 4, null, false);
            Column colOne = new Column(COL_ONE_NM, 4, null, false, true, "", null, "");
            Column colTwo = new Column(COL_TWO_NM, 4, null, false);
            Column colChild = new Column(COL_CHILD_NM, 4, null, false);
            Column colParent = new Column(COL_PARENT_NM, 4, null, false);
            result = tabName.add(colName);
            result = tabName.add(colOne);
            result = tabName.add(colTwo);
            result = tabChild.add(colChild);
            result = tabParent.add(colParent);
            ArrayList<String> pkCols = new ArrayList<String>();
            pkCols.add(colOne.getName());
            PrimaryKey pk = new PrimaryKey(PK_TEST_NM, pkCols);
            tabName.setPrimaryKey(pk);
            ArrayList<IIndexColumn> idxCols = new ArrayList<IIndexColumn>();
            idxCols.add(colOne);
            idxCols.add(colTwo);
            Index idxTest = new Index(IDX_TEST_NM, idxCols, true, true);
            result = tabName.add(idxTest);
            ForeignKey fkTest = new ForeignKey(FK_TEST_NM, tabParent, tabChild, COL_PARENT_NM, COL_CHILD_NM);
            result = tabChild.add(fkTest);
            ArrayList<Column> ucCols = new ArrayList<Column>();
            ucCols.add(colOne);
            ucCols.add(colTwo);
            UniqueConstraint uc = new UniqueConstraint(tabName, ucCols, UC_TEST_NM);
            tabName.add(uc);
        }
        catch (Exception e) {
            LogUtil.logErr("NamingTestData error: " + e.getMessage());
        }
        return db;
    }

    public static BasicColumnTemplate getBasicColumnTemplate() {
        Column column = NamingTestData.getBasicColumn();
        BasicColumnTemplate template = new BasicColumnTemplate(true, COL_NAME, BasicTypesSvr.instance().getType(COL_DATA_TYPE_DESC), COL_LENGTH);
        template.setIsNullable(true);
        template.setAutoNumber(false);
        template.setDefault(COL_DEFAULT);
        template.setScale(COL_SCALE);
        template.setIsPrimaryKey(true);
        template.setComment(COL_COMMENT);
        return template;
    }

    public static Column getBasicColumn() {
        Column column = null;
        try {
            column = new Column(COL_NAME, BasicTypesSvr.instance().getIdFromDesc(COL_DATA_TYPE_DESC), COL_LENGTH, true, false, COL_DEFAULT, COL_SCALE, "");
        }
        catch (Exception e) {
            LogUtil.printStackTrace(e);
        }
        return column;
    }

    public static GeneratedColumnTemplate getGeneratedColumnTemplate() {
        BasicColumnTemplate template = NamingTestData.getBasicColumnTemplate();
        BasicNameBuilder builder = NamingTestData.getBasicNameBuilder();
        return new GeneratedColumnTemplate(template, builder);
    }

    public static BasicNameBuilder getBasicNameBuilder() {
        return new BasicNameBuilder(PREFIX, BASE_NAME, SUFFIX, true);
    }
}

