/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.testData;

import com.harrand.coreclasses.element.Cardinality;
import com.harrand.coreclasses.element.StringPair;
import com.harrand.coreclasses.element.Version;
import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.interfaces.Collector;
import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.coreclasses.rename.RenameMgr;
import com.harrand.coregui.command.Command;
import com.harrand.coregui.command.idf.RenameIdf;
import com.harrand.coregui.command.idf.UpdateInCollector;
import com.harrand.dbwrench.dataConversion.DbDataConversion;
import com.harrand.dbwrench.diagram.DataGenSketch;
import com.harrand.dbwrench.diagram.DbTableGlyph;
import com.harrand.dbwrench.jdbc.CustomTypeIdCtrl;
import com.harrand.dbwrench.jdbc.DataTypeSvr;
import com.harrand.dbwrench.jdbc.Dbms;
import com.harrand.dbwrench.jdbc.IDataType;
import com.harrand.dbwrench.jdbc.JdbcConfig;
import com.harrand.dbwrench.object.Column;
import com.harrand.dbwrench.object.CustomType;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.ForeignKey;
import com.harrand.dbwrench.object.Index;
import com.harrand.dbwrench.object.PrimaryKey;
import com.harrand.dbwrench.object.Proc;
import com.harrand.dbwrench.object.Schema;
import com.harrand.dbwrench.object.Sequence;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrench.object.Trigger;
import com.harrand.dbwrench.object.View;
import com.harrand.dbwrench.object.index.ColumnFunction;
import com.harrand.dbwrench.object.index.IIndexColumn;
import com.harrand.dbwrench.object.table.constraint.UniqueConstraint;
import com.harrand.dbwrench.security.App;
import com.harrand.dbwrench.testData.IndexOptionTextTestData;
import com.harrand.sketch.core.Diagram;
import com.harrand.util.LogUtil;
import com.harrand.util.Validator;
import java.awt.Point;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class DbmsTestData {
    public static final String SBR_CONTACT_DISC_UC_NM = "uc_sbr_contact_disc";
    private JdbcConfig config_;
    private Dbms dbms_;
    private int dbmsId_;
    private Version version_;
    private String nowStr_ = "";
    private boolean useSchemas_ = true;
    private List dataTbls_ = null;
    private boolean dblQuoteMixedCase_ = false;
    public static final String GEN_ID = "Id";
    public static final String GEN_CHNG_BY = "ChangedBy";
    public static final String GEN_CHNG_DATE = "ChangedDate";
    public static final String DB_NM = "DbmsTestDb";
    public static final String DB_NM_LOWER_CASE = "dbmstestdb";
    public static final String DB_A_KEY = "A";
    public static final String DB_B_KEY = "B";
    public static final int OLD_DB = 0;
    public static final int NEW_DB = 1;
    public static final String SCH_CMPY_NM = "Company";
    public static final String SCH_CMPY_CMM_OLD = "Company Lab Report Data";
    public static final String SCH_CMPY_CMM_NEW = "Company Proprietary Data";
    public static final String SCH_WEB_NM_OLD = "Outside";
    public static final String SCH_WEB_NM_NEW = "Website";
    public static final String SCH_WEB_CMM = "Customer Website Data";
    public static final String SCH_RSH_NM = "Research";
    public static final String SCH_FIN_NM = "Finance";
    public static final String SCH_FIN_CMM = "Finance & Accounting";
    public static final String DIA_A_NM = "zDiagramA";
    public static final String PROC_NM_PSQL = "Company.GetRecentPatients(integer)";
    public static final String PROC_NM_SQL_SVR = "company.hsr_GetPatientRecent";
    public static final String PROC_COMMENT = "Get Recent Patients";
    public static final String PROC_COMMENT_NEW = "Get Most Recent Patients";
    public static final String PROC_SRC_PSQL = "create or replace function \"Company\".\"GetRecentPatients\"(integer) returns \"Company\".\"Patient\" as $$\nSELECT * FROM \"Company\".\"Patient\" WHERE \"PatientId\" < $1;\n$$ language 'sql';";
    public static final String PROC_SRC_PSQL_NEW = "create or replace function \"Company\".\"GetRecentPatients\"(integer) returns \"Company\".\"Patient\" as $$\nSELECT * FROM \"Company\".\"Patient\" WHERE \"PatientId\" >= $1;\n$$ language 'sql';";
    public static final String PROC_NM_PSQL_PIC = "Company.getRecentPics(integer)";
    public static final String PROC_SRC_PSQL_PIC = "create or replace function \"Company\".\"GetRecentPics\"(integer) \nreturns setof \"Company\".\"Picture\" as $BODY$\nSELECT * FROM \"Company\".\"Picture\" WHERE \"PictureId\" >= $1;\n$BODY$ language 'sql';";
    public static final String PROC_NM_PSQL_PATH = "Company.GetPathInfo(pathId int4, pathAlias character varying)";
    public static final String PROC_SRC_PSQL_PATH = "CREATE FUNCTION \"Company\".\"GetPathInfo\"(pathId int4, pathAlias character varying)\n    RETURNS \"Company\".\"Pathologist\" AS $$\nDECLARE\n    apath \"Company\".\"Pathologist\"%ROWTYPE;\n    str character varying := 'hello';\nBEGIN\n    /* ensure id is valid */\n    IF (pathId < 0)\n    THEN\n\tSELECT * INTO apath FROM \"Company\".\"Pathologist\"    WHERE \"PathologistId\" = 0;\n    END IF;\n    \n    /* pathAlias is just returned as is*/\n    SELECT * INTO apath FROM \"Company\".\"Pathologist\"     WHERE \"PathologistId\" = pathId;\n    RETURN apath;\nEND;\n$$ LANGUAGE plpgsql;";
    public static final String PROC_NM_PSQL_ADD_TWO_80 = "Company.AddTwo(numa integer, numa integer)";
    public static final String PROC_SRC_PSQL_ADD_TWO_80 = "CREATE FUNCTION \"Company\".\"AddTwo\"(numa integer, numb integer)\n    RETURNS integer AS $$\nBEGIN\n    RETURN numa + numb;\nEND;\n$$ LANGUAGE plpgsql;";
    public static final String PROC_NM_PSQL_ADD_TWO_74 = "Company.AddTwo()";
    public static final String PROC_SRC_PSQL_ADD_TWO_74 = "CREATE FUNCTION \"Company\".\"AddTwo\"(integer, integer)\n    RETURNS integer AS '\nBEGIN\n    RETURN $1 + $2;\nEND;\n' LANGUAGE plpgsql;";
    public static final String PROC_NM_PSQL_TRG = "Company.ProcTrgPatientClean()";
    public static final String PROC_COMMENT_PSQL_TRG = "Clean patient information";
    public static final String PROC_SRC_PSQL_TRG = "create function \"Company\".\"ProcTrgPatientClean\"() returns trigger AS '\nbegin \nreturn old;\nend;\n' LANGUAGE 'plpgsql';";
    public static final String PROC_SRC_SQL_SVR = "CREATE PROCEDURE company.hsr_GetPatientRecent\n   @Id   integer = 0\nAS\nSELECT * FROM Company.Patient\nWHERE Company.Patient.PatientId < @Id\nORDER BY Company.Patient.PatientId\nRETURN";
    public static final String PROC_SRC_SQL_SVR_NEW = "CREATE PROCEDURE Company.hsr_GetPatientRecent\n   @Id   integer = 0\nAS\nSELECT * FROM Company.Patient\nWHERE Company.Patient.PatientId >= @Id\nORDER BY Company.Patient.PatientId\nRETURN";
    public static final String PROC_SRC_SQL_SVR_ADD_TWO = "CREATE PROCEDURE Company.hsr_AddTwo\n   @NumA   integer = 0,\n   @NumB   integer = 0\nAS\nSELECT @NumA + @NumB\nRETURN";
    public static final String PROC_NM_SQL_SVR_ADD_TWO = "Company.hsr_AddTwo";
    public static final String PROC_MYSQL_PR_NM = "`simpleproc`";
    public static final String PROC_MYSQL_FN_NM = "`hello`(s CHAR(20))";
    public static final String PROC_MYSQL_CMM_FN = "MySql Function Comment";
    public static final String PROC_MYSQL_CMM_PR = "MySql Proc Comment";
    public static final String PROC_MYSQL_SRC_PR = "CREATE PROCEDURE `simpleproc`(OUT param1 INT)\n    COMMENT 'MySql Proc Comment'\nBEGIN \nEND";
    public static final String PROC_MYSQL_SRC_FN = "CREATE FUNCTION `hello`(s CHAR(20)) RETURNS char(50)\n    COMMENT 'MySql Function Comment'\nRETURN CONCAT('Hello, ',s,'!')";
    public static final String PROC_ORCL_RM_PIC_FL_NM = "REMOVE_PIC_FILE";
    public static final String PROC_ORCL_FACT_NM = "FACTORI";
    public static final String PROC_ORCL_IN_OUT_NM = "INOUT";
    public static final String PROC_ORCL_RM_PIC_FL_SRC = "CREATE OR REPLACE PROCEDURE COMPANY.REMOVE_PIC_FILE (pic_file_id NUMBER) AS \ntot_pics NUMBER; \nBEGIN  \n  DELETE FROM picturefile \n  WHERE picturefile.picturefileid = pic_file_id; \ntot_pics := tot_pics - 1; \nEND;";
    public static final String PROC_ORCL_FACT_SRC = "CREATE OR REPLACE PROCEDURE COMPANY.FACTORI(a in out number) \nis \nb number:=1; \nbegin \nfor i in 1..a loop \n b:=b*i; \nend loop; \na:=b; \nend;";
    public static final String PROC_ORCL_IN_OUT_SRC = "CREATE OR REPLACE PROCEDURE COMPANY.INOUT(x IN OUT VARCHAR) IS  \nBEGIN  \nINSERT INTO filetype(filetypeid, name) VALUES(1, x);    \nx := 'outvalue';  \nEND;";
    public static final String PATH_TBL_NM = "Pathologist";
    public static final String PATH_NAME_NM = "Name";
    public static final int PATH_NAME_DT = 12;
    public static final Integer PATH_NAME_LN = new Integer(255);
    public static final String PATH_EMP_ID_NM = "EmployeeId";
    public static final int PATH_EMP_ID_DT = 4;
    public static final String PATH_NAME_COM = "Docs Full Name";
    public static final String PATH_NAME_COM_NEW = "Doc's Full Dr. Name";
    public static final boolean PATH_NAME_UNIQUE_FLAG = true;
    public static final String PATH_ID_NM = "PathologistId";
    public static final int PATH_ID_DT = 4;
    public static final String PATH_HIRE_DATE_NM = "HireDate";
    public static final int PATH_HIRE_DATE_DT = 91;
    public static final String PATH_OBS_NM = "ObsoleteCol";
    public static final String PATH_PK_NM = "PkPathologist";
    public static final String PATH_IDX_NAME_NM = "idxPathologistName";
    public static final boolean PATH_IDX_NAME_UNQ_OLD = false;
    public static final boolean PATH_IDX_NAME_UNQ_NEW = true;
    public static final String PATH_IDX_ID_NM = "idxPathologistId";
    public static final String PATH_IDX_EMP_ID_NM = "idxPathologistEmployeeId";
    public static final String PATH_IDX_ID_NM_NM = "idxPathologistIdName";
    public static final String PATH_HIRE_DATE_DEF_PSQL = "`('now'::text)::timestamp without time zone";
    public static final String PATH_HIRE_DATE_DEF_SQL_SVR = "getDate()";
    public static final String PATH_HIRE_DATE_DEF_MYSQL = "now()";
    public static final String PATH_HIRE_DATE_DEF_ORACLE = "`SYSDATE";
    public static final String PATIENT_TBL_NM = "Patient";
    public static final String PATIENT_NAME_NM = "Name";
    public static final int PATIENT_NAME_DT = 12;
    public static final Integer PATIENT_NAME_LN = new Integer(100);
    public static final Integer PATIENT_NAME_NEW_LN = new Integer(255);
    public static final String PATIENT_ID_NM = "PatientId";
    public static final int PATIENT_ID_DT = 4;
    public static final Integer PATIENT_ID_LN = null;
    public static final String PATIENT_SOURCE_ID_NM = "SourceId";
    public static final int PATIENT_SOURCE_ID_DT = 12;
    public static final Integer PATIENT_SOURCE_ID_LN = new Integer(25);
    public static final String PATIENT_SOURCE_ID_CONV_VAL = "-1";
    public static final String PATIENT_PK_NM = "PkPatient";
    public static final String PATIENT_IDX_NAME_NM = "idxPatientName";
    public static final boolean PATIENT_IDX_NAME_UNQ = false;
    public static final String PATIENT_TRG_NM = "trgPatientClean";
    public static final String PATIENT_TRG_FN_NM = "\"Company\".\"ProcTrgPatientClean\"()";
    public static final String RPT_TBL_NM = "Report";
    public static final String RPT_ID_NM = "ReportId";
    public static final int RPT_ID_DT = 4;
    public static final String RPT_PUBLISH_TIME_NM = "PublishTime";
    public static final int RPT_PUBLISH_TIME_DT = 700;
    public static final String RPT_REPORT_TEXT_NM = "ReportText";
    public static final int RPT_REPORT_TEXT_DT = 703;
    public static final Integer RPT_REPORT_TEXT_LN = null;
    public static final String RPT_PK_NM = "PkReport";
    public static final String RPT_IDX_PATH_ID_NM = "idxRptPathologistId";
    public static final String RPT_IDX_PATIENT_ID_NM = "idxPatientId";
    public static final String RPT_TRG_NM = "trgPublishReport";
    public static final boolean RPT_TRG_DEL = false;
    public static final boolean RPT_TRG_DEL_NEW = true;
    public static final boolean RPT_TRG_UPD = true;
    public static final boolean RPT_TRG_INS = true;
    public static final boolean RPT_TRG_FOR_ROW = true;
    public static final boolean RPT_TRG_EXEC_AFTER = true;
    public static final String RPT_TRG_SQL = "Select * From Report";
    public static final String RPT_TRG_SQL_PSQL = "create function \"Company\".\"fnPublishReport\"() returns trigger AS '\nbegin \nreturn NEW;\nend;\n' LANGUAGE 'plpgsql';";
    public static final String RPT_TRG_SQL_ORACLE = "CREATE OR REPLACE\nTRIGGER Company.trgPublishReport \nBEFORE DELETE OR INSERT OR UPDATE \n ON Company.Report FOR EACH ROW \nBEGIN \n NULL;\nEND;";
    public static final String RPT_TRG_FN_NM = "\"Company\".\"fnPublishReport\"()";
    public static final String RPT_TBL_OPT = "WITHOUT OIDS";
    public static final String PIC_TBL_NM = "Picture";
    public static final String PIC_TBL_COM = "Images";
    public static final String PIC_TBL_COM_NEW = "Report Images";
    public static final String PIC_ID_NM = "PictureId";
    public static final int PIC_ID_DT = 4;
    public static final String PIC_CAPTION_NM = "Caption";
    public static final int PIC_CAPTION_DT = 12;
    public static final Integer PIC_CAPTION_LN = new Integer(150);
    public static final Integer PIC_CAPTION_NEW_LN = new Integer(255);
    public static final String PIC_COLOR_LEVEL_NM = "ColorLevel";
    public static final int PIC_COLOR_LEVEL_DT = 4;
    public static final String PIC_PK_NM = "PkPicture";
    public static final String PIC_IDX_CAPTION_NM = "idxPictureCaption";
    public static final boolean PIC_IDX_CAPTION_UNQ = false;
    public static final String PIC_IDX_RPT_ID_NM = "idxPictureReportId";
    public static final String PIC_TBL_OPT = "ENGINE=InnoDB";
    public static final String CAM_TBL_NM = "Camera";
    public static final String CAM_ID_NM = "CameraId";
    public static final int CAM_ID_DT = 5;
    public static final boolean CAM_ID_SIGN_OLD = true;
    public static final boolean CAM_ID_SIGN_NEW = false;
    public static final String CAM_TYPE_NM = "CameraType";
    public static final int CAM_TYPE_DT = 706;
    public static final String CAM_PK_NM = "pkCamera";
    public static final String CAM_TYPE_ENUM_CSV_OLD = "'CCD','Film','Digital'";
    public static final String CAM_TYPE_ENUM_CSV_NEW = "'CCD','Film','Digital','Laser'";
    public static final String DT_TBL_NM = "DataTypes";
    public static final String VAR_CHAR_NULL_LEN_COL_NM = "xVarCharNullLength";
    public static final String NUM_NULL_LEN_COL_NM = "xNumericNullLength";
    public static final String CUSTOM_TYPE_INT_NM = "myIntType";
    public static final String CUSTOM_TYPE_INT_COL_NM = "xMyTypeInt";
    public static final String CUSTOM_TYPE_VCHAR_NM = "myVCharType";
    public static final String CUSTOM_TYPE_VCHAR_COL_NM = "xMyVCharType";
    public static final String NVARCHAR2_COL_NM = "xNVarChar2";
    public static final int NVARCHAR2_COL_LN = 125;
    public static final String DASH_COL_NM = "dash-col";
    public static final String PIC_FILE_TBL_NM = "PictureFile";
    public static final String PIC_FILE_ID_NM = "PictureFileId";
    public static final int PIC_FILE_ID_DT = 4;
    public static final Integer PIC_FILE_ID_LN = null;
    public static final String PIC_FILE_URL_NM = "URL";
    public static final int PIC_FILE_URL_DT = 1;
    public static final Integer PIC_FILE_URL_LN = new Integer(150);
    public static final String PIC_FILE_URL_DEF = "www";
    public static final String PIC_FILE_URL_DEF_ORCL = "'www'";
    public static final String PIC_FILE_PK_NM = "PkPictureFile";
    public static final String PIC_FILE_IDX_PIC_ID_NM = "idxPictureFilePictureId";
    public static final String INV_TBL_NM_OLD = "Invoice";
    public static final String INV_TBL_NM_NEW = "Receivable";
    public static final String INV_TBL_COM = "Company's Receivable Statements";
    public static final String INV_ID_NM = "Id";
    public static final int INV_ID_DT = 4;
    public static final Integer INV_ID_LN = null;
    public static final String INV_AMOUNT_NM = "Amount";
    public static final int INV_AMOUNT_DT = 3;
    public static final Integer INV_AMOUNT_LN = new Integer(10);
    public static final String INV_AMOUNT_DEF = "0";
    public static final Integer INV_AMOUNT_SCALE = new Integer(2);
    public static final String INV_AMOUNT_COM = "Total Payable";
    public static final String INV_PAID_NM = "PaidFlag";
    public static final int INV_PAID_DT = 16;
    public static final Integer INV_PAID_LN = null;
    public static final String INV_PAID_DEF = "0";
    public static final String INV_PAID_COM = "Account Paid in Full";
    public static final String INV_SENT_NM = "SentFlag";
    public static final int INV_SENT_DT = 16;
    public static final Integer INV_SENT_LN = new Integer(1);
    public static final String INV_LABOR_NM = "Labor";
    public static final int INV_LABOR_DT = 3;
    public static final Integer INV_LABOR_SCALE = new Integer(3);
    public static final Integer INV_LABOR_LN = new Integer(8);
    public static final String INV_LEGACY_ID_NM = "LegacyId";
    public static final int INV_LEGACY_ID_DT = 4;
    public static final Integer INV_LEGACY_ID_LN = null;
    public static final String INV_CODENAME_NM = "CodeName";
    public static final int INV_CODENAME_DT = 12;
    public static final Integer INV_CODENAME_LN = new Integer(35);
    public static final String INV_LABOR_DEF = "10";
    public static final String INV_PK_NM = "PkInvoice";
    public static final String INV_TBL_OPT = "MAX_ROWS=10000";
    public static final String INV_IDX_CODENAME_NM = "idxCodeName";
    public static final String FILE_TYPE_TBL_NM = "FileType";
    public static final String FILE_TYPE_ID_NM = "FileTypeId";
    public static final int FILE_TYPE_ID_DT = 4;
    public static final Integer FILE_TYPE_ID_LN = null;
    public static final String FILE_TYPE_NAME_NM = "Name";
    public static final int FILE_TYPE_NAME_DT = 12;
    public static final Integer FILE_TYPE_NAME_LN = new Integer(25);
    public static final String FILE_TYPE_PK_NM = "PkFileType";
    public static final String FILE_TYPE_IDX_NAME_NM = "idxFileTypeName";
    public static final boolean FILE_TYPE_IDX_NAME_UNQ = false;
    public static final String GROUPS_TBL_NM = "Groups";
    public static final String GROUPS_ID_NM = "Id";
    public static final int GROUPS_ID_DT = 4;
    public static final Integer GROUPS_ID_LN = null;
    public static final String GROUPS_DESC_NM = "Desc";
    public static final int GROUPS_DESC_DT = 12;
    public static final Integer GROUPS_DESC_LN = new Integer(25);
    public static final Integer GROUPS_DESC_LN_NEW = new Integer(75);
    public static final String GROUPS_ICON_NM = "GroupIcon";
    public static final String GROUPS_MIS_STMT_NM = "MissionStmt";
    public static final String GROUPS_PK_NM = "PkGroups";
    public static final String GROUPS_IDX_DESC_NM = "idxGroupsDesc";
    public static final boolean GROUPS_IDX_DESC_UNQ = false;
    public static final String GROUPS_INSERT_BY_NM = "InsertBy";
    public static final int GROUPS_INSERT_BY_DT = 12;
    public static final Integer GROUPS_INSERT_BY_LN = new Integer(50);
    public static final String GROUPS_UPDATE_BY_NM = "UpdateBy";
    public static final int GROUPS_UPDATE_BY_DT = 12;
    public static final Integer GROUPS_UPDATE_BY_LN = new Integer(50);
    public static final String GROUPS_INSERT_DATE_NM = "InsertDate";
    public static final int GROUPS_INSERT_DATE_DT = 700;
    public static final String GROUPS_UPDATE_DATE_NM = "UpdateDate";
    public static final int GROUPS_UPDATE_DATE_DT = 700;
    public static final String SBR_TBL_NM = "Subscriber";
    public static final String SBR_TBL_COM = "Company Branches with subscriptions";
    public static final String SBR_COMPANY_ID_NM = "CompanyId";
    public static final String SBR_BRANCH_ID_NM = "BranchId";
    public static final String SBR_CONTACT_NM = "ContactName";
    public static final String SBR_PK_NM = "SubscriberPk";
    public static final String SBR_IDX_NAME_NM = "SubscriberNameIdx";
    public static final String SBR_IDX_DIS_NM = "SubscriberDisIdx";
    public static final String SBR_TBL_OPT = "WITH OIDS";
    public static final String SBN_TBL_NM = "Subscription";
    public static final String SBN_TBL_COM = "All Subscriptions";
    public static final String SBN_ID_NM = "SubscriptionId";
    public static final String SBN_COMPANY_ID_NM = "CompanyId";
    public static final String SBN_BRANCH_ID_NM = "BranchId";
    public static final String SBN_IS_TRIAL_NM = "IsTrial";
    public static final String SBN_YEAR_NM = "Year";
    public static final String SBN_EXP_DATE_NM = "ExpirationDate";
    public static final String SBN_PK_NM = "SubscriptionPk";
    public static final String WBR_TBL_NM_OLD = "WebPage";
    public static final String WBR_TBL_NM_NEW = "WebResource";
    public static final String WBR_URL_NM_OLD = "Url";
    public static final String WBR_URL_NM_NEW = "OfficialUrl";
    public static final boolean WBR_URL_NULL_OLD = true;
    public static final boolean WBR_URL_NULL_NEW = false;
    public static final String WBR_URL_DEF_OLD = "";
    public static final String WBR_URL_DEF_NEW = ".html";
    public static final String WBR_URL_CMM_OLD = "Allows null";
    public static final String WBR_URL_CMM_NEW = "No more nulls, has default";
    public static final String WBR_ACC_TYPE_ID_NM = "WebResourceAccessTypeId";
    public static final String WBR_PK_NM = "pkWebResource";
    public static final String WBR_IDX_ACC_ID_NM = "idxAccTypId";
    public static final String WBH_TBL_NM = "WebResourceHit";
    public static final String WBH_WBR_NM_OLD = "WebPageId";
    public static final String WBH_WBR_NM_NEW = "WebResourceId";
    public static final String WBH_INCR_NM = "Increment";
    public static final String WBH_INCR_CMM = "Psql keyword, but not reserved";
    public static final String WBH_HIT_DATE_NM_OLD = "HitTime";
    public static final String WBH_HIT_DATE_NM_NEW = "HitDate";
    public static final String WBH_SBR_ID_NM = "SubscriberId";
    public static final String WBH_PK_NM = "PkWebResHit";
    public static final String WBH_IDX_RES_ID_NM = "idxWbhWbrId";
    public static final String WBH_IDX_SBR_ID_NM = "idxWbhSbrId";
    public static final String WBA_TBL_NM = "WebResourceAccessType";
    public static final String WBA_ID_NM_OLD = "uid";
    public static final String WBA_ID_NM_NEW = "Id";
    public static final String WBA_ACC_DES_NM_OLD = "accessDes";
    public static final String WBA_ACC_DES_NM_NEW = "AccessDes";
    public static final String ACC_TBL_NM = "Account";
    public static final String ACC_ID_COL_NM = "Id";
    public static final String ACC_TBL_CMM_WEB = "IT Access Accounts";
    public static final String ACC_SUP_COL_NM = "SuperUser";
    public static final String ACC_CMP_ADM_COL_NM = "CompanyAdmin";
    public static final String ACC_SUS_COL_NM = "Suspended";
    public static final String ACC_CMP_ADM_COL_CMM = "Administrator for client company";
    public static final String ACC_SUS_COL_CMM = "Temporarily Disabled";
    public static final String ACC_TBL_CMM_FIN = "Financial Accounts";
    public static final String ACC_TAX_COL_NM = "Taxable";
    public static final String ACC_FIS_COL_NM = "YearEnd";
    public static final String ACC_FIS_COL_CMM = "Month of Fiscal Year End";
    public static final String ACC_FIS_LEG_COL_NM = "LegacyIdStr";
    public static final String ACC_FIS_LEG_IDX_NM = "idxLegacyId";
    public static final String FK_ACC_LEG_NM = "fkAccountLegacy";
    public static final String LEG_TBL_NM = "Legacy";
    public static final String LEG_ID_STR_COL_NM = "LegacyIdStr";
    public static final String DIS_TBL_NM = "Discount";
    public static final String DIS_ID_COL_NM = "DiscountId";
    public static final String MGR_TBL_NM = "Manager";
    public static final String MGR_ID_NM = "Id";
    public static final String MGR_NM_NM = "Name";
    public static final String MGR_BOSS_ID = "BossId";
    public static final String PAY_TBL_NM_OLD = "Payment";
    public static final String PAY_TBL_NM_NEW = "Payable";
    public static final String PAY_AMT_COL_NM = "Amount";
    public static final String PAY_TAX_COL_NM = "Tax";
    public static final String PAY_PAID_COL_NM = "Paid";
    public static final String PET_TBL_NM = "PettyCash";
    public static final String PET_COL_AMT_NM = "Amount";
    public static final String PET_COL_NOTES_NM = "Notes";
    public static final String PET_IDX_AMT_NM = "idxAmount";
    public static final String PET_IDX_NOTES_NM = "idxNotes";
    public static final String LOAN_TBL_NM = "Loan";
    public static final String LOAN_COL_AMT_NM = "Amount";
    public static final String LOAN_COL_RATE_NM = "Rate";
    public static final String LOAN_COL_BR_NM_NM = "BrokerNm";
    public static final String LOAN_COL_INST_ID_NM = "InstituteId";
    public static final String LOAN_IDX_INST_ID_NM = "idxInstituteId";
    public static final String LOAN_IDX_MYSQL_OPT_TXT = "USING HASH";
    public static final String REF_TBL_NM = "Referral";
    public static final String OBSOLETE_TBL_NM = "ObsoleteTbl";
    public static final String FK_RPT_PATH_NM = "FkReportPathologist";
    public static final String FK_RPT_PATIENT_NM = "fkReportPatient";
    public static final String FK_PIC_RPT_NM = "fkPictureReport";
    public static final String FK_PIC_FILE_PIC_NM = "fkPictureFilePicture";
    public static final String FK_PIC_FILE_FILE_TYPE_NM = "fkPictureFileFileType";
    public static final String FK_SBN_SBR_NM = "fk_Subscription_Subscriber";
    public static final String FK_PIC_RPT_COMM_A = "Each Pic must be in a report";
    public static final String FK_PIC_RPT_COMM_B = "All pics require report (b)";
    public static final String FK_WBH_SBN_NM = "fkSubWebHit";
    public static final String FK_WBR_WBA_NM = "fkWebResWebAccType";
    public static final String FK_WBH_WBR_NM = "fkWebHitWebRes";
    public static final String FK_MGR_MGR_NM = "fkMgrMgrBoss";
    public static final String FK_SBR_DIS_NM = "fkSubscriberDiscount";
    public static final String MGR_NM_UC_NM = "uc_mgr_nm";
    public static final String X_SMALL_INT_NM = "xSmallInt";
    public static final String VW_RPT_SUMM_NM = "vwReportSummary";
    public static final String VW_RPT_SUMM_SQL = "SELECT p.\"Name\", pa.\"Name\" AS PatientName, rp.\"ReportId\" \nFROM \"Company\".\"Pathologist\" p \n\tJOIN \"Company\".\"Report\" rp ON p.\"PathologistId\" = rp.\"PathologistId\" \n\tJOIN \"Company\".\"Patient\" pa ON rp.\"PatientId\" = pa.\"PatientId\" ";
    public static final String VW_PIC_SUMM_NM = "vwPictureSummary";
    public static final String VW_PIC_SUMM_SQL = "SELECT pa.\"Name\", pic.\"Caption\"\nFROM \"Company\".\"Patient\" pa \n\tJOIN \"Company\".\"Report\" rp ON pa.\"PatientId\" = rp.\"PatientId\" \n\tJOIN \"Company\".\"Picture\" pic ON rp.\"ReportId\" = pic.\"ReportId\" ";
    public static final String VW_WBH_OLD_NM = "vwWbhOld";
    public static final String VW_SAME_NM = "vwSame";
    public static final String VW_WBH_NEW_NM = "vwWbhNew";
    public static final String VW_WBH_OLD_SQL = "SELECT \"ContactName\" FROM \"Outside\".\"Subscriber\"";
    public static final String VW_SAME_SQL = "SELECT \"PathologistId\" FROM \"Company\".\"Pathologist\"";
    public static final String VW_WBH_NEW_SQL = "SELECT \"ContactName\" FROM \"Website\".\"Subscriber\"";
    public static final String VW_WBH_OLD_SQL_ORCL = "SELECT \"ContactName\" FROM \"Website\".\"Subscriber\"";
    public static final String SEQ_OLD_COMMENT = "Old Seq Comment";
    public static final String SEQ_NEW_COMMENT = "New Seq Comment";
    public static final String SEQ_NM = "dbmsTestSequence";
    public static final int SEQ_INCR = 1;
    public static final String SEQ_FIN_ITEMS = "seqFinanceItems";
    public static final String BLOB_DATA = "SOME_LONG-BLOB!DATA,339DK39SJWILSJFI323093LJAFJI3020930JAJF\nSO2348UASNDFOI2O7349213NAOWE9R0283423987AFHAWEFAOWFEJAWEOFPJ";

    public DbmsTestData(JdbcConfig config) {
        this.setConfig(config);
    }

    public void setConfig(JdbcConfig config) {
        this.config_ = config;
        this.dbms_ = this.config_.getDbms();
        this.dbmsId_ = this.dbms_.getId();
        this.version_ = this.config_.getVersion();
        this.nowStr_ = this.config_.getNowStr();
        this.useSchemas_ = this.config_.supportsSchemas();
    }

    public void setDblQuoteMixedCase(boolean dblQuoteMixedCase) {
        this.dblQuoteMixedCase_ = dblQuoteMixedCase;
    }

    public Map getDatabases() {
        HashMap<String, Database> dbs = new HashMap<String, Database>();
        Database dbA = new Database(DB_NM);
        Database dbB = new Database(DB_NM);
        if (this.useSchemas_) {
            dbA.remove(Schema.getClassName(), "schemaA");
            dbB.remove(Schema.getClassName(), "schemaA");
        }
        this.dataTbls_ = new ArrayList();
        App.setDb(dbA);
        this.addCommonItems(dbA);
        this.addOldViews(dbA);
        App.setDb(dbB);
        this.addCommonItems(dbB);
        this.addUpdateItems(dbB);
        this.addNewViews(dbB);
        this.setDataTables(dbB);
        dbs.put(DB_A_KEY, dbA);
        dbs.put(DB_B_KEY, dbB);
        return dbs;
    }

    public Map getDbResetScripts() {
        HashMap scripts = new HashMap();
        return scripts;
    }

    public Map getDbDataInsertScripts() {
        HashMap scripts = new HashMap();
        return scripts;
    }

    private void addCommonItems(Database db) {
        Schema schCurrent = null;
        Schema schCurrentFinance = null;
        Schema schInternal = null;
        if (this.useSchemas_) {
            schInternal = new Schema(SCH_CMPY_NM);
            schInternal.setComment(SCH_CMPY_CMM_OLD);
            db.add(schInternal);
            schCurrent = schInternal;
            this.addCustomTypes(schInternal);
        } else {
            schCurrent = db.getSchema("schemaA");
        }
        schCurrentFinance = schCurrent;
        if (this.isOracle()) {
            schCurrentFinance = new Schema(SCH_FIN_NM);
            db.add(schCurrentFinance);
        }
        schCurrent.add(this.getPathologistTable());
        schCurrent.add(this.getReportTable());
        schCurrent.add(this.getPatientTable());
        schCurrent.add(this.getPictureTable());
        schCurrent.add(this.getPictureFileTable());
        schCurrentFinance.add(this.getInvoiceTable());
        schCurrent.add(this.getGroupsTable());
        schCurrentFinance.add(this.getPettyCashTable());
        schCurrentFinance.add(this.getPayableTable());
        schCurrentFinance.add(this.getReferralTable());
        schCurrent.add(this.getManagerTable());
        schCurrent.add(this.getObsoleteTable());
        if (this.dbmsId_ != 2) {
            schCurrent.add(this.getDataTypesTableDisp(schInternal));
        }
        if (this.dbmsId_ == 0) {
            schCurrent.add(this.getCameraTable());
        }
        if (this.useSchemas_) {
            Schema schWeb = new Schema(this.getWebSchNm(0));
            if (this.config_.isPsql()) {
                schWeb.setComment(SCH_WEB_CMM);
            }
            db.add(schWeb);
            schCurrent = schWeb;
        }
        schCurrent.add(this.getSubscriberTable());
        schCurrent.add(this.getSubscriptionTable());
        schCurrent.add(this.getWebResAccessTypeTable());
        schCurrent.add(this.getWebResourceHitTable());
        schCurrent.add(this.getWebResourceTable());
        if (this.isOracle()) {
            schCurrentFinance.add(this.getDiscountTable());
        } else {
            schCurrent.add(this.getDiscountTable());
        }
        if (this.dbmsId_ != 0) {
            schCurrent.add(this.getAccountTableWeb());
        }
        if (this.useSchemas_) {
            Schema schResearch = new Schema(SCH_RSH_NM);
            db.add(schResearch);
        }
        this.addCommonFks(db);
        this.addCommonViews(db);
        this.addCommonProcs(db);
        if (this.config_.supportsSequences()) {
            this.addCommonSeqs(db);
        }
        this.addTableOptions(db);
        Diagram diagram = DataGenSketch.getEmptyDiagram(db, DIA_A_NM);
        db.add(diagram);
    }

    private boolean isMySql() {
        return this.config_.isMySql();
    }

    private boolean isOracle() {
        return this.config_.isOracle();
    }

    private boolean isPsql() {
        return this.config_.isPsql();
    }

    private boolean isSqlSvr() {
        return this.config_.isSqlSvr();
    }

    private Column getIntegerIdCol(String colNm, int dataTypeId, boolean autoNumber) {
        return this.getIntegerIdCol(colNm, dataTypeId, WBR_URL_DEF_OLD, WBR_URL_DEF_OLD, false, autoNumber);
    }

    private Column getIntegerIdCol(String colNm, int dataTypeId) {
        return this.getIntegerIdCol(colNm, dataTypeId, WBR_URL_DEF_OLD, WBR_URL_DEF_OLD, false, false);
    }

    private Column getIntegerIdCol(String colNm, int dataTypeId, String defStr, String cmm, boolean nullable, boolean autonumber) {
        try {
            if (!this.isOracle()) {
                return new Column(colNm, dataTypeId, null, nullable, autonumber, defStr, null, cmm);
            }
            return new Column(colNm, 780, new Integer(10), nullable, autonumber, defStr, new Integer(0), cmm);
        }
        catch (Exception e) {
            LogUtil.logErr(e.getMessage());
            return null;
        }
    }

    private int getValidTypeId(int requestedTypeId) {
        if (!this.isOracle()) {
            return requestedTypeId;
        }
        switch (requestedTypeId) {
            case 4: {
                return 780;
            }
            case 16: {
                return 780;
            }
            case 3: {
                return 780;
            }
            case 8: {
                return 780;
            }
            case 6: {
                return 780;
            }
            case 701: {
                return 780;
            }
            case 12: {
                return 781;
            }
        }
        return requestedTypeId;
    }

    private int getValidOnDeleteId(int requestedId) {
        if (!this.isOracle()) {
            return requestedId;
        }
        switch (requestedId) {
            case 1: {
                return 2;
            }
            case 4: {
                return 2;
            }
        }
        return requestedId;
    }

    private boolean isPsqlVersionWithRegClass() {
        Version version = this.config_.getVersion();
        boolean hasRegClass = true;
        if (version != null) {
            int major = this.config_.getVersion().getLevel1();
            hasRegClass = major >= 8;
        }
        return hasRegClass;
    }

    private void setDataTables(Database dbB) {
        Schema schCurrent = null;
        schCurrent = this.useSchemas_ ? dbB.getSchema(SCH_CMPY_NM) : dbB.getSchema("schemaA");
        this.dataTbls_.add(schCurrent.getTable(PATH_TBL_NM));
        this.dataTbls_.add(schCurrent.getTable(RPT_TBL_NM));
        this.dataTbls_.add(schCurrent.getTable(PATIENT_TBL_NM));
        this.dataTbls_.add(schCurrent.getTable(PIC_TBL_NM));
        this.dataTbls_.add(schCurrent.getTable(PIC_FILE_TBL_NM));
        this.dataTbls_.add(schCurrent.getTable(GROUPS_TBL_NM));
        this.dataTbls_.add(schCurrent.getTable(FILE_TYPE_TBL_NM));
        this.dataTbls_.add(schCurrent.getTable(MGR_TBL_NM));
        if (this.config_.isMySql()) {
            this.dataTbls_.add(schCurrent.getTable(CAM_TBL_NM));
        }
        if (this.useSchemas_) {
            schCurrent = dbB.getSchema(this.getWebSchNm(1));
        }
        this.dataTbls_.add(schCurrent.getTable(SBR_TBL_NM));
        this.dataTbls_.add(schCurrent.getTable(SBN_TBL_NM));
        this.dataTbls_.add(schCurrent.getTable(WBA_TBL_NM));
        this.dataTbls_.add(schCurrent.getTable(WBR_TBL_NM_NEW));
        this.dataTbls_.add(schCurrent.getTable(WBH_TBL_NM));
        if (this.useSchemas_) {
            schCurrent = dbB.getSchema(SCH_FIN_NM);
        }
        this.dataTbls_.add(schCurrent.getTable(INV_TBL_NM_NEW));
    }

    public List getDataTables() {
        return this.dataTbls_;
    }

    public List getTableGlyphsAll(Database db) {
        Diagram diagram = db.getDiagram(DIA_A_NM);
        ArrayList<DbTableGlyph> tableGlyphs = new ArrayList<DbTableGlyph>();
        for (Schema schema : db.values(Schema.getClassName())) {
            for (Table table : schema.values(Table.getClassName())) {
                DbTableGlyph glyph = new DbTableGlyph(new Point(0, 0), table, diagram);
                tableGlyphs.add(glyph);
            }
        }
        return tableGlyphs;
    }

    private String getWebSchNm(int dbVersion) {
        String schNm = SCH_WEB_NM_OLD;
        if (dbVersion == 1) {
            schNm = SCH_WEB_NM_NEW;
        }
        if (this.isOracle()) {
            schNm = SCH_WEB_NM_NEW;
        }
        return schNm;
    }

    private Table getPathologistTable() {
        Table table = new Table(PATH_TBL_NM);
        String defaultStr = this.getHireDateDefaultFunction();
        try {
            Column nameCol = new Column("Name", this.getValidTypeId(12), PATH_NAME_LN, false, false, WBR_URL_DEF_OLD, null, PATH_NAME_COM);
            Column hireCol = new Column(PATH_HIRE_DATE_NM, 91, null, false, false, defaultStr, null, WBR_URL_DEF_OLD);
            Column idCol = this.getIntegerIdCol(PATH_ID_NM, 4);
            Column empIdCol = this.getIntegerIdCol(PATH_EMP_ID_NM, 4);
            Column obsoleteCol = new Column(PATH_OBS_NM, this.getValidTypeId(4), null, true, false, "13", null, WBR_URL_DEF_OLD);
            nameCol.setUnique(true);
            table.add(nameCol);
            table.add(idCol);
            table.add(hireCol);
            table.add(empIdCol);
            table.add(obsoleteCol);
            ArrayList<String> pkCols = new ArrayList<String>();
            pkCols.add(PATH_ID_NM);
            PrimaryKey pk = new PrimaryKey(PATH_PK_NM, pkCols);
            table.setPrimaryKey(pk);
            if (!this.isOracle()) {
                ArrayList<IIndexColumn> idxCols = new ArrayList<IIndexColumn>();
                idxCols.add(nameCol);
                Index nameIndex = new Index(PATH_IDX_NAME_NM, idxCols, false, false);
                this.checkSetPsqlOptionText(nameIndex);
                table.add(nameIndex);
            }
            ArrayList<IIndexColumn> idxColsC = new ArrayList<IIndexColumn>();
            idxColsC.add((IIndexColumn)((Object)PATH_ID_NM));
            idxColsC.add((IIndexColumn)((Object)"Name"));
            idxColsC.add(idCol);
            idxColsC.add(nameCol);
            Index idxIdNm = new Index(PATH_IDX_ID_NM_NM, idxColsC, false, true);
            this.checkSetPsqlOptionText(idxIdNm);
            table.add(idxIdNm);
        }
        catch (Exception e) {
            LogUtil.printStackTrace(e);
        }
        return table;
    }

    private String getHireDateDefaultFunction() {
        String defaultStr = WBR_URL_DEF_OLD;
        int dbmsId = this.dbms_.getId();
        switch (dbmsId) {
            case 1: {
                defaultStr = PATH_HIRE_DATE_DEF_PSQL;
                break;
            }
            case 3: {
                defaultStr = PATH_HIRE_DATE_DEF_SQL_SVR;
                break;
            }
            case 0: {
                defaultStr = WBR_URL_DEF_OLD;
                break;
            }
            case 4: {
                defaultStr = PATH_HIRE_DATE_DEF_ORACLE;
            }
        }
        return defaultStr;
    }

    private Table getReportTable() {
        Table table = new Table(RPT_TBL_NM);
        table.setUseManualSort(true);
        String auto = this.isPsql() ? "nextval('company.report_reportid_seq'::regclass)" : WBR_URL_DEF_OLD;
        int textTypeId = this.isOracle() ? 783 : 703;
        try {
            Column idCol = this.getIntegerIdCol(RPT_ID_NM, 4, true);
            idCol.setDefaultValue(auto);
            Column pathIdCol = this.getIntegerIdCol(PATH_ID_NM, 4, PATIENT_SOURCE_ID_CONV_VAL, WBR_URL_DEF_OLD, false, false);
            Column publishCol = new Column(RPT_PUBLISH_TIME_NM, this.getTimeStampTypeId(), null, true);
            Column textCol = new Column(RPT_REPORT_TEXT_NM, textTypeId, RPT_REPORT_TEXT_LN, true);
            Column patientIdCol = new Column(PATIENT_ID_NM, this.getValidTypeId(4), PATIENT_ID_LN, false);
            table.add(idCol);
            table.add(pathIdCol);
            table.add(publishCol);
            table.add(textCol);
            table.add(patientIdCol);
            ArrayList<String> pkCols = new ArrayList<String>();
            pkCols.add(RPT_ID_NM);
            PrimaryKey pk = new PrimaryKey(RPT_PK_NM, pkCols);
            table.setPrimaryKey(pk);
            Index pathIndex = new Index(RPT_IDX_PATH_ID_NM, pathIdCol, false, false);
            this.checkSetPsqlOptionText(pathIndex);
            table.add(pathIndex);
            Index patientIndex = new Index(RPT_IDX_PATIENT_ID_NM, patientIdCol, false, false);
            this.checkSetPsqlOptionText(patientIndex);
            table.add(patientIndex);
            String sql = this.getReportTrgSql();
            Trigger trg = new Trigger(RPT_TRG_NM, false, true, true, sql, true, true);
            table.add(trg);
        }
        catch (Exception e) {
            LogUtil.printStackTrace(e);
        }
        return table;
    }

    private String getReportTrgSql() {
        String sql = "(Unsupported Dbms)";
        switch (this.config_.getDbmsId()) {
            case 3: {
                sql = RPT_TRG_SQL;
                break;
            }
            case 1: {
                sql = RPT_TRG_FN_NM;
                break;
            }
            case 4: {
                sql = RPT_TRG_SQL_ORACLE;
            }
        }
        sql = this.chkStripQuotes(sql);
        return sql;
    }

    private Table getSubscriberTable() {
        Table table = new Table(SBR_TBL_NM);
        table.setUseManualSort(true);
        try {
            Column companyIdCol = this.getIntegerIdCol("CompanyId", 4);
            Column branchIdCol = this.getIntegerIdCol("BranchId", 4);
            Column contactCol = new Column(SBR_CONTACT_NM, 1, new Integer(50), false);
            Column discIdCol = new Column(DIS_ID_COL_NM, this.getValidTypeId(4), null, true);
            table.add(companyIdCol);
            table.add(branchIdCol);
            table.add(contactCol);
            table.add(discIdCol);
            ArrayList<String> pkCols = new ArrayList<String>();
            pkCols.add("CompanyId");
            pkCols.add("BranchId");
            PrimaryKey pk = new PrimaryKey(SBR_PK_NM, pkCols);
            table.setPrimaryKey(pk);
            Index nameIndex = new Index(SBR_IDX_NAME_NM, contactCol, false, false);
            this.checkSetPsqlOptionText(nameIndex);
            table.add(nameIndex);
            Index disIndex = new Index(SBR_IDX_DIS_NM, discIdCol, false, false);
            this.checkSetPsqlOptionText(disIndex);
            table.add(disIndex);
            if (this.config_.supportUniqueConstraint()) {
                ArrayList<Column> ucCols = new ArrayList<Column>();
                ucCols.add(table.getColumn(SBR_CONTACT_NM));
                UniqueConstraint uc = new UniqueConstraint(table, ucCols, SBR_CONTACT_DISC_UC_NM);
                table.add(uc);
            }
        }
        catch (Exception e) {
            LogUtil.printStackTrace(e);
        }
        return table;
    }

    private Table getSubscriptionTable() {
        Table table = new Table(SBN_TBL_NM);
        table.setUseManualSort(true);
        try {
            Column idCol = new Column(SBN_ID_NM, this.getValidTypeId(4), null, false);
            Column companyIdCol = new Column("CompanyId", this.getValidTypeId(4), null, false);
            Column branchIdCol = new Column("BranchId", this.getValidTypeId(4), null, false);
            Column yearCol = new Column(SBN_YEAR_NM, this.getValidTypeId(4), null, true);
            table.add(idCol);
            table.add(companyIdCol);
            table.add(branchIdCol);
            table.add(yearCol);
            ArrayList<String> pkCols = new ArrayList<String>();
            pkCols.add(SBN_ID_NM);
            PrimaryKey pk = new PrimaryKey(SBN_PK_NM, pkCols);
            table.setPrimaryKey(pk);
            if (this.dbmsId_ == 0 && this.version_ != null) {
                ArrayList<IIndexColumn> idxCols = new ArrayList<IIndexColumn>();
                idxCols.add(companyIdCol);
                idxCols.add(branchIdCol);
                Index fkIdx = new Index("SubscriptionMysqlFkIdx", idxCols, false, false);
                this.checkSetPsqlOptionText(fkIdx);
                table.add(fkIdx);
            }
        }
        catch (Exception e) {
            LogUtil.printStackTrace(e);
        }
        return table;
    }

    private Table getPatientTable() {
        Table table = new Table(PATIENT_TBL_NM);
        String auto = this.isPsql() ? "nextval('company.patient_patientid_seq'::regclass)" : WBR_URL_DEF_OLD;
        try {
            Column nameCol = new Column("Name", this.getValidTypeId(12), PATIENT_NAME_LN, false);
            Column idCol = this.getIntegerIdCol(PATIENT_ID_NM, 4, true);
            idCol.setDefaultValue(auto);
            table.add(nameCol);
            table.add(idCol);
            ArrayList<String> pkCols = new ArrayList<String>();
            pkCols.add(PATIENT_ID_NM);
            PrimaryKey pk = new PrimaryKey(PATIENT_PK_NM, pkCols);
            table.setPrimaryKey(pk);
            Index nameIndex = new Index(PATIENT_IDX_NAME_NM, nameCol, false, false);
            this.checkSetPsqlOptionText(nameIndex);
            table.add(nameIndex);
            if (this.dbmsId_ == 1) {
                String trgFuncNm = this.chkStripQuotes(PATIENT_TRG_FN_NM);
                Trigger trg = new Trigger(PATIENT_TRG_NM, true, false, false, trgFuncNm, true, true);
                table.add(trg);
            }
        }
        catch (Exception e) {
            LogUtil.printStackTrace(e);
        }
        return table;
    }

    private Table getPictureTable() {
        Table table = new Table(PIC_TBL_NM);
        table.setComment(PIC_TBL_COM);
        String auto = this.isPsql() ? "nextval('company.picture_pictureid_seq'::regclass)" : WBR_URL_DEF_OLD;
        try {
            Column captionCol = new Column(PIC_CAPTION_NM, this.getValidTypeId(12), PIC_CAPTION_LN, false);
            Column idCol = this.getIntegerIdCol(PIC_ID_NM, 4, true);
            idCol.setDefaultValue(auto);
            Column colorLevelCol = new Column(PIC_COLOR_LEVEL_NM, this.getValidTypeId(4), null, false);
            Column reportIdCol = this.getIntegerIdCol(RPT_ID_NM, 4, WBR_URL_DEF_OLD, WBR_URL_DEF_OLD, true, false);
            table.add(captionCol);
            table.add(colorLevelCol);
            table.add(idCol);
            table.add(reportIdCol);
            ArrayList<String> pkCols = new ArrayList<String>();
            pkCols.add(PIC_ID_NM);
            PrimaryKey pk = new PrimaryKey(PIC_PK_NM, pkCols);
            table.setPrimaryKey(pk);
            Index nameIndex = new Index(PIC_IDX_CAPTION_NM, captionCol, false, false);
            table.add(nameIndex);
            this.checkSetPsqlOptionText(nameIndex);
            Index rptIndex = new Index(PIC_IDX_RPT_ID_NM, reportIdCol, false, false);
            this.checkSetPsqlOptionText(rptIndex);
            table.add(rptIndex);
        }
        catch (Exception e) {
            LogUtil.printStackTrace(e);
        }
        return table;
    }

    private Table getCameraTable() {
        Table table = new Table(CAM_TBL_NM);
        try {
            Column idCol = new Column(CAM_ID_NM, 5, null, true, false, "2", null, WBR_URL_DEF_OLD, true, WBR_URL_DEF_OLD);
            Column typeCol = new Column(CAM_TYPE_NM, 706, null, true, false, "Digital", null, WBR_URL_DEF_OLD, true, CAM_TYPE_ENUM_CSV_OLD);
            table.add(idCol);
            table.add(typeCol);
            ArrayList<String> pkCols = new ArrayList<String>();
            pkCols.add(CAM_ID_NM);
            PrimaryKey pk = new PrimaryKey(CAM_PK_NM, pkCols);
            table.setPrimaryKey(pk);
        }
        catch (Exception e) {
            LogUtil.printStackTrace(e);
        }
        return table;
    }

    private Table getPictureFileTable() {
        Table table = new Table(PIC_FILE_TBL_NM);
        String defaultValue = WBR_URL_DEF_OLD;
        try {
            boolean autoNumber = true;
            Column idCol = this.getIntegerIdCol(PIC_FILE_ID_NM, 4, autoNumber);
            idCol.setDefaultValue(defaultValue);
            Column urlCol = new Column(PIC_FILE_URL_NM, this.getValidTypeId(1), PIC_FILE_URL_LN, false, false, PIC_FILE_URL_DEF, null, WBR_URL_DEF_OLD);
            Column picIdCol = this.getIntegerIdCol(PIC_ID_NM, 4, WBR_URL_DEF_OLD, WBR_URL_DEF_OLD, true, false);
            Column colFileTypeId = new Column(FILE_TYPE_ID_NM, this.getValidTypeId(4), null, true);
            table.add(idCol);
            table.add(urlCol);
            table.add(picIdCol);
            table.add(colFileTypeId);
            ArrayList<String> pkCols = new ArrayList<String>();
            pkCols.add(PIC_FILE_ID_NM);
            PrimaryKey pk = new PrimaryKey(PIC_FILE_PK_NM, pkCols);
            table.setPrimaryKey(pk);
            Index rptIndex = new Index(PIC_FILE_IDX_PIC_ID_NM, picIdCol, false, false);
            this.checkSetPsqlOptionText(rptIndex);
            table.add(rptIndex);
        }
        catch (Exception e) {
            LogUtil.printStackTrace(e);
        }
        return table;
    }

    private Table getInvoiceTable() {
        Table table = new Table(INV_TBL_NM_OLD);
        table.setComment(INV_TBL_COM);
        Integer laborLen = !this.isOracle() ? INV_LABOR_LN : null;
        Integer laborScale = !this.isOracle() ? INV_LABOR_SCALE : null;
        Integer amtLen = !this.isOracle() ? INV_AMOUNT_LN : null;
        Integer amtScale = !this.isOracle() ? INV_AMOUNT_SCALE : null;
        Integer sentLen = null;
        String auto = this.isPsql() ? "nextval('finance.receivable_id_seq'::regclass)" : WBR_URL_DEF_OLD;
        try {
            Column idCol = this.getIntegerIdCol("Id", 4, true);
            idCol.setDefaultValue(auto);
            Column amountCol = new Column("Amount", this.getValidTypeId(3), amtLen, false, false, "0", amtScale, INV_AMOUNT_COM);
            Column laborCol = new Column(INV_LABOR_NM, this.getValidTypeId(3), laborLen, true, false, INV_LABOR_DEF, laborScale, WBR_URL_DEF_OLD);
            Column paidCol = new Column(INV_PAID_NM, this.getValidTypeId(16), INV_PAID_LN, false, false, "0", null, INV_PAID_COM);
            Column sentCol = new Column(INV_SENT_NM, this.getValidTypeId(16), sentLen, false);
            Column legacyCol = new Column(INV_LEGACY_ID_NM, this.getValidTypeId(4), INV_LEGACY_ID_LN, true);
            Column codeNameCol = new Column(INV_CODENAME_NM, this.getValidTypeId(12), INV_CODENAME_LN, true);
            Column reportIdCol = this.getIntegerIdCol(RPT_ID_NM, 4);
            table.setUseManualSort(true);
            table.add(idCol);
            table.add(codeNameCol);
            table.add(amountCol);
            table.add(laborCol);
            table.add(paidCol);
            table.add(sentCol);
            table.add(legacyCol);
            table.add(reportIdCol);
            ArrayList<String> pkCols = new ArrayList<String>();
            pkCols.add("Id");
            PrimaryKey pk = new PrimaryKey(INV_PK_NM, pkCols);
            table.setPrimaryKey(pk);
            Index index = new Index(INV_IDX_CODENAME_NM, codeNameCol, false, false);
            this.checkSetPsqlOptionText(index);
            table.add(index);
        }
        catch (Exception e) {
            LogUtil.printStackTrace(e);
        }
        return table;
    }

    private Table getFileTypeTable() {
        Table table = new Table(FILE_TYPE_TBL_NM);
        String auto = this.isPsql() ? "nextval('company.filetype_filetypeid_seq'::regclass)" : WBR_URL_DEF_OLD;
        try {
            Column nameCol = new Column("Name", this.getValidTypeId(12), FILE_TYPE_NAME_LN, false);
            Column idCol = this.getIntegerIdCol(FILE_TYPE_ID_NM, 4, true);
            idCol.setDefaultValue(auto);
            table.add(nameCol);
            table.add(idCol);
            ArrayList<String> pkCols = new ArrayList<String>();
            pkCols.add(FILE_TYPE_ID_NM);
            PrimaryKey pk = new PrimaryKey(FILE_TYPE_PK_NM, pkCols);
            table.setPrimaryKey(pk);
            Index nameIndex = new Index(FILE_TYPE_IDX_NAME_NM, nameCol, false, false);
            this.checkSetPsqlOptionText(nameIndex);
            table.add(nameIndex);
        }
        catch (Exception e) {
            LogUtil.printStackTrace(e);
        }
        return table;
    }

    private Table getGroupsTable() {
        Table table = new Table(GROUPS_TBL_NM);
        String auto = this.isPsql() ? "nextval('company.groups_id_seq'::regclass)" : WBR_URL_DEF_OLD;
        try {
            Column descCol = new Column(GROUPS_DESC_NM, this.getValidTypeId(12), GROUPS_DESC_LN, false);
            Column idCol = this.getIntegerIdCol("Id", 4, true);
            idCol.setDefaultValue(auto);
            Column iconCol = new Column(GROUPS_ICON_NM, 2004, null, true);
            Column misStmtCol = new Column(GROUPS_MIS_STMT_NM, this.getValidTypeId(12), 500, true);
            Column insertByCol = new Column(GROUPS_INSERT_BY_NM, this.getValidTypeId(12), GROUPS_INSERT_BY_LN, false);
            Column updateByCol = new Column(GROUPS_UPDATE_BY_NM, this.getValidTypeId(12), GROUPS_UPDATE_BY_LN, true);
            Column insertDateCol = new Column(GROUPS_INSERT_DATE_NM, this.getTimeStampTypeId(), null, false);
            Column updateDateCol = new Column(GROUPS_UPDATE_DATE_NM, this.getTimeStampTypeId(), null, true);
            table.setUseManualSort(true);
            table.add(idCol);
            table.add(descCol);
            table.add(iconCol);
            table.add(misStmtCol);
            table.add(insertByCol);
            table.add(updateByCol);
            table.add(insertDateCol);
            table.add(updateDateCol);
            ArrayList<String> pkCols = new ArrayList<String>();
            pkCols.add("Id");
            PrimaryKey pk = new PrimaryKey(GROUPS_PK_NM, pkCols);
            table.setPrimaryKey(pk);
            Index nameIndex = new Index(GROUPS_IDX_DESC_NM, descCol, false, false);
            this.checkSetPsqlOptionText(nameIndex);
            table.add(nameIndex);
        }
        catch (Exception e) {
            LogUtil.printStackTrace(e);
        }
        return table;
    }

    private Table getWebResourceTable() {
        Table table = new Table(WBR_TBL_NM_OLD);
        table.setUseManualSort(true);
        String auto = this.isPsql() ? "nextval('outside.webpage_id_seq'::regclass)" : WBR_URL_DEF_OLD;
        try {
            Column idCol = this.getIntegerIdCol("Id", 4, true);
            idCol.setDefaultValue(auto);
            Column urlCol = new Column(WBR_URL_NM_OLD, this.getValidTypeId(12), new Integer(100), true, false, WBR_URL_DEF_OLD, null, WBR_URL_CMM_OLD);
            Column accTypIdCol = this.getIntegerIdCol(WBR_ACC_TYPE_ID_NM, 4);
            Column changeBy = new Column(GEN_CHNG_BY, 1, new Integer(50), false);
            Column changeDate = new Column(GEN_CHNG_DATE, this.getTimeStampTypeId(), null, false);
            table.add(idCol);
            table.add(urlCol);
            table.add(accTypIdCol);
            table.add(changeBy);
            table.add(changeDate);
            ArrayList<String> pkCols = new ArrayList<String>();
            pkCols.add("Id");
            PrimaryKey pk = new PrimaryKey(WBR_PK_NM, pkCols);
            table.setPrimaryKey(pk);
            Index idx = new Index(WBR_IDX_ACC_ID_NM, accTypIdCol, false, false);
            this.checkSetPsqlOptionText(idx);
            table.add(idx);
        }
        catch (Exception e) {
            LogUtil.printStackTrace(e);
        }
        return table;
    }

    private Table getWebResourceHitTable() {
        Table table = new Table(WBH_TBL_NM);
        table.setUseManualSort(true);
        String auto = this.isPsql() ? "nextval('outside.webresourcehit_id_seq'::regclass)" : WBR_URL_DEF_OLD;
        try {
            Column idCol = this.getIntegerIdCol("Id", 4, WBR_URL_DEF_OLD, WBR_URL_DEF_OLD, false, true);
            idCol.setDefaultValue(auto);
            Column hitDateCol = new Column(WBH_HIT_DATE_NM_OLD, this.getTimeStampTypeId(), null, false);
            Column webResIdCol = new Column(WBH_WBR_NM_OLD, this.getValidTypeId(4), null, false);
            Column subscriberCol = new Column(WBH_SBR_ID_NM, this.getValidTypeId(4), null, false);
            Column incrCol = new Column(WBH_INCR_NM, this.getValidTypeId(4), null, true, false, "1", null, WBH_INCR_CMM, false, WBR_URL_DEF_OLD);
            Column changeBy = new Column(GEN_CHNG_BY, 1, new Integer(50), false);
            Column changeDate = new Column(GEN_CHNG_DATE, this.getTimeStampTypeId(), null, false);
            table.add(idCol);
            table.add(hitDateCol);
            table.add(webResIdCol);
            table.add(subscriberCol);
            table.add(incrCol);
            table.add(changeBy);
            table.add(changeDate);
            ArrayList<String> pkCols = new ArrayList<String>();
            pkCols.add("Id");
            PrimaryKey pk = new PrimaryKey(WBH_PK_NM, pkCols);
            table.setPrimaryKey(pk);
            Index idxWbr = new Index(WBH_IDX_RES_ID_NM, webResIdCol, false, false);
            this.checkSetPsqlOptionText(idxWbr);
            table.add(idxWbr);
            Index idxSbr = new Index(WBH_IDX_SBR_ID_NM, subscriberCol, false, false);
            this.checkSetPsqlOptionText(idxSbr);
            table.add(idxSbr);
        }
        catch (Exception e) {
            LogUtil.printStackTrace(e);
        }
        return table;
    }

    private Table getWebResAccessTypeTable() {
        Table table = new Table(WBA_TBL_NM);
        table.setUseManualSort(true);
        String auto = this.isPsql() ? "nextval(('outside.webresourceaccesstype_uid_seq'::text)::regclass)" : WBR_URL_DEF_OLD;
        try {
            Column idCol = this.getIntegerIdCol(WBA_ID_NM_OLD, 4, true);
            idCol.setDefaultValue(auto);
            idCol.setAutoNumber(true);
            Column desCol = new Column(WBA_ACC_DES_NM_OLD, this.getValidTypeId(12), new Integer(100), false);
            Column changeBy = new Column(GEN_CHNG_BY, 1, new Integer(50), false);
            Column changeDate = new Column(GEN_CHNG_DATE, this.getTimeStampTypeId(), null, false);
            table.add(idCol);
            table.add(desCol);
            table.add(changeBy);
            table.add(changeDate);
            ArrayList<String> pkCols = new ArrayList<String>();
            pkCols.add(WBA_ID_NM_OLD);
            PrimaryKey pk = new PrimaryKey("pkWebResAccTbl", pkCols);
            table.setPrimaryKey(pk);
            Index nameIndex = new Index("idxWbaName", desCol, false, false);
            this.checkSetPsqlOptionText(nameIndex);
            table.add(nameIndex);
        }
        catch (Exception e) {
            LogUtil.printStackTrace(e);
        }
        return table;
    }

    private Table getDiscountTable() {
        Table table = new Table(DIS_TBL_NM);
        table.setUseManualSort(true);
        try {
            Column idCol = this.getIntegerIdCol(DIS_ID_COL_NM, 4);
            table.add(idCol);
            ArrayList<String> pkCols = new ArrayList<String>();
            pkCols.add(DIS_ID_COL_NM);
            PrimaryKey pk = new PrimaryKey("pkDiscount", pkCols);
            table.setPrimaryKey(pk);
        }
        catch (Exception e) {
            LogUtil.printStackTrace(e);
        }
        return table;
    }

    private Table getDataTypesTableDisp(Schema schCmpy) {
        if (this.config_.isSqlSvr()) {
            return this.getDTTableSqlSvr(schCmpy);
        }
        if (this.config_.isPsql()) {
            return this.getDTTablePsql(schCmpy);
        }
        if (this.config_.isMySql()) {
            return this.getDTTableMySql();
        }
        if (this.isOracle()) {
            return this.getDTTableOracle(schCmpy);
        }
        return null;
    }

    private Table getDTTableSqlSvr(Schema schInt) {
        Table table = new Table(DT_TBL_NM);
        table.setUseManualSort(true);
        CustomType customType = schInt.getCustomType(CUSTOM_TYPE_INT_NM);
        try {
            table.add(new Column("id", 4, null, false, true, WBR_URL_DEF_OLD, null, WBR_URL_DEF_OLD));
            table.add(new Column("xSmallDataTime", 726, null, true));
            table.add(new Column("xNumeric", 2, new Integer(10), true, false, WBR_URL_DEF_OLD, new Integer(3), WBR_URL_DEF_OLD));
            table.add(new Column("xNChar", 722, new Integer(10), true));
            table.add(new Column("xNText", 723, null, true));
            table.add(new Column("xNVarChar", 724, new Integer(125), true));
            table.add(new Column("xImage", 721, null, true));
            table.add(new Column("xSqlVariant", 725, null, true));
            table.add(new Column(CUSTOM_TYPE_INT_COL_NM, customType, null, true, false, WBR_URL_DEF_OLD, null, WBR_URL_DEF_OLD, WBR_URL_DEF_OLD));
            if (this.config_.isSqlSvr2005()) {
                table.add(new Column("xXml", 728, null, true));
            }
            ArrayList<String> pkCols = new ArrayList<String>();
            pkCols.add("id");
            PrimaryKey pk = new PrimaryKey("pkDataType", pkCols);
            table.setPrimaryKey(pk);
        }
        catch (Exception e) {
            LogUtil.printStackTrace(e);
        }
        return table;
    }

    private Table getDTTableOracle(Schema schCmpy) {
        Table table = new Table(DT_TBL_NM);
        table.setUseManualSort(true);
        CustomType customType = schCmpy.getCustomType(CUSTOM_TYPE_INT_NM);
        try {
            Column timeStampCol = new Column("xTIMESTAMP", 93, null, true);
            timeStampCol.setDefaultValue("sysDate");
            Column vChar2Col = new Column("xVarChar2", 781, new Integer(125), true);
            vChar2Col.setDefaultValue("null");
            table.add(new Column("id", this.getValidTypeId(4), null, false, true, WBR_URL_DEF_OLD, null, WBR_URL_DEF_OLD));
            table.add(new Column("xNumber", 780, null, true));
            table.add(vChar2Col);
            table.add(new Column(NVARCHAR2_COL_NM, 782, new Integer(125), true));
            table.add(new Column("xCLOB", 783, null, true));
            table.add(new Column("xNCLOB", 784, null, true));
            table.add(new Column("xRAW", 785, new Integer(125), true));
            table.add(timeStampCol);
            table.add(new Column(CUSTOM_TYPE_INT_COL_NM, customType, null, true, false, WBR_URL_DEF_OLD, null, WBR_URL_DEF_OLD, WBR_URL_DEF_OLD));
            ArrayList<String> pkCols = new ArrayList<String>();
            pkCols.add("id");
            PrimaryKey pk = new PrimaryKey("pkDataType", pkCols);
            table.setPrimaryKey(pk);
        }
        catch (Exception e) {
            LogUtil.printStackTrace(e);
        }
        return table;
    }

    private Table getDTTablePsql(Schema schInt) {
        Table table = new Table(DT_TBL_NM);
        table.setUseManualSort(true);
        CustomType customType = schInt.getCustomType(CUSTOM_TYPE_INT_NM);
        String defaultValue = WBR_URL_DEF_OLD;
        try {
            table.add(new Column("id", 4, null, false, true, defaultValue, null, WBR_URL_DEF_OLD));
            table.add(new Column("xBigint", -5, null, true));
            table.add(new Column("xBytea", 760, null, true));
            table.add(new Column("xBit", -7, new Integer(5), true));
            table.add(new Column("xBox", 761, null, true));
            table.add(new Column("xBinary", -2, null, true));
            table.add(new Column("xChar", 1, new Integer(10), true));
            table.add(new Column("xCidr", 763, null, true));
            table.add(new Column("xCircle", 762, null, true));
            table.add(new Column("xDate", 91, null, true));
            table.add(new Column("xDecimal", 3, null, true));
            table.add(new Column("xDouble", 8, null, true));
            table.add(new Column("xFloat", 6, null, true));
            table.add(new Column("xInet", 764, null, true));
            table.add(new Column("xInterval", 765, null, true));
            table.add(new Column("xJson", 786, null, true));
            table.add(new Column("xJsonB", 787, null, true));
            table.add(new Column("xLine", 766, null, true));
            table.add(new Column("xLseg", 767, null, true));
            table.add(new Column("xMacaddr", 768, null, true));
            table.add(new Column("xMoney", 701, null, true));
            table.add(new Column("xNumeric", 2, null, true));
            table.add(new Column("xPath", 769, null, true));
            table.add(new Column("xPoint", 770, null, true));
            table.add(new Column("xPolygon", 771, null, true));
            table.add(new Column("xReal", 7, null, true));
            table.add(new Column(X_SMALL_INT_NM, 5, null, true));
            table.add(new Column("xText", 703, null, true));
            table.add(new Column("xTime", 92, null, true));
            table.add(new Column("xTimeTz", 773, null, true));
            table.add(new Column("xTimestamp", 93, null, true));
            table.add(new Column("xTimestampTz", 772, null, true));
            table.add(new Column("xTsQuery", 776, null, true));
            table.add(new Column("xTsVector", 775, null, true));
            table.add(new Column("xUnique", 704, null, true));
            table.add(new Column("xUuid", 774, null, true));
            table.add(new Column("xVarbinary", -3, null, true));
            table.add(new Column(VAR_CHAR_NULL_LEN_COL_NM, 12, null, true));
            table.add(new Column(CUSTOM_TYPE_INT_COL_NM, customType, null, true, false, WBR_URL_DEF_OLD, null, WBR_URL_DEF_OLD, WBR_URL_DEF_OLD));
            table.add(new Column(DASH_COL_NM, 4, null, true));
            ArrayList<String> pkCols = new ArrayList<String>();
            pkCols.add("id");
            PrimaryKey pk = new PrimaryKey("pkDataType", pkCols);
            table.setPrimaryKey(pk);
        }
        catch (Exception e) {
            LogUtil.printStackTrace(e);
        }
        return table;
    }

    private void addCustomTypes(Schema sch) {
        CustomType intType = CustomTypeIdCtrl.instance().createCustomType(sch.getDb(), CUSTOM_TYPE_INT_NM, WBR_URL_DEF_OLD);
        CustomType vcharType = CustomTypeIdCtrl.instance().createCustomType(sch.getDb(), CUSTOM_TYPE_VCHAR_NM, WBR_URL_DEF_OLD);
        sch.add(intType);
        sch.add(vcharType);
    }

    private Table getDTTableMySql() {
        Table table = new Table(DT_TBL_NM);
        table.setUseManualSort(true);
        try {
            table.add(new Column("id", 4, null, false, true, WBR_URL_DEF_OLD, null, WBR_URL_DEF_OLD));
            table.add(new Column("xSet", 740, null, true, false, WBR_URL_DEF_OLD, null, WBR_URL_DEF_OLD, true, "'itemA', 'itemB', 'itemC'"));
            ArrayList<String> pkCols = new ArrayList<String>();
            pkCols.add("id");
            PrimaryKey pk = new PrimaryKey("pkDataType", pkCols);
            table.setPrimaryKey(pk);
        }
        catch (Exception e) {
            LogUtil.printStackTrace(e);
        }
        return table;
    }

    private Table getLoanTable(Schema schInt) {
        Table table = new Table(LOAN_TBL_NM);
        table.setUseManualSort(true);
        int textTypeId = this.isOracle() ? 783 : 703;
        Integer amtLen = !this.isOracle() ? new Integer(10) : null;
        Integer amtScale = !this.isOracle() ? new Integer(2) : null;
        boolean supportsCustomTypes = this.config_.supportsCustomTypes();
        IDataType vCharCustomType = supportsCustomTypes ? schInt.getCustomType(CUSTOM_TYPE_VCHAR_NM) : DataTypeSvr.getDataType(textTypeId);
        IDataType intCustomType = supportsCustomTypes ? schInt.getCustomType(CUSTOM_TYPE_INT_NM) : DataTypeSvr.getDataType(this.getValidTypeId(4));
        try {
            String defStr = WBR_URL_DEF_OLD;
            if (this.config_.isPsql()) {
                defStr = this.isPsqlVersionWithRegClass() ? "nextval(('\"Finance\".\"seqFinanceItems\"'::text)::regclass)" : "nextval('\"Finance\".\"seqFinanceItems\"'::text)";
                defStr = this.chkStripQuotes(defStr);
            }
            Column idCol = this.getIntegerIdCol("Id", 4, defStr, WBR_URL_DEF_OLD, false, true);
            Column amtCol = new Column("Amount", this.getValidTypeId(3), amtLen, true, false, WBR_URL_DEF_OLD, amtScale, WBR_URL_DEF_OLD);
            Column rateCol = new Column(LOAN_COL_RATE_NM, this.getValidTypeId(6), null, true);
            Column brokerCol = new Column(LOAN_COL_BR_NM_NM, vCharCustomType, null, true, false, WBR_URL_DEF_OLD, null, WBR_URL_DEF_OLD, WBR_URL_DEF_OLD);
            Column instCol = new Column(LOAN_COL_INST_ID_NM, intCustomType, null, true, false, WBR_URL_DEF_OLD, null, WBR_URL_DEF_OLD, WBR_URL_DEF_OLD);
            table.add(idCol);
            table.add(amtCol);
            table.add(rateCol);
            table.add(brokerCol);
            table.add(instCol);
            ArrayList<String> pkCols = new ArrayList<String>();
            pkCols.add("Id");
            PrimaryKey pk = new PrimaryKey("pkLoan", pkCols);
            table.setPrimaryKey(pk);
            if (this.isMySql()) {
                Index idxInstituteId = new Index(LOAN_IDX_INST_ID_NM, instCol, false, false);
                idxInstituteId.setOptionText(LOAN_IDX_MYSQL_OPT_TXT);
                table.add(idxInstituteId);
            }
        }
        catch (Exception e) {
            LogUtil.printStackTrace(e);
        }
        return table;
    }

    private Table getAccountTableWeb() {
        Table table = new Table(ACC_TBL_NM);
        table.setUseManualSort(true);
        table.setComment(ACC_TBL_CMM_WEB);
        try {
            Column idCol = this.getIntegerIdCol("Id", 4);
            Column superCol = new Column(ACC_SUP_COL_NM, this.getValidTypeId(16), null, true);
            Column adminCol = new Column(ACC_CMP_ADM_COL_NM, this.getValidTypeId(16), null, true, false, WBR_URL_DEF_OLD, null, ACC_CMP_ADM_COL_CMM);
            Column suspendCol = new Column(ACC_SUS_COL_NM, this.getValidTypeId(16), null, true, false, WBR_URL_DEF_OLD, null, ACC_SUS_COL_CMM);
            table.add(idCol);
            table.add(superCol);
            table.add(adminCol);
            table.add(suspendCol);
            ArrayList<String> pkCols = new ArrayList<String>();
            pkCols.add("Id");
            PrimaryKey pk = new PrimaryKey("pkAccount", pkCols);
            table.setPrimaryKey(pk);
        }
        catch (Exception e) {
            LogUtil.printStackTrace(e);
        }
        return table;
    }

    private Table getAccountTableFinance() {
        Table table = new Table(ACC_TBL_NM);
        table.setUseManualSort(true);
        table.setComment(ACC_TBL_CMM_FIN);
        try {
            String defStr = WBR_URL_DEF_OLD;
            if (this.config_.isPsql()) {
                defStr = this.isPsqlVersionWithRegClass() ? "nextval(('\"Finance\".\"seqFinanceItems\"'::text)::regclass)" : "nextval('\"Finance\".\"seqFinanceItems\"'::text)";
                defStr = this.chkStripQuotes(defStr);
            }
            Column idCol = this.getIntegerIdCol("Id", 4, defStr, WBR_URL_DEF_OLD, false, true);
            Column taxCol = new Column(ACC_TAX_COL_NM, this.getValidTypeId(16), null, true);
            Column fiscalCol = new Column(ACC_FIS_COL_NM, this.getValidTypeId(4), null, true, false, WBR_URL_DEF_OLD, null, ACC_FIS_COL_CMM);
            Column legacyIdCol = new Column("LegacyIdStr", this.getValidTypeId(12), new Integer(10), true, false, WBR_URL_DEF_OLD, null, WBR_URL_DEF_OLD);
            table.add(idCol);
            table.add(taxCol);
            table.add(fiscalCol);
            table.add(legacyIdCol);
            ArrayList<String> pkCols = new ArrayList<String>();
            pkCols.add("Id");
            PrimaryKey pk = new PrimaryKey("pkAccount", pkCols);
            table.setPrimaryKey(pk);
            Index idxLegacy = new Index(ACC_FIS_LEG_IDX_NM, legacyIdCol, false, false);
            this.checkSetPsqlOptionText(idxLegacy);
            table.add(idxLegacy);
        }
        catch (Exception e) {
            LogUtil.printStackTrace(e);
        }
        return table;
    }

    private Table getLegacyTable() {
        Table table = new Table(LEG_TBL_NM);
        table.setUseManualSort(true);
        try {
            Column idStrCol = new Column("LegacyIdStr", this.getValidTypeId(12), new Integer(10), false);
            table.add(idStrCol);
            ArrayList<String> pkCols = new ArrayList<String>();
            pkCols.add(idStrCol.getName());
            PrimaryKey pk = new PrimaryKey("pkLegacy", pkCols);
            table.setPrimaryKey(pk);
        }
        catch (Exception e) {
            LogUtil.printStackTrace(e);
        }
        return table;
    }

    private Table getManagerTable() {
        Table table = new Table(MGR_TBL_NM);
        table.setUseManualSort(true);
        try {
            Column idCol = this.getIntegerIdCol("Id", 4);
            Column desCol = new Column("Name", this.getValidTypeId(12), new Integer(100), false);
            Column bossIdCol = this.getIntegerIdCol(MGR_BOSS_ID, 4);
            table.add(idCol);
            table.add(desCol);
            table.add(bossIdCol);
            ArrayList<String> pkCols = new ArrayList<String>();
            pkCols.add(idCol.getName());
            PrimaryKey pk = new PrimaryKey("pkManager", pkCols);
            table.setPrimaryKey(pk);
            Index bossIndex = new Index("idxBossId", bossIdCol, false, false);
            this.checkSetPsqlOptionText(bossIndex);
            table.add(bossIndex);
            if (this.config_.supportUniqueConstraint()) {
                ArrayList<Column> ucCols = new ArrayList<Column>();
                ucCols.add(table.getColumn("Name"));
                UniqueConstraint uc = new UniqueConstraint(table, ucCols, MGR_NM_UC_NM);
                table.add(uc);
            }
        }
        catch (Exception e) {
            LogUtil.printStackTrace(e);
        }
        return table;
    }

    private Table getPayableTable() {
        Table table = new Table(PAY_TBL_NM_OLD);
        table.setUseManualSort(true);
        try {
            Column idCol = this.getIntegerIdCol("Id", 4);
            Column amtCol = new Column("Amount", this.getValidTypeId(701), null, false);
            Column taxCol = new Column(PAY_TAX_COL_NM, this.getValidTypeId(8), null, false);
            Column paidCol = new Column(PAY_PAID_COL_NM, this.getValidTypeId(16), null, false);
            table.add(idCol);
            table.add(amtCol);
            table.add(taxCol);
            table.add(paidCol);
            ArrayList<String> pkCols = new ArrayList<String>();
            pkCols.add(idCol.getName());
            PrimaryKey pk = new PrimaryKey("pkPayable", pkCols);
            table.setPrimaryKey(pk);
        }
        catch (Exception e) {
            LogUtil.printStackTrace(e);
        }
        return table;
    }

    private Table getPettyCashTable() {
        Table table = new Table(PET_TBL_NM);
        table.setUseManualSort(true);
        if (this.isMySql()) {
            table.setTableOptions("ENGINE=MyISAM");
        }
        try {
            Column idCol = this.getIntegerIdCol("Id", 4);
            Column amtCol = new Column("Amount", this.getValidTypeId(701), null, false);
            Column notesCol = new Column(PET_COL_NOTES_NM, this.getValidTypeId(12), new Integer(100), false);
            table.add(idCol);
            table.add(amtCol);
            table.add(notesCol);
            ArrayList<String> pkCols = new ArrayList<String>();
            pkCols.add(idCol.getName());
            PrimaryKey pk = new PrimaryKey("pkPettyCash", pkCols);
            table.setPrimaryKey(pk);
            ArrayList<IIndexColumn> indexCols = new ArrayList<IIndexColumn>();
            indexCols.add(amtCol);
            if (this.isPsql()) {
                String columnFunctionText = "\"substring\"((notes)::text, 1, 8)";
                ColumnFunction columnFunction = new ColumnFunction(columnFunctionText);
                indexCols.add(columnFunction);
            }
            Index idxAmount = new Index(PET_IDX_AMT_NM, indexCols, false, false);
            idxAmount.setOptionText(IndexOptionTextTestData.getPettyCashIndexOptionText(this.config_));
            table.add(idxAmount);
            if (this.config_.isMySql()) {
                Index idxNotes = new Index(PET_IDX_NOTES_NM, notesCol, false, false);
                idxNotes.setFullText(true);
                table.add(idxNotes);
            }
        }
        catch (Exception e) {
            LogUtil.printStackTrace(e);
        }
        return table;
    }

    private Table getReferralTable() {
        Table table = new Table(REF_TBL_NM);
        table.setUseManualSort(true);
        try {
            Column idCol = this.getIntegerIdCol("Id", 4);
            table.add(idCol);
            ArrayList<String> pkCols = new ArrayList<String>();
            pkCols.add(idCol.getName());
            PrimaryKey pk = new PrimaryKey("pkReferral", pkCols);
            table.setPrimaryKey(pk);
        }
        catch (Exception e) {
            LogUtil.printStackTrace(e);
        }
        return table;
    }

    private Table getObsoleteTable() {
        Table table = new Table(OBSOLETE_TBL_NM);
        try {
            Column idCol = this.getIntegerIdCol("Id", 4);
            table.add(idCol);
            ArrayList<String> pkCols = new ArrayList<String>();
            pkCols.add(idCol.getName());
            PrimaryKey pk = new PrimaryKey("pkObsolete", pkCols);
            table.setPrimaryKey(pk);
        }
        catch (Exception e) {
            LogUtil.printStackTrace(e);
        }
        return table;
    }

    private void addCommonFks(Database db) {
        Schema schDefault = this.useSchemas_ ? null : db.getSchema("schemaA");
        Schema schInt = this.useSchemas_ ? db.getSchema(SCH_CMPY_NM) : schDefault;
        Schema schWeb = this.useSchemas_ ? db.getSchema(this.getWebSchNm(0)) : schDefault;
        Table tblPath = schInt.getTable(PATH_TBL_NM);
        Table tblReport = schInt.getTable(RPT_TBL_NM);
        Table tblPic = schInt.getTable(PIC_TBL_NM);
        Table tblPatient = schInt.getTable(PATIENT_TBL_NM);
        Table tblMgr = schInt.getTable(MGR_TBL_NM);
        Table tblSbr = schWeb.getTable(SBR_TBL_NM);
        Table tblSbn = schWeb.getTable(SBN_TBL_NM);
        Table tblWbr = schWeb.getTable(WBR_TBL_NM_OLD);
        Table tblWbh = schWeb.getTable(WBH_TBL_NM);
        Table tblWba = schWeb.getTable(WBA_TBL_NM);
        ForeignKey fkReportPath = new ForeignKey(FK_RPT_PATH_NM, tblPath, tblReport, PATH_ID_NM, PATH_ID_NM);
        ForeignKey fkReportPatient = new ForeignKey(FK_RPT_PATIENT_NM, tblPatient, tblReport, PATIENT_ID_NM, PATIENT_ID_NM);
        ArrayList<StringPair> fkCols = new ArrayList<StringPair>();
        fkCols.add(new StringPair(RPT_ID_NM, RPT_ID_NM));
        ForeignKey fkPictureReport = new ForeignKey(FK_PIC_RPT_NM, tblReport, tblPic, fkCols, 0, 2, FK_PIC_RPT_COMM_A, new Cardinality(false, true, true), RPT_ID_NM);
        fkCols = new ArrayList();
        fkCols.add(new StringPair("CompanyId", "CompanyId"));
        fkCols.add(new StringPair("BranchId", "BranchId"));
        ForeignKey fkSubscriptionSubscriber = new ForeignKey(FK_SBN_SBR_NM, tblSbr, tblSbn, fkCols, this.getValidOnDeleteId(3), 3, WBR_URL_DEF_OLD, new Cardinality(true, true, true), "BranchId");
        tblReport.add(fkReportPath);
        tblReport.add(fkReportPatient);
        tblPic.add(fkPictureReport);
        tblSbn.add(fkSubscriptionSubscriber);
        if (this.dbmsId_ != 2) {
            tblPic.add(fkPictureReport);
        }
        ForeignKey fkWebHitSbr = new ForeignKey(FK_WBH_SBN_NM, tblSbn, tblWbh, SBN_ID_NM, WBH_SBR_ID_NM);
        tblWbh.add(fkWebHitSbr);
        ForeignKey fkWebResWebAcc = new ForeignKey(FK_WBR_WBA_NM, tblWba, tblWbr, WBA_ID_NM_OLD, WBR_ACC_TYPE_ID_NM);
        tblWbr.add(fkWebResWebAcc);
        ForeignKey fkWebHitWebRes = new ForeignKey(FK_WBH_WBR_NM, tblWbr, tblWbh, "Id", WBH_WBR_NM_OLD);
        tblWbh.add(fkWebHitWebRes);
        ForeignKey fkMgrMgrBoss = new ForeignKey(FK_MGR_MGR_NM, tblMgr, tblMgr, "Id", MGR_BOSS_ID);
        tblMgr.add(fkMgrMgrBoss);
    }

    private void addCommonViews(Database db) {
        try {
            Schema schInt = this.useSchemas_ ? db.getSchema(SCH_CMPY_NM) : db.getSchema("schemaA");
            View reportView = new View(VW_RPT_SUMM_NM, this.getCompatibleSrc(VW_RPT_SUMM_SQL));
            schInt.add(reportView);
        }
        catch (Exception e) {
            LogUtil.printStackTrace(e);
        }
    }

    private void addOldViews(Database db) {
        try {
            Schema schWeb;
            Schema schema = this.useSchemas_ ? db.getSchema(this.getWebSchNm(0)) : (schWeb = db.getSchema("schemaA"));
            Schema schCompany = this.useSchemas_ ? db.getSchema(SCH_CMPY_NM) : db.getSchema("schemaA");
            String oldSql = this.isOracle() ? "SELECT \"ContactName\" FROM \"Website\".\"Subscriber\"" : VW_WBH_OLD_SQL;
            View vwOld = new View(VW_WBH_OLD_NM, this.getCompatibleSrc(oldSql));
            schWeb.add(vwOld);
            View vwSame = new View(VW_SAME_NM, this.getCompatibleSrc(VW_SAME_SQL));
            schCompany.add(vwSame);
        }
        catch (Exception e) {
            LogUtil.printStackTrace(e);
        }
    }

    private void addNewViews(Database db) {
        try {
            Schema schWeb;
            Schema schema = this.useSchemas_ ? db.getSchema(this.getWebSchNm(1)) : (schWeb = db.getSchema("schemaA"));
            Schema schCompany = this.useSchemas_ ? db.getSchema(SCH_CMPY_NM) : db.getSchema("schemaA");
            View vwNew = new View(VW_WBH_NEW_NM, this.getCompatibleSrc("SELECT \"ContactName\" FROM \"Website\".\"Subscriber\""));
            schWeb.add(vwNew);
            View vwSame = new View(VW_SAME_NM, this.getCompatibleSrc(VW_SAME_SQL));
            schCompany.add(vwSame);
        }
        catch (Exception e) {
            LogUtil.printStackTrace(e);
        }
    }

    private void addCommonProcs(Database db) {
        Schema schema;
        String defNm = "defName";
        Schema schema2 = this.useSchemas_ ? db.getSchema(SCH_CMPY_NM) : (schema = db.getSchema("schemaA"));
        if (this.dbmsId_ == 1) {
            Proc proc = new Proc(this.getPsql74ProcSrc(PROC_SRC_PSQL), PROC_COMMENT, defNm);
            schema.add(proc);
            Proc procPic = new Proc(this.getPsql74ProcSrc(PROC_SRC_PSQL_PIC), WBR_URL_DEF_OLD, defNm);
            schema.add(procPic);
            Proc procTrg = new Proc(this.getPsql74ProcSrc(PROC_SRC_PSQL_TRG), PROC_COMMENT_PSQL_TRG, defNm);
            schema.add(procTrg);
            Proc procRptTrg = new Proc(this.getPsql74ProcSrc(RPT_TRG_SQL_PSQL), WBR_URL_DEF_OLD, defNm);
            schema.add(procRptTrg);
            if (this.config_.supportsPgProcArgNms()) {
                Proc procPath = new Proc(this.chkStripQuotes(PROC_SRC_PSQL_PATH), WBR_URL_DEF_OLD, defNm);
                schema.add(procPath);
            }
        } else if (this.dbmsId_ == 3) {
            Proc proc = new Proc(this.chkStripQuotes(PROC_SRC_SQL_SVR), PROC_COMMENT, defNm);
            schema.add(proc);
        } else if (this.config_.isMySql()) {
            Proc proc = new Proc(PROC_MYSQL_SRC_PR, PROC_COMMENT, defNm);
            schema.add(proc);
            Proc function = new Proc(PROC_MYSQL_SRC_FN, PROC_COMMENT, defNm);
            schema.add(function);
        } else if (this.isOracle()) {
            Proc procA = new Proc(this.chkStripQuotes(PROC_ORCL_FACT_SRC), WBR_URL_DEF_OLD, defNm);
            schema.add(procA);
            Proc procB = new Proc(this.chkStripQuotes(PROC_ORCL_RM_PIC_FL_SRC), WBR_URL_DEF_OLD, defNm);
            schema.add(procB);
            Proc procC = new Proc(this.chkStripQuotes(PROC_ORCL_IN_OUT_SRC), WBR_URL_DEF_OLD, defNm);
            schema.add(procC);
        }
    }

    private String getPsql74ProcSrc(String src) {
        String newSrc = this.chkStripQuotes(src);
        if (this.config_.supportsPgProcArgNms()) {
            return newSrc;
        }
        String noDollarSrc = newSrc.replaceAll("\\$\\$", "'");
        noDollarSrc = noDollarSrc.replaceAll("\\$BODY\\$", "'");
        return noDollarSrc;
    }

    private String getCompatibleSrc(String src) {
        String newSrc = src;
        if (!this.dblQuoteMixedCase_) {
            newSrc = this.chkStripQuotes(src);
        }
        if (!this.config_.supportsSchemas()) {
            newSrc = newSrc.replaceAll("Finance\\.", WBR_URL_DEF_OLD);
            newSrc = newSrc.replaceAll("Company\\.", WBR_URL_DEF_OLD);
            newSrc = newSrc.replaceAll("Website\\.", WBR_URL_DEF_OLD);
            newSrc = newSrc.replaceAll("Outside\\.", WBR_URL_DEF_OLD);
        }
        return newSrc;
    }

    private void addTableOptions(Database db) {
        Schema schWeb;
        Schema schCompany;
        Schema schema = this.useSchemas_ ? db.getSchema(SCH_CMPY_NM) : (schCompany = db.getSchema("schemaA"));
        Schema schema2 = this.useSchemas_ ? db.getSchema(this.getWebSchNm(0)) : (schWeb = db.getSchema("schemaA"));
        if (this.dbmsId_ == 1) {
            Table tblReport = schCompany.getTable(RPT_TBL_NM);
            tblReport.setTableOptions(RPT_TBL_OPT);
            Table tblSubscribers = schWeb.getTable(SBR_TBL_NM);
            tblSubscribers.setTableOptions(SBR_TBL_OPT);
        } else if (this.dbmsId_ == 0) {
            Table tblPicture = schCompany.getTable(PIC_TBL_NM);
            tblPicture.setTableOptions(PIC_TBL_OPT);
            Table tblInvoice = schCompany.getTable(INV_TBL_NM_OLD);
            tblInvoice.setTableOptions(INV_TBL_OPT);
        }
    }

    private void addCommonSeqs(Database db) {
        Schema schCompany = this.useSchemas_ ? db.getSchema(SCH_CMPY_NM) : db.getSchema("schemaA");
        Sequence seq = new Sequence(SEQ_NM, 1, SEQ_OLD_COMMENT);
        schCompany.add(seq);
        if (this.config_.isPsql()) {
            schCompany.add(new Sequence("FileType_FileTypeId_seq", 1, WBR_URL_DEF_OLD));
            schCompany.add(new Sequence("Groups_Id_seq", 1, WBR_URL_DEF_OLD));
            schCompany.add(new Sequence("Invoice_Id_seq", 1, WBR_URL_DEF_OLD));
            schCompany.add(new Sequence("Patient_PatientId_seq", 1, WBR_URL_DEF_OLD));
            schCompany.add(new Sequence("Picture_PictureId_seq", 1, WBR_URL_DEF_OLD));
            schCompany.add(new Sequence("Report_ReportId_seq", 1, WBR_URL_DEF_OLD));
            Schema schWeb = db.getSchema(SCH_WEB_NM_OLD);
            schWeb.add(new Sequence("webpage_id_seq", 1, WBR_URL_DEF_OLD));
            schWeb.add(new Sequence("webresourceaccesstype_uid_seq", 1, WBR_URL_DEF_OLD));
            schWeb.add(new Sequence("webresourcehit_id_seq", 1, WBR_URL_DEF_OLD));
            Sequence webResourceSequence = new Sequence("webResource_id_seq", 1, WBR_URL_DEF_OLD);
            webResourceSequence.setStart(5L);
            schWeb.add(webResourceSequence);
        }
    }

    private void addUpdateItems(Database db) {
        Schema schWeb;
        Schema schCompany;
        Schema schDefault = this.useSchemas_ ? null : db.getSchema("schemaA");
        Schema schema = schCompany = this.useSchemas_ ? db.getSchema(SCH_CMPY_NM) : schDefault;
        if (this.useSchemas_) {
            schCompany.setComment(SCH_CMPY_CMM_NEW);
        }
        Schema schFinance = schDefault;
        if (this.useSchemas_) {
            schFinance = this.isOracle() ? db.getSchema(SCH_FIN_NM) : new Schema(SCH_FIN_NM);
        }
        RenameMgr renameMgr = db.getRenameMgr();
        Schema schema2 = schWeb = this.useSchemas_ ? db.getSchema(this.getWebSchNm(0)) : schDefault;
        if (this.useSchemas_) {
            db.remove(Schema.getClassName(), SCH_RSH_NM);
            schFinance.setComment(SCH_FIN_CMM);
            db.add(schFinance);
            if (!this.isOracle()) {
                this.doRename(db, schWeb, SCH_WEB_NM_OLD, SCH_WEB_NM_NEW, renameMgr);
            }
        }
        try {
            Proc oldProc;
            Proc newProc;
            ITestResult addRslt;
            Table tblPath = schCompany.getTable(PATH_TBL_NM);
            tblPath.remove(Column.getClassName(), PATH_OBS_NM);
            schCompany.remove(Table.getClassName(), OBSOLETE_TBL_NM);
            schFinance.add(this.getAccountTableFinance());
            schFinance.add(this.getLoanTable(schCompany));
            schFinance.add(this.getLegacyTable());
            Column newCaption = new Column(PIC_CAPTION_NM, this.getValidTypeId(12), PIC_CAPTION_NEW_LN, false);
            Table tblPic = schCompany.getTable(PIC_TBL_NM);
            Column oldCaption = tblPic.getColumn(PIC_CAPTION_NM);
            ITestResult updRslt = tblPic.updateItem(oldCaption, newCaption);
            tblPic.setComment(PIC_TBL_COM_NEW);
            Table tblSubscription = schWeb.getTable(SBN_TBL_NM);
            Column ExpDateCol = new Column(SBN_EXP_DATE_NM, 91, null, true);
            String defStr = this.dbmsId_ == 1 ? "false" : "0";
            Column isTrialCol = new Column(SBN_IS_TRIAL_NM, this.getValidTypeId(16), null, false, false, defStr, null, "Is Free Trial");
            tblSubscription.add(isTrialCol);
            tblSubscription.add(ExpDateCol);
            if (this.dbmsId_ == 0) {
                Table tblCamera = schCompany.getTable(CAM_TBL_NM);
                Column idCol = new Column(CAM_ID_NM, 5, null, true, false, "2", null, WBR_URL_DEF_OLD, false, WBR_URL_DEF_OLD);
                Column typeCol = new Column(CAM_TYPE_NM, 706, null, true, false, "Digital", null, WBR_URL_DEF_OLD, true, CAM_TYPE_ENUM_CSV_NEW);
                Column oldIdCol = tblCamera.getColumn(CAM_ID_NM);
                Column oldTypeCol = tblCamera.getColumn(CAM_TYPE_NM);
                updRslt = tblCamera.updateItem(oldIdCol, idCol);
                updRslt = tblCamera.updateItem(oldTypeCol, typeCol);
            }
            Column newDesc = new Column(GROUPS_DESC_NM, this.getValidTypeId(12), GROUPS_DESC_LN_NEW, false);
            Table groupsTable = schCompany.getTable(GROUPS_TBL_NM);
            Column oldDesc = groupsTable.getColumn(GROUPS_DESC_NM);
            updRslt = groupsTable.updateItem(oldDesc, newDesc);
            Table pathTable = schCompany.getTable(PATH_TBL_NM);
            Column nameColOld = pathTable.getColumn("Name");
            Column nameColNew = new Column("Name", this.getValidTypeId(12), PATH_NAME_LN, false, false, WBR_URL_DEF_OLD, null, PATH_NAME_COM_NEW);
            nameColNew.setUnique(true);
            updRslt = pathTable.updateItem(nameColOld, nameColNew);
            if (!this.isOracle()) {
                Column pathNmCol = pathTable.getColumn("Name");
                Index newNameIdx = new Index(PATH_IDX_NAME_NM, pathNmCol, false, true);
                this.checkSetPsqlOptionText(newNameIdx);
                pathTable = schCompany.getTable(PATH_TBL_NM);
                Index oldNameIdx = pathTable.getIndex(PATH_IDX_NAME_NM);
                updRslt = pathTable.updateItem(oldNameIdx, newNameIdx);
            }
            tblPic.remove(Index.getClassName(), PIC_IDX_CAPTION_NM);
            ArrayList<String> pkCols = new ArrayList<String>();
            pkCols.add(PATH_ID_NM);
            PrimaryKey pk = new PrimaryKey(PATH_PK_NM, pkCols);
            pathTable.setPrimaryKey(pk);
            Column pathEmpIdCol = pathTable.getColumn(PATH_EMP_ID_NM);
            Index idxEmpId = new Index(PATH_IDX_EMP_ID_NM, pathEmpIdCol, false, false);
            this.checkSetPsqlOptionText(idxEmpId);
            pathTable.add(idxEmpId);
            if (!this.isOracle()) {
                this.addTableTransfers(db);
            }
            this.doTblRenames(db);
            this.addWebResourceUpdateItems(db);
            schCompany.add(this.getFileTypeTable());
            View imageView = new View(VW_PIC_SUMM_NM, this.getCompatibleSrc(VW_PIC_SUMM_SQL));
            schCompany.add(imageView);
            Table tblReport = schCompany.getTable(RPT_TBL_NM);
            Table tblPicFile = schCompany.getTable(PIC_FILE_TBL_NM);
            Table tblMgr = schCompany.getTable(MGR_TBL_NM);
            Table tblSbr = schWeb.getTable(SBR_TBL_NM);
            Table tblWbh = schWeb.getTable(WBH_TBL_NM);
            Table tblDiscount = schFinance.getTable(DIS_TBL_NM);
            Table tblAccFin = schFinance.getTable(ACC_TBL_NM);
            Table tblLegacy = schFinance.getTable(LEG_TBL_NM);
            if (this.config_.supportsSequences()) {
                Sequence oldSeq = schCompany.getSequence(SEQ_NM);
                Sequence newSeq = new Sequence(SEQ_NM, 1, SEQ_NEW_COMMENT);
                updRslt = schCompany.updateItem(oldSeq, newSeq);
                Sequence seqFin = new Sequence(SEQ_FIN_ITEMS, 1, WBR_URL_DEF_OLD);
                addRslt = schFinance.add(seqFin);
                if (this.config_.isPsql()) {
                    String auto = "nextval('website.webresourcehit_id_seq'::regclass)";
                    Column colWbhId = tblWbh.getColumn("Id");
                    colWbhId.setDefaultValue(auto);
                }
            }
            if (this.config_.supportUniqueConstraint()) {
                ArrayList<Column> ucCols = new ArrayList<Column>();
                ucCols.add(tblSbr.getColumn(SBR_CONTACT_NM));
                ucCols.add(tblSbr.getColumn(DIS_ID_COL_NM));
                UniqueConstraint ucUpdate = new UniqueConstraint(tblSbr, ucCols, SBR_CONTACT_DISC_UC_NM);
                UniqueConstraint ucOld = tblSbr.getUniqueConstraint(SBR_CONTACT_DISC_UC_NM);
                tblSbr.updateItem(ucOld, ucUpdate);
                tblMgr.remove(UniqueConstraint.getClassName(), MGR_NM_UC_NM);
            }
            ArrayList<StringPair> fkColsA = new ArrayList<StringPair>();
            fkColsA.add(new StringPair(PIC_ID_NM, PIC_ID_NM));
            ForeignKey fkPictureFilePicture = new ForeignKey(FK_PIC_FILE_PIC_NM, tblPic, tblPicFile, fkColsA, 2, 2, "newly added fk", new Cardinality(true, true, true), PIC_ID_NM);
            tblPicFile.add(fkPictureFilePicture);
            int fkActionId = this.config_.isMySql() ? 1 : this.getValidOnDeleteId(4);
            ArrayList<StringPair> fkColsB = new ArrayList<StringPair>();
            fkColsB.add(new StringPair(PATH_ID_NM, PATH_ID_NM));
            ForeignKey fkReportPathNew = new ForeignKey(FK_RPT_PATH_NM, tblPath, tblReport, fkColsB, fkActionId, fkActionId, WBR_URL_DEF_OLD, new Cardinality(true, true, true), PATH_ID_NM);
            ForeignKey fkReportPathOld = tblReport.getForeignKey(FK_RPT_PATH_NM);
            updRslt = tblReport.updateItem(fkReportPathOld, fkReportPathNew);
            ArrayList<StringPair> fkColsLeg = new ArrayList<StringPair>();
            fkColsLeg.add(new StringPair("LegacyIdStr", "LegacyIdStr"));
            ForeignKey fkAccountLegacy = new ForeignKey(FK_ACC_LEG_NM, tblLegacy, tblAccFin, fkColsLeg, fkActionId, fkActionId, WBR_URL_DEF_OLD, new Cardinality(true, true, true), "LegacyIdStr");
            tblAccFin.add(fkAccountLegacy);
            if (this.dbmsId_ != 2) {
                ArrayList<StringPair> fkColsC = new ArrayList<StringPair>();
                fkColsC.add(new StringPair(RPT_ID_NM, RPT_ID_NM));
                ForeignKey fkPictureReportNew = new ForeignKey(FK_PIC_RPT_NM, tblReport, tblPic, fkColsC, 0, 0, FK_PIC_RPT_COMM_B, new Cardinality(true, true, true), RPT_ID_NM);
                ForeignKey fkPictureReportOld = tblPic.getForeignKey(FK_PIC_RPT_NM);
                updRslt = tblPic.updateItem(fkPictureReportOld, fkPictureReportNew);
            }
            if (!this.isOracle()) {
                ArrayList<StringPair> fkColsD = new ArrayList<StringPair>();
                fkColsD.add(new StringPair(DIS_ID_COL_NM, DIS_ID_COL_NM));
                ForeignKey fkSubscriberDiscount = new ForeignKey(FK_SBR_DIS_NM, tblDiscount, tblSbr, fkColsD, 0, 2, WBR_URL_DEF_OLD, new Cardinality(true, true, true), DIS_ID_COL_NM);
                tblSbr.add(fkSubscriberDiscount);
            }
            if (this.dbmsId_ == 1) {
                newProc = new Proc(this.getPsql74ProcSrc(PROC_SRC_PSQL_NEW), PROC_COMMENT_NEW, "defName");
                oldProc = schCompany.getProc(PROC_NM_PSQL);
                updRslt = schCompany.updateItem(oldProc, newProc);
                String addTwoSrc = this.config_.supportsPgProcArgNms() ? PROC_SRC_PSQL_ADD_TWO_80 : PROC_SRC_PSQL_ADD_TWO_74;
                Proc addProc = new Proc(this.getPsql74ProcSrc(addTwoSrc), WBR_URL_DEF_OLD, "defName");
                addRslt = schCompany.add(addProc);
            } else if (this.dbmsId_ == 3) {
                newProc = new Proc(PROC_SRC_SQL_SVR_NEW, PROC_COMMENT_NEW, "defName");
                oldProc = schCompany.getProc(PROC_NM_SQL_SVR);
                updRslt = schCompany.updateItem(oldProc, newProc);
                Proc addProc = new Proc(PROC_SRC_SQL_SVR_ADD_TWO, WBR_URL_DEF_OLD, "defName");
                ITestResult iTestResult = schCompany.add(addProc);
            }
            String sql = this.getReportTrgSql();
            Trigger trgNew = new Trigger(RPT_TRG_NM, true, true, true, sql, true, true);
            Trigger trgOld = tblReport.getTrigger(RPT_TRG_NM);
            updRslt = tblReport.updateItem(trgOld, trgNew);
            Column sourceIdCol = new Column(PATIENT_SOURCE_ID_NM, this.getValidTypeId(12), PATIENT_SOURCE_ID_LN, true);
            Table patientTable = schCompany.getTable(PATIENT_TBL_NM);
            patientTable.add(sourceIdCol);
            Column newName = new Column("Name", this.getValidTypeId(12), PATIENT_NAME_NEW_LN, false);
            Column oldName = patientTable.getColumn("Name");
            updRslt = patientTable.updateItem(oldName, newName);
            DbDataConversion conversion = new DbDataConversion(sourceIdCol, patientTable, db, PATIENT_SOURCE_ID_CONV_VAL);
            db.add(conversion);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void addTableTransfers(Database db) {
        Schema schWeb;
        Schema schCompany;
        Schema schema = this.useSchemas_ ? db.getSchema(SCH_CMPY_NM) : (schCompany = db.getSchema("schemaA"));
        Schema schema2 = this.useSchemas_ ? db.getSchema(this.getWebSchNm(1)) : (schWeb = db.getSchema("schemaA"));
        Schema schFinance = this.useSchemas_ ? db.getSchema(SCH_FIN_NM) : db.getSchema("schemaA");
        try {
            Table tblPettyCash = schCompany.getTable(PET_TBL_NM);
            schCompany.remove(tblPettyCash.getMapName(), tblPettyCash.getName());
            schFinance.add(tblPettyCash);
            Table tblRef = schCompany.getTable(REF_TBL_NM);
            schCompany.remove(tblRef.getMapName(), tblRef.getName());
            schWeb.add(tblRef);
            Table tblPayable = schCompany.getTable(PAY_TBL_NM_OLD);
            schCompany.remove(tblPayable.getMapName(), tblPayable.getName());
            schFinance.add(tblPayable);
            Table tblInvoice = schCompany.getTable(INV_TBL_NM_OLD);
            schCompany.remove(tblInvoice.getMapName(), tblInvoice.getName());
            schFinance.add(tblInvoice);
            Table tblDis = schWeb.getTable(DIS_TBL_NM);
            schWeb.remove(tblDis.getMapName(), tblDis.getName());
            schFinance.add(tblDis);
        }
        catch (Exception e) {
            LogUtil.printStackTrace(e);
        }
    }

    private void doTblRenames(Database db) {
        RenameMgr renameMgr = db.getRenameMgr();
        Schema schFinance = this.useSchemas_ ? db.getSchema(SCH_FIN_NM) : db.getSchema("schemaA");
        Table tblPayable = schFinance.getTable(PAY_TBL_NM_OLD);
        this.doRename(schFinance, tblPayable, PAY_TBL_NM_OLD, PAY_TBL_NM_NEW, renameMgr);
        Table tblInvoice = schFinance.getTable(INV_TBL_NM_OLD);
        this.doRename(schFinance, tblInvoice, INV_TBL_NM_OLD, INV_TBL_NM_NEW, renameMgr);
    }

    private void addWebResourceUpdateItems(Database db) {
        Schema schWeb = this.useSchemas_ ? db.getSchema(this.getWebSchNm(1)) : db.getSchema("schemaA");
        try {
            RenameMgr renameMgr = db.getRenameMgr();
            Table tblWebRes = schWeb.getTable(WBR_TBL_NM_OLD);
            this.doRename(schWeb, tblWebRes, WBR_TBL_NM_OLD, WBR_TBL_NM_NEW, renameMgr);
            Column colWebResUrl = tblWebRes.getColumn(WBR_URL_NM_OLD);
            this.doRename(tblWebRes, colWebResUrl, WBR_URL_NM_OLD, WBR_URL_NM_NEW, renameMgr);
            Column oldRnmWbrUrlCol = tblWebRes.getColumn(WBR_URL_NM_NEW);
            Column newWbrUrlCol = new Column(WBR_URL_NM_NEW, this.getValidTypeId(12), new Integer(100), false, false, WBR_URL_DEF_NEW, null, WBR_URL_CMM_NEW);
            tblWebRes.updateItem(oldRnmWbrUrlCol, newWbrUrlCol);
            if (this.config_.isPsql()) {
                String defStr = this.isPsqlVersionWithRegClass() ? "nextval(('\"Website\".\"WebResource_id_seq\"'::text)::regclass)" : "nextval('\"Website\".\"WebResource_id_seq\"'::text)";
                defStr = this.chkStripQuotes(defStr);
                Column oldWbrIdCol = tblWebRes.getColumn("Id");
                Column newWbrIdCol = new Column(oldWbrIdCol.getName(), oldWbrIdCol.getDataTypeId(), oldWbrIdCol.getLength(), oldWbrIdCol.getIsNullable(), oldWbrIdCol.getAutoNumber(), defStr, oldWbrIdCol.getScale(), oldWbrIdCol.getComment(), oldWbrIdCol.getSignedFlag(), oldWbrIdCol.getEnumCsv());
                tblWebRes.updateItem(oldWbrIdCol, newWbrIdCol);
            }
            Table tblWebHit = schWeb.getTable(WBH_TBL_NM);
            Column colHitDate = tblWebHit.getColumn(WBH_HIT_DATE_NM_OLD);
            this.doRename(tblWebHit, colHitDate, WBH_HIT_DATE_NM_OLD, WBH_HIT_DATE_NM_NEW, renameMgr);
            Column colWebResId = tblWebHit.getColumn(WBH_WBR_NM_OLD);
            this.doRename(tblWebHit, colWebResId, WBH_WBR_NM_OLD, WBH_WBR_NM_NEW, renameMgr);
            Table tblWebAccType = schWeb.getTable(WBA_TBL_NM);
            Column colId = tblWebAccType.getColumn(WBA_ID_NM_OLD);
            if (this.config_.isPsql()) {
                String defStr = this.isPsqlVersionWithRegClass() ? "nextval(('\"Website\".\"WebResourceAccessType_uid_seq\"'::text)::regclass)" : "nextval('\"Website\".\"WebResourceAccessType_uid_seq\"'::text)";
                defStr = this.chkStripQuotes(defStr);
                Column newColId = new Column(colId.getName(), colId.getDataTypeId(), colId.getLength(), colId.getIsNullable(), colId.getAutoNumber(), defStr, colId.getScale(), colId.getComment(), colId.getSignedFlag(), colId.getEnumCsv());
                tblWebAccType.updateItem(colId, newColId);
                colId = tblWebAccType.getColumn(WBA_ID_NM_OLD);
            }
            this.doRename(tblWebAccType, colId, WBA_ID_NM_OLD, "Id", renameMgr);
            Column colName = tblWebAccType.getColumn(WBA_ACC_DES_NM_OLD);
            this.doRename(tblWebAccType, colName, WBA_ACC_DES_NM_OLD, WBA_ACC_DES_NM_NEW, renameMgr);
        }
        catch (Exception e) {
            LogUtil.printStackTrace(e);
        }
    }

    private String chkStripQuotes(String str) {
        if (!this.dblQuoteMixedCase_) {
            return StrHelper.removeDblQuotes(str);
        }
        return str;
    }

    private void chkStripQuotes(List list) {
        if (!this.dblQuoteMixedCase_) {
            ArrayList<String> newList = new ArrayList<String>();
            for (String str : list) {
                String newStr = StrHelper.removeDblQuotes(str);
                newList.add(newStr);
            }
            list.clear();
            list.addAll(newList);
        }
    }

    private String reAddQuotes(String wholeStr, String searchStr, String quotedStr) {
        if (this.config_.isPsql() && !this.dblQuoteMixedCase_) {
            return wholeStr.replaceAll(searchStr, quotedStr);
        }
        return wholeStr;
    }

    private void reAddQuotes(List strs, String searchStr, String quotedStr) {
        if (this.config_.isPsql() && !this.dblQuoteMixedCase_) {
            ArrayList<String> newList = new ArrayList<String>();
            for (String str : strs) {
                String newStr = str.replaceAll(searchStr, quotedStr);
                newList.add(newStr);
            }
            strs.clear();
            strs.addAll(newList);
        }
    }

    private void doRename(Collector collector, Identifiable idf, String oldName, String newName, RenameMgr renameMgr) {
        RenameIdf rnmCmd = new RenameIdf(collector, idf, oldName, newName, null);
        rnmCmd.setRenameMgr(renameMgr);
        rnmCmd.actionPerformed(null);
    }

    public List getInsertDataSqlCmds(String dbKey) {
        ArrayList sqlList = new ArrayList();
        if (dbKey.equals(DB_A_KEY)) {
            sqlList.addAll(this.getInsertDataSql(PATH_TBL_NM));
            sqlList.addAll(this.getInsertDataSql(PATIENT_TBL_NM));
            sqlList.addAll(this.getInsertDataSql(RPT_TBL_NM));
            sqlList.addAll(this.getInsertDataSql(PIC_TBL_NM));
            sqlList.addAll(this.getInsertDataSql(PIC_FILE_TBL_NM));
            sqlList.addAll(this.getInsertDataSql(MGR_TBL_NM));
            if (!this.isOracle()) {
                sqlList.addAll(this.getInsertDataSql(INV_TBL_NM_OLD));
                sqlList.addAll(this.getInsertDataSql(GROUPS_TBL_NM));
                sqlList.addAll(this.getInsertDataSql(CAM_TBL_NM));
                sqlList.addAll(this.getInsertDataSql(SBR_TBL_NM));
                sqlList.addAll(this.getInsertDataSql(SBN_TBL_NM));
                sqlList.addAll(this.getInsertDataSql(WBA_TBL_NM));
                sqlList.addAll(this.getInsertDataSql(WBR_TBL_NM_OLD));
                sqlList.addAll(this.getInsertDataSql(WBH_TBL_NM));
                sqlList.addAll(this.getInsertDataSql(DT_TBL_NM));
            }
        } else if (dbKey.equals(DB_B_KEY)) {
            if (!this.isOracle()) {
                sqlList.addAll(this.getInsertDataSql(FILE_TYPE_TBL_NM));
                sqlList.addAll(this.getInsertDataSql(LEG_TBL_NM));
                sqlList.addAll(this.getUpdateDataSqlPatient());
            }
        } else {
            StrHelper.throwProgExcept("DbKey: " + dbKey + " couldn't be matched!!");
        }
        return sqlList;
    }

    private List getInsertDataSql(String tableName) {
        if (tableName.equalsIgnoreCase(PATH_TBL_NM)) {
            if (this.isOracle()) {
                return this.getInsertDataSqlPathologistOracle();
            }
            return this.getInsertDataSqlPathologist();
        }
        if (tableName.equalsIgnoreCase(RPT_TBL_NM)) {
            if (this.isOracle()) {
                return this.getInsertDataSqlReportOracle();
            }
            return this.getInsertDataSqlReport();
        }
        if (tableName.equalsIgnoreCase(PATIENT_TBL_NM)) {
            if (this.isOracle()) {
                return this.getInsertDataSqlPatientOracle();
            }
            return this.getInsertDataSqlPatient();
        }
        if (tableName.equalsIgnoreCase(PIC_TBL_NM)) {
            if (this.isOracle()) {
                return this.getInsertDataSqlPictureOracle();
            }
            return this.getInsertDataSqlPicture();
        }
        if (tableName.equalsIgnoreCase(PIC_FILE_TBL_NM)) {
            if (this.isOracle()) {
                return this.getInsertDataSqlPictureFileOracle();
            }
            return this.getInsertDataSqlPictureFile();
        }
        if (tableName.equalsIgnoreCase(INV_TBL_NM_OLD)) {
            return this.getInsertDataSqlInvoice();
        }
        if (tableName.equalsIgnoreCase(FILE_TYPE_TBL_NM)) {
            return this.getInsertDataSqlFileType();
        }
        if (tableName.equalsIgnoreCase(GROUPS_TBL_NM)) {
            return this.getInsertDataGroups();
        }
        if (tableName.equalsIgnoreCase(CAM_TBL_NM)) {
            return this.getInsertDataSqlCamera();
        }
        if (tableName.equalsIgnoreCase(SBR_TBL_NM)) {
            return this.getInsertDataSqlSubscriber();
        }
        if (tableName.equalsIgnoreCase(SBN_TBL_NM)) {
            return this.getInsertDataSqlSubscription();
        }
        if (tableName.equalsIgnoreCase(WBA_TBL_NM)) {
            return this.getInsertDataSqlWebResAccType();
        }
        if (tableName.equalsIgnoreCase(WBR_TBL_NM_OLD)) {
            return this.getInsertDataSqlWebRes();
        }
        if (tableName.equalsIgnoreCase(WBH_TBL_NM)) {
            return this.getInsertDataSqlWebResHit();
        }
        if (tableName.equalsIgnoreCase(MGR_TBL_NM)) {
            return this.getInsertDataManager();
        }
        if (tableName.equalsIgnoreCase(DT_TBL_NM)) {
            if (!this.config_.isMsAccess()) {
                return this.getInsertDataSqlDataTypesDisp();
            }
        } else if (tableName.equalsIgnoreCase(LEG_TBL_NM) && !this.config_.isMsAccess()) {
            return this.getInsertDataLegacy();
        }
        return new ArrayList();
    }

    private String getInsertString(String schNm, String tblNm) {
        return "INSERT INTO " + this.getForEngNm(schNm, tblNm) + "\n\t";
    }

    private String getUpdateString(String schNm, String tblNm) {
        return "UPDATE " + this.getForEngNm(schNm, tblNm) + " SET\n\t";
    }

    private String getForEngNm(String schNm, String tblNm) {
        String tblNmFull = "\"" + tblNm + "\"";
        if (this.config_.supportsSchemas()) {
            return "\"" + schNm + "\"." + tblNmFull;
        }
        return tblNmFull;
    }

    private List getInsertDataSqlPathologist() {
        String insertStr = this.getInsertString(SCH_CMPY_NM, PATH_TBL_NM);
        String prefix = insertStr + "(\"" + PATH_ID_NM + "\", \"" + "Name" + "\", \"" + PATH_HIRE_DATE_NM + "\", \"" + PATH_EMP_ID_NM + "\") VALUES\n\t";
        prefix = this.chkStripQuotes(prefix);
        ArrayList<String> sqlList = new ArrayList<String>();
        sqlList.add(prefix + "(1, 'Sisco', '1985-01-19', 1021)");
        sqlList.add(prefix + "(2, 'Costa', '2005-02-02', 10023)");
        sqlList.add(prefix + "(3, 'Burmer', '1995-12-24', 1002)");
        sqlList.add(prefix + "(4, 'Woodward', '1995-5-26', 1049)");
        sqlList.add(prefix + "(5, 'Bishop', '2001-11-10', 1031)");
        return sqlList;
    }

    private List getInsertDataSqlPathologistOracle() {
        String insertStr = this.getInsertString(SCH_CMPY_NM, PATH_TBL_NM);
        String prefix = insertStr + "(\"" + PATH_ID_NM + "\", \"" + "Name" + "\", \"" + PATH_HIRE_DATE_NM + "\", \"" + PATH_EMP_ID_NM + "\") VALUES\n\t";
        prefix = this.chkStripQuotes(prefix);
        ArrayList<String> sqlList = new ArrayList<String>();
        sqlList.add(prefix + "(1, 'Sisco', " + this.getOracleToDate("'1985-01-19'") + ", 1021)");
        sqlList.add(prefix + "(2, 'Costa', " + this.getOracleToDate("'2005-02-02'") + ", 10023)");
        sqlList.add(prefix + "(3, 'Burmer', " + this.getOracleToDate("'1995-12-24'") + ", 1002)");
        sqlList.add(prefix + "(4, 'Woodward', " + this.getOracleToDate("'1995-05-26'") + ", 1049)");
        sqlList.add(prefix + "(5, 'Bishop', " + this.getOracleToDate("'2001-11-10'") + ", 1031)");
        return sqlList;
    }

    private String getOracleToDate(String dateStr) {
        return "to_date(" + dateStr + ", 'yyyy-mm-dd')";
    }

    private List getInsertDataSqlPatient() {
        String insertStr = this.getInsertString(SCH_CMPY_NM, PATIENT_TBL_NM);
        String prefix = insertStr + "(\"" + "Name" + "\") VALUES\n\t";
        prefix = this.chkStripQuotes(prefix);
        ArrayList<String> sqlList = new ArrayList<String>();
        sqlList.add(prefix + "('NameA')");
        sqlList.add(prefix + "('NameB')");
        sqlList.add(prefix + "('NameC')");
        sqlList.add(prefix + "('NameD')");
        return sqlList;
    }

    private List getInsertDataSqlPatientOracle() {
        String insertStr = this.getInsertString(SCH_CMPY_NM, PATIENT_TBL_NM);
        String prefix = insertStr + "(\"" + "Name" + "\", \"" + PATIENT_ID_NM + "\") VALUES\n\t";
        prefix = this.chkStripQuotes(prefix);
        ArrayList<String> sqlList = new ArrayList<String>();
        sqlList.add(prefix + "('NameA', 1)");
        sqlList.add(prefix + "('NameB', 2)");
        sqlList.add(prefix + "('NameC', 3)");
        sqlList.add(prefix + "('NameD', 4)");
        return sqlList;
    }

    private List getInsertDataSqlReport() {
        String insertStr = this.getInsertString(SCH_CMPY_NM, RPT_TBL_NM);
        String prefix = insertStr + "(\"" + PATH_ID_NM + "\", \"" + PATIENT_ID_NM + "\", \"" + RPT_REPORT_TEXT_NM + "\", \"" + RPT_PUBLISH_TIME_NM + "\") VALUES\n\t";
        prefix = this.chkStripQuotes(prefix);
        ArrayList<String> sqlList = new ArrayList<String>();
        sqlList.add(prefix + "(1, 1, 'Some report Text', '2003-8-19 01:30:45')");
        sqlList.add(prefix + "(1, 2, 'Report one tissue', null)");
        sqlList.add(prefix + "(2, 1, 'done for some customer', '2005-1-22 01:30:45')");
        sqlList.add(prefix + "(2, 2, 'Was strongly positive', '2004-1-31 01:30:45')");
        sqlList.add(prefix + "(2, 4, 'was Strongly negative', null)");
        sqlList.add(prefix + "(3, 3, 'No conclusive results', '2001-4-22 01:30:45')");
        sqlList.add(prefix + "(4, 3, 'Needs further study', '1999-5-15 01:30:45')");
        sqlList.add(prefix + "(4, 4, 'Inclusive results', null)");
        sqlList.add(prefix + "(4, 1, 'Further Analysis Required', '2004-12-1 01:30:45')");
        sqlList.add(prefix + "(5, 2, 'Incomplete due to tissue problems', null)");
        sqlList.add(prefix + "(5, 3, 'Results comprimized by faulty reagents', null)");
        sqlList.add(prefix + "(5, 4, 'Used new analysis software', '2002-10-15 01:30:45')");
        return sqlList;
    }

    private List getInsertDataSqlReportOracle() {
        String insertStr = this.getInsertString(SCH_CMPY_NM, RPT_TBL_NM);
        String prefix = insertStr + "(\"" + RPT_ID_NM + "\", \"" + PATH_ID_NM + "\", \"" + PATIENT_ID_NM + "\", \"" + RPT_REPORT_TEXT_NM + "\", \"" + RPT_PUBLISH_TIME_NM + "\") VALUES\n\t";
        prefix = this.chkStripQuotes(prefix);
        ArrayList<String> sqlList = new ArrayList<String>();
        sqlList.add(prefix + "(1, 1, 1, 'Some report Text', SYSDATE)");
        sqlList.add(prefix + "(2, 1, 2, 'Report one tissue', SYSDATE)");
        sqlList.add(prefix + "(3, 2, 1, 'done for some customer', SYSDATE)");
        sqlList.add(prefix + "(4, 2, 2, 'Was strongly positive', SYSDATE)");
        sqlList.add(prefix + "(5, 2, 4, 'was Strongly negative', null)");
        sqlList.add(prefix + "(6, 3, 3, 'No conclusive results', SYSDATE)");
        sqlList.add(prefix + "(7, 4, 3, 'Needs further study', SYSDATE)");
        sqlList.add(prefix + "(8, 4, 4, 'Inclusive results', null)");
        sqlList.add(prefix + "(9, 4, 1, 'Further Analysis Required', SYSDATE)");
        sqlList.add(prefix + "(10, 5, 2, 'Incomplete due to tissue problems', null)");
        sqlList.add(prefix + "(11, 5, 3, 'Results comprimized by faulty reagents', null)");
        sqlList.add(prefix + "(12, 5, 4, 'Used new analysis software', SYSDATE)");
        return sqlList;
    }

    private List getInsertDataSqlSubscriber() {
        String insertStr = this.getInsertString(this.getWebSchNm(0), SBR_TBL_NM);
        String prefix = insertStr + "(\"" + "CompanyId" + "\", \"" + "BranchId" + "\", \"" + SBR_CONTACT_NM + "\") VALUES\n\t";
        prefix = this.chkStripQuotes(prefix);
        ArrayList<String> sqlList = new ArrayList<String>();
        sqlList.add(prefix + "(1, 1, 'D. Sutherland')");
        sqlList.add(prefix + "(1, 2, 'Micheal Smith')");
        sqlList.add(prefix + "(2, 1, 'Ted Rall')");
        return sqlList;
    }

    private List getInsertDataSqlSubscription() {
        String insertStr = this.getInsertString(this.getWebSchNm(0), SBN_TBL_NM);
        String prefix = insertStr + "(\"" + SBN_ID_NM + "\", \"" + "CompanyId" + "\", \"" + "BranchId" + "\") VALUES\n\t";
        prefix = this.chkStripQuotes(prefix);
        ArrayList<String> sqlList = new ArrayList<String>();
        sqlList.add(prefix + "(1, 1, 2)");
        sqlList.add(prefix + "(2, 1, 2)");
        sqlList.add(prefix + "(3, 1, 2)");
        sqlList.add(prefix + "(4, 1, 1)");
        sqlList.add(prefix + "(5, 1, 1)");
        sqlList.add(prefix + "(6, 2, 1)");
        sqlList.add(prefix + "(7, 2, 1)");
        sqlList.add(prefix + "(8, 1, 2)");
        return sqlList;
    }

    private List getInsertDataSqlInvoice() {
        String insertStr = this.getInsertString(SCH_CMPY_NM, INV_TBL_NM_OLD);
        String prefix = insertStr + "(\"" + "Amount" + "\", \"" + INV_LABOR_NM + "\", \"" + INV_PAID_NM + "\", \"" + INV_LEGACY_ID_NM + "\", \"" + INV_CODENAME_NM + "\", \"" + RPT_ID_NM + "\", \"" + INV_SENT_NM + "\") VALUES\n\t";
        prefix = this.chkStripQuotes(prefix);
        ArrayList<String> sqlList = new ArrayList<String>();
        if (this.config_.isPsql()) {
            sqlList.add(prefix + "(2600.02, null, '1', null, null, 1, '1')");
            sqlList.add(prefix + "(4568, 152, '1', 4, 'Hon4b', 2, '1')");
            sqlList.add(prefix + "(1546, 68, '0', null, 'Merc3d', 3, '1')");
            sqlList.add(prefix + "(16858, 195, '0', 3, null, 4, '1')");
            sqlList.add(prefix + "(1536.25, null, '0', 3, 'Merc3d', 5, '1')");
            sqlList.add(prefix + "(5698.62, 78.95, '0', null, 'Merc3d', 6, '1')");
            sqlList.add(prefix + "(48596.65, 375.95, '0', 3, null, 7, '0')");
            sqlList.add(prefix + "(14998.50, null, '0', 3, 'Hon4b', 8, '0')");
        } else if (this.config_.isMySql()) {
            sqlList.add(prefix + "(2600.02, null, 1, null, null, 1, 1)");
            sqlList.add(prefix + "(4568, 152, 1, 4, 'Hon4b', 2, 1)");
            sqlList.add(prefix + "(1546, 68, 0, null, 'Merc3d', 3, 1)");
            sqlList.add(prefix + "(16858, 195, 0, 3, null, 4, 1)");
            sqlList.add(prefix + "(1536.25, null, 0, 3, 'Merc3d', 5, 1)");
            sqlList.add(prefix + "(5698.62, 78.95, 0, null, 'Merc3d', 6, 1)");
            sqlList.add(prefix + "(48596.65, 375.95, 0, 3, null, 7, 0)");
            sqlList.add(prefix + "(14998.50, null, 0, 3, 'Hon4b', 8, 0)");
        } else {
            sqlList.add(prefix + "(2600.02, null, '1', null, null, 1, 1)");
            sqlList.add(prefix + "(4568, 152, '1', 4, 'Hon4b', 2, 1)");
            sqlList.add(prefix + "(1546, 68, 0, null, 'Merc3d', 3, 1)");
            sqlList.add(prefix + "(16858, 195, 0, 3, null, 4, 1)");
            sqlList.add(prefix + "(1536.25, null, 0, 3, 'Merc3d', 5, 1)");
            sqlList.add(prefix + "(5698.62, 78.95, 0, null, 'Merc3d', 6, 1)");
            sqlList.add(prefix + "(48596.65, 375.95, 0, 3, null, 7, 0)");
            sqlList.add(prefix + "(14998.50, null, 0, 3, 'Hon4b', 8, 0)");
        }
        return sqlList;
    }

    private List getInsertDataSqlPicture() {
        String insertStr = this.getInsertString(SCH_CMPY_NM, PIC_TBL_NM);
        String prefix = insertStr + "(\"" + RPT_ID_NM + "\", \"" + PIC_CAPTION_NM + "\", \"" + PIC_COLOR_LEVEL_NM + "\") VALUES\n\t(";
        prefix = this.chkStripQuotes(prefix);
        ArrayList<String> sqlList = new ArrayList<String>();
        sqlList.add(prefix + "1, 'Adipocytes', 256)");
        sqlList.add(prefix + "1, 'Glia', 256)");
        sqlList.add(prefix + "2, 'Neurons', 16000)");
        sqlList.add(prefix + "2, 'Perkingje Fibre', 256)");
        sqlList.add(prefix + "3, 'Adipocytes', 256)");
        sqlList.add(prefix + "3, 'Glia', 16000)");
        sqlList.add(prefix + "3, 'Glomerulus', 256)");
        sqlList.add(prefix + "4, 'Neurons', 256)");
        sqlList.add(prefix + "4, 'Glomerulus', 32000)");
        sqlList.add(prefix + "4, 'Adipocytes', 256)");
        sqlList.add(prefix + "5, 'Perkingje Fibre', 256)");
        sqlList.add(prefix + "5, 'Glia', 32000)");
        sqlList.add(prefix + "5, 'Adipocytes', 256)");
        sqlList.add(prefix + "5, 'Adipocytes', 16000)");
        sqlList.add(prefix + "6, 'Myocardium', 256)");
        sqlList.add(prefix + "6, 'Perkingje Fibre', 256)");
        sqlList.add(prefix + "6, 'Adipocytes', 32000)");
        sqlList.add(prefix + "7, 'Glia', 32000)");
        return sqlList;
    }

    private List getInsertDataSqlPictureOracle() {
        String insertStr = this.getInsertString(SCH_CMPY_NM, PIC_TBL_NM);
        String prefix = insertStr + "(\"" + PIC_ID_NM + "\", \"" + RPT_ID_NM + "\", \"" + PIC_CAPTION_NM + "\", \"" + PIC_COLOR_LEVEL_NM + "\") VALUES\n\t(";
        prefix = this.chkStripQuotes(prefix);
        ArrayList<String> sqlList = new ArrayList<String>();
        sqlList.add(prefix + "1, 1, 'Adipocytes', 256)");
        sqlList.add(prefix + "2, 1, 'Glia', 256)");
        sqlList.add(prefix + "3, 2, 'Neurons', 16000)");
        sqlList.add(prefix + "4, 2, 'Perkingje Fibre', 256)");
        sqlList.add(prefix + "5, 3, 'Adipocytes', 256)");
        sqlList.add(prefix + "6, 3, 'Glia', 16000)");
        sqlList.add(prefix + "7, 3, 'Glomerulus', 256)");
        sqlList.add(prefix + "8, 4, 'Neurons', 256)");
        sqlList.add(prefix + "9, 4, 'Glomerulus', 32000)");
        sqlList.add(prefix + "10, 4, 'Adipocytes', 256)");
        sqlList.add(prefix + "11, 5, 'Perkingje Fibre', 256)");
        sqlList.add(prefix + "12, 5, 'Glia', 32000)");
        sqlList.add(prefix + "13, 5, 'Adipocytes', 256)");
        sqlList.add(prefix + "14, 5, 'Adipocytes', 16000)");
        sqlList.add(prefix + "15, 6, 'Myocardium', 256)");
        sqlList.add(prefix + "16, 6, 'Perkingje Fibre', 256)");
        sqlList.add(prefix + "17, 6, 'Adipocytes', 32000)");
        sqlList.add(prefix + "18, 7, 'Glia', 32000)");
        return sqlList;
    }

    private List getInsertDataSqlPictureFile() {
        String insertStr = this.getInsertString(SCH_CMPY_NM, PIC_FILE_TBL_NM);
        String prefix = insertStr + "(\"" + PIC_ID_NM + "\", \"" + PIC_FILE_URL_NM + "\") VALUES\n\t(";
        prefix = this.chkStripQuotes(prefix);
        ArrayList<String> sqlList = new ArrayList<String>();
        int id = 1;
        String filePath = "//imageSvr/imgFolder/";
        sqlList.add(prefix + id + ", '" + filePath + id + ".png')");
        sqlList.add(prefix + id + ", '" + filePath + id++ + ".jpg')");
        sqlList.add(prefix + id + ", '" + filePath + id + ".png')");
        sqlList.add(prefix + id + ", '" + filePath + id++ + ".jpg')");
        sqlList.add(prefix + id + ", '" + filePath + id + ".png')");
        sqlList.add(prefix + id + ", '" + filePath + id++ + ".jpg')");
        sqlList.add(prefix + id + ", '" + filePath + id + ".png')");
        sqlList.add(prefix + id + ", '" + filePath + id++ + ".jpg')");
        sqlList.add(prefix + id + ", '" + filePath + id + ".png')");
        sqlList.add(prefix + id + ", '" + filePath + id++ + ".jpg')");
        sqlList.add(prefix + id + ", '" + filePath + id + ".png')");
        sqlList.add(prefix + id + ", '" + filePath + id++ + ".jpg')");
        sqlList.add(prefix + id + ", '" + filePath + id + ".png')");
        sqlList.add(prefix + id + ", '" + filePath + id++ + ".jpg')");
        sqlList.add(prefix + id + ", '" + filePath + id + ".png')");
        sqlList.add(prefix + id + ", '" + filePath + id++ + ".jpg')");
        sqlList.add(prefix + id + ", '" + filePath + id + ".png')");
        sqlList.add(prefix + id + ", '" + filePath + id++ + ".jpg')");
        sqlList.add(prefix + id + ", '" + filePath + id + ".png')");
        sqlList.add(prefix + id + ", '" + filePath + id++ + ".jpg')");
        sqlList.add(prefix + id + ", '" + filePath + id + ".png')");
        sqlList.add(prefix + id + ", '" + filePath + id++ + ".jpg')");
        return sqlList;
    }

    private List getInsertDataSqlPictureFileOracle() {
        String insertStr = this.getInsertString(SCH_CMPY_NM, PIC_FILE_TBL_NM);
        String prefix = insertStr + "(\"" + PIC_FILE_ID_NM + "\", \"" + PIC_ID_NM + "\", \"" + PIC_FILE_URL_NM + "\") VALUES\n\t(";
        prefix = this.chkStripQuotes(prefix);
        ArrayList<String> sqlList = new ArrayList<String>();
        int id = 1;
        String filePath = "//imageSvr/imgFolder/";
        sqlList.add(prefix + "1, " + id + ", '" + filePath + id + ".png')");
        sqlList.add(prefix + "2, " + id + ", '" + filePath + id++ + ".jpg')");
        sqlList.add(prefix + "3, " + id + ", '" + filePath + id + ".png')");
        sqlList.add(prefix + "4, " + id + ", '" + filePath + id++ + ".jpg')");
        sqlList.add(prefix + "5, " + id + ", '" + filePath + id + ".png')");
        sqlList.add(prefix + "6, " + id + ", '" + filePath + id++ + ".jpg')");
        sqlList.add(prefix + "7, " + id + ", '" + filePath + id + ".png')");
        sqlList.add(prefix + "8, " + id + ", '" + filePath + id++ + ".jpg')");
        sqlList.add(prefix + "9, " + id + ", '" + filePath + id + ".png')");
        sqlList.add(prefix + "10, " + id + ", '" + filePath + id++ + ".jpg')");
        sqlList.add(prefix + "11, " + id + ", '" + filePath + id + ".png')");
        sqlList.add(prefix + "12, " + id + ", '" + filePath + id++ + ".jpg')");
        sqlList.add(prefix + "13, " + id + ", '" + filePath + id + ".png')");
        sqlList.add(prefix + "14, " + id + ", '" + filePath + id++ + ".jpg')");
        sqlList.add(prefix + "15, " + id + ", '" + filePath + id + ".png')");
        sqlList.add(prefix + "16, " + id + ", '" + filePath + id++ + ".jpg')");
        sqlList.add(prefix + "17, " + id + ", '" + filePath + id + ".png')");
        sqlList.add(prefix + "18, " + id + ", '" + filePath + id++ + ".jpg')");
        sqlList.add(prefix + "19, " + id + ", '" + filePath + id + ".png')");
        sqlList.add(prefix + "20, " + id + ", '" + filePath + id++ + ".jpg')");
        sqlList.add(prefix + "21, " + id + ", '" + filePath + id + ".png')");
        sqlList.add(prefix + "22, " + id + ", '" + filePath + id++ + ".jpg')");
        return sqlList;
    }

    private List getInsertDataSqlCamera() {
        if (this.dbmsId_ == 0) {
            String insertStr = this.getInsertString(SCH_CMPY_NM, CAM_TBL_NM);
            String prefix = insertStr + "(\"" + CAM_ID_NM + "\", \"" + CAM_TYPE_NM + "\") VALUES\n\t";
            prefix = this.chkStripQuotes(prefix);
            ArrayList<String> sqlList = new ArrayList<String>();
            sqlList.add(prefix + "(1, 'Digital')");
            sqlList.add(prefix + "(2, 'CCD')");
            sqlList.add(prefix + "(3, 'Digital')");
            sqlList.add(prefix + "(4, 'Film')");
            return sqlList;
        }
        return new ArrayList();
    }

    private List getInsertDataSqlDataTypesDisp() {
        if (this.config_.isSqlSvr()) {
            return this.getInsertDTDataSqlSvr();
        }
        if (this.config_.isPsql()) {
            return this.getInsertDTDataPsql();
        }
        if (this.config_.isMySql()) {
            return this.getInsertDTDataMySql();
        }
        if (this.isOracle()) {
            return this.getInsertDTDataOracle();
        }
        return null;
    }

    private List getInsertDTDataSqlSvr() {
        String insertStr = this.getInsertString(SCH_CMPY_NM, DT_TBL_NM);
        String prefix = insertStr + "(\"xSmallDataTime\", \"xNChar\", \"xNText\", " + "\"xNVarChar\", \"xImage\", \"xSqlVariant\") VALUES\n\t";
        prefix = this.chkStripQuotes(prefix);
        ArrayList<String> list = new ArrayList<String>();
        list.add(prefix + "('2003-05-08 12:35:29', " + "'someNchar', 'someNtext', 'someNvarchar'," + "'someblobdata3iheiad', 'sqlVariant')");
        return list;
    }

    private List getInsertDTDataOracle() {
        String insertStr = this.getInsertString(SCH_CMPY_NM, DT_TBL_NM);
        String prefix = insertStr + "(\"XNUMBER\", \"XVARCHAR2\", \"XNVARCHAR2\", " + "\"XCLOB\", \"XNCLOB\", \"XRAW\") VALUES\n\t";
        prefix = this.chkStripQuotes(prefix);
        ArrayList<String> list = new ArrayList<String>();
        list.add(prefix + "('2011', " + "'someVarchar2', 'someNVarchar2', 'someCLOB'," + "'someNCLOB', 'sqlRaw')");
        return list;
    }

    private List getInsertDTDataPsql() {
        String insertStr = this.getInsertString(SCH_CMPY_NM, DT_TBL_NM);
        String prefix = insertStr + "(\"xBytea\", \"xTimestampTz\", \"xInterval\", " + "\"xTimeTz\", \"xPoint\", \"xLseg\", \"xBox\", \"xPath\", \"xPolygon\"," + "\"xCircle\", \"xCidr\", \"xInet\", \"xMacaddr\") VALUES\n\t";
        prefix = this.chkStripQuotes(prefix);
        ArrayList<String> list = new ArrayList<String>();
        list.add(prefix + "('someblobdata3iheiad', " + "'2004-10-19 10:23:54+02', '1 12:59:10', " + "'04:05:06 PST', '(5, 3)', " + "'(6, 7), (8, 9)', " + "'(10, 11), (12, 13)', " + "'(18, 19), (20, 21), (22, 23)', " + "'(24, 25), (26, 27), (28, 29)', " + "'( (30 , 31 ) , 5 )', " + "'192.168.100.128/25', " + "'192.168.100.128', " + "'08-00-2b-01-02-03'" + ")");
        return list;
    }

    private List getInsertDTDataMySql() {
        String insertStr = this.getInsertString(SCH_CMPY_NM, DT_TBL_NM);
        String prefix = insertStr + "(\"xSet\") VALUES\n\t";
        prefix = this.chkStripQuotes(prefix);
        ArrayList<String> list = new ArrayList<String>();
        list.add(prefix + "('itemB,itemC')");
        return list;
    }

    private List getInsertDataSqlFileType() {
        String insertStr = this.getInsertString(SCH_CMPY_NM, FILE_TYPE_TBL_NM);
        String prefix = insertStr + "(\"" + "Name" + "\") VALUES\n\t";
        prefix = this.chkStripQuotes(prefix);
        ArrayList<String> sqlList = new ArrayList<String>();
        sqlList.add(prefix + "('JPG')");
        sqlList.add(prefix + "('PNG')");
        sqlList.add(prefix + "('GIF')");
        sqlList.add(prefix + "('TIF')");
        return sqlList;
    }

    private List getInsertDataGroups() {
        Table tabGroup = this.getGroupsTable();
        Column colDesc = tabGroup.getColumn(GROUPS_DESC_NM);
        String descStr = this.config_.getFormattedName(colDesc);
        String insertStr = this.getInsertString(SCH_CMPY_NM, GROUPS_TBL_NM);
        String prefix = insertStr + "(" + descStr + ", \"" + GROUPS_MIS_STMT_NM + "\", \"" + GROUPS_ICON_NM + "\", \"" + GROUPS_INSERT_BY_NM + "\", \"" + GROUPS_UPDATE_BY_NM + "\", \"" + GROUPS_INSERT_DATE_NM + "\", \"" + GROUPS_UPDATE_DATE_NM + "\") VALUES\n\t(";
        prefix = this.chkStripQuotes(prefix);
        prefix = this.reAddQuotes(prefix, colDesc.getName(), descStr);
        ArrayList<String> sqlList = new ArrayList<String>();
        sqlList.add(prefix + "'Pathologists', 'Score tissues', null, 'SlaidJ', 'HarnekR', " + this.nowStr_ + ", " + this.nowStr_ + ")");
        sqlList.add(prefix + "'Imagers', 'Capture images', null, 'RobL', 'ShawnM', " + this.nowStr_ + ", " + this.nowStr_ + ")");
        sqlList.add(prefix + "'Labs', null, '" + BLOB_DATA + "', 'HarnekR', 'PeterC', " + this.nowStr_ + ", " + this.nowStr_ + ")");
        sqlList.add(prefix + "'Publishers', 'Edit reports', '" + BLOB_DATA + "', 'AnothonyJ', 'TedB', " + this.nowStr_ + ", " + this.nowStr_ + ")");
        return sqlList;
    }

    private List getInsertDataSqlWebResAccType() {
        String insertStr = this.getInsertString(this.getWebSchNm(0), WBA_TBL_NM);
        String prefix = insertStr + "(\"" + WBA_ACC_DES_NM_OLD + "\", \"" + GEN_CHNG_BY + "\", \"" + GEN_CHNG_DATE + "\") VALUES\n\t";
        prefix = this.chkStripQuotes(prefix);
        ArrayList<String> sqlList = new ArrayList<String>();
        sqlList.add(prefix + "('External', 'HarnekR', " + this.nowStr_ + ")");
        sqlList.add(prefix + "('Company Only', 'HarnekR', " + this.nowStr_ + ")");
        sqlList.add(prefix + "('DMZ Only', 'HarnekR', " + this.nowStr_ + ")");
        return sqlList;
    }

    private List getInsertDataSqlWebRes() {
        ArrayList<String> sqlList = new ArrayList<String>();
        String insertStr = this.getInsertString(this.getWebSchNm(0), WBR_TBL_NM_OLD);
        String prefix = insertStr + "(\"" + WBR_URL_NM_OLD + "\", \"" + WBR_ACC_TYPE_ID_NM + "\", \"" + GEN_CHNG_BY + "\", \"" + GEN_CHNG_DATE + "\") VALUES\n\t";
        prefix = this.chkStripQuotes(prefix);
        sqlList.add(prefix + "('index.html', 1, 'HarnekR', " + this.nowStr_ + ")");
        sqlList.add(prefix + "('features.html', 1, 'HarnekR', " + this.nowStr_ + ")");
        sqlList.add(prefix + "('download.html', 1, 'HarnekR', " + this.nowStr_ + ")");
        sqlList.add(prefix + "('stats.html', 2, 'HarnekR', " + this.nowStr_ + ")");
        return sqlList;
    }

    private List getInsertDataSqlWebResHit() {
        String insertStr = this.getInsertString(this.getWebSchNm(0), WBH_TBL_NM);
        String prefix = insertStr + "(\"" + WBH_SBR_ID_NM + "\", \"" + WBH_HIT_DATE_NM_OLD + "\", \"" + WBH_WBR_NM_OLD + "\", \"" + GEN_CHNG_BY + "\", \"" + GEN_CHNG_DATE + "\") VALUES\n\t";
        prefix = this.chkStripQuotes(prefix);
        ArrayList<String> sqlList = new ArrayList<String>();
        sqlList.add(prefix + "(1, " + this.nowStr_ + ", 1, 'KenF', " + this.nowStr_ + ")");
        sqlList.add(prefix + "(1, " + this.nowStr_ + ", 2, 'KenF', " + this.nowStr_ + ")");
        sqlList.add(prefix + "(2, " + this.nowStr_ + ", 1, 'KenF', " + this.nowStr_ + ")");
        sqlList.add(prefix + "(2, " + this.nowStr_ + ", 3, 'KenF', " + this.nowStr_ + ")");
        return sqlList;
    }

    private List getInsertDataManager() {
        String insertStr = this.getInsertString(SCH_CMPY_NM, MGR_TBL_NM);
        String prefix = insertStr + "(\"" + "Id" + "\", \"" + "Name" + "\", \"" + MGR_BOSS_ID + "\") VALUES\n\t";
        prefix = this.chkStripQuotes(prefix);
        ArrayList<String> sqlList = new ArrayList<String>();
        sqlList.add(prefix + "(1, 'PeterS', 1)");
        sqlList.add(prefix + "(2, 'PaulA', 1)");
        sqlList.add(prefix + "(3, 'KenF', 1)");
        sqlList.add(prefix + "(4, 'BobB', 4)");
        return sqlList;
    }

    private List getInsertDataLegacy() {
        String insertStr = this.getInsertString(SCH_FIN_NM, LEG_TBL_NM);
        String prefix = insertStr + "(\"" + "LegacyIdStr" + "\") VALUES\n\t";
        prefix = this.chkStripQuotes(prefix);
        ArrayList<String> sqlList = new ArrayList<String>();
        sqlList.add(prefix + "('19-4586')");
        sqlList.add(prefix + "('20-4586')");
        sqlList.add(prefix + "('21-8475')");
        sqlList.add(prefix + "('22-5846c')");
        sqlList.add(prefix + "('23-9847')");
        sqlList.add(prefix + "('24-7848')");
        return sqlList;
    }

    private List getUpdateDataSqlPatient() {
        String updateStr = this.getUpdateString(SCH_CMPY_NM, PATIENT_TBL_NM);
        ArrayList<String> sqlList = new ArrayList<String>();
        sqlList.add(updateStr + "\"SourceId\"='393-39-93' WHERE \"PatientId\" = 1");
        sqlList.add(updateStr + "\"SourceId\"='362-68-585' WHERE \"PatientId\" = 2");
        sqlList.add(updateStr + "\"SourceId\"='22-586-236' WHERE \"PatientId\" = 3");
        sqlList.add(updateStr + "\"SourceId\"='19-858-69' WHERE \"PatientId\" = 4");
        this.chkStripQuotes(sqlList);
        return sqlList;
    }

    public List getPostUpdateInsertSqls() {
        ArrayList<String> sqlStrs = new ArrayList<String>();
        String sql = WBR_URL_DEF_OLD;
        if (this.dbmsId_ == 0) {
            sql = this.getInsertString(SCH_CMPY_NM, CAM_TBL_NM) + "(\"" + CAM_ID_NM + "\", \"" + CAM_TYPE_NM + "\") VALUES\n\t" + "(5, 'Laser')";
            sqlStrs.add(sql);
        }
        Table tabGroup = this.getGroupsTable();
        Column colDesc = tabGroup.getColumn(GROUPS_DESC_NM);
        String descStr = this.config_.getFormattedName(colDesc);
        sql = this.getInsertString(SCH_CMPY_NM, GROUPS_TBL_NM) + "(" + descStr + ", \"" + GROUPS_MIS_STMT_NM + "\", \"" + GROUPS_ICON_NM + "\", \"" + GROUPS_INSERT_BY_NM + "\", \"" + GROUPS_UPDATE_BY_NM + "\", \"" + GROUPS_INSERT_DATE_NM + "\", \"" + GROUPS_UPDATE_DATE_NM + "\") VALUES\n\t" + "('Post Analysis', 'Analyze Biz Success', null, " + "'AnothonyJ', 'TedB', " + this.nowStr_ + ", " + this.nowStr_ + ")";
        sqlStrs.add(sql);
        sql = this.getInsertString(SCH_CMPY_NM, PATH_TBL_NM) + "(\"" + PATH_ID_NM + "\", \"" + "Name" + "\", \"" + PATH_HIRE_DATE_NM + "\", \"" + PATH_EMP_ID_NM + "\") VALUES\n\t" + "(6, 'Albright', '1971-12-30', 1109)";
        sqlStrs.add(sql);
        sql = this.getInsertString(SCH_CMPY_NM, PATIENT_TBL_NM) + "(\"" + "Name" + "\", \"" + PATIENT_SOURCE_ID_NM + "\") VALUES\n\t" + "('NamePost', '222-2515')";
        sqlStrs.add(sql);
        sql = this.getInsertString(SCH_CMPY_NM, RPT_TBL_NM) + "(\"" + PATH_ID_NM + "\", \"" + PATIENT_ID_NM + "\", \"" + RPT_REPORT_TEXT_NM + "\", \"" + RPT_PUBLISH_TIME_NM + "\") VALUES\n\t" + "(6, 1, 'Post Update Report', '2005-7-29 02:20:23')";
        sqlStrs.add(sql);
        sql = this.getInsertString(this.getWebSchNm(1), SBR_TBL_NM) + "(\"" + "CompanyId" + "\", \"" + "BranchId" + "\", \"" + SBR_CONTACT_NM + "\") VALUES\n\t" + "(2, 2, 'Paul Postal')";
        sqlStrs.add(sql);
        sql = this.getInsertString(this.getWebSchNm(1), SBN_TBL_NM) + "(\"" + SBN_ID_NM + "\", \"" + "CompanyId" + "\", \"" + "BranchId" + "\") VALUES\n\t" + "(9, 1, 1)";
        sqlStrs.add(sql);
        sql = this.config_.isPsql() ? this.getInsertString(SCH_FIN_NM, INV_TBL_NM_NEW) + "(\"" + "Amount" + "\", \"" + INV_LABOR_NM + "\", \"" + INV_PAID_NM + "\", \"" + INV_LEGACY_ID_NM + "\", \"" + INV_CODENAME_NM + "\", \"" + RPT_ID_NM + "\", \"" + INV_SENT_NM + "\") VALUES\n\t" + "(1159.00, null, '1', 2, 'Zen3c', 7, '0')" : this.getInsertString(SCH_FIN_NM, INV_TBL_NM_NEW) + "(" + "Amount" + ", " + INV_LABOR_NM + ", " + INV_PAID_NM + ", " + INV_LEGACY_ID_NM + ", " + INV_CODENAME_NM + ", " + RPT_ID_NM + ", " + INV_SENT_NM + ") VALUES\n\t" + "(1159.00, null, '1', 2, 'Zen3c', 7, 0)";
        sqlStrs.add(sql);
        sql = this.getInsertString(SCH_CMPY_NM, PIC_TBL_NM) + "(\"" + RPT_ID_NM + "\", \"" + PIC_CAPTION_NM + "\", \"" + PIC_COLOR_LEVEL_NM + "\") VALUES\n\t" + "(7, 'Post Mortem', 32000)";
        sqlStrs.add(sql);
        sql = this.getInsertString(SCH_CMPY_NM, PIC_FILE_TBL_NM) + "(\"" + PIC_ID_NM + "\", \"" + PIC_FILE_URL_NM + "\") VALUES\n\t" + "(6, '//postSvr/imgFolder/1.jpg')";
        sqlStrs.add(sql);
        sql = this.getInsertString(SCH_CMPY_NM, FILE_TYPE_TBL_NM) + "(\"" + "Name" + "\") VALUES\n\t" + "('MP3')";
        sqlStrs.add(sql);
        sql = this.getInsertString(SCH_CMPY_NM, MGR_TBL_NM) + "(\"" + "Id" + "\", \"" + "Name" + "\", \"" + MGR_BOSS_ID + "\") VALUES\n\t" + "(5, 'LaneP', 4)";
        sqlStrs.add(sql);
        sql = this.getInsertString(this.getWebSchNm(1), WBA_TBL_NM) + "(\"" + WBA_ACC_DES_NM_NEW + "\", \"" + GEN_CHNG_BY + "\", \"" + GEN_CHNG_DATE + "\") VALUES\n\t" + "('Guest Area', 'HarnekR', " + this.nowStr_ + ")";
        sqlStrs.add(sql);
        sql = this.getInsertString(this.getWebSchNm(1), WBR_TBL_NM_NEW) + "(\"" + WBR_URL_NM_NEW + "\", \"" + WBR_ACC_TYPE_ID_NM + "\", \"" + GEN_CHNG_BY + "\", \"" + GEN_CHNG_DATE + "\") VALUES\n\t" + "('privacy.html', 2, 'HarnekR', " + this.nowStr_ + ")";
        sqlStrs.add(sql);
        this.chkStripQuotes(sqlStrs);
        this.reAddQuotes(sqlStrs, colDesc.getName(), descStr);
        return sqlStrs;
    }

    public static void dbLowerCase(Database db, boolean lowerCaseTables, boolean lowerCaseColumns) {
        ArrayList<RenameIdf> tableCmds = new ArrayList<RenameIdf>();
        ArrayList<UpdateInCollector> colCmds = new ArrayList<UpdateInCollector>();
        for (Schema schema : db.values(Schema.getClassName())) {
            for (Table table : schema.values(Table.getClassName())) {
                if (lowerCaseColumns) {
                    for (Column oldCol : table.values(Column.getClassName())) {
                        Column newCol = oldCol.getRenameDup(oldCol.getName().toLowerCase());
                        UpdateInCollector cmd = new UpdateInCollector(table, oldCol, newCol, Command.getStateDo());
                        colCmds.add(cmd);
                    }
                }
                if (!lowerCaseTables) continue;
                String tblNmLc = table.getName().toLowerCase();
                RenameIdf cmd = new RenameIdf(schema, table, table.getName(), tblNmLc, null);
                tableCmds.add(cmd);
            }
        }
        for (Command command : colCmds) {
            command.actionPerformed(null);
        }
        for (Command command : tableCmds) {
            command.actionPerformed(null);
        }
    }

    private int getTimeStampTypeId() {
        if (this.isOracle()) {
            return 91;
        }
        return 700;
    }

    private void checkSetPsqlOptionText(Index index) {
        if (index != null && this.isPsql() && !Validator.isStringValid(index.getOptionText())) {
            index.setOptionText("using btree");
        }
    }
}

