/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.security;

import com.harrand.coreclasses.element.Version;
import com.harrand.coreclasses.file.FilePath;
import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.option.IOptionMgr;
import com.harrand.coreclasses.text.Abbreviation;
import com.harrand.coregui.option.BasicOptionMgr;
import com.harrand.coregui.option.UserOptionMgr;
import com.harrand.dbwrench.jdbc.JdbcConfig;
import com.harrand.dbwrench.security.App;
import com.harrand.dbwrench.security.DbUser;
import com.harrand.util.LogUtil;
import com.harrand.util.XmlHelper;
import java.awt.Rectangle;
import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class VersionUpdate {
    private DbUser user_;
    private Document profileDoc_;
    private Element elmOldProfile_;

    public VersionUpdate(DbUser user) {
        if (user == null) {
            StrHelper.throwProgExcept("User can not be null.");
        }
        this.user_ = user;
        File profileFile = this.user_.getProfileFile();
        if (profileFile.exists()) {
            this.profileDoc_ = XmlHelper.loadDocument(profileFile);
            this.elmOldProfile_ = this.profileDoc_.getDocumentElement();
        }
    }

    public boolean profileFileExists() {
        return this.profileDoc_ != null;
    }

    public String getVersionStr() {
        Element elmVersionStr = XmlHelper.getFirstElementByTagName(this.elmOldProfile_, "ProfileVersion");
        String versionStr = elmVersionStr != null ? XmlHelper.getElementValue(elmVersionStr) : null;
        return versionStr;
    }

    public Version getVersionObj() {
        Version version = null;
        Element elmVersion = XmlHelper.getFirstElementByTagName(this.elmOldProfile_, Version.clazz());
        if (elmVersion != null) {
            version = Version.fromXml(elmVersion);
        }
        return version;
    }

    public double getVersionValue() {
        String oldVersionStr = this.getVersionStr();
        Version version = this.getVersionObj();
        double value = 0.0;
        value = version == null ? (oldVersionStr == null ? new Version(0, null, new Integer(9), null, null, null, null).getVersionValue().doubleValue() : new Version(0, new Integer(1), null, null, null, null, null).getVersionValue().doubleValue()) : version.getVersionValue();
        return value;
    }

    public static Version getCurrentVersion() {
        return new Version(0, new Integer(1), new Integer(4), null, null, null, null);
    }

    public static void updateMsSqlDriver(DbUser user) {
        ArrayList<JdbcConfig> updatedConfigs = new ArrayList<JdbcConfig>();
        for (JdbcConfig config : user.values(JdbcConfig.clazz())) {
            String driver = config.getDriverClassName();
            if (driver.indexOf("com.microsoft") < 0) continue;
            JdbcConfig newConfig = new JdbcConfig(config.getDbms().getName(), config.getServer(), config.getObjectInstanceName(), config.getDsn(), config.getUserName(), config.getPassword(), config.getPort(), config.getDbms().getDefaultDriverName());
            updatedConfigs.add(newConfig);
            System.out.println("updating: " + config.getName());
        }
        for (JdbcConfig addConfig : updatedConfigs) {
            user.add(addConfig);
        }
    }

    private Map getBasicTreeMap() {
        Comparator comparator = String.CASE_INSENSITIVE_ORDER;
        return new TreeMap(comparator);
    }

    public Rectangle getMdiBounds() {
        Element elmMdiBounds = XmlHelper.getFirstElementByTagName(this.elmOldProfile_, "MdiBounds");
        return XmlHelper.fromXmlRectangle(elmMdiBounds);
    }

    public Map getFilePathMap() {
        Map map = this.getBasicTreeMap();
        NodeList nodes = this.elmOldProfile_.getElementsByTagName(FilePath.clazz());
        for (int i = 0; i < nodes.getLength(); ++i) {
            FilePath filePath = FilePath.fromXml((Element)nodes.item(i));
            map.put(filePath.getName(), filePath);
        }
        return map;
    }

    public Map getAbbreviationMap() {
        Map map = this.getBasicTreeMap();
        NodeList nodes = this.elmOldProfile_.getElementsByTagName(Abbreviation.clazz());
        for (int i = 0; i < nodes.getLength(); ++i) {
            Abbreviation abbr = Abbreviation.fromXml((Element)nodes.item(i));
            map.put(abbr.getName(), abbr);
        }
        return map;
    }

    public Map getConfigMap() {
        Map map = this.getBasicTreeMap();
        String fileName = App.getConfigFolder() + this.user_.getUserName() + ".conn";
        File file = new File(fileName);
        try {
            String xmlAsString = this.user_.readEncrypted(file);
            String className = JdbcConfig.clazz();
            if (xmlAsString.indexOf(className) >= 0) {
                Document doc = XmlHelper.getDocFromString(xmlAsString);
                Element element = doc.getDocumentElement();
                NodeList list = element.getElementsByTagName(className);
                for (int i = 0; i < list.getLength(); ++i) {
                    JdbcConfig config = JdbcConfig.fromXml((Element)list.item(i));
                    map.put(config.getName(), config);
                }
            }
        }
        catch (Exception e) {
            LogUtil.printStackTrace(e);
        }
        return map;
    }

    public Map getOptionMgrMap() {
        HashMap<String, IOptionMgr> map = new HashMap<String, IOptionMgr>();
        String fileName = App.getConfigFolder() + "EditOpts." + this.user_.getUserName() + ".xml";
        IOptionMgr mgr = this.getOptionMgr(fileName);
        map.put(mgr.getName(), mgr);
        fileName = App.getConfigFolder() + "ResGridOpts." + this.user_.getUserName() + ".xml";
        mgr = this.getOptionMgr(fileName);
        map.put(mgr.getName(), mgr);
        return map;
    }

    private IOptionMgr getOptionMgr(String fileName) {
        Document doc = XmlHelper.loadDocument(new File(fileName));
        Element elmOptionMgr = doc.getDocumentElement();
        Element elmBasicMgr = XmlHelper.getFirstElementByTagName(elmOptionMgr, BasicOptionMgr.clazz());
        BasicOptionMgr basicMgr = BasicOptionMgr.fromXml(elmBasicMgr);
        return new UserOptionMgr(basicMgr.getName(), basicMgr.getAllOptions(), this.user_);
    }

    public void deleteObsoleteFiles() {
        String path = App.getConfigFolder();
        String userName = this.user_.getUserName();
        this.deleteFile(new File(path + "app.config.xml"));
        this.deleteFile(new File(path + "EditOpts." + userName + ".xml"));
        this.deleteFile(new File(path + "ResGridOpts." + userName + ".xml"));
        this.deleteFile(new File(path + userName + ".conn"));
    }

    private void deleteFile(File file) {
        if (file.exists()) {
            file.delete();
        }
    }
}

