/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.security;

import com.harrand.coreclasses.dataEntry.DataEntryResult;
import com.harrand.coreclasses.display.BoundsStore;
import com.harrand.coreclasses.element.Version;
import com.harrand.coreclasses.eula.BasicEulaMgr;
import com.harrand.coreclasses.eula.IEulaMgr;
import com.harrand.coreclasses.file.BasicFileUseMgr;
import com.harrand.coreclasses.file.FilePath;
import com.harrand.coreclasses.file.IFilePathSvr;
import com.harrand.coreclasses.file.IFileUseMgr;
import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.interfaces.Collector;
import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.coreclasses.interfaces.implementation.BasicIdentifiable;
import com.harrand.coreclasses.notification.BasicObservable;
import com.harrand.coreclasses.notification.IObservable;
import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.coreclasses.option.IOptionMgr;
import com.harrand.coreclasses.option.IOptionMgrSvr;
import com.harrand.coreclasses.security.BasicLogin;
import com.harrand.coreclasses.security.BasicPasswordCipher;
import com.harrand.coreclasses.security.BasicUser;
import com.harrand.coreclasses.security.Code;
import com.harrand.coreclasses.security.ICodeStore;
import com.harrand.coreclasses.security.ILogin;
import com.harrand.coreclasses.security.IPasswordCipher;
import com.harrand.coreclasses.security.IUser;
import com.harrand.coreclasses.text.Abbreviation;
import com.harrand.coreclasses.text.IAbbreviationSrv;
import com.harrand.coreclasses.xml.abstractions.IXmlable;
import com.harrand.dbwrench.jdbc.IJdbcConfigObserver;
import com.harrand.dbwrench.jdbc.JdbcConfig;
import com.harrand.dbwrench.naming.DbwNameBldrSvr;
import com.harrand.dbwrench.option.DbwOptionMgrSvr;
import com.harrand.dbwrench.security.App;
import com.harrand.dbwrench.security.VersionUpdate;
import com.harrand.dbwrench.template.ColumnTemplateSvr;
import com.harrand.sketch.prefs.diagram.DiagramPrefXmlCtrl;
import com.harrand.sketch.prefs.diagram.GlyphLocatePrefCtrl;
import com.harrand.sketch.zoom.presets.ZoomPresetsCtrl;
import com.harrand.sketch.zoom.presets.ZoomPresetsXmlCtrl;
import com.harrand.util.FileHelper;
import com.harrand.util.LogUtil;
import com.harrand.util.XmlHelper;
import java.awt.Rectangle;
import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class DbUser
implements IUser,
IObservable,
IPasswordCipher,
Collector,
IAbbreviationSrv,
IOptionMgrSvr,
ICodeStore,
IFilePathSvr,
IEulaMgr {
    private Map outerMap_;
    private IOptionMgrSvr optionMgrSvr_;
    private BasicUser basicUser_ = new BasicUser();
    private IFileUseMgr fileUseMgr_;
    private BasicPasswordCipher cipher_;
    private BasicObservable observable_ = new BasicObservable();
    private Version profileVersion_;
    private IEulaMgr eulaMgr_ = new BasicEulaMgr();
    private ColumnTemplateSvr colTemplateSrv_;
    private BoundsStore boundsStore_ = new BoundsStore();
    private IJdbcConfigObserver jdbcConfigObserver;
    private Element elmBinaries_;
    private Document docBinary_;
    private Rectangle mdiBounds_ = null;
    private Calendar calInstall_;
    private Code code_;
    private Code v2UpgradeCode_;
    private boolean testingFlag_ = false;
    private static String abbrMapName_ = Abbreviation.clazz();
    private boolean initFontConfigFile_ = false;
    public static final String XML_PROFILE = "Profile";
    public static final String XML_MDI_BOUNDS = "MdiBounds";
    public static final String PROMPT_PASSWORD_XML = "PromptForPassword";
    public static final String PROFILE_VERSION_OLD_XML = "ProfileVersion";
    public static final String BINARIES_XML = "Binaries";
    public static final String BINARY_XML = "Binary";
    public static final String NAME_XML = "Name";
    public static final String VALUE_XML = "Value";
    public static final String BLD_XML = "Build";
    public static final String PLF_XML = "UiPlatform";

    public DbUser() {
        this((ILogin)null);
    }

    public DbUser(ILogin login) {
        if (login == null) {
            login = BasicLogin.getDefautLogin();
        }
        try {
            this.login(login);
        }
        catch (Exception e) {
            LogUtil.printStackTrace(e);
        }
    }

    DbUser(File profileFile) {
        this.setTestingFlag(true);
        this.buildMaps();
        this.loadProfile(profileFile);
    }

    public void setAuthenticated(boolean passed) {
        this.basicUser_.setAuthenticated(passed);
    }

    public boolean getInitFontConfigFile() {
        return this.initFontConfigFile_;
    }

    public void setInitFontConfigFile(boolean flag) {
        this.initFontConfigFile_ = flag;
    }

    public void setJdbcConfigObserver(IJdbcConfigObserver jdbcConfigObserver) {
        this.jdbcConfigObserver = jdbcConfigObserver;
    }

    private void checkVersion() {
        VersionUpdate versionUpdate = new VersionUpdate(this);
        if (versionUpdate.profileFileExists()) {
            this.updateVersion(versionUpdate);
        } else {
            this.saveNewProfile();
        }
    }

    private void updateVersion(VersionUpdate versionUpdate) {
        double versionValue = versionUpdate.getVersionValue();
        double currentValue = 1020000.0;
        if (versionValue < 1000200.0) {
            System.out.println("Older Config Files Detected For: " + this.getUserName());
            this.buildCipher(this.getLogin());
            this.buildMaps();
        }
        if (versionValue <= 1000000.0) {
            System.out.println("Updating Config Files from v1.0.0.0...");
            this.loadProfile();
            this.setFilePath(new FilePath("filePath.desc.jpeg", ""));
            this.setFilePath(new FilePath("filePath.desc.png", ""));
            VersionUpdate.updateMsSqlDriver(this);
            this.save();
            System.out.println(">> Wrote v1.0.1.0 config file.");
            this.loadProfile();
            System.out.println("Config Files Update Finished.");
        }
    }

    private void loginDefault() {
        try {
            this.login(BasicLogin.getDefautLogin());
        }
        catch (Exception e) {
            LogUtil.printStackTrace(e);
        }
    }

    private boolean buildCipher(ILogin login) {
        boolean success = false;
        try {
            this.cipher_ = new BasicPasswordCipher(login);
            success = true;
        }
        catch (Exception e) {
            LogUtil.printStackTrace(e);
        }
        return success;
    }

    private void buildMaps() {
        Comparator comparator = String.CASE_INSENSITIVE_ORDER;
        this.outerMap_ = new TreeMap();
        this.outerMap_.put(FilePath.clazz(), new TreeMap(comparator));
        this.outerMap_.put(Abbreviation.clazz(), new TreeMap(comparator));
        this.outerMap_.put(JdbcConfig.clazz(), new TreeMap(comparator));
    }

    public Version getVersion() {
        return this.profileVersion_;
    }

    @Override
    public ITestResult checkDuplicateName(String mapNm, String newNm) {
        return new DataEntryResult(true);
    }

    @Override
    public ITestResult add(Identifiable idf) {
        this.addDisp(idf, true);
        return new DataEntryResult(true);
    }

    private void addDisp(Identifiable idf, boolean saveFile) {
        this.addDisp(idf, saveFile, true);
    }

    private void addDisp(Identifiable idf, boolean saveFile, boolean notifyObs) {
        Map innerMap = this.getInnerMap(idf.getMapName());
        innerMap.put(idf.getName(), idf);
        if (idf instanceof JdbcConfig && this.jdbcConfigObserver != null) {
            this.jdbcConfigObserver.setCurrentConfig((JdbcConfig)idf);
        }
        if (notifyObs) {
            this.notifyObservers(new UpdateChain(idf));
        }
        if (saveFile) {
            this.write();
        }
    }

    @Override
    public Identifiable get(String mapName, String identifiableName) {
        if (this.getInnerMap(mapName).containsKey(identifiableName)) {
            return (Identifiable)this.getInnerMap(mapName).get(identifiableName);
        }
        LogUtil.logErr(FileHelper.getResource("err.msg.identifiable.not.found") + "\n" + "Identifiable: " + identifiableName + "\n" + "MapName:      " + mapName + "\n" + "Collector:    " + this.getName());
        return null;
    }

    @Override
    public boolean contains(String mapName, String identifiableName) {
        return this.getInnerMap(mapName).containsKey(identifiableName);
    }

    @Override
    public String getDisplayName(String mapName) {
        if (mapName.equals(abbrMapName_)) {
            return FileHelper.getRes("display.name." + mapName);
        }
        return App.getRes("display.name." + mapName);
    }

    @Override
    public String getDisplayPlural(String mapName) {
        if (mapName.equals(abbrMapName_)) {
            return FileHelper.getRes("display.plural." + mapName);
        }
        return App.getRes("display.plural." + mapName);
    }

    @Override
    public Set getKeys(String mapName) {
        return this.getInnerMap(mapName).keySet();
    }

    @Override
    public String getName() {
        return this.basicUser_.getUserName();
    }

    @Override
    public void setName(String newName) {
    }

    @Override
    public String getMapName() {
        return "DbUser";
    }

    public void setTestingFlag(boolean flag) {
        this.testingFlag_ = flag;
    }

    public boolean getTestingFlag() {
        return this.testingFlag_;
    }

    @Override
    public void remove(String mapName, String identifiableName) {
        Map innerMap = this.getInnerMap(mapName);
        Identifiable idf = (Identifiable)innerMap.get(identifiableName);
        innerMap.remove(identifiableName);
        this.notifyObservers(new UpdateChain(idf));
        this.write();
    }

    @Override
    public void rename(Identifiable idf, String oldName, String newName) {
        StrHelper.throwProgExcept("Rename() not implemented");
    }

    @Override
    public int size(String mapName) {
        return this.getInnerMap(mapName).size();
    }

    @Override
    public ITestResult updateItem(Identifiable oldIdf, Identifiable newIdf) {
        this.add(newIdf);
        if (!oldIdf.getName().equals(newIdf.getName())) {
            Map innerMap = this.getInnerMap(oldIdf.getMapName());
            innerMap.remove(oldIdf.getName());
        }
        this.notifyObservers(new UpdateChain(newIdf));
        this.write();
        return new DataEntryResult(true);
    }

    @Override
    public List values(String mapName) {
        return new ArrayList(this.getInnerMap(mapName).values());
    }

    @Override
    public String decrypt(byte[] bytes) throws Exception {
        return this.cipher_.decrypt(bytes);
    }

    @Override
    public byte[] encrypt(String clearText) throws Exception {
        return this.cipher_.encrypt(clearText);
    }

    @Override
    public String readEncrypted(File file) throws Exception {
        return this.cipher_.readEncrypted(file);
    }

    @Override
    public void writeEncrypted(String clearText, File file) throws Exception {
        if (this.isAuthenticated()) {
            this.cipher_.writeEncrypted(clearText, file);
        }
    }

    @Override
    public boolean authenticate(ILogin login) throws Exception {
        boolean success = false;
        try {
            BasicPasswordCipher testCipher = new BasicPasswordCipher(login);
            String text = testCipher.readEncrypted(this.getBinaryFile());
            success = text.indexOf(BINARIES_XML) >= 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return success;
    }

    @Override
    public void setPassword(ILogin login) throws Exception {
        if (!this.isAuthenticated()) {
            throw new Exception(FileHelper.getRes("password.change.requires.login.msg"));
        }
        this.basicUser_.login(login);
        this.buildCipher(login);
        this.write();
    }

    public IFileUseMgr getFileUseMgr() {
        return this.fileUseMgr_;
    }

    @Override
    public String getUserName() {
        return this.basicUser_.getUserName();
    }

    @Override
    public boolean isAuthenticated() {
        return this.basicUser_.isAuthenticated();
    }

    @Override
    public ILogin getLogin() {
        return this.basicUser_.getLogin();
    }

    @Override
    public boolean getPromptForPassword() {
        return this.basicUser_.getPromptForPassword();
    }

    @Override
    public void setPromptForPassword(boolean promptForPassword) {
        this.basicUser_.setPromptForPassword(promptForPassword);
        this.write();
    }

    @Override
    public void logout() throws Exception {
        this.basicUser_.logout();
        this.loginDefault();
    }

    @Override
    public void login(ILogin login) throws Exception {
        this.basicUser_.login(login);
        this.optionMgrSvr_ = new DbwOptionMgrSvr(this);
        this.checkVersion();
        boolean passed = this.authenticate(login);
        this.setAuthenticated(passed);
        this.buildMaps();
        this.buildCipher(login);
        this.loadProfile();
        this.notifyObservers(null);
    }

    private void loadProfile() {
        File profileFile = this.getProfileFile();
        this.loadProfile(profileFile);
    }

    private void loadProfile(File profileFile) {
        LogUtil.logErr("DbUser:profile.path: " + profileFile.getAbsolutePath());
        Document doc = XmlHelper.loadDocument(profileFile);
        Element elmProfile = doc.getDocumentElement();
        this.loadSimpleElements(elmProfile);
        this.loadIdfs(elmProfile);
        this.loadOptionMgrs(elmProfile);
        this.loadJdbcConfigs(doc, elmProfile);
        this.loadNameBldrs(elmProfile);
        if (!this.testingFlag_) {
            this.write();
        }
    }

    private void loadSimpleElements(Element elmProfile) {
        Element elmFileUseMgr;
        boolean prompt = XmlHelper.getElementValueBoolean(XmlHelper.getFirstElementByTagName(elmProfile, PROMPT_PASSWORD_XML));
        this.basicUser_.setPromptForPassword(prompt);
        Element elmVersion = XmlHelper.getFirstElementByTagName(elmProfile, Version.clazz());
        this.profileVersion_ = elmVersion != null ? Version.fromXml(elmVersion) : VersionUpdate.getCurrentVersion();
        DbUser dbUser = this;
        Element elmBoundsStore = XmlHelper.getFirstElementByTagName(elmProfile, dbUser.boundsStore_.clazz());
        if (elmBoundsStore != null) {
            this.boundsStore_ = BoundsStore.fromXml(elmBoundsStore);
        }
        this.fileUseMgr_ = (elmFileUseMgr = XmlHelper.getFirstElementByTagName(elmProfile, BasicFileUseMgr.clazz())) != null ? BasicFileUseMgr.fromXml(elmFileUseMgr, this) : new BasicFileUseMgr(this);
        App.setFileUseMgr(this.fileUseMgr_);
        this.addCodes(elmProfile);
        this.addZoomPresets(elmProfile);
        this.loadDiagramPrefs(elmProfile);
        Element elmTemplates = XmlHelper.getFirstElementByTagName(elmProfile, "BasicTemplateSvr");
        this.colTemplateSrv_ = elmTemplates != null ? ColumnTemplateSvr.fromXml(elmTemplates) : new ColumnTemplateSvr(ColumnTemplateSvr.getDefaultTemplates());
        this.colTemplateSrv_.setUser(this);
        Element elmEulaMgr = XmlHelper.getFirstElementByTagName(elmProfile, "StartUp");
        if (elmEulaMgr != null) {
            this.eulaMgr_ = BasicEulaMgr.fromXml(elmEulaMgr);
        }
        String bld = XmlHelper.getFirstElementValue(elmProfile, BLD_XML);
        String plf = XmlHelper.getFirstElementValue(elmProfile, PLF_XML);
        this.calInstall_ = bld.equals("") || bld.equals("") ? new GregorianCalendar() : StrHelper.getDateBldPlf(bld, plf);
        if (this.profileVersion_.compareTo(VersionUpdate.getCurrentVersion()) < 0) {
            this.profileVersion_ = VersionUpdate.getCurrentVersion();
        }
    }

    private void loadIdfs(Element elmProfile) {
        int i;
        Element elmMdiBounds = XmlHelper.getFirstElementByTagName(elmProfile, XML_MDI_BOUNDS);
        this.mdiBounds_ = XmlHelper.fromXmlRectangle(elmMdiBounds);
        Element elmGroup = XmlHelper.getFirstElementByTagName(elmProfile, "FilePaths");
        NodeList nodes = elmGroup.getElementsByTagName(FilePath.clazz());
        for (i = 0; i < nodes.getLength(); ++i) {
            this.addDisp(FilePath.fromXml((Element)nodes.item(i)), false);
        }
        elmGroup = XmlHelper.getFirstElementByTagName(elmProfile, "Abbreviations");
        nodes = elmGroup.getElementsByTagName(abbrMapName_);
        for (i = 0; i < nodes.getLength(); ++i) {
            this.addDisp(Abbreviation.fromXml((Element)nodes.item(i)), false);
        }
    }

    private void loadJdbcConfigs(Document doc, Element elmProfile) {
        Map binariesMap = this.isAuthenticated() ? this.getBinaries() : new HashMap();
        Element elmGroup = XmlHelper.getFirstElementByTagName(elmProfile, "JdbcConfigs");
        JdbcConfig config = null;
        NodeList nodes = elmGroup.getElementsByTagName(JdbcConfig.clazz());
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element elmConfig = (Element)nodes.item(i);
            this.appendBinaryValue(doc, elmConfig, binariesMap);
            config = JdbcConfig.fromXml(elmConfig);
            this.addDisp(config, false, false);
        }
        if (config != null) {
            this.notifyObservers(new UpdateChain(config));
        }
    }

    private void addZoomPresets(Element elmProfile) {
        ZoomPresetsXmlCtrl presetsXmlCtrl = new ZoomPresetsXmlCtrl();
        presetsXmlCtrl.loadPresetsFromXml(elmProfile);
        ZoomPresetsCtrl.getInstance().setUser(this);
    }

    private void loadDiagramPrefs(Element elmProfile) {
        DiagramPrefXmlCtrl xmlCtrl = new DiagramPrefXmlCtrl();
        xmlCtrl.loadDataFromXml(elmProfile);
        GlyphLocatePrefCtrl.getInstance().setUser(this);
    }

    private void addCodes(Element elmProfile) {
        NodeList nodes = elmProfile.getElementsByTagName("License");
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element elmCode = (Element)nodes.item(i);
            Code codeOut = Code.fromXml(elmCode);
            if (codeOut.isStandard()) {
                this.code_ = codeOut;
                continue;
            }
            this.v2UpgradeCode_ = codeOut;
        }
    }

    private Map getBinaries() {
        HashMap<String, String> binariesMap = new HashMap<String, String>();
        try {
            String text = this.readEncrypted(this.getBinaryFile());
            Document doc = XmlHelper.getDocFromString(text);
            Element elmGroup = doc.getDocumentElement();
            NodeList nodes = elmGroup.getElementsByTagName(BINARY_XML);
            for (int i = 0; i < nodes.getLength(); ++i) {
                Element elmBinary = (Element)nodes.item(i);
                String name = XmlHelper.getFirstElementValue(elmBinary, NAME_XML);
                String value = XmlHelper.getFirstElementValue(elmBinary, VALUE_XML);
                binariesMap.put(name, value);
            }
        }
        catch (Exception e) {
            LogUtil.printStackTrace(e);
        }
        return binariesMap;
    }

    private void appendBinaryValue(Document doc, Element elmConfig, Map binariesMap) {
        String name = XmlHelper.getFirstElementValue(elmConfig, NAME_XML);
        String value = (String)binariesMap.get(name);
        String pwd = "";
        if (this.isAuthenticated()) {
            if (value != null) {
                pwd = value;
            } else {
                System.out.println("Binary value not found for JdbcConfig: " + name);
            }
        }
        Element elmPwd = XmlHelper.createElementSimple(doc, "Password", pwd);
        XmlHelper.addForeignElement(doc, elmConfig, elmPwd);
    }

    private void loadOptionMgrs(Element elmProfile) {
        Element elmMgrs = XmlHelper.getFirstElementByTagName(elmProfile, "OptionMgrs");
        this.optionMgrSvr_ = DbwOptionMgrSvr.fromXml(elmMgrs, this);
    }

    private void loadNameBldrs(Element elmProfile) {
        Element elmBldrs = XmlHelper.getFirstElementByTagName(elmProfile, "DbwNameBldrSvr");
        DbwNameBldrSvr.fromXmlInit(elmBldrs, this);
    }

    @Override
    public IOptionMgr getOptionMgr(String key) {
        return this.optionMgrSvr_.getOptionMgr(key);
    }

    @Override
    public Element asXmlElement() {
        Document doc = XmlHelper.getNewDocument();
        Element elmProfile = doc.createElement(XML_PROFILE);
        XmlHelper.addForeignElement(doc, elmProfile, this.profileVersion_.asXmlElement());
        XmlHelper.addForeignElement(doc, elmProfile, this.code_.asXmlElement());
        if (this.v2UpgradeCode_ != null) {
            XmlHelper.addForeignElement(doc, elmProfile, this.v2UpgradeCode_.asXmlElement());
        }
        XmlHelper.addElementSimple(doc, elmProfile, PROMPT_PASSWORD_XML, this.getPromptForPassword());
        XmlHelper.addElementSimple(doc, elmProfile, BLD_XML, StrHelper.getBld(this.calInstall_));
        Element elmMdiBounds = XmlHelper.asXml(doc, this.mdiBounds_, XML_MDI_BOUNDS);
        XmlHelper.appendChildSafe(elmProfile, elmMdiBounds);
        XmlHelper.addForeignElement(doc, elmProfile, ((BasicFileUseMgr)this.fileUseMgr_).asXmlElement());
        BasicIdentifiable.addIdfMapXmlGrouped(this.getInnerMap(FilePath.clazz()), doc, elmProfile, "FilePaths");
        BasicIdentifiable.addIdfMapXmlGrouped(this.getInnerMap(abbrMapName_), doc, elmProfile, "Abbreviations");
        XmlHelper.addForeignElement(doc, elmProfile, this.boundsStore_.asXmlElement());
        XmlHelper.addElementSimple(doc, elmProfile, PLF_XML, StrHelper.getPlf(this.calInstall_));
        XmlHelper.addForeignElement(doc, elmProfile, ((IXmlable)((Object)this.eulaMgr_)).asXmlElement());
        this.addJdbcConfigXml(doc, elmProfile);
        XmlHelper.addForeignElement(doc, elmProfile, this.optionMgrSvr_.asXmlElement());
        XmlHelper.addForeignElement(doc, elmProfile, DbwNameBldrSvr.instance().asXmlElement());
        this.addZoomPresetsXml(doc, elmProfile);
        this.addDiagramPrefs(doc, elmProfile);
        if (this.colTemplateSrv_ == null) {
            this.colTemplateSrv_ = new ColumnTemplateSvr(ColumnTemplateSvr.getDefaultTemplates());
        }
        XmlHelper.addForeignElement(doc, elmProfile, this.colTemplateSrv_.asXmlElement());
        return elmProfile;
    }

    private void addJdbcConfigXml(Document doc, Element elmProfile) {
        this.docBinary_ = XmlHelper.getNewDocument();
        this.elmBinaries_ = this.docBinary_.createElement(BINARIES_XML);
        Element elmGroup = doc.createElement("JdbcConfigs");
        Iterator it = this.values(JdbcConfig.clazz()).iterator();
        while (it.hasNext()) {
            try {
                JdbcConfig config = (JdbcConfig)it.next();
                Element elmImported = (Element)doc.importNode(config.asXmlElement(), true);
                Element elmPassword = XmlHelper.getFirstElementByTagName(elmImported, "Password");
                this.addBinaryElement(elmImported);
                elmImported.removeChild(elmPassword);
                elmGroup.appendChild(elmImported);
            }
            catch (Exception e) {
                LogUtil.logErr("DbUser.JdbcConfigXml.error: " + e.getMessage());
            }
        }
        elmProfile.appendChild(elmGroup);
    }

    private void addZoomPresetsXml(Document doc, Element elmProfile) {
        ZoomPresetsXmlCtrl presetsXmlCtrl = new ZoomPresetsXmlCtrl();
        XmlHelper.addForeignElement(doc, elmProfile, presetsXmlCtrl.asXmlElement());
    }

    private void addDiagramPrefs(Document doc, Element elmProfile) {
        DiagramPrefXmlCtrl diagramPrefXmlCtrl = new DiagramPrefXmlCtrl();
        XmlHelper.addForeignElement(doc, elmProfile, diagramPrefXmlCtrl.asXmlElement());
    }

    private void addBinaryElement(Element elmConfig) {
        Element elmName = XmlHelper.getFirstElementByTagName(elmConfig, NAME_XML);
        Element elmPassword = XmlHelper.getFirstElementByTagName(elmConfig, "Password");
        Element elmBinary = this.docBinary_.createElement(BINARY_XML);
        XmlHelper.addElementSimple(this.docBinary_, elmBinary, NAME_XML, XmlHelper.getElementValue(elmName));
        XmlHelper.addElementSimple(this.docBinary_, elmBinary, VALUE_XML, XmlHelper.getElementValue(elmPassword));
        this.elmBinaries_.appendChild(elmBinary);
    }

    public File getProfileFile() {
        String fileName = App.getConfigFolder() + "profile." + this.getUserName() + ".xml";
        return new File(fileName);
    }

    public File getBinaryFile() {
        String fileName = App.getConfigFolder() + this.getUserName() + ".binary";
        return new File(fileName);
    }

    private void write() {
        this.writeProfile();
        if (this.isAuthenticated()) {
            try {
                String strXml = XmlHelper.getStringFromElement(this.elmBinaries_);
                this.writeEncrypted(strXml, this.getBinaryFile());
            }
            catch (Exception e) {
                LogUtil.printStackTrace(e);
            }
        }
    }

    private void writeProfile() {
        try {
            XmlHelper.writeElement(this.asXmlElement(), this.getProfileFile());
        }
        catch (Exception e) {
            LogUtil.printStackTrace(e);
        }
    }

    private Map getInnerMap(String mapName) throws IllegalArgumentException {
        Map map = (Map)this.outerMap_.get(mapName);
        if (map == null) {
            throw new IllegalArgumentException("Could not find mapName: " + mapName + ".\n" + "Valid map names are: " + this.outerMap_.keySet().toString() + ".");
        }
        return (Map)this.outerMap_.get(mapName);
    }

    private void saveNewProfile() {
        this.setProfileDefaults();
        this.write();
        this.loadProfile();
        this.setInitFontConfigFile(true);
        LogUtil.logMsg("DbUser.creating new profile!!!!!!!!");
    }

    private void setProfileDefaults() {
        this.buildCipher(this.getLogin());
        this.setAuthenticated(true);
        this.buildMaps();
        this.profileVersion_ = VersionUpdate.getCurrentVersion();
        this.code_ = new Code("");
        this.calInstall_ = new GregorianCalendar();
        this.mdiBounds_ = new Rectangle(50, 50, 750, 550);
        this.fileUseMgr_ = new BasicFileUseMgr(this);
        this.setDefaultFilePaths();
        this.setDefaultAbbreviations();
    }

    private void setDefaultFilePaths() {
        this.addDisp(new FilePath("filePath.desc.db", ""), false);
        this.addDisp(new FilePath("filePath.desc.script", ""), false);
        this.addDisp(new FilePath("filePath.desc.jpeg", ""), false);
        this.addDisp(new FilePath("filePath.desc.png", ""), false);
    }

    private void setDefaultAbbreviations() {
        this.addDisp(new Abbreviation("de", "DESCRIBE"), false);
        this.addDisp(new Abbreviation("fr", "FROM"), false);
        this.addDisp(new Abbreviation("ii", "INSERT INTO"), false);
        this.addDisp(new Abbreviation("ins", "INSERT"), false);
        this.addDisp(new Abbreviation("lj", "LEFT JOIN"), false);
        this.addDisp(new Abbreviation("ob", "ORDER BY"), false);
        this.addDisp(new Abbreviation("se", "SELECT"), false);
        this.addDisp(new Abbreviation("ssf", "SELECT * FROM"), false);
        this.addDisp(new Abbreviation("wh", "WHERE"), false);
    }

    @Override
    public int getObserverCount() {
        return this.observable_.getObserverCount();
    }

    @Override
    public void removeAllObservers() {
        this.observable_.removeAllObservers();
    }

    @Override
    public void addObserver(IObserver observer) {
        this.observable_.addObserver(observer);
    }

    @Override
    public void notifyObservers(UpdateChain chain) {
        if (chain == null) {
            chain = new UpdateChain();
        }
        chain.add(this);
        this.observable_.notifyObservers(chain);
    }

    @Override
    public void removeObserver(IObserver observer) {
        this.observable_.removeObserver(observer);
    }

    @Override
    public Code getCode() {
        return this.code_;
    }

    @Override
    public Code getV2UpgradeCode() {
        return this.v2UpgradeCode_;
    }

    @Override
    public void setCode(Code code) {
        this.code_ = code;
        this.write();
    }

    @Override
    public void setV2UpgradeCode(Code v2UpgradeCode) {
        this.v2UpgradeCode_ = v2UpgradeCode;
        this.write();
    }

    @Override
    public Calendar getInstallCal() {
        return this.calInstall_;
    }

    public Collection getConfigs() {
        Map map = (Map)this.outerMap_.get(JdbcConfig.clazz());
        return map.values();
    }

    @Override
    public Abbreviation getAbbreviation(String shortText) {
        Abbreviation abbr = this.getKeys(abbrMapName_).contains(shortText) ? (Abbreviation)this.get(abbrMapName_, shortText) : null;
        return abbr;
    }

    public Rectangle getMdiBounds() {
        return new Rectangle(this.mdiBounds_);
    }

    public BoundsStore getBoundsStore() {
        return this.boundsStore_;
    }

    public void setMdiBounds(Rectangle mdiBounds) {
        this.mdiBounds_ = new Rectangle(mdiBounds);
        this.write();
    }

    @Override
    public void save() {
        this.write();
    }

    @Override
    public FilePath getFilePath(String nameId) {
        return (FilePath)this.get(FilePath.clazz(), nameId);
    }

    @Override
    public void setFilePath(FilePath filePath) {
        this.add(filePath);
    }

    @Override
    public boolean getEulaAccepted() {
        return this.eulaMgr_.getEulaAccepted();
    }

    @Override
    public void setEulaAccepted(boolean accepted) {
        this.eulaMgr_.setEulaAccepted(accepted);
        this.write();
    }

    public ColumnTemplateSvr getColumnTemplateSvr() {
        return this.colTemplateSrv_;
    }
}

