/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.script.svrSync;

import com.harrand.coreclasses.dataEntry.DataEntryResult;
import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.dbwrench.jdbc.JdbcConfig;
import com.harrand.dbwrench.metaData.IMetaDataCtrl;
import com.harrand.dbwrench.metaData.MySqlMetaDataCtrl;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.Index;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrench.script.builder.RenameScriptUtil;
import com.harrand.dbwrench.script.pair.TablePair;
import com.harrand.dbwrench.script.svrSync.AutoCreatedIndexCtrl;
import com.harrand.dbwrench.script.svrSync.ISvrSyncCtrl;
import com.harrand.dbwrench.script.svrSync.IndexOptionTextSyncCtrl;
import com.harrand.dbwrench.script.svrSync.PostgrSQLTableOptionsSyncCtrl;
import java.util.ArrayList;
import java.util.List;

public final class MySqlSvrSyncCtrl
implements ISvrSyncCtrl {
    private JdbcConfig config_;
    private Database svrDb_;
    private Database designDb_;
    private Database differenceDb_;
    private IMetaDataCtrl metaDataCtrl_;
    private RenameScriptUtil renameScriptUtil_;
    private String tableClazz_ = Table.getClassName();
    private String indexClazz_ = Index.getClassName();

    public MySqlSvrSyncCtrl(JdbcConfig config) {
        this.config_ = config;
        this.metaDataCtrl_ = new MySqlMetaDataCtrl(this.config_);
        this.renameScriptUtil_ = new RenameScriptUtil();
    }

    @Override
    public void setSvrDb(Database db) {
        this.differenceDb_ = this.svrDb_ = db;
    }

    @Override
    public ITestResult isDbInSync(Database designDb) {
        this.designDb_ = designDb;
        this.refreshDifferenceDb(designDb);
        DataEntryResult result = new DataEntryResult(true);
        boolean inSync = this.getDiffTableIndexNames().isEmpty();
        if (!inSync) {
            result = new DataEntryResult(false, "Database Differences", this.getIndexDiffMsg());
        }
        return result;
    }

    @Override
    public void syncAll(Database designDb) {
        this.designDb_ = designDb;
        this.syncTableOptions(designDb);
        this.syncIndexOptionText(designDb);
        this.syncAutoCreatedIndexes();
    }

    private void syncAutoCreatedIndexes() {
        new AutoCreatedIndexCtrl().addAutoCreatedIndexes(this.svrDb_, this.designDb_);
    }

    private void syncIndexOptionText(Database desingDb) {
        new IndexOptionTextSyncCtrl().syncIndexOptionText(this.svrDb_, desingDb);
    }

    private void syncTableOptions(Database designDb) {
        new PostgrSQLTableOptionsSyncCtrl().syncDesign(this.svrDb_, designDb);
    }

    private void refreshDifferenceDb(Database designDb) {
        this.renameScriptUtil_.refreshMatches(this.differenceDb_, designDb, this.config_);
    }

    private ITestResult removeCommonIndexes(Database designDb) {
        List tblPairs = this.renameScriptUtil_.getTablePairs(false);
        for (TablePair pair : tblPairs) {
            Table tblDiff = pair.getSvrTable();
            Table tblDes = pair.getDesignTable();
            ArrayList diffIndexNames = new ArrayList(tblDiff.getKeys(this.indexClazz_));
            for (Index idx : tblDes.values(this.indexClazz_)) {
                String idxName = idx.getName();
                if (!diffIndexNames.contains(idxName)) continue;
                tblDiff.remove(this.indexClazz_, idxName);
            }
        }
        return new DataEntryResult(true);
    }

    private void syncIndexes(Database designDb) {
        List tblPairs = this.renameScriptUtil_.getTablePairs(false);
        for (TablePair pair : tblPairs) {
            Table tblDiff = pair.getSvrTable();
            Table tblDes = pair.getDesignTable();
            for (Index idx : tblDiff.values(this.indexClazz_)) {
                ITestResult iTestResult = tblDes.add(idx);
            }
        }
    }

    private List getDiffTableIndexNames() {
        ArrayList<String> diffIndexes = new ArrayList<String>();
        List tblPairs = this.renameScriptUtil_.getTablePairs(false);
        for (TablePair pair : tblPairs) {
            Table tblDiff = pair.getSvrTable();
            Table tblDes = pair.getDesignTable();
            for (Index idx : tblDiff.values(this.indexClazz_)) {
                String tblDiffForEngNm = this.config_.getForEngNm(tblDiff);
                String tabIdxName = tblDiffForEngNm + "." + idx.getName();
                diffIndexes.add(tabIdxName);
            }
        }
        return diffIndexes;
    }

    private String getIndexDiffMsg() {
        StringBuffer sb = new StringBuffer("The following indexes were automatically added to the server database. \nProbably to accommodate foreign keys or unique constraints:");
        for (String tabIdxName : this.getDiffTableIndexNames()) {
            sb.append("\n    " + tabIdxName);
        }
        sb.append("\nDo you wish to add these indexes to your DbWrench design database?");
        return sb.toString();
    }
}

