/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.script.svrSync;

import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.Index;
import com.harrand.dbwrench.object.Schema;
import com.harrand.dbwrench.object.Table;
import com.harrand.util.Validator;

public final class IndexOptionTextSyncCtrl {
    public void syncIndexOptionText(Database svrDb, Database designDb) {
        for (Schema designSch : designDb.getSchemas()) {
            for (Table designTbl : designSch.getTables()) {
                for (Index designIndex : designTbl.getIndexes()) {
                    String svrOptionText;
                    String designOptionText = designIndex.getOptionText();
                    boolean syncDefault = !Validator.isStringValid(designOptionText);
                    Index svrIndex = this.getServerIndex(svrDb, designIndex);
                    if (!syncDefault || svrIndex == null || !Validator.isStringValid(svrOptionText = svrIndex.getOptionText())) continue;
                    designIndex.setOptionText(svrOptionText);
                }
            }
        }
    }

    private Index getServerIndex(Database svrDb, Index designIndex) {
        Table table;
        Index svrIndex = null;
        String tableDotNote = designIndex.getTable().getDotNote();
        if (svrDb.containsTable(tableDotNote) && (table = svrDb.getTableFromDotNote(tableDotNote)).contains(Index.getClassName(), designIndex.getName())) {
            svrIndex = table.getIndex(designIndex.getName());
        }
        return svrIndex;
    }
}

