/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.script.misc;

import com.harrand.dbwrench.object.Column;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrench.script.builder.RenameScriptUtil;
import com.harrand.dbwrench.script.pair.ColumnPair;
import com.harrand.dbwrench.script.pair.TablePair;
import java.util.List;

public class DataTruncationCtrl {
    private RenameScriptUtil renameScriptUtil_ = null;
    private String warning_ = null;

    public DataTruncationCtrl(RenameScriptUtil renameScriptUtil) {
        this.renameScriptUtil_ = renameScriptUtil;
    }

    public String getWarning() {
        return this.warning_;
    }

    public void recalculate() {
        StringBuffer sb = new StringBuffer();
        List tblPairs = this.renameScriptUtil_.getTablePairs(false);
        for (TablePair tblPair : tblPairs) {
            Table designTbl = tblPair.getDesignTable();
            List colPairs = this.renameScriptUtil_.getColumnPairs(designTbl, false);
            for (ColumnPair colPair : colPairs) {
                boolean isShorter;
                Column serverCol = colPair.getSvrColumn();
                Column designCol = colPair.getDesignColumn();
                Integer serverLength = serverCol.getLength();
                Integer designLength = designCol.getLength();
                if (serverLength == null || designLength == null || !(isShorter = designLength < serverLength)) continue;
                String colDotNote = designTbl.getDotNote() + "." + designCol.getName();
                sb.append("    " + colDotNote + " from " + serverLength + " to " + designLength + "\n");
            }
        }
        this.warning_ = sb.length() > 0 ? "WARNING: The length of the following columns will be reduced:\n" + sb.toString() + "Data in these columns may be truncated or lost." : null;
    }
}

