/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.script.converter;

import com.harrand.dbwrench.jdbc.BasicTypesSvr;
import com.harrand.dbwrench.jdbc.DataTypeSvr;
import com.harrand.dbwrench.jdbc.IDataType;
import com.harrand.dbwrench.jdbc.JdbcConfig;
import com.harrand.dbwrench.object.Column;
import com.harrand.dbwrench.object.CustomType;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.Schema;
import com.harrand.dbwrench.script.converter.BasicDataTypeConverter;
import com.harrand.dbwrench.script.converter.IDataTypeConverter;
import com.harrand.util.LogUtil;
import com.harrand.util.MathUtil;
import com.harrand.util.Validator;

public final class PostgreSqlDataTypeConverter
implements IDataTypeConverter {
    private BasicDataTypeConverter basicConv_ = new BasicDataTypeConverter(1000000000);
    private JdbcConfig config_;
    public static final int TEXT_LIMIT = 1000000000;
    public static final String BYTEA_DMO = "BYTEA";
    public static final String OID_DMO = "OID";
    public static final String VARBIT_DMO = "VARBIT";
    public static final String[] RESERVED_WORDS = new String[]{"call"};

    public PostgreSqlDataTypeConverter(JdbcConfig config) {
        this.config_ = config;
    }

    @Override
    public String getDataTypeDmo(Column column) {
        String dmo;
        IDataType dataType = column.getDataType();
        if (!dataType.isStandardType()) {
            return this.getCustomTypeDmo(column);
        }
        int dataTypeId = column.getDataTypeId();
        switch (dataTypeId) {
            case -2: {
                dmo = VARBIT_DMO;
                break;
            }
            case -7: {
                dmo = this.getBitDmo(column);
                break;
            }
            case 2004: {
                dmo = BYTEA_DMO;
                break;
            }
            case 16: {
                dmo = "BOOL";
                break;
            }
            case 700: {
                dmo = "TIMESTAMP";
                break;
            }
            case 8: {
                dmo = this.getDoubleDmo(column);
                break;
            }
            case 709: {
                dmo = BYTEA_DMO;
                break;
            }
            case 712: {
                dmo = "TEXT";
                break;
            }
            case 708: {
                dmo = BYTEA_DMO;
                break;
            }
            case 711: {
                dmo = "TEXT";
                break;
            }
            case 702: {
                dmo = "INTEGER";
                break;
            }
            case 701: {
                dmo = this.getMoneyDmo(column);
                break;
            }
            case 707: {
                dmo = BYTEA_DMO;
                break;
            }
            case 710: {
                dmo = "TEXT";
                break;
            }
            case -6: {
                dmo = "SMALLINT";
                break;
            }
            case 704: {
                dmo = OID_DMO;
                break;
            }
            case -3: {
                dmo = VARBIT_DMO;
                break;
            }
            default: {
                dmo = this.basicConv_.getDataTypeDmo(column);
            }
        }
        if (column.getIsArray()) {
            dmo = dmo + "[]";
        }
        return dmo;
    }

    private String getCustomTypeDmo(Column column) {
        String dmo = null;
        CustomType type = (CustomType)column.getDataType();
        dmo = this.config_.getDblEnquoteOn() ? this.config_.getForEngNm(type.getSchema()) + ".\"" + column.getDataTypeAndLength() + "\"" : this.basicConv_.getCustomTypeDmo(column);
        return dmo;
    }

    private String getMoneyDmo(Column column) {
        return "MONEY";
    }

    private String getBitDmo(Column column) {
        return "BIT" + column.getLengthScaleEnclosed();
    }

    private String getDoubleDmo(Column column) {
        return "DOUBLE PRECISION";
    }

    @Override
    public IDataType getDataType(Database db, Schema sch, String dtNm) {
        Integer typeIdObj = this.getInexactTypeId(dtNm);
        if (typeIdObj != null) {
            int id = typeIdObj;
            return this.getBasicType(id);
        }
        return DataTypeSvr.getDataType(db, sch, dtNm);
    }

    public Integer getInexactTypeId(String dtNm) {
        String dtNmLc = dtNm.toLowerCase();
        Integer idObj = null;
        if (dtNmLc.equals("int8")) {
            return -5;
        }
        if (dtNmLc.equals("bpchar")) {
            return 1;
        }
        if (dtNmLc.equals("character varying")) {
            return 12;
        }
        if (dtNmLc.equals("character")) {
            return 1;
        }
        if (dtNmLc.equals("double precision")) {
            return 8;
        }
        if (dtNmLc.equals("time without time zone")) {
            return 92;
        }
        if (dtNmLc.equals("time with time zone")) {
            return 773;
        }
        if (dtNmLc.equals("timestamp without time zone")) {
            return 93;
        }
        if (dtNmLc.equals("timestamp with time zone")) {
            return 772;
        }
        if (dtNmLc.equals("varbit")) {
            return -3;
        }
        if (dtNmLc.equals("bit varying")) {
            return -3;
        }
        if (dtNmLc.equals("oid")) {
            return 704;
        }
        if (dtNmLc.equals("bool")) {
            return 16;
        }
        if (dtNmLc.equals("float8")) {
            return 6;
        }
        if (dtNmLc.equals("int4")) {
            return 4;
        }
        if (dtNmLc.equals("float4")) {
            return 7;
        }
        if (dtNmLc.equals("int2")) {
            return 5;
        }
        if (dtNmLc.equals("\"path\"")) {
            return 769;
        }
        if (dtNmLc.indexOf("float") >= 0) {
            return 6;
        }
        return idObj;
    }

    private IDataType getBasicType(int typeId) {
        return BasicTypesSvr.instance().getType(typeId);
    }

    @Override
    public Column getConverted(Column inputCol, Column designCol) {
        Column newColumn = null;
        IDataType newDataType = inputCol.getDataType();
        int newDataTypeId = newDataType.getId();
        if (inputCol.getDataType().isStandardType()) {
            newDataTypeId = this.getStandardizedDataTypeId(inputCol.getDataType(), designCol.getDataType());
            newDataType = DataTypeSvr.getDataType(newDataTypeId);
            newDataTypeId = this.getSerialDataTypeId(newDataTypeId, inputCol, designCol);
            newDataType = DataTypeSvr.getDataType(newDataTypeId);
        }
        String inputNm = inputCol.getName();
        String designNm = designCol.getName();
        String newName = inputNm;
        if (!this.config_.supportsMixedCase() && inputNm.equalsIgnoreCase(designNm)) {
            newName = designNm;
        }
        Integer newLength = this.basicConv_.getConvertedLength(newDataType, inputCol, designCol);
        Integer newScale = this.basicConv_.getConvertedScale(newDataType, inputCol, designCol);
        newLength = this.getLimitedSize(newDataType, newLength, designCol.getLength());
        newScale = this.getLimitedSize(newDataType, newScale, designCol.getScale());
        boolean newSigned = this.basicConv_.getStandardizedSigned(inputCol, designCol);
        String newDefault = this.getStandardizeDefault(inputCol, designCol);
        boolean newAutoNumber = designCol.getAutoNumber();
        String newComment = designCol.getComment();
        try {
            newColumn = new Column(newName, newDataType, newLength, inputCol.getIsNullable(), newAutoNumber, newDefault, newScale, newComment, newSigned, inputCol.getEnumCsv());
            newColumn.setUnique(inputCol.getUnique());
            newColumn.setIsArray(inputCol.getIsArray());
        }
        catch (Exception e) {
            LogUtil.logErr("Error: PgSqlTypeConvert.createColumn: " + e.getMessage());
        }
        return newColumn;
    }

    @Override
    public boolean isEquivalent(Column inputCol, Column designCol) {
        if (inputCol == null || designCol == null) {
            return this.basicConv_.isEquivalent(inputCol, designCol);
        }
        Column newColumn = this.getConverted(inputCol, designCol);
        boolean equivalent = newColumn.equals(designCol);
        if (!equivalent) {
            // empty if block
        }
        return equivalent;
    }

    private int getStandardizedDataTypeId(IDataType inputDT, IDataType designDT) {
        int inputId = inputDT.getId();
        int designId = designDT.getId();
        int[] similarIds = new int[]{};
        switch (inputId) {
            case 760: {
                similarIds = new int[]{2004, 707, 708, 709};
                break;
            }
            case 2: {
                similarIds = new int[]{3};
                break;
            }
            case -3: {
                similarIds = new int[]{-2, -3};
                break;
            }
            case 93: {
                similarIds = new int[]{700};
                break;
            }
            case 8: {
                similarIds = new int[]{6};
                break;
            }
            case 4: {
                similarIds = new int[]{702};
                break;
            }
            case 5: {
                similarIds = new int[]{-6};
                break;
            }
            case 703: {
                similarIds = new int[]{710, 711, 712};
            }
        }
        int newId = this.basicConv_.getStandardizedIdDisp(inputId, designId, similarIds);
        return newId;
    }

    private int getStandardizedIdDisp(int inputId, int designId, int[] matchingIds) {
        return this.basicConv_.getStandardizedIdDisp(inputId, designId, matchingIds);
    }

    private int getSerialDataTypeId(int newDataTypeId, Column inputCol, Column designCol) {
        int convId = newDataTypeId;
        int designId = designCol.getDataType().getId();
        return convId;
    }

    public String getStandardizeDefault(Column inputCol, Column designCol) {
        boolean hasBackTick;
        String strInput = inputCol.getDefault();
        String strDesign = designCol.getDefault();
        String newDefault = strInput;
        if (!strInput.equals(strDesign)) {
            if (strInput.indexOf("nextval") >= 0 && !Validator.isStringValid(strDesign)) {
                newDefault = strDesign;
            }
            if (inputCol.getDataTypeId() == 16) {
                newDefault = this.basicConv_.getStarndardizedBooleanDefault(inputCol, designCol);
            }
        }
        boolean bl = hasBackTick = strDesign.indexOf("`") == 0;
        if (hasBackTick && strInput.indexOf("`") != 0) {
            newDefault = strDesign;
        }
        return newDefault;
    }

    private Integer getLimitedSize(IDataType inputDataType, Integer inputSize, Integer designSize) {
        int inputDataTypeId;
        Integer newSize = inputSize;
        if (inputSize != null && ((inputDataTypeId = inputDataType.getId()) == 3 || inputDataTypeId == 2) && inputSize == 1000) {
            newSize = MathUtil.dup(designSize);
        }
        return newSize;
    }
}

