/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.script.converter;

import com.harrand.dbwrench.jdbc.BasicTypesSvr;
import com.harrand.dbwrench.jdbc.DataTypeSvr;
import com.harrand.dbwrench.jdbc.IDataType;
import com.harrand.dbwrench.object.Column;
import com.harrand.dbwrench.object.CustomType;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.Schema;
import com.harrand.dbwrench.script.compare.OracleCompareCtrl;
import com.harrand.dbwrench.script.converter.BasicDataTypeConverter;
import com.harrand.dbwrench.script.converter.IDataTypeConverter;
import com.harrand.util.LogUtil;

public final class OracleDataTypeConverter
implements IDataTypeConverter {
    private BasicDataTypeConverter basicConv_ = new BasicDataTypeConverter(1000000000);
    public static final int TEXT_LIMIT = 1000000000;

    @Override
    public String getDataTypeDmo(Column column) {
        String dmo;
        IDataType dataType = column.getDataType();
        if (!dataType.isStandardType()) {
            return this.getCustomTypeDmo(column);
        }
        int dataTypeId = column.getDataTypeId();
        switch (dataTypeId) {
            case 16: {
                dmo = "NUMBER(1)";
                break;
            }
            default: {
                dmo = this.basicConv_.getDataTypeDmo(column);
            }
        }
        return dmo;
    }

    private String getCustomTypeDmo(Column column) {
        String dmo = null;
        CustomType type = (CustomType)column.getDataType();
        dmo = this.basicConv_.getCustomTypeDmo(column);
        return dmo;
    }

    @Override
    public IDataType getDataType(Database db, Schema sch, String dtNm) {
        Integer typeIdObj = this.getInexactTypeId(dtNm);
        if (typeIdObj != null) {
            int id = typeIdObj;
            return this.getBasicType(id);
        }
        return DataTypeSvr.getDataType(db, sch, dtNm);
    }

    @Override
    public boolean isEquivalent(Column svrCol, Column designCol) {
        boolean equivalent;
        if (svrCol == null || designCol == null) {
            return this.basicConv_.isEquivalent(svrCol, designCol);
        }
        Column convSvrCol = this.getConverted(svrCol, designCol);
        Column designCol_UC = (Column)designCol.getDup();
        designCol_UC.setName(designCol.getName().toUpperCase());
        designCol_UC.setAutoNumber(false);
        if (OracleCompareCtrl.isUndefinedTrivialCompare(svrCol.getScaleStr(), designCol.getScaleStr())) {
            designCol_UC.setScale(convSvrCol.getScale());
        }
        if (!(equivalent = convSvrCol.equals(designCol_UC))) {
            // empty if block
        }
        return equivalent;
    }

    @Override
    public Column getConverted(Column svrCol, Column designCol) {
        Column newColumn = null;
        IDataType svrDataType = svrCol.getDataType();
        int svrDataTypeId = svrDataType.getId();
        String svrNm = svrCol.getName();
        String designNm = designCol.getName();
        String convName = svrNm;
        Integer newLength = this.basicConv_.getConvertedLength(svrDataType, svrCol, designCol);
        Integer newScale = this.basicConv_.getConvertedScale(svrDataType, svrCol, designCol);
        boolean newSigned = this.basicConv_.getStandardizedSigned(svrCol, designCol);
        String newDefault = svrCol.getDefault();
        String newComment = designCol.getComment();
        try {
            newColumn = new Column(convName, svrDataType, newLength, svrCol.getIsNullable(), svrCol.getAutoNumber(), newDefault, newScale, newComment, newSigned, svrCol.getEnumCsv());
            newColumn.setUnique(svrCol.getUnique());
            newColumn.setIsArray(svrCol.getIsArray());
        }
        catch (Exception e) {
            LogUtil.logErr("Error: OraclelTypeConvert.createColumn: " + e.getMessage());
        }
        return newColumn;
    }

    public Integer getInexactTypeId(String dtNm) {
        String dtNmLc = dtNm.toLowerCase();
        Integer idObj = null;
        if (dtNmLc.equals("timestamp(6)")) {
            return 93;
        }
        return idObj;
    }

    private IDataType getBasicType(int typeId) {
        return BasicTypesSvr.instance().getType(typeId);
    }
}

