/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.script.converter;

import com.harrand.coreclasses.element.Version;
import com.harrand.coreclasses.help.StrHelper;
import com.harrand.dbwrench.jdbc.BasicTypesSvr;
import com.harrand.dbwrench.jdbc.DataTypeSvr;
import com.harrand.dbwrench.jdbc.IDataType;
import com.harrand.dbwrench.jdbc.JdbcConfig;
import com.harrand.dbwrench.object.Column;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.Schema;
import com.harrand.dbwrench.script.builder.CommentScriptBldr;
import com.harrand.dbwrench.script.converter.BasicDataTypeConverter;
import com.harrand.dbwrench.script.converter.IDataTypeConverter;
import com.harrand.util.Validator;
import java.text.DecimalFormat;

public final class MySqlDataTypeConverter
implements IDataTypeConverter {
    private BasicDataTypeConverter basicConv_ = new BasicDataTypeConverter(256);
    private JdbcConfig config_;
    public static final String UNSIGNED_STR = "UNSIGNED";
    private static final Version COMMENT_VERSION = new Version(0, new Integer(4), new Integer(1), new Integer(0), null, null, null);
    private static final Version VER_5 = new Version(0, new Integer(5), new Integer(0), new Integer(0), null, null, null);
    public static final int TEXT_LIMIT = 256;
    public static final String[] RESERVED_WORDS = new String[]{"connection", "force", "natural", "match", "loop", "limit"};
    public static final String CURRENT_TIMESTAMP_STR = "CURRENT_TIMESTAMP";

    public void setConfig(JdbcConfig config) {
        this.config_ = config;
    }

    @Override
    public String getDataTypeDmo(Column column) {
        String dmo;
        int dataTypeId = column.getDataTypeId();
        switch (dataTypeId) {
            case 2004: {
                dmo = this.getBlobDmo(column);
                break;
            }
            case 701: {
                dmo = this.getMoneyDmo(column);
                break;
            }
            case 7: {
                dmo = "FLOAT";
                break;
            }
            case 704: {
                dmo = "INTEGER";
                break;
            }
            case -3: {
                dmo = this.getVarBinaryDmo(column);
                break;
            }
            default: {
                dmo = this.basicConv_.getDataTypeDmo(column);
            }
        }
        if (!column.getSignedFlag()) {
            dmo = dmo + " " + UNSIGNED_STR;
        }
        return dmo;
    }

    private String getVarBinaryDmo(Column column) {
        if (this.basicConv_.isUnderCharLimit(column)) {
            return "VARCHAR(" + column.getLengthScaleText() + ") BINARY";
        }
        return this.getBlobDmo(column);
    }

    private String getMoneyDmo(Column column) {
        return "DECIMAL(10, 2)";
    }

    private String getBlobDmo(Column column) {
        return "BLOB";
    }

    @Override
    public IDataType getDataType(Database db, Schema sch, String dtNm) {
        String name = dtNm.toLowerCase();
        if (name.equals("varchar binary")) {
            return this.getBasicType(-3);
        }
        if (name.equals("mediumblob")) {
            return this.getBasicType(708);
        }
        if (name.equals("mediumtext")) {
            return this.getBasicType(711);
        }
        if (name.equals("year")) {
            return this.getBasicType(4);
        }
        if (name.equals("int")) {
            return this.getBasicType(4);
        }
        return DataTypeSvr.getDataType(db, sch, dtNm);
    }

    private IDataType getBasicType(int typeId) {
        return BasicTypesSvr.instance().getType(typeId);
    }

    @Override
    public Column getConverted(Column inputCol, Column designCol) {
        Column newColumn = null;
        int newDataTypeId = this.getStandardizedDataTypeId(inputCol.getDataType(), designCol.getDataType());
        IDataType newDataType = DataTypeSvr.getDataType(newDataTypeId);
        Integer newLength = this.basicConv_.getConvertedLength(newDataType, inputCol, designCol);
        Integer newScale = this.basicConv_.getConvertedScale(newDataType, inputCol, designCol);
        String newDefault = this.cleanDefault(inputCol, designCol);
        boolean newNullable = this.getStandardizedNullable(inputCol, designCol);
        String newComment = this.getStandardizedComment(inputCol, designCol);
        try {
            newColumn = new Column(inputCol.getName(), newDataTypeId, newLength, newNullable, inputCol.getAutoNumber(), newDefault, newScale, newComment, inputCol.getSignedFlag(), inputCol.getEnumCsv());
            newColumn.setUnique(inputCol.getUnique());
            newColumn.setIsArray(inputCol.getIsArray());
        }
        catch (Exception e) {
            System.out.println("Error: MySqlTypeConvert.getConverted: " + e.getMessage());
        }
        return newColumn;
    }

    @Override
    public boolean isEquivalent(Column inputCol, Column designCol) {
        if (inputCol == null || designCol == null) {
            return this.basicConv_.isEquivalent(inputCol, designCol);
        }
        Column newColumn = this.getConverted(inputCol, designCol);
        boolean equivalent = newColumn.equals(designCol);
        if (!equivalent) {
            // empty if block
        }
        return equivalent;
    }

    private int getStandardizedDataTypeId(IDataType inputDT, IDataType designDT) {
        int inputId = inputDT.getId();
        int designId = designDT.getId();
        Version version = this.config_.getVersion();
        int[] similarIds = new int[]{};
        switch (inputId) {
            case 12: {
                if (version != null && version.compareTo(VER_5) >= 0) {
                    similarIds = new int[]{-2, -3};
                    break;
                }
                similarIds = new int[]{1};
                break;
            }
            case -6: {
                similarIds = new int[]{16};
                break;
            }
            case 6: {
                similarIds = new int[]{7};
                break;
            }
            case 3: {
                similarIds = new int[]{701, 2};
            }
        }
        int newId = this.basicConv_.getStandardizedIdDisp(inputId, designId, similarIds);
        return newId;
    }

    private String cleanDefault(Column inputCol, Column designCol) {
        String designDefault = designCol.getDefault();
        String inputDefault = inputCol.getDefault();
        String newDefault = inputCol.getDefault();
        if (!Validator.isStringValid(inputDefault)) {
            return "";
        }
        if (designDefault.indexOf("()") >= 0) {
            newDefault = designDefault;
        }
        if (designDefault.length() > 0 && designDefault.substring(0, 1).equals("`")) {
            newDefault = "`" + newDefault;
        }
        if (!Validator.isStringValid(designDefault)) {
            if (StrHelper.isZeroValue(inputDefault)) {
                newDefault = "";
            } else if (inputDefault.equals(CURRENT_TIMESTAMP_STR)) {
                newDefault = "";
            }
        } else if (StrHelper.isNumeric(inputDefault)) {
            String designFormatted;
            DecimalFormat formatter = new DecimalFormat("#.########");
            double inputValue = Double.parseDouble(inputDefault);
            double designValue = Double.parseDouble(designDefault);
            String inputFormatted = formatter.format(inputValue);
            if (inputFormatted.equals(designFormatted = formatter.format(designValue))) {
                newDefault = designDefault;
            }
        }
        if (inputCol.getDataTypeId() == 706) {
            newDefault = designDefault;
        }
        return newDefault;
    }

    private String getStandardizedComment(Column inputCol, Column designCol) {
        String designComment;
        String inputComment = inputCol.getComment();
        String commentStr = designComment = designCol.getComment();
        Version version = this.config_.getVersion();
        if (version != null) {
            if (version.compareTo(COMMENT_VERSION) >= 0) {
                commentStr = inputComment;
            }
        } else if (Validator.isStringValid(inputComment) && CommentScriptBldr.needsUpdate(inputComment, designComment)) {
            commentStr = inputComment;
        }
        return commentStr;
    }

    private boolean getStandardizedNullable(Column inputCol, Column designCol) {
        boolean newNullable = inputCol.getIsNullable();
        String inputDefault = inputCol.getDefault();
        String designDefault = designCol.getDefault();
        if (inputCol.getDataType().getId() == 93 && inputCol.getIsNullable()) {
            newNullable = designCol.getIsNullable();
        }
        if (!StrHelper.isZeroValue(designDefault)) {
            newNullable = designCol.getIsNullable();
        }
        return newNullable;
    }

    private int getStandardizedIdDisp(int inputId, int designId, int[] matchingIds) {
        return this.basicConv_.getStandardizedIdDisp(inputId, designId, matchingIds);
    }
}

