/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.script.converter;

import com.harrand.dbwrench.jdbc.BasicTypesSvr;
import com.harrand.dbwrench.jdbc.DataTypeSvr;
import com.harrand.dbwrench.jdbc.IDataType;
import com.harrand.dbwrench.object.Column;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.Schema;
import com.harrand.dbwrench.script.converter.BasicDataTypeConverter;
import com.harrand.dbwrench.script.converter.IDataTypeConverter;
import com.harrand.util.LogUtil;

public final class MsSqlServerDataTypeConverter
implements IDataTypeConverter {
    private BasicDataTypeConverter basicConv_ = new BasicDataTypeConverter(4001);
    public static final int TEXT_LIMIT = 4001;
    public static final String[] RESERVED_WORDS = new String[]{"currency"};

    @Override
    public String getDataTypeDmo(Column column) {
        String dmo;
        IDataType dataType = column.getDataType();
        if (!dataType.isStandardType()) {
            return this.basicConv_.getCustomTypeDmo(column);
        }
        int dataTypeId = column.getDataTypeId();
        switch (dataTypeId) {
            case 2004: {
                dmo = this.getImageDmo(column);
                break;
            }
            case 16: {
                dmo = "BIT";
                break;
            }
            case 8: {
                dmo = "FLOAT";
                break;
            }
            case 709: {
                dmo = this.getImageDmo(column);
                break;
            }
            case 712: {
                dmo = "TEXT";
                break;
            }
            case 708: {
                dmo = this.getImageDmo(column);
                break;
            }
            case 711: {
                dmo = "TEXT";
                break;
            }
            case 702: {
                dmo = "INTEGER";
                break;
            }
            case 707: {
                dmo = this.getImageDmo(column);
                break;
            }
            case 710: {
                dmo = "TEXT";
                break;
            }
            case 704: {
                dmo = "UniqueIdentifier";
                break;
            }
            default: {
                dmo = this.basicConv_.getDataTypeDmo(column);
            }
        }
        return dmo;
    }

    private String getImageDmo(Column column) {
        return "IMAGE";
    }

    @Override
    public IDataType getDataType(Database db, Schema sch, String dtNm) {
        Integer typeIdObj = this.getInexactTypeId(dtNm);
        if (typeIdObj != null) {
            int id = typeIdObj;
            return this.getBasicType(id);
        }
        return DataTypeSvr.getDataType(db, sch, dtNm);
    }

    public Integer getInexactTypeId(String dtNm) {
        String dtNmLc = dtNm.toLowerCase();
        Integer idObj = null;
        if (dtNmLc.equals("bigint identity")) {
            return -5;
        }
        if (dtNmLc.equals("smallint identity")) {
            return 5;
        }
        if (dtNmLc.equals("int identity")) {
            return 4;
        }
        if (dtNmLc.equals("int")) {
            return 4;
        }
        if (dtNmLc.equals("tinyint identity")) {
            return -6;
        }
        if (dtNmLc.equals("uniqueidentifier")) {
            return 704;
        }
        if (dtNmLc.equals("sql_variant")) {
            return 725;
        }
        if (dtNmLc.equals("smallmoney")) {
            return 701;
        }
        return idObj;
    }

    private IDataType getBasicType(int typeId) {
        return BasicTypesSvr.instance().getType(typeId);
    }

    @Override
    public Column getConverted(Column inputCol, Column designCol) {
        Column newColumn = null;
        IDataType newDataType = inputCol.getDataType();
        int newDataTypeId = newDataType.getId();
        if (inputCol.getDataType().isStandardType()) {
            newDataTypeId = this.getStandardizedDataTypeId(inputCol.getDataType(), designCol.getDataType());
            newDataType = DataTypeSvr.getDataType(newDataTypeId);
        }
        Integer newLength = this.basicConv_.getConvertedLength(newDataType, inputCol, designCol);
        Integer newScale = this.basicConv_.getConvertedScale(newDataType, inputCol, designCol);
        boolean newSigned = this.basicConv_.getStandardizedSigned(inputCol, designCol);
        String defaultStr = this.getStandardizedDefault(inputCol, designCol);
        String newComment = designCol.getComment();
        try {
            newColumn = new Column(inputCol.getName(), newDataType, newLength, inputCol.getIsNullable(), inputCol.getAutoNumber(), defaultStr, newScale, newComment, newSigned, inputCol.getEnumCsv());
            newColumn.setUnique(inputCol.getUnique());
            newColumn.setIsArray(inputCol.getIsArray());
        }
        catch (Exception e) {
            LogUtil.logErr("Error: MsSqlSvrTypeConvert.createColumn: " + e.getMessage());
        }
        return newColumn;
    }

    @Override
    public boolean isEquivalent(Column inputCol, Column designCol) {
        if (inputCol == null || designCol == null) {
            return this.basicConv_.isEquivalent(inputCol, designCol);
        }
        Column newColumn = this.getConverted(inputCol, designCol);
        boolean equivalent = newColumn.equals(designCol);
        return equivalent;
    }

    private int getStandardizedDataTypeId(IDataType inputDT, IDataType designDT) {
        int inputId = inputDT.getId();
        int designId = designDT.getId();
        int[] similarIds = new int[]{};
        switch (inputId) {
            case -7: {
                similarIds = new int[]{16};
                break;
            }
            case 721: {
                similarIds = new int[]{707, 2004, 708, 709};
                break;
            }
            case 6: {
                similarIds = new int[]{8};
                break;
            }
            case 4: {
                similarIds = new int[]{702};
                break;
            }
            case 7: {
                similarIds = new int[]{3, 6};
                break;
            }
            case 700: {
                similarIds = new int[]{93};
                break;
            }
            case 703: {
                similarIds = new int[]{710, 711, 712};
                break;
            }
            case 704: {
                similarIds = new int[]{4};
            }
        }
        int newId = this.basicConv_.getStandardizedIdDisp(inputId, designId, similarIds);
        return newId;
    }

    private String getStandardizedDefault(Column inputCol, Column designCol) {
        String defaultStr = inputCol.getDefault();
        if (inputCol.getDefault().equalsIgnoreCase(designCol.getDefault())) {
            defaultStr = designCol.getDefault();
        }
        return defaultStr;
    }

    private int getStandardizedIdDisp(int inputId, int designId, int[] matchingIds) {
        return this.basicConv_.getStandardizedIdDisp(inputId, designId, matchingIds);
    }
}

