/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.script.converter;

import com.harrand.dbwrench.jdbc.BasicTypesSvr;
import com.harrand.dbwrench.jdbc.DataTypeSvr;
import com.harrand.dbwrench.jdbc.IDataType;
import com.harrand.dbwrench.object.Column;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.Schema;
import com.harrand.dbwrench.script.converter.BasicDataTypeConverter;
import com.harrand.dbwrench.script.converter.IDataTypeConverter;

public final class MsAccessDataTypeConverter
implements IDataTypeConverter {
    private BasicDataTypeConverter basicConv_ = new BasicDataTypeConverter(256);
    private static final int TEXT_LIMIT = 256;
    public static final String CURRENCY_DMO = "CURRENCY";
    public static final String MEMO_DMO = "MEMO";
    public static final String LONG_DMO = "LONG";
    public static final String LONGBINARY_DMO = "LONGBINARY";
    public static final String SINGLE_DMO = "SINGLE";
    public static final String[] RESERVED_WORDS = new String[]{"currency"};

    @Override
    public String getDataTypeDmo(Column column) {
        String dmo;
        int dataTypeId = column.getDataTypeId();
        switch (dataTypeId) {
            case -5: {
                dmo = LONG_DMO;
                break;
            }
            case -2: {
                dmo = LONGBINARY_DMO;
                break;
            }
            case 2004: {
                dmo = LONGBINARY_DMO;
                break;
            }
            case 16: {
                dmo = "BIT";
                break;
            }
            case 1: {
                dmo = this.getTextDmo(column);
                break;
            }
            case 3: {
                dmo = SINGLE_DMO;
                break;
            }
            case 6: {
                dmo = SINGLE_DMO;
                break;
            }
            case 709: {
                dmo = LONGBINARY_DMO;
                break;
            }
            case 712: {
                dmo = MEMO_DMO;
                break;
            }
            case 702: {
                dmo = "INTEGER";
                break;
            }
            case 708: {
                dmo = LONGBINARY_DMO;
                break;
            }
            case 711: {
                dmo = MEMO_DMO;
                break;
            }
            case 701: {
                dmo = CURRENCY_DMO;
                break;
            }
            case 2: {
                dmo = SINGLE_DMO;
                break;
            }
            case 7: {
                dmo = SINGLE_DMO;
                break;
            }
            case 703: {
                dmo = MEMO_DMO;
                break;
            }
            case 92: {
                dmo = "DATE";
                break;
            }
            case 93: {
                dmo = "DATE";
                break;
            }
            case -6: {
                dmo = "SMALLINT";
                break;
            }
            case 707: {
                dmo = LONGBINARY_DMO;
                break;
            }
            case 710: {
                dmo = MEMO_DMO;
                break;
            }
            case 704: {
                dmo = "AutoNumber";
                break;
            }
            case 12: {
                dmo = this.getTextDmo(column);
                break;
            }
            case -3: {
                dmo = LONGBINARY_DMO;
                break;
            }
            default: {
                dmo = this.basicConv_.getDataTypeDmo(column);
            }
        }
        return dmo;
    }

    private String getTextDmo(Column column) {
        if (this.basicConv_.isUnderCharLimit(column)) {
            return "TEXT(" + column.getLengthScaleText() + ")";
        }
        return MEMO_DMO;
    }

    @Override
    public IDataType getDataType(Database db, Schema schema, String dtNm) {
        String name = dtNm.toLowerCase();
        if (name.equals("longchar")) {
            return this.getBasicType(703);
        }
        if (name.equals("counter")) {
            return this.getBasicType(704);
        }
        if (name.equals("longbinary")) {
            return this.getBasicType(2004);
        }
        if (name.equals("currency")) {
            return this.getBasicType(701);
        }
        return DataTypeSvr.getDataType(db, schema, dtNm);
    }

    private IDataType getBasicType(int typeId) {
        return BasicTypesSvr.instance().getType(typeId);
    }

    @Override
    public Column getConverted(Column inputCol, Column designCol) {
        Column newColumn = null;
        int newDataTypeId = this.getStandardizedDataTypeId(inputCol.getDataType(), designCol.getDataType());
        IDataType newDataType = DataTypeSvr.getDataType(newDataTypeId);
        boolean newNullable = designCol.getIsNullable();
        String newDefault = designCol.getDefault();
        Integer newLength = this.basicConv_.getConvertedLength(newDataType, inputCol, designCol);
        Integer newScale = this.basicConv_.getConvertedScale(newDataType, inputCol, designCol);
        boolean newSigned = this.basicConv_.getStandardizedSigned(inputCol, designCol);
        String newComment = designCol.getComment();
        try {
            newColumn = new Column(inputCol.getName(), newDataTypeId, newLength, newNullable, inputCol.getAutoNumber(), newDefault, newScale, newComment, newSigned, inputCol.getEnumCsv());
        }
        catch (Exception e) {
            System.out.println("Error: MsAccessTypeConvert.createColumn: " + e.getMessage());
        }
        return newColumn;
    }

    @Override
    public boolean isEquivalent(Column inputCol, Column designCol) {
        if (inputCol == null || designCol == null) {
            return this.basicConv_.isEquivalent(inputCol, designCol);
        }
        Column newColumn = this.getConverted(inputCol, designCol);
        return newColumn.equals(designCol);
    }

    private int getStandardizedDataTypeId(IDataType inputDT, IDataType designDT) {
        int inputId = inputDT.getId();
        int designId = designDT.getId();
        int[] similarIds = new int[]{};
        switch (inputId) {
            case -2: {
                similarIds = new int[]{-3};
                break;
            }
            case -7: {
                similarIds = new int[]{16};
                break;
            }
            case 2004: {
                similarIds = new int[]{707, 708, 709};
                break;
            }
            case 8: {
                similarIds = new int[]{2, 7};
                break;
            }
            case 7: {
                similarIds = new int[]{3, 6};
                break;
            }
            case 4: {
                similarIds = new int[]{-5, 702};
                break;
            }
            case 700: {
                similarIds = new int[]{91, 92, 93};
                break;
            }
            case 5: {
                similarIds = new int[]{-6};
                break;
            }
            case 703: {
                similarIds = new int[]{710, 711, 712};
                break;
            }
            case -3: {
                similarIds = new int[]{-2};
                break;
            }
            case 12: {
                similarIds = new int[]{1};
                break;
            }
            case 704: {
                similarIds = new int[]{4, -5, 702, 5, -6};
            }
        }
        int newId = this.basicConv_.getStandardizedIdDisp(inputId, designId, similarIds);
        return newId;
    }

    private int getStandardizedIdDisp(int inputId, int designId, int[] matchingIds) {
        return this.basicConv_.getStandardizedIdDisp(inputId, designId, matchingIds);
    }
}

