/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.script.converter;

import com.harrand.dbwrench.jdbc.DataTypeSvr;
import com.harrand.dbwrench.jdbc.IDataType;
import com.harrand.dbwrench.object.Column;
import com.harrand.dbwrench.object.CustomType;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.Schema;
import com.harrand.dbwrench.script.converter.IDataTypeConverter;
import com.harrand.util.MathUtil;

public final class BasicDataTypeConverter
implements IDataTypeConverter {
    private int charLimit_;
    public static final String TEXT_DMO = "TEXT";
    public static final String JSONB_DMO = "JSONB";
    public static final String JSON_DMO = "JSON";

    public BasicDataTypeConverter(int charLimit) {
        this.charLimit_ = charLimit;
    }

    @Override
    public String getDataTypeDmo(Column column) {
        String dmo = column.getDataTypeDescFull();
        int dataTypeId = column.getDataTypeId();
        switch (dataTypeId) {
            case -5: {
                dmo = "BIGINT";
                break;
            }
            case -2: {
                dmo = this.getBinaryDmo(column);
                break;
            }
            case -7: {
                dmo = "BIT";
                break;
            }
            case 2004: {
                dmo = "BLOB";
                break;
            }
            case 16: {
                dmo = "BOOLEAN";
                break;
            }
            case 761: {
                dmo = "BOX";
                break;
            }
            case 760: {
                dmo = "BYTEA";
                break;
            }
            case 1: {
                dmo = this.getCharDmo(column);
                break;
            }
            case 763: {
                dmo = "CIDR";
                break;
            }
            case 762: {
                dmo = "CIRCLE";
                break;
            }
            case 783: {
                dmo = "CLOB";
                break;
            }
            case 91: {
                dmo = "DATE";
                break;
            }
            case 700: {
                dmo = "DATETIME";
                break;
            }
            case 3: {
                dmo = this.getDecimalDmo(column);
                break;
            }
            case 8: {
                dmo = "DOUBLE";
                break;
            }
            case 706: {
                dmo = this.getEnumDmo(column);
                break;
            }
            case 6: {
                dmo = "FLOAT";
                break;
            }
            case 779: {
                dmo = "GEOMETRY";
                break;
            }
            case 721: {
                dmo = "IMAGE";
                break;
            }
            case 4: {
                dmo = "INTEGER";
                break;
            }
            case 764: {
                dmo = "INET";
                break;
            }
            case 765: {
                dmo = "INTERVAL";
                break;
            }
            case 786: {
                dmo = JSON_DMO;
                break;
            }
            case 787: {
                dmo = JSONB_DMO;
                break;
            }
            case 766: {
                dmo = "LINE";
                break;
            }
            case 767: {
                dmo = "LSEG";
                break;
            }
            case 709: {
                dmo = "LONGBLOB";
                break;
            }
            case 712: {
                dmo = "LONGTEXT";
                break;
            }
            case 768: {
                dmo = "MACADDR";
                break;
            }
            case 708: {
                dmo = "MEDIUMBLOB";
                break;
            }
            case 711: {
                dmo = "MEDIUMTEXT";
                break;
            }
            case 702: {
                dmo = "MEDIUMINT";
                break;
            }
            case 701: {
                dmo = "MONEY";
                break;
            }
            case 722: {
                dmo = this.getNCharDmo(column);
                break;
            }
            case 784: {
                dmo = "NCLOB";
                break;
            }
            case 723: {
                dmo = "NTEXT";
                break;
            }
            case 724: {
                dmo = this.getNVarCharDmo(column);
                break;
            }
            case 782: {
                dmo = this.getNVarChar2Dmo(column);
                break;
            }
            case 729: {
                dmo = "NVARCHAR(MAX)";
                break;
            }
            case 780: {
                dmo = this.getNumberDmo(column);
                break;
            }
            case 2: {
                dmo = this.getNumericDmo(column);
                break;
            }
            case 769: {
                dmo = "PATH";
                break;
            }
            case 770: {
                dmo = "POINT";
                break;
            }
            case 771: {
                dmo = "POLYGON";
                break;
            }
            case 7: {
                dmo = "REAL";
                break;
            }
            case 785: {
                dmo = this.getRawDmo(column);
                break;
            }
            case 740: {
                dmo = this.getSetDmo(column);
                break;
            }
            case 5: {
                dmo = "SMALLINT";
                break;
            }
            case 726: {
                dmo = "SMALLDATETIME";
                break;
            }
            case 725: {
                dmo = "SQL_VARIANT";
                break;
            }
            case 703: {
                dmo = TEXT_DMO;
                break;
            }
            case 92: {
                dmo = "TIME";
                break;
            }
            case 773: {
                dmo = "TIME WITH TIME ZONE";
                break;
            }
            case 93: {
                dmo = "TIMESTAMP";
                break;
            }
            case 772: {
                dmo = "TIMESTAMP WITH TIME ZONE";
                break;
            }
            case -6: {
                dmo = "TINYINT";
                break;
            }
            case 707: {
                dmo = "TINYBLOB";
                break;
            }
            case 710: {
                dmo = "TINYTEXT";
                break;
            }
            case 776: {
                dmo = "TSQUERY";
                break;
            }
            case 775: {
                dmo = "TSVECTOR";
                break;
            }
            case 704: {
                dmo = "UNIQUEID";
                break;
            }
            case 774: {
                dmo = "UUID";
                break;
            }
            case -3: {
                dmo = this.getVarBinaryDmo(column);
                break;
            }
            case 730: {
                dmo = "VARBINARY(MAX)";
                break;
            }
            case 12: {
                dmo = this.getVarCharDmo(column);
                break;
            }
            case 731: {
                dmo = "VARCHAR(MAX)";
                break;
            }
            case 781: {
                dmo = this.getVarChar2Dmo(column);
                break;
            }
            case 728: {
                dmo = "XML";
            }
        }
        return dmo;
    }

    public String getCustomTypeDmo(Column column) {
        CustomType type = (CustomType)column.getDataType();
        return type.getSchema() + "." + column.getDataTypeDescFull();
    }

    @Override
    public IDataType getDataType(Database db, Schema sch, String dtNm) {
        String name = dtNm.toLowerCase();
        return DataTypeSvr.getDataType(db, sch, dtNm);
    }

    @Override
    public boolean isEquivalent(Column inputCol, Column designCol) {
        boolean isEquivalent = false;
        if (inputCol == null && designCol == null) {
            isEquivalent = true;
        } else if (inputCol == null) {
            isEquivalent = false;
        } else if (designCol == null) {
            isEquivalent = false;
        }
        return isEquivalent;
    }

    @Override
    public Column getConverted(Column inputCol, Column designCol) {
        try {
            Column newColumn = new Column(inputCol.getName(), inputCol.getDataTypeId(), inputCol.getLength(), inputCol.getIsNullable(), inputCol.getAutoNumber(), inputCol.getDefault(), inputCol.getScale(), inputCol.getComment(), inputCol.getSignedFlag(), inputCol.getEnumCsv());
            newColumn.setUnique(inputCol.getUnique());
            newColumn.setIsArray(inputCol.getIsArray());
            return newColumn;
        }
        catch (Exception e) {
            System.out.println("Error: BasicDataTypeConvert.getConverted: " + e.getMessage());
            return null;
        }
    }

    public int getStandardizedIdDisp(int inputId, int designId, int[] similarIds) {
        int newId = inputId;
        for (int i = 0; i < similarIds.length; ++i) {
            if (similarIds[i] != designId) continue;
            newId = designId;
        }
        return newId;
    }

    public Integer getConvertedLength(IDataType newDataType, Column inputCol, Column designCol) {
        Integer newLength = MathUtil.dup(inputCol.getLength());
        boolean converted = this.isDataTypeConverted(newDataType, inputCol, designCol);
        if (converted) {
            if (designCol.getDataType().isLengthUsed()) {
                if (!inputCol.getDataType().isLengthUsed()) {
                    newLength = MathUtil.dup(designCol.getLength());
                }
            } else {
                newLength = null;
            }
        }
        return newLength;
    }

    public Integer getConvertedScale(IDataType newDataType, Column inputCol, Column designCol) {
        Integer newScale = MathUtil.dup(inputCol.getScale());
        boolean converted = this.isDataTypeConverted(newDataType, inputCol, designCol);
        if (converted) {
            if (designCol.getDataType().isScaleUsed()) {
                if (!inputCol.getDataType().isScaleUsed()) {
                    newScale = MathUtil.dup(designCol.getScale());
                }
            } else {
                newScale = null;
            }
        }
        return newScale;
    }

    public boolean isDataTypeConverted(IDataType newDataType, Column inputCol, Column designCol) {
        return newDataType.getId() == designCol.getDataType().getId();
    }

    public boolean getStandardizedSigned(Column inputCol, Column designCol) {
        return designCol.getSignedFlag();
    }

    public String getStarndardizedBooleanDefault(Column inputCol, Column designCol) {
        boolean boolDesign;
        boolean boolInput;
        String strInput = inputCol.getDefault();
        String strDesign = designCol.getDefault();
        String newDefault = strInput;
        if (!strInput.equals(strDesign) && (boolInput = this.getBooleanFromText(strInput)) == (boolDesign = this.getBooleanFromText(strDesign))) {
            newDefault = strDesign;
        }
        return newDefault;
    }

    public boolean getBooleanFromText(String text) {
        boolean bool = true;
        String textLc = text.toLowerCase();
        if (textLc.equals("f") || textLc.equals("false") || textLc.equals("0")) {
            bool = false;
        }
        return bool;
    }

    public boolean isUnderCharLimit(Column column) {
        Integer length = column.getLength();
        if (length == null) {
            return true;
        }
        return length < this.charLimit_;
    }

    private String getBinaryDmo(Column column) {
        return "BINARY(" + column.getLengthScaleText() + ")";
    }

    private String getCharDmo(Column column) {
        return "CHAR(" + column.getLengthScaleText() + ")";
    }

    private String getEnumDmo(Column column) {
        return "ENUM(" + column.getEnumCsv() + ")";
    }

    private String getSetDmo(Column column) {
        return "SET(" + column.getEnumCsv() + ")";
    }

    public String getDecimalDmo(Column column) {
        return "DECIMAL" + this.getLenSclNullFormattedStr(column);
    }

    private String getNumberDmo(Column column) {
        return "NUMBER" + this.getLenSclNullFormattedStr(column);
    }

    private String getNumericDmo(Column column) {
        return "NUMERIC" + this.getLenSclNullFormattedStr(column);
    }

    private String getVarBinaryDmo(Column column) {
        return "VARBINARY(" + column.getLengthScaleText() + ")";
    }

    private String getVarCharDmo(Column column) {
        return "VARCHAR" + this.getLenSclNullFormattedStr(column);
    }

    private String getVarChar2Dmo(Column column) {
        return "VARCHAR2" + this.getLenSclNullFormattedStr(column);
    }

    private String getNCharDmo(Column column) {
        return "NCHAR(" + column.getLengthScaleText() + ")";
    }

    private String getNVarCharDmo(Column column) {
        return "NVARCHAR(" + column.getLengthScaleText() + ")";
    }

    private String getNVarChar2Dmo(Column column) {
        return "NVARCHAR2" + this.getLenSclNullFormattedStr(column);
    }

    private String getRawDmo(Column column) {
        return "RAW" + this.getLenSclNullFormattedStr(column);
    }

    private String getLenSclNullFormattedStr(Column column) {
        String lenSclRaw = column.getLengthScaleText();
        String lenSclFormatted = lenSclRaw.length() == 0 ? "" : "(" + lenSclRaw + ")";
        return lenSclFormatted;
    }
}

