/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.script.compare.formatter;

import com.harrand.coreclasses.help.StrHelper;
import com.harrand.util.LogUtil;
import com.harrand.util.Validator;

public class MySqlViewFormatter {
    private String rawSql_ = null;
    private String formattedSql_ = null;

    public String getFormattedSql(String rawSql) {
        if (!Validator.isStringValid(rawSql)) {
            LogUtil.logErr("MySqlVwFormatter: rawSql can not be null or empty string.");
        }
        this.rawSql_ = rawSql;
        this.formatSql();
        return this.formattedSql_;
    }

    private void formatSql() {
        String newSql = this.rawSql_.replaceAll(" \n", "\n");
        newSql = newSql.replaceAll("`", "");
        newSql = StrHelper.removeComments(newSql);
        newSql = StrHelper.replaceFormattingWithSpaces(newSql);
        newSql = StrHelper.removeExtraSpaces(newSql);
        newSql = this.stripExtraBrackets(newSql);
        this.formattedSql_ = this.addWhiteSpaces(newSql);
    }

    private String stripExtraBrackets(String sql) {
        boolean hasFrom;
        String cleanSql = null;
        String[] fromSplits = sql.split("(?i)\\sfrom\\s");
        boolean bl = hasFrom = fromSplits.length > 1;
        if (hasFrom) {
            String postFromClause = fromSplits[1];
            String[] whereSplits = postFromClause.split("(?i)\\swhere\\s");
            String fromClause = whereSplits[0];
            String whereClause = whereSplits.length > 1 ? "WHERE " + whereSplits[1] : "";
            String[] joinSplits = fromClause.split("(?i)\\sjoin\\s");
            StringBuffer sbNewFrom = new StringBuffer();
            int joinCount = joinSplits.length - 1;
            for (int i = 0; i < joinSplits.length; ++i) {
                String phrase = joinSplits[i];
                String newPhrase = i == 0 ? this.cleanFromPhrase(phrase, joinCount) : this.cleanJoinPhrase(phrase);
                sbNewFrom.append(newPhrase.trim() + " ");
            }
            cleanSql = fromSplits[0] + " " + sbNewFrom.toString() + whereClause;
        } else {
            cleanSql = sql;
        }
        return cleanSql;
    }

    private String cleanFromPhrase(String fromPhrase, int joinCount) {
        String regExStr = "\\({" + joinCount + "}";
        String newPhrase = "FROM " + fromPhrase;
        newPhrase = newPhrase.replaceFirst(regExStr, "");
        newPhrase = newPhrase.replaceAll("(?i)\\sas\\s", " ");
        return newPhrase;
    }

    private String cleanJoinPhrase(String joinPhrase) {
        boolean hasExtraBrackets;
        String newJoinPhrase = joinPhrase;
        boolean bl = hasExtraBrackets = joinPhrase.indexOf(" on((") >= 0;
        if (hasExtraBrackets) {
            newJoinPhrase = joinPhrase.replaceFirst(" on\\(\\(", " ON ");
        } else {
            boolean bl2 = hasExtraBrackets = joinPhrase.indexOf(" ON((") >= 0;
            if (hasExtraBrackets) {
                newJoinPhrase = joinPhrase.replaceFirst(" ON\\(\\(", " ON ");
            }
        }
        if (hasExtraBrackets) {
            newJoinPhrase = newJoinPhrase.replaceAll("\\)\\)\\)", "");
        }
        newJoinPhrase = "JOIN " + newJoinPhrase;
        newJoinPhrase = newJoinPhrase.replaceAll("(?i)\\sas\\s", " ");
        return newJoinPhrase;
    }

    private String addWhiteSpaces(String sql) {
        String newSql = new String(sql);
        newSql = newSql.replaceFirst("(?i)select\\s", "SELECT\n    ");
        newSql = newSql.replaceAll(", ", ",");
        newSql = newSql.replaceAll(",", ",\n    ");
        newSql = newSql.replaceAll("\\s(?i)from\\s", "\nFROM ");
        newSql = newSql.replaceAll("\\s(?i)where\\s", "\nWHERE ");
        newSql = newSql.replaceAll("\\s(?i)order by\\s", "\nORDER BY ");
        newSql = newSql.replaceAll("\\s(?i)group by\\s", "\nGROUP BY ");
        newSql = newSql.replaceAll("\\s(?i)join\\s", "\n    JOIN ");
        newSql = newSql.replaceAll("\\s(?i)and\\s", "\n        AND ");
        newSql = newSql.replaceAll("\\s(?i)or\\s", "\n        OR ");
        newSql = newSql.replaceAll("\\s(?i)on\\s", " ON ");
        newSql = newSql.replaceAll("\\s(?i)as\\s", " AS ");
        newSql = newSql.trim();
        return newSql;
    }
}

