/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.script.compare;

import com.harrand.coreclasses.dataEntry.CompareResult;
import com.harrand.coreclasses.element.ICollPair;
import com.harrand.coreclasses.element.IIdfPair;
import com.harrand.dbwrench.jdbc.JdbcConfig;
import com.harrand.dbwrench.object.Proc;
import com.harrand.dbwrench.object.Trigger;
import com.harrand.dbwrench.script.compare.BasicDbmsCompareCtrl;
import com.harrand.dbwrench.script.compare.itemizer.PsqlProcItemizer;

public class PsqlCompareCtrl
extends BasicDbmsCompareCtrl {
    public PsqlCompareCtrl(JdbcConfig config) {
        super(config, false);
    }

    @Override
    protected CompareResult isTriggerEquiv(IIdfPair idfPair, ICollPair collPair) {
        String prefix;
        boolean hasPrefixB;
        Trigger trgSrv = (Trigger)idfPair.getSvrIdf();
        Trigger trgDesign = (Trigger)idfPair.getDesignIdf();
        StringBuffer sb = new StringBuffer();
        this.compare(sb, "On Delete", trgSrv.getFireOnDeleteFlag(), trgDesign.getFireOnDeleteFlag());
        this.compare(sb, "On Insert", trgSrv.getFireOnInsertFlag(), trgDesign.getFireOnInsertFlag());
        this.compare(sb, "On Update", trgSrv.getFireOnUpdateFlag(), trgDesign.getFireOnUpdateFlag());
        this.compare(sb, "Execute Before", trgSrv.getExecBefore(), trgDesign.getExecBefore());
        this.compare(sb, "For Each Row", trgSrv.getForEachRow(), trgDesign.getForEachRow());
        String trgSqlRawA = trgSrv.getSql();
        String trgSqlRawB = trgDesign.getSql();
        String trgSqlA = trgSqlRawA;
        String trgSqlB = trgSqlRawB;
        boolean hasPrefixA = trgSqlRawA.split("\\.").length > 1;
        boolean bl = hasPrefixB = trgSqlRawB.split("\\.").length > 1;
        if (hasPrefixA && !hasPrefixB) {
            prefix = trgSqlRawA.split("\\.")[0];
            trgSqlB = prefix + "." + trgSqlRawB;
        }
        if (!hasPrefixA && hasPrefixB) {
            prefix = trgSqlRawB.split("\\.")[0];
            trgSqlA = prefix + "." + trgSqlRawA;
        }
        this.compare(sb, "SQL", trgSqlA, trgSqlB);
        return this.buildResult(idfPair, collPair, sb);
    }

    @Override
    protected CompareResult isProcEquiv(IIdfPair idfPair, ICollPair collPair) {
        StringBuffer sb = new StringBuffer();
        Proc procSrv = (Proc)idfPair.getSvrIdf();
        Proc procDesign = (Proc)idfPair.getDesignIdf();
        PsqlProcItemizer itemizerA = new PsqlProcItemizer(procSrv);
        PsqlProcItemizer itemizerB = new PsqlProcItemizer(procDesign);
        this.compare(sb, "Source Body", itemizerA.getBodyRemoveEscapes(), itemizerB.getBodyRemoveEscapes());
        this.compare(sb, "Return Type", itemizerA.getReturnType(), itemizerB.getReturnType());
        this.compare(sb, "Language", itemizerA.getLanguage(), itemizerB.getLanguage());
        if (!this.getForForwardEngineer()) {
            this.compare(sb, "Comment", procSrv.getComment(), procDesign.getComment());
        }
        return this.buildResult(idfPair, collPair, sb);
    }
}

