/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.script.compare;

import com.harrand.coreclasses.dataEntry.CompareResult;
import com.harrand.coreclasses.element.BasicCollPair;
import com.harrand.coreclasses.element.BasicIdfPair;
import com.harrand.coreclasses.element.ICollPair;
import com.harrand.coreclasses.element.IIdfPair;
import com.harrand.coreclasses.interfaces.Collector;
import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.coreclasses.list.NamedList;
import com.harrand.coreclasses.option.IOptionMgr;
import com.harrand.dbwrench.jdbc.JdbcConfig;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.ForeignKey;
import com.harrand.dbwrench.object.Index;
import com.harrand.dbwrench.object.PrimaryKey;
import com.harrand.dbwrench.object.Proc;
import com.harrand.dbwrench.object.Schema;
import com.harrand.dbwrench.object.Sequence;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrench.object.Trigger;
import com.harrand.dbwrench.object.View;
import com.harrand.dbwrench.object.table.constraint.UniqueConstraint;
import com.harrand.dbwrench.option.OptMgrHelper;
import com.harrand.dbwrench.script.builder.RenameScriptUtil;
import com.harrand.dbwrench.script.compare.IDbmsCompareCtrl;
import com.harrand.dbwrench.script.pair.SchemaPair;
import com.harrand.dbwrench.script.pair.TablePair;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class DbCompareCtrl {
    private IDbmsCompareCtrl compareCtrl_;
    private RenameScriptUtil rnmScriptUtil_ = new RenameScriptUtil();
    private boolean caseSens_ = false;
    private String dbDescA_ = "Server DB";
    private String dbDescB_ = "Design DB";

    public NamedList getDiffResults(IDbmsCompareCtrl compareCtrl, Database dbSvr, Database dbDesign, JdbcConfig config) {
        this.compareCtrl_ = compareCtrl;
        this.caseSens_ = config.isSqlSvr();
        this.rnmScriptUtil_.refreshMatches(dbSvr, dbDesign, config);
        List diffResults = new ArrayList();
        BasicCollPair dbPair = new BasicCollPair(dbSvr, dbDesign);
        diffResults = this.getDiffResultsDisp(this.rnmScriptUtil_.getSchemaPairs(true), dbPair);
        List sortedResults = this.prioritizeDiffsDisp(diffResults);
        this.setResultIds(sortedResults);
        NamedList nameds = new NamedList();
        nameds.addAll(sortedResults);
        return nameds;
    }

    private List getDiffResultsDisp(List pairs, ICollPair collPair) {
        ArrayList diffResults = new ArrayList();
        for (IIdfPair pair : pairs) {
            String clz = pair.getClz();
            if (clz.equals(Schema.getClassName())) {
                Schema schA = (Schema)pair.getSvrIdf();
                Schema schB = (Schema)pair.getDesignIdf();
                this.addIfDiff(diffResults, this.compareCtrl_.isEquivalent(pair, collPair));
                if (pair.getHasNull()) continue;
                this.addTblDiffs((SchemaPair)pair, diffResults);
                this.addSchemaSubDiffs(pair, Proc.getClassName(), diffResults);
                this.addSchemaSubDiffs(pair, View.getClassName(), diffResults);
                this.addSchemaSubDiffs(pair, Sequence.getClassName(), diffResults);
                continue;
            }
            if (!clz.equals(Table.getClassName())) continue;
            TablePair tblPair = (TablePair)pair;
            Table tblA = (Table)tblPair.getSvrIdf();
            Table tblB = (Table)tblPair.getDesignIdf();
            this.addIfDiff(diffResults, this.compareCtrl_.isEquivalent(pair, collPair));
            if (pair.getHasNull()) continue;
            this.addColumnDiffs(tblPair, diffResults);
            this.addTableSubDiffs(tblPair, ForeignKey.getClassName(), diffResults);
            this.addPkDiff(tblPair, diffResults);
            this.addTableSubDiffs(tblPair, Index.getClassName(), diffResults);
            this.addTableSubDiffs(tblPair, UniqueConstraint.getClassName(), diffResults);
            this.addTableSubDiffs(tblPair, Trigger.getClassName(), diffResults);
        }
        return diffResults;
    }

    private boolean isOptEnabled(String classNm) {
        boolean isEnabled = true;
        OptMgrHelper optMgrHelper = OptMgrHelper.getIntance();
        IOptionMgr forEngOptMgr = optMgrHelper.getOptionMgr("forward.engineer.option.mgr");
        String optNm = optMgrHelper.getForEngOptionNm(classNm);
        isEnabled = forEngOptMgr.getBoolValue(optNm);
        return isEnabled;
    }

    private void addTblDiffs(SchemaPair schPair, List diffResults) {
        Schema schSvr = schPair.getSvrSchema();
        Schema schDesign = schPair.getDesignSchema();
        ArrayList<TablePair> currentTblPairs = new ArrayList<TablePair>();
        List allTblPairs = this.rnmScriptUtil_.getTablePairs(true);
        for (TablePair tblPair : allTblPairs) {
            String designTblSchNm;
            Table svrTbl = tblPair.getSvrTable();
            Table designTbl = tblPair.getDesignTable();
            String svrTblSchNm = svrTbl != null ? svrTbl.getSchema().getName() : "";
            String string = designTblSchNm = designTbl != null ? designTbl.getSchema().getName() : "";
            if (!schSvr.getName().equals(svrTblSchNm) && !schDesign.getName().equals(designTblSchNm)) continue;
            currentTblPairs.add(tblPair);
        }
        List tblDiffs = this.getDiffResultsDisp(currentTblPairs, schPair);
        diffResults.addAll(tblDiffs);
    }

    private void addColumnDiffs(TablePair tblPair, List diffs) {
        Table tblDesign = (Table)tblPair.getDesignIdf();
        List colPairs = this.rnmScriptUtil_.getColumnPairs(tblDesign, true);
        for (IIdfPair colPair : colPairs) {
            CompareResult result = this.compareCtrl_.isEquivalent(colPair, tblPair);
            if (result.getPassed()) continue;
            diffs.add(result);
        }
    }

    private void addTableSubDiffs(TablePair tblPair, String clzNm, List diffs) {
        if (!this.isOptEnabled(clzNm)) {
            return;
        }
        Table tblSvr = tblPair.getSvrTable();
        Table tblDesign = tblPair.getDesignTable();
        List subPairs = this.getNonRenamablePair(tblSvr, tblDesign, clzNm);
        for (IIdfPair subPair : subPairs) {
            CompareResult result = this.compareCtrl_.isEquivalent(subPair, tblPair);
            if (result.getPassed()) continue;
            diffs.add(result);
        }
    }

    private void addPkDiff(TablePair tblPair, List diffs) {
        BasicIdfPair pkPair;
        CompareResult result;
        Table tblSvr = tblPair.getSvrTable();
        Table tblDesign = tblPair.getDesignTable();
        PrimaryKey pkSvr = tblSvr.getPrimaryKey();
        PrimaryKey pkDesign = tblDesign.getPrimaryKey();
        if (!(pkSvr == null && pkDesign == null || (result = this.compareCtrl_.isEquivalent(pkPair = new BasicIdfPair(tblSvr.getPrimaryKey(), tblDesign.getPrimaryKey(), tblDesign.getDotNote()), tblPair)).getPassed())) {
            diffs.add(result);
        }
    }

    private void addSchemaSubDiffs(IIdfPair idfSchPair, String clzNm, List diffs) {
        if (!this.isOptEnabled(clzNm)) {
            return;
        }
        Schema schA = (Schema)idfSchPair.getSvrIdf();
        Schema schB = (Schema)idfSchPair.getDesignIdf();
        SchemaPair schPair = (SchemaPair)idfSchPair;
        List subPairs = this.getNonRenamablePair(schA, schB, clzNm);
        for (IIdfPair subPair : subPairs) {
            CompareResult result = this.compareCtrl_.isEquivalent(subPair, schPair);
            if (result.getPassed()) continue;
            diffs.add(result);
        }
    }

    private List getNonRenamablePair(Collector collA, Collector collB, String clzNm) {
        ArrayList<BasicIdfPair> pairs = new ArrayList<BasicIdfPair>();
        Set keysA = collA.getKeys(clzNm);
        Set keysB = collB.getKeys(clzNm);
        String nmPrefix = collB.getName();
        if (collB instanceof Table) {
            nmPrefix = ((Table)collB).getDotNote();
        }
        ArrayList onlyAKeys = new ArrayList(keysA);
        onlyAKeys.removeAll(keysB);
        for (String nm : onlyAKeys) {
            BasicIdfPair pair = new BasicIdfPair(collA.get(clzNm, nm), null, nmPrefix);
            pairs.add(pair);
        }
        ArrayList onlyBKeys = new ArrayList(keysB);
        onlyBKeys.removeAll(keysA);
        for (String nm : onlyBKeys) {
            BasicIdfPair pair = new BasicIdfPair(null, collB.get(clzNm, nm), nmPrefix);
            pairs.add(pair);
        }
        ArrayList bothKeys = new ArrayList(keysA);
        bothKeys.retainAll(keysB);
        for (String nm : bothKeys) {
            BasicIdfPair pair = new BasicIdfPair(collA.get(clzNm, nm), collB.get(clzNm, nm), nmPrefix);
            pairs.add(pair);
        }
        return pairs;
    }

    private void addIfDiff(List diffResults, CompareResult result) {
        if (!result.getPassed()) {
            diffResults.add(result);
        }
    }

    private List prioritizeDiffsDisp(List diffResults) {
        List diffResultsA = this.prioritizeDiffs("Index", diffResults);
        List diffResultsB = this.prioritizeDiffs("ForeignKey", diffResultsA);
        return diffResultsB;
    }

    private List prioritizeDiffs(String clz, List diffResults) {
        ArrayList<CompareResult> sortedDiffs = new ArrayList<CompareResult>();
        ArrayList<CompareResult> addClzResults = new ArrayList<CompareResult>();
        ArrayList<CompareResult> removeClzResults = new ArrayList<CompareResult>();
        for (CompareResult diffResult : diffResults) {
            Identifiable srvIdf = diffResult.getIdfPair().getSvrIdf();
            Identifiable desIdf = diffResult.getIdfPair().getDesignIdf();
            if (srvIdf != null && srvIdf.getMapName().equals(clz) && desIdf == null) {
                addClzResults.add(diffResult);
                continue;
            }
            if (desIdf != null && desIdf.getMapName().equals(clz) && srvIdf == null) {
                removeClzResults.add(diffResult);
                continue;
            }
            sortedDiffs.add(diffResult);
        }
        for (int i = 0; i < removeClzResults.size(); ++i) {
            CompareResult diffResult = (CompareResult)removeClzResults.get(i);
            sortedDiffs.add(i, diffResult);
        }
        for (CompareResult diffResult : addClzResults) {
            sortedDiffs.add(diffResult);
        }
        return sortedDiffs;
    }

    private void setResultIds(List results) {
        int nextId = 1;
        for (CompareResult result : results) {
            result.setId(new Integer(nextId));
            ++nextId;
        }
    }
}

