/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.script.compare;

import com.harrand.coreclasses.dataEntry.CompareResult;
import com.harrand.coreclasses.element.DiffItem;
import com.harrand.coreclasses.element.ICollPair;
import com.harrand.coreclasses.element.IIdfPair;
import com.harrand.dbwrench.jdbc.JdbcConfig;
import com.harrand.dbwrench.object.Column;
import com.harrand.dbwrench.object.ForeignKey;
import com.harrand.dbwrench.object.Index;
import com.harrand.dbwrench.object.PrimaryKey;
import com.harrand.dbwrench.object.Proc;
import com.harrand.dbwrench.object.Schema;
import com.harrand.dbwrench.object.Sequence;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrench.object.Trigger;
import com.harrand.dbwrench.object.View;
import com.harrand.dbwrench.object.table.constraint.UniqueConstraint;
import com.harrand.dbwrench.script.compare.IDbmsCompareCtrl;
import com.harrand.dbwrench.script.compare.formatter.MySqlViewFormatter;
import com.harrand.dbwrench.script.compare.formatter.PsqlViewFormatter;
import com.harrand.util.LogUtil;
import java.util.ArrayList;
import java.util.List;

public class BasicDbmsCompareCtrl
implements IDbmsCompareCtrl {
    private JdbcConfig config_;
    private boolean supportsMixedCase_;
    List diffItems_ = new ArrayList();
    private boolean forForwardEngineer_ = false;

    public BasicDbmsCompareCtrl(JdbcConfig config, boolean supportsMixedCase) {
        this.setConfig(config);
        this.setSupportsMixedCase(supportsMixedCase);
    }

    public void setConfig(JdbcConfig config) {
        if (config == null) {
            LogUtil.logErr("BasicDbmsCompareCtrl.config can not be null.");
        }
        this.config_ = config;
    }

    public JdbcConfig getConfig() {
        return this.config_;
    }

    public void setSupportsMixedCase(boolean supportsMixedCase) {
        this.supportsMixedCase_ = supportsMixedCase;
    }

    public void setForForwardEngineer(boolean forForwardEngineer) {
        this.forForwardEngineer_ = forForwardEngineer;
    }

    public boolean getSupportsMixedCase() {
        return this.supportsMixedCase_;
    }

    public boolean getForForwardEngineer() {
        return this.forForwardEngineer_;
    }

    @Override
    public CompareResult isEquivalent(IIdfPair idfPair, ICollPair collPair) {
        if (idfPair.getHasNull()) {
            return this.getOneNullResult(idfPair, collPair);
        }
        String clzNm = idfPair.getClz();
        if (clzNm.equals(Proc.getClassName())) {
            return this.isProcEquiv(idfPair, collPair);
        }
        if (clzNm.equals(View.getClassName())) {
            return this.isViewEquiv(idfPair, collPair);
        }
        if (clzNm.equals(Sequence.getClassName())) {
            return this.isSequenceEquiv(idfPair, collPair);
        }
        if (clzNm.equals(Table.getClassName())) {
            return this.isTableEquiv(idfPair, collPair);
        }
        if (clzNm.equals(Schema.getClassName())) {
            return this.isSchemaEquiv(idfPair, collPair);
        }
        if (clzNm.equals(Column.getClassName())) {
            return this.isColumnEquiv(idfPair, collPair);
        }
        if (clzNm.equals(ForeignKey.getClassName())) {
            return this.isFkEquiv(idfPair, collPair);
        }
        if (clzNm.equals(PrimaryKey.getClassName())) {
            return this.isPkEquiv(idfPair, collPair);
        }
        if (clzNm.equals(Index.getClassName())) {
            return this.isIndexEquiv(idfPair, collPair);
        }
        if (clzNm.equals(UniqueConstraint.getClassName())) {
            return this.isUcEquiv(idfPair, collPair);
        }
        if (clzNm.equals(Trigger.getClassName())) {
            return this.isTriggerEquiv(idfPair, collPair);
        }
        LogUtil.logErr("BasicDbCompareCtrl.unsupport type: " + clzNm);
        return null;
    }

    private void compareAutoNumber(StringBuffer sb, Column colSrv, Column colDesign) {
        if (!this.config_.isPsql()) {
            this.compare(sb, "Auto Num.", colSrv.getAutoNumberDesc(), colDesign.getAutoNumberDesc());
        }
    }

    private CompareResult getOneNullResult(IIdfPair idfPair, ICollPair collPair) {
        ArrayList<DiffItem> diffItems = new ArrayList<DiffItem>();
        if (idfPair.getSvrIdf() == null) {
            DiffItem diffItem = new DiffItem("Not On Server", " -- ", " -- ");
            diffItems.add(diffItem);
            CompareResult result = new CompareResult(idfPair, collPair, "Not On Server", " -- ", false, diffItems);
            result.setIsRemove(true);
            return result;
        }
        DiffItem diffItem = new DiffItem("Not In Design", " -- ", " -- ");
        diffItems.add(diffItem);
        return new CompareResult(idfPair, collPair, "Not In Design", " -- ", false, diffItems);
    }

    protected CompareResult isPkEquiv(IIdfPair idfPair, ICollPair collPair) {
        StringBuffer sb = new StringBuffer();
        PrimaryKey pkSrv = (PrimaryKey)idfPair.getSvrIdf();
        PrimaryKey pkDesign = (PrimaryKey)idfPair.getDesignIdf();
        this.compare(sb, "Key Columns", pkSrv.getColumnsCsv(), pkDesign.getColumnsCsv());
        return this.buildResult(idfPair, collPair, sb);
    }

    protected CompareResult isColumnEquiv(IIdfPair colPair, ICollPair collPair) {
        StringBuffer sb = new StringBuffer();
        Column colSrv = (Column)colPair.getSvrIdf();
        Column colDesign = (Column)colPair.getDesignIdf();
        this.compare(sb, "Name", colSrv.getName(), colDesign.getName());
        this.compare(sb, "Data Type", colSrv.getDataTypeDesc(), colDesign.getDataTypeDesc());
        this.compare(sb, "Length", colSrv.getLengthStr(), colDesign.getLengthStr());
        this.compare(sb, "Scale", colSrv.getScaleStr(), colDesign.getScaleStr());
        this.compare(sb, "Nulls", colSrv.getIsNullableDesc(), colDesign.getIsNullableDesc());
        this.compareAutoNumber(sb, colSrv, colDesign);
        this.compare(sb, "Is Array", colSrv.getIsArray(), colDesign.getIsArray());
        this.compareColDefault(sb, colSrv.getDefault(), colDesign.getDefault());
        this.compare(sb, "ENUM Values", colSrv.getEnumCsv(), colDesign.getEnumCsv());
        if (!this.getForForwardEngineer()) {
            this.compare(sb, "Comment", colSrv.getComment(), colDesign.getComment());
        }
        return this.buildResult(colPair, collPair, sb);
    }

    protected CompareResult isIndexEquiv(IIdfPair idfPair, ICollPair collPair) {
        StringBuffer sb = new StringBuffer();
        Index idxSrv = (Index)idfPair.getSvrIdf();
        Index idxDesign = (Index)idfPair.getDesignIdf();
        this.compare(sb, "Indexed Columns", idxSrv.getIndexColumnDdlTextsCSV(), idxDesign.getIndexColumnDdlTextsCSV());
        this.compare(sb, "Unique Flag", idxSrv.getUnique(), idxDesign.getUnique());
        this.compare(sb, "Full Text", idxSrv.getFullText(), idxDesign.getFullText());
        this.compare(sb, "Spatial", idxSrv.getSpatial(), idxDesign.getSpatial());
        if (this.supportsOptionTextRevEng()) {
            this.compare(sb, "Option Text", idxSrv.getOptionText(), idxDesign.getOptionText());
        }
        return this.buildResult(idfPair, collPair, sb);
    }

    private CompareResult isUcEquiv(IIdfPair idfPair, ICollPair collPair) {
        StringBuffer sb = new StringBuffer();
        UniqueConstraint ucSrv = (UniqueConstraint)idfPair.getSvrIdf();
        UniqueConstraint ucDesign = (UniqueConstraint)idfPair.getDesignIdf();
        this.compare(sb, "Unique Columns", ucSrv.getColumnsCsv(), ucDesign.getColumnsCsv());
        return this.buildResult(idfPair, collPair, sb);
    }

    protected CompareResult isTriggerEquiv(IIdfPair idfPair, ICollPair collPair) {
        StringBuffer sb = new StringBuffer();
        Trigger trgSrv = (Trigger)idfPair.getSvrIdf();
        Trigger trgDesign = (Trigger)idfPair.getDesignIdf();
        this.compare(sb, "On Delete", trgSrv.getFireOnDeleteFlag(), trgDesign.getFireOnDeleteFlag());
        this.compare(sb, "On Insert", trgSrv.getFireOnInsertFlag(), trgDesign.getFireOnInsertFlag());
        this.compare(sb, "On Update", trgSrv.getFireOnUpdateFlag(), trgDesign.getFireOnUpdateFlag());
        this.compare(sb, "SQL", trgSrv.getSql(), trgDesign.getSql());
        return this.buildResult(idfPair, collPair, sb);
    }

    protected CompareResult isFkEquiv(IIdfPair idfPair, ICollPair collPair) {
        StringBuffer sb = new StringBuffer();
        ForeignKey fkSrv = (ForeignKey)idfPair.getSvrIdf();
        ForeignKey fkDesign = (ForeignKey)idfPair.getDesignIdf();
        this.compare(sb, "Parent Table", fkSrv.getParTbl().getName(), fkDesign.getParTbl().getName());
        this.compare(sb, "Child Table", fkSrv.getChdTbl().getName(), fkDesign.getChdTbl().getName());
        this.compare(sb, "Parent Column(s)", fkSrv.getParentColumnsCsv(), fkDesign.getParentColumnsCsv());
        this.compare(sb, "Child Column(s)", fkSrv.getChildColumnsCsv(), fkDesign.getChildColumnsCsv());
        if (!this.config_.isSqlSvr2000() && !this.config_.isMsAccess()) {
            this.compare(sb, "Delete Action", fkSrv.getDeleteActionStr(), fkDesign.getDeleteActionStr());
            this.compare(sb, "Update Action", fkSrv.getUpdateActionStr(), fkDesign.getUpdateActionStr());
        }
        this.compare(sb, "Comment", fkSrv.getComment(), fkDesign.getComment());
        return this.buildResult(idfPair, collPair, sb);
    }

    protected CompareResult isTableEquiv(IIdfPair idfPair, ICollPair collPair) {
        StringBuffer sb = new StringBuffer();
        Table tblSrv = (Table)idfPair.getSvrIdf();
        Table tblDesign = (Table)idfPair.getDesignIdf();
        this.compare(sb, "Name", tblSrv.getName(), tblDesign.getName());
        this.compare(sb, "Table Options", this.getRefinedTableOptions(tblSrv.getTableOptions()), this.getRefinedTableOptions(tblDesign.getTableOptions()));
        if (!this.getForForwardEngineer()) {
            this.compare(sb, "Comment", tblSrv.getComment(), tblDesign.getComment());
        }
        return this.buildResult(idfPair, collPair, sb);
    }

    protected CompareResult isSchemaEquiv(IIdfPair idfPair, ICollPair collPair) {
        StringBuffer sb = new StringBuffer();
        Schema schSrv = (Schema)idfPair.getSvrIdf();
        Schema schDesign = (Schema)idfPair.getDesignIdf();
        if (!this.getForForwardEngineer()) {
            this.compare(sb, "Comment", schSrv.getComment(), schDesign.getComment());
        }
        return this.buildResult(idfPair, collPair, sb);
    }

    protected CompareResult isProcEquiv(IIdfPair idfPair, ICollPair collPair) {
        StringBuffer sb = new StringBuffer();
        Proc procSrv = (Proc)idfPair.getSvrIdf();
        Proc procDesign = (Proc)idfPair.getDesignIdf();
        if (!this.getForForwardEngineer()) {
            this.compare(sb, "Comment", procSrv.getComment(), procDesign.getComment());
        }
        this.compare(sb, "Source Code", procSrv.getSrc(), procDesign.getSrc());
        return this.buildResult(idfPair, collPair, sb);
    }

    protected CompareResult isViewEquiv(IIdfPair idfPair, ICollPair collPair) {
        StringBuffer sb = new StringBuffer();
        View vwSrv = (View)idfPair.getSvrIdf();
        View vwDesign = (View)idfPair.getDesignIdf();
        if (this.config_.isPsql()) {
            PsqlViewFormatter formatter = new PsqlViewFormatter(vwSrv);
            String textSrv = formatter.getFormattedSql();
            formatter.setView(vwDesign);
            String textDesign = formatter.getFormattedSql();
            this.compare(sb, "SQL", textSrv, textDesign);
        } else if (this.config_.isMySql()) {
            MySqlViewFormatter formatter = new MySqlViewFormatter();
            String textSrv = formatter.getFormattedSql(vwSrv.getSql());
            String textDesign = formatter.getFormattedSql(vwDesign.getSql());
            this.compare(sb, "SQL", textSrv, textDesign);
        } else {
            this.compare(sb, "SQL", vwSrv.getSql(), vwDesign.getSql());
        }
        return this.buildResult(idfPair, collPair, sb);
    }

    protected CompareResult isSequenceEquiv(IIdfPair idfPair, ICollPair collPair) {
        StringBuffer sb = new StringBuffer();
        Sequence seqSrv = (Sequence)idfPair.getSvrIdf();
        Sequence seqDesign = (Sequence)idfPair.getDesignIdf();
        this.compare(sb, "Increment", seqSrv.getIncrement(), seqDesign.getIncrement());
        if (!this.getForForwardEngineer()) {
            this.compare(sb, "Comment", seqSrv.getComment(), seqDesign.getComment());
        }
        return this.buildResult(idfPair, collPair, sb);
    }

    public void compare(StringBuffer sb, String prefix, boolean boolA, boolean boolB) {
        if (boolA != boolB) {
            this.addDiffStr(sb, prefix, Boolean.toString(boolA), Boolean.toString(boolB));
        }
    }

    public void compare(StringBuffer sb, String prefix, int intA, int intB) {
        if (intA != intB) {
            this.addDiffStr(sb, prefix, Integer.toString(intA), Integer.toString(intB));
        }
    }

    public void compare(StringBuffer sb, String prefix, String strA, String strB) {
        if (this.getSupportsMixedCase()) {
            if (!strA.equals(strB)) {
                this.addDiffStr(sb, prefix, strA, strB);
            }
        } else {
            String lcB;
            String lcA = strA.toLowerCase();
            if (!lcA.equals(lcB = strB.toLowerCase())) {
                this.addDiffStr(sb, prefix, lcA, lcB);
            }
        }
    }

    private void addDiffStr(StringBuffer sb, String prefix, String strA, String strB) {
        if (sb.length() > 0) {
            sb.append(" \n");
        }
        String formattedA = "<" + strA + ">";
        String formattedB = "<" + strB + ">";
        if (prefix.equals("Comment")) {
            formattedA = "'" + strA + "'";
            formattedB = "'" + strB + "'";
        }
        boolean hasCr = strA.indexOf("\n") > 0 || strB.indexOf("\n") > 0;
        String strNotEquals = hasCr ? "\n != \n" : " != ";
        DiffItem diffItem = new DiffItem(prefix, formattedA, formattedB);
        this.diffItems_.add(diffItem);
        String diffStr = prefix + ": " + formattedA + strNotEquals + formattedB;
        sb.append(diffStr);
    }

    public CompareResult buildResult(IIdfPair idfPair, ICollPair collPair, StringBuffer sbDetail) {
        String detail = sbDetail.toString();
        CompareResult result = detail.length() > 0 ? new CompareResult(idfPair, collPair, "Changed", detail, false, new ArrayList(this.diffItems_)) : new CompareResult(idfPair, collPair);
        this.diffItems_ = new ArrayList();
        return result;
    }

    private boolean supportsOptionTextRevEng() {
        return this.config_.isPsql() || this.config_.isMySql();
    }

    public void compareColDefault(StringBuffer sb, String svrDefault, String designDefault) {
        String designWithoutBackTick = designDefault.replaceFirst("`", "");
        String svrClean = svrDefault.replaceFirst("`", "");
        String svrWithBrackets = svrClean + "()";
        if (svrWithBrackets.equalsIgnoreCase(designWithoutBackTick)) {
            this.compare(sb, "Default", svrWithBrackets, designWithoutBackTick);
        } else {
            this.compare(sb, "Default", svrClean, designWithoutBackTick);
        }
    }

    private String getRefinedTableOptions(String tableOptions) {
        if (this.config_.isMySql()) {
            String replaced = tableOptions.replaceFirst("AUTO_INCREMENT=\\d+", "AUTO_INCREMENT=****");
            return replaced;
        }
        return tableOptions;
    }
}

