/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.script.builder.grouper;

import com.harrand.coreclasses.interfaces.IScript;
import com.harrand.coreclasses.interfaces.IStep;
import com.harrand.coreclasses.interfaces.implementation.BasicScript;
import com.harrand.dbwrench.db.auto.ctrl.DatabaseAutoAddEntitiesCtrl;
import com.harrand.dbwrench.db.auto.sequence.AutoSequenceGenerator;
import com.harrand.dbwrench.db.auto.sequence.AutonumberDefaultValueGenerator;
import com.harrand.dbwrench.jdbc.JdbcConfig;
import com.harrand.dbwrench.object.Column;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.Schema;
import com.harrand.dbwrench.object.Sequence;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrench.script.builder.SequenceScriptBldr;
import java.util.HashMap;

public final class AutoGeneratedSequenceGrouper {
    public static final String SCRIPT_NAME = "Autogenerated Sequences";
    private SequenceScriptBldr sequenceScriptBldr;

    public IScript getAutoGeneratedSequenceScript(Database db, JdbcConfig config) {
        this.sequenceScriptBldr = new SequenceScriptBldr(config);
        HashMap<Sequence, Table> sequenceTableMap = new HashMap<Sequence, Table>();
        BasicScript script = null;
        if (config.isPsql()) {
            for (Schema schema : db.getSchemas()) {
                for (Table table : schema.getTables()) {
                    Sequence autogeneratedSequence;
                    Column autoNumberColumn;
                    String defaultValue;
                    boolean isDefaultValueEmpty;
                    if (!table.hasAutoNumberColumn() || !(isDefaultValueEmpty = (defaultValue = (autoNumberColumn = table.getAutoNumberColumn()).getDefault()) == null || defaultValue.length() == 0)) continue;
                    if (script == null) {
                        script = this.createScript();
                    }
                    if ((autogeneratedSequence = this.getAutogeneratedSequence(table)) == null) continue;
                    sequenceTableMap.put(autogeneratedSequence, table);
                    script.add(this.getAddSequenceStep(autogeneratedSequence));
                }
            }
            DatabaseAutoAddEntitiesCtrl databaseAutoAddEntitiesCtrl = DatabaseAutoAddEntitiesCtrl.getInstance();
            databaseAutoAddEntitiesCtrl.setSequenceTableMap(sequenceTableMap);
        }
        return script;
    }

    private BasicScript createScript() {
        return new BasicScript(SCRIPT_NAME, SCRIPT_NAME);
    }

    public Sequence getAutogeneratedSequence(Table table) {
        return new AutoSequenceGenerator().getAutogeneratedSequence(table);
    }

    private String getNewDefaulValue(Sequence autogeneratedSequence) {
        AutonumberDefaultValueGenerator defaultValueGenerator = new AutonumberDefaultValueGenerator();
        return defaultValueGenerator.getNewDefaulValue(autogeneratedSequence);
    }

    private IStep getAddSequenceStep(Sequence autogeneratedSequence) {
        IStep step = this.sequenceScriptBldr.getStep(null, autogeneratedSequence);
        return step;
    }
}

