/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.script.builder;

import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.interfaces.IStep;
import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.coreclasses.interfaces.implementation.BasicScript;
import com.harrand.coreclasses.interfaces.implementation.BasicStep;
import com.harrand.coreclasses.option.IOptionMgr;
import com.harrand.coreclasses.script.IScriptBuilder;
import com.harrand.coregui.option.BasicOptionMgr;
import com.harrand.dbwrench.jdbc.JdbcConfig;
import com.harrand.dbwrench.object.Column;
import com.harrand.dbwrench.object.Schema;
import com.harrand.dbwrench.object.Sequence;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrench.object.Trigger;
import com.harrand.util.FileHelper;
import com.harrand.util.ResMgr;

public final class TriggerScriptBuilder
implements IScriptBuilder {
    private JdbcConfig config_;
    private Table table_;
    private Trigger oldTrigger_;
    private Trigger newTrigger_;
    private String newTriggerName_;
    private IOptionMgr forEngOptMgr_ = null;
    private String className_;
    private String displayName_;
    private String nameSuffix_;

    public TriggerScriptBuilder(Table table, JdbcConfig config) {
        this.table_ = table;
        this.config_ = config;
        this.className_ = Trigger.getClassName();
        this.displayName_ = this.table_.getDisplayName(this.className_);
    }

    @Override
    public void setForEngOptMgr(IOptionMgr optionMgr) {
        this.forEngOptMgr_ = optionMgr;
    }

    @Override
    public IStep getStep(Identifiable oldItem, Identifiable newItem) {
        this.oldTrigger_ = (Trigger)oldItem;
        this.newTrigger_ = (Trigger)newItem;
        if (this.newTrigger_ != null) {
            this.newTriggerName_ = this.newTrigger_.getName();
        }
        this.nameSuffix_ = this.table_.getDisplayName(this.className_) + ": " + this.newTriggerName_;
        return this.buildStepDisp();
    }

    private IStep buildStepDisp() {
        IStep step = null;
        if (!this.isScriptingOn()) {
            return null;
        }
        if (this.oldTrigger_ == null && this.newTrigger_ == null) {
            return null;
        }
        if (this.config_.supportsTrigger()) {
            if (this.oldTrigger_ == null) {
                step = this.getAddStep(this.newTrigger_);
            } else if (this.newTrigger_ == null) {
                step = this.getRemoveStep();
            } else if (this.needsUpdate(this.oldTrigger_, this.newTrigger_)) {
                step = this.getUpdateStep();
            }
        }
        return step;
    }

    @Override
    public boolean needsUpdate(Identifiable idfA, Identifiable idfB) {
        if (idfA == null && idfB == null) {
            return false;
        }
        if (idfA == null) {
            return true;
        }
        if (idfB == null) {
            return true;
        }
        String execTextA = StrHelper.cleanParameterizedInput((String)this.getAddStep((Trigger)idfA).getExecuteObject());
        String execTextB = StrHelper.cleanParameterizedInput((String)this.getAddStep((Trigger)idfB).getExecuteObject());
        if (this.config_.supportsMixedCase()) {
            return !execTextA.equals(execTextB);
        }
        return !execTextA.equalsIgnoreCase(execTextB);
    }

    private String getSimpleComment(Trigger trigger) {
        String name = trigger != null ? trigger.getName() : "NULL";
        return this.table_.getDisplayName(this.className_) + ": " + name;
    }

    private String getForEngNm(Identifiable idf) {
        return this.config_.getForEngNm(idf);
    }

    private IStep getAddStep(Trigger trigger) {
        String execText = this.getTriggerAddSql(this.config_.getDbms().getId(), trigger);
        BasicStep step = new BasicStep(ResMgr.getRes("add.label") + " " + this.getSimpleComment(trigger), execText);
        step.setLogEntry(ResMgr.getRes("added.label") + " " + this.nameSuffix_);
        return step;
    }

    private String getTriggerAddSql(int dbmsId, Trigger trigger) {
        String sql = "";
        switch (dbmsId) {
            case 3: {
                sql = this.getSqlSvrDdl(trigger, true);
                break;
            }
            case 1: {
                String bracketStr = trigger.getSql().indexOf(")") > 0 ? "" : "()";
                sql = "CREATE TRIGGER " + this.getForEngNm(trigger) + "\n\t" + trigger.getExecWhenStr() + " " + trigger.getFlagsAsOrString() + " ON " + this.getForEngNm(this.table_) + "\n\t" + trigger.getForEachStr() + " EXECUTE PROCEDURE " + trigger.getSql() + bracketStr;
                break;
            }
            case 4: {
                sql = this.getOracleDDL(trigger, true);
            }
        }
        return sql;
    }

    private IStep getRemoveStep() {
        String execText = "";
        switch (this.config_.getDbms().getId()) {
            case 3: {
                Schema schema = this.table_.getSchema();
                String trgNm = this.oldTrigger_.getName();
                String itemNm = schema.getDbSchemaCount() > 1 ? StrHelper.getDotNote(schema.getName(), trgNm) : trgNm;
                execText = "DROP TRIGGER " + itemNm;
                break;
            }
            case 1: {
                execText = "DROP TRIGGER " + this.getForEngNm(this.oldTrigger_) + " ON " + this.getForEngNm(this.table_);
                break;
            }
            case 4: {
                String schNm = this.oldTrigger_.getTable().getSchema().getName();
                execText = "DROP TRIGGER " + schNm + "." + this.oldTrigger_.getName();
            }
        }
        String oldName = this.oldTrigger_.getName();
        BasicStep step = new BasicStep(FileHelper.getRes("remove.label") + " " + oldName, execText);
        step.setLogEntry(ResMgr.getRes("dropped.label") + " " + this.displayName_ + ": " + oldName);
        return step;
    }

    private IStep getUpdateStep() {
        BasicScript script = new BasicScript(FileHelper.getResource("update.label") + this.nameSuffix_);
        script.add(this.getRemoveStep());
        script.add(this.getAddStep(this.newTrigger_));
        return script;
    }

    private String getSqlSvrDdl(Trigger trigger, boolean isAdd) {
        String createWord = isAdd ? "CREATE" : this.config_.getReplaceStr();
        String sql = createWord + " TRIGGER [" + trigger.getName() + "] ON " + this.getForEngNm(this.table_) + " FOR " + trigger.getFlagsCsv() + "\n\t AS " + trigger.getSql();
        sql = sql.replaceAll("  ", " ");
        return sql;
    }

    private String getOracleDDL(Trigger trigger, boolean isAdd) {
        return trigger.getSql();
    }

    public static String getOracleAutoNumberTrgSql(Table tbl, Column idCol, Sequence seq) {
        String tblNm = tbl.getName();
        String trgSql = "CREATE OR REPLACE TRIGGER " + tblNm + "_trg \n" + "BEFORE INSERT ON " + tblNm + " \n" + "FOR EACH ROW  \n" + "BEGIN  \n" + "SELECT " + seq.getName() + ".nextval \n" + "INTO :new." + idCol.getName() + " FROM dual;  \n" + "END;  \n";
        return trgSql;
    }

    private boolean isScriptingOn() {
        return BasicOptionMgr.getBoolValueSafe(this.forEngOptMgr_, "forward.engineer.triggers", true);
    }
}

