/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.script.builder;

import com.harrand.coreclasses.dataConversion.abstractions.IDataConversion;
import com.harrand.coreclasses.dataEntry.DataEntryResult;
import com.harrand.coreclasses.element.Version;
import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.interfaces.IScript;
import com.harrand.coreclasses.interfaces.IStep;
import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.coreclasses.interfaces.implementation.BasicScript;
import com.harrand.coreclasses.interfaces.implementation.BasicStep;
import com.harrand.coreclasses.option.IOptionMgr;
import com.harrand.coreclasses.script.IScriptBuilder;
import com.harrand.coreclasses.script.bldr.IdfStepsBldr;
import com.harrand.coreclasses.text.escape.IStrEscapeCtrl;
import com.harrand.coregui.option.BasicOptionMgr;
import com.harrand.dbwrench.dataConversion.DbDataConversion;
import com.harrand.dbwrench.jdbc.JdbcConfig;
import com.harrand.dbwrench.naming.DbwNameBldrSvr;
import com.harrand.dbwrench.naming.SequenceNameBldr;
import com.harrand.dbwrench.object.Column;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.Index;
import com.harrand.dbwrench.object.PrimaryKey;
import com.harrand.dbwrench.object.Schema;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrench.object.Trigger;
import com.harrand.dbwrench.object.table.constraint.UniqueConstraint;
import com.harrand.dbwrench.script.JdbcScriptCtrl;
import com.harrand.dbwrench.script.alterColumnCtrl.BasicAlterColumnCtrlFactory;
import com.harrand.dbwrench.script.alterColumnCtrl.IAlterColumnCtrl;
import com.harrand.dbwrench.script.alterColumnCtrl.PsqlAlterColumnCtrl;
import com.harrand.dbwrench.script.builder.ColumnScriptBuilder;
import com.harrand.dbwrench.script.builder.CommentScriptBldr;
import com.harrand.dbwrench.script.builder.IndexScriptBuilder;
import com.harrand.dbwrench.script.builder.PrimaryKeyScriptBuilder;
import com.harrand.dbwrench.script.builder.RenameScriptUtil;
import com.harrand.dbwrench.script.builder.SchemaScriptBldr;
import com.harrand.dbwrench.script.builder.ScriptUtil;
import com.harrand.dbwrench.script.builder.SequenceScriptBldr;
import com.harrand.dbwrench.script.builder.TriggerScriptBuilder;
import com.harrand.dbwrench.script.builder.table.UniqueConstaintScriptBldr;
import com.harrand.dbwrench.script.pair.ColumnPair;
import com.harrand.dbwrench.script.pair.SchemaPair;
import com.harrand.dbwrench.script.pair.TablePair;
import com.harrand.dbwrench.security.App;
import com.harrand.dbwrenchgui.db.SqlReservedWordGui;
import com.harrand.util.FileHelper;
import com.harrand.util.ResMgr;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class TableScriptBuilder
implements IScriptBuilder {
    private final JdbcConfig config_;
    private Database designDb_;
    private Database svrDb_;
    private Schema schNewTbl_;
    private Table oldTable_;
    private Table newTable_;
    private TablePair tablePair_;
    private int dbmsId_;
    private String newTableName_;
    private String className_;
    private String nameSuffix_;
    private IdfStepsBldr idxStepBldr;
    private IdfStepsBldr trgStepBldr;
    private IdfStepsBldr ucStepBldr;
    private IOptionMgr forEngOptMgr_ = null;
    private SchemaScriptBldr schemaScriptBldr_ = null;
    private ColumnScriptBuilder columnScriptBldr_ = null;
    private CommentScriptBldr commentBldr_;
    private SequenceScriptBldr seqScriptBldr_;
    private SequenceNameBldr seqNameBldr_;
    private RenameScriptUtil renameScriptUtil_ = new RenameScriptUtil();
    private boolean tblCaseSens_ = true;
    private boolean generalCaseSens_ = true;
    private boolean allowDrop_ = false;
    private boolean wasTransferred_ = false;
    public static final String TMP_SFX = "_old";
    public static final String DROP_OLD_TRAN_TBL_MSG = "Drop Old Transfer Table";
    public static final String INNODB_TYPE_STR = "TYPE=InnoDB";
    public static final String INNODB_ENGINE_STR = "ENGINE=InnoDB";

    public TableScriptBuilder(Database db, JdbcConfig config) {
        this.designDb_ = db;
        this.config_ = config;
        this.dbmsId_ = this.config_.getDbms().getId();
        this.className_ = Table.getClassName();
        this.tblCaseSens_ = this.config_.supportsMixedCaseTableName();
        this.generalCaseSens_ = this.config_.supportsMixedCase();
        this.commentBldr_ = new CommentScriptBldr(this.config_);
        this.schemaScriptBldr_ = new SchemaScriptBldr(this.designDb_, this.config_);
        this.seqScriptBldr_ = new SequenceScriptBldr(config);
        this.seqNameBldr_ = (SequenceNameBldr)DbwNameBldrSvr.instance().getNameBldr("SequenceNameBldr");
    }

    private void createStepBldrs() {
        String idxMapNm = Index.getClassName();
        this.idxStepBldr = new IdfStepsBldr(this.getScriptBuilder(idxMapNm), idxMapNm, this.generalCaseSens_);
        String trgMapNm = Trigger.getClassName();
        this.trgStepBldr = new IdfStepsBldr(this.getScriptBuilder(trgMapNm), trgMapNm, this.generalCaseSens_);
        String ucMapNm = UniqueConstraint.getClassName();
        this.ucStepBldr = new IdfStepsBldr(this.getScriptBuilder(ucMapNm), ucMapNm, this.generalCaseSens_);
    }

    public void setSvrDb(Database svrDb) {
        this.svrDb_ = svrDb;
    }

    public Database getSvrDb() {
        return this.svrDb_;
    }

    public void setSeqScriptBldr(SequenceScriptBldr seqScriptBldr) {
        this.seqScriptBldr_ = seqScriptBldr;
    }

    public SequenceScriptBldr getSeqBldr() {
        return this.seqScriptBldr_;
    }

    public void setAllowDrop(boolean allow) {
        this.allowDrop_ = allow;
    }

    public boolean getAllowDrop() {
        return this.allowDrop_;
    }

    public void setRenameScriptUtil(RenameScriptUtil renameScriptUtil) {
        this.renameScriptUtil_ = renameScriptUtil;
        this.schemaScriptBldr_.setRenamScriptUtil(this.renameScriptUtil_);
    }

    public void setTableWasTransferred(boolean wasTransferred) {
        this.wasTransferred_ = wasTransferred;
    }

    @Override
    public IStep getStep(Identifiable oldItem, Identifiable newItem) {
        this.setVars((Table)oldItem, (Table)newItem);
        return this.buildStepDisp();
    }

    public void clearAutoAddedSeqDotNotes() {
        if (this.seqScriptBldr_ != null) {
            this.seqScriptBldr_.clearAutoAddedSeqDotNotes();
        }
    }

    private void setVars(Table oldTbl, Table newTbl) {
        this.oldTable_ = oldTbl;
        this.newTable_ = newTbl;
        this.schNewTbl_ = this.newTable_ != null ? this.newTable_.getSchema() : null;
        this.newTableName_ = this.newTable_ != null ? this.newTable_.getName() : "";
        this.nameSuffix_ = " " + this.designDb_.getDisplayName(this.className_) + ": " + this.newTableName_;
        this.tablePair_ = new TablePair(this.oldTable_, this.newTable_);
        this.tablePair_.setWasTransferred(this.wasTransferred_);
    }

    private IStep buildStepDisp() {
        IStep step = null;
        if (this.oldTable_ == null && this.newTable_ == null) {
            return null;
        }
        if (this.oldTable_ == null) {
            step = this.getAddStep(this.newTable_);
        } else if (this.newTable_ == null) {
            step = this.getRemoveStep();
        } else if (this.tablePair_.getWasTransferred()) {
            step = this.getTransferStep();
        } else if (this.needsUpdate(this.oldTable_, this.newTable_)) {
            step = this.getRebuildOrUpdateStep();
        }
        return step;
    }

    private IStep getRebuildOrUpdateStep() {
        IStep step = null;
        ITestResult rebuildRequiredRslt = this.isRebuildRequired();
        step = rebuildRequiredRslt.getPassed() ? this.getRebuildStep(rebuildRequiredRslt) : this.getUpdateStep();
        return step;
    }

    @Override
    public void setForEngOptMgr(IOptionMgr optionMgr) {
        this.forEngOptMgr_ = optionMgr;
        this.seqScriptBldr_.setForEngOptMgr(this.forEngOptMgr_);
    }

    @Override
    public boolean needsUpdate(Identifiable idfA, Identifiable idfB) {
        boolean needsUpdate = false;
        if (idfA == null && idfB == null) {
            return false;
        }
        if (idfA == null) {
            return true;
        }
        if (idfB == null) {
            return true;
        }
        TableScriptBuilder internalBuilder = new TableScriptBuilder(this.designDb_, this.config_);
        IScript scriptA = (IScript)internalBuilder.getStep(null, (Table)idfA);
        IScript scriptB = (IScript)internalBuilder.getStep(null, (Table)idfB);
        JdbcScriptCtrl ctrl = new JdbcScriptCtrl();
        String execTextA = ctrl.asRunnableText(scriptA);
        String execTextB = ctrl.asRunnableText(scriptB);
        if (this.generalCaseSens_) {
            if (this.tblCaseSens_) {
                needsUpdate = !execTextA.equals(execTextB);
            } else {
                String nameA = idfA.getName();
                String nameB = idfB.getName();
                String nameALc = new String(nameA).toLowerCase();
                String nameBLc = new String(nameB).toLowerCase();
                execTextA = execTextA.replaceAll("TIMESTAMP NOT NULL", "TIMESTAMP NULL");
                execTextB = execTextB.replaceAll("TIMESTAMP NOT NULL", "TIMESTAMP NULL");
                needsUpdate = !(execTextA = execTextA.replaceAll(nameA, nameALc)).equals(execTextB = execTextB.replaceAll(nameB, nameBLc));
            }
        } else {
            needsUpdate = !execTextA.equalsIgnoreCase(execTextB);
        }
        return needsUpdate;
    }

    private String getSimpleComment(Table table) {
        String name = table != null ? table.getName() : "NULL";
        return this.designDb_.getDisplayName(this.className_) + ": " + name;
    }

    private String getForEngNm(Identifiable idf) {
        return this.config_.getForEngNm(idf);
    }

    private IStep getAddStep(Table table) {
        String comment = this.getSimpleComment(table);
        String name = ResMgr.getRes("add.label") + " Table: " + this.getForEngNm(table);
        BasicScript script = new BasicScript(name, StrHelper.getSectionString(name));
        ScriptUtil.addNotNullStep(script, this.getCreateAutoSequenceStep());
        ScriptUtil.addNotNullStep(script, this.getCreateStep());
        this.addItemsSteps(script, true);
        return script;
    }

    private IStep getRemoveStep() {
        BasicStep step;
        String oldSchNm = this.oldTable_.getSchema().getName();
        if (!this.designDb_.contains(Schema.getClassName(), oldSchNm)) {
            return null;
        }
        String tblNm = this.getForEngNm(this.oldTable_);
        String removeName = FileHelper.getRes("remove.label") + " " + App.getRes("table.label") + ": " + tblNm;
        if (this.allowDrop_) {
            step = new BasicStep(removeName, "DROP TABLE " + tblNm);
            step.setComment(StrHelper.getSectionString(removeName));
            step.setLogEntry(ResMgr.getRes("dropped.label") + " " + this.className_ + ": " + tblNm);
        } else {
            String comment = App.getRes("remove.table.not.allowed.msg");
            step = new BasicStep(removeName, "");
            step.setComment(comment);
            String logEntry = StrHelper.getEnclosedInSingleDash(step.getComment() + "\n" + ResMgr.getRes("drop.not.label") + App.getRes("table.label") + ": " + tblNm);
            step.setLogEntry(logEntry);
        }
        return step;
    }

    private String getCascadeStr() {
        String cascadeStr = this.dbmsId_ == 1 ? " CASCADE" : "";
        return cascadeStr;
    }

    private IStep getUpdateStep() {
        String nm = FileHelper.getResource("update.label") + this.nameSuffix_;
        String cmm = StrHelper.getSectionString(nm);
        BasicScript script = new BasicScript(nm, cmm);
        this.addItemsSteps(script, false);
        if (script.hasSubSteps()) {
            return script;
        }
        return null;
    }

    private IStep getRebuildStep(ITestResult rebuildRequireRslt) {
        String oldForEngSuffix = "Table: " + this.config_.getForEngNm(this.oldTable_);
        String rebuildLabel = FileHelper.getResource("rebuild.label") + " " + oldForEngSuffix;
        String rebuiltMsg = StrHelper.getSectionStringNoTermination(rebuildLabel) + "\nReasons:" + "\n" + rebuildRequireRslt.getDetail() + "\n*****************************************************************************/";
        BasicScript script = new BasicScript(rebuildLabel, rebuiltMsg);
        String basicTmpTblNm = this.chkEnquoteSimple(this.oldTable_.getName() + TMP_SFX);
        String tempTblSrcDotNote = this.getTempTblSrcDotNote();
        String tblForEngNm = this.escapeIfReserved(tempTblSrcDotNote);
        String tempTblForEngNm = this.chkEnquoteDotNote(tempTblSrcDotNote + TMP_SFX);
        ScriptUtil.addNotNullStep(script, this.getRenameStep(tblForEngNm, basicTmpTblNm));
        ScriptUtil.addNotNullStep(script, this.getCreateStep());
        List colPairs = this.renameScriptUtil_.getColumnPairs(this.newTable_, false);
        ScriptUtil.addNotNullStep(script, this.getRepopulateComplete(colPairs, tempTblForEngNm));
        ScriptUtil.addNotNullStep(script, this.getDropTempTableStep(tempTblForEngNm));
        this.addItemsSteps(script, true);
        return script;
    }

    private String chkEnquoteSimple(String str) {
        String retStr = str;
        if (this.isEnquoteOn(str)) {
            retStr = StrHelper.encloseDblQuotes(str);
        }
        return retStr;
    }

    private String chkEnquoteDotNote(String probDotNote) {
        String retStr = probDotNote;
        if (this.isEnquoteOn(probDotNote)) {
            retStr = probDotNote.indexOf(".") > 0 ? StrHelper.encloseDblQuotesDotNote(probDotNote) : StrHelper.encloseDblQuotes(probDotNote);
        }
        return retStr;
    }

    private boolean isEnquoteOn(String str) {
        return this.config_.getDbms().checkDblQuotePsqlNm(str);
    }

    private String getTempTblSrcDotNote() {
        String oldSchNm;
        String oldTblForEngNm = this.oldTable_.getName();
        String schNm = oldSchNm = this.oldTable_.getSchema().getName();
        if (this.config_.getUseSchemaPrefix(this.oldTable_.getSchema())) {
            if (this.getUseNewSchOldTblNm()) {
                String oldSchRename = null;
                Iterator itSch = this.renameScriptUtil_.getSchemaPairs(false).iterator();
                while (oldSchRename == null && itSch.hasNext()) {
                    SchemaPair schPair = (SchemaPair)itSch.next();
                    if (!schPair.getSvrSchema().getName().equalsIgnoreCase(oldSchNm)) continue;
                    oldSchRename = schPair.getDesignSchema().getName();
                }
                schNm = oldSchRename;
            }
            oldTblForEngNm = schNm + "." + this.oldTable_.getName();
        }
        return oldTblForEngNm;
    }

    private boolean getUseNewSchOldTblNm() {
        boolean shouldUse = false;
        Schema schOld = this.oldTable_.getSchema();
        if (this.config_.getUseSchemaPrefix(schOld)) {
            String oldSchNm = schOld.getName();
            boolean oldSchExists = this.designDb_.contains(schOld.getMapName(), oldSchNm);
            shouldUse = !oldSchExists;
        }
        return shouldUse;
    }

    public IStep getSql2000TransferStep(TablePair tblPair, List colPairs) {
        this.setTableWasTransferred(true);
        this.setVars(tblPair.getSvrTable(), tblPair.getDesignTable());
        String fromTblNm = this.oldTable_.getDotNote();
        String scriptNm = "Transfer Renamed Schema Table" + fromTblNm;
        BasicScript script = new BasicScript(scriptNm, scriptNm);
        this.addSqlSvrTransferSteps(script, colPairs, fromTblNm);
        return script;
    }

    private void addSqlSvrTransferSteps(IScript script, List colPairs, String fromTblNm) {
        ScriptUtil.addNotNullStep(script, this.getCreateStep());
        ScriptUtil.addNotNullStep(script, this.getRepopulateComplete(colPairs, fromTblNm));
        this.addItemsSteps(script, true);
        ScriptUtil.addNotNullStep(script, this.getDropOldTransferStep(fromTblNm));
    }

    private IStep getTransferStep() {
        String oldForEngSuffix = "Table: " + this.config_.getForEngNm(this.oldTable_);
        BasicScript script = null;
        List colPairs = this.renameScriptUtil_.getColumnPairs(this.newTable_, false);
        if (this.config_.isSqlSvr()) {
            script = new BasicScript("Transfer & Update " + oldForEngSuffix, "\n" + StrHelper.getSectionStringShort("Transfer & Update" + oldForEngSuffix));
            if (!this.config_.isSqlSvr2005() || this.isRebuildRequired().getPassed()) {
                String oldTblNm = this.getTempTblSrcDotNote();
                this.addSqlSvrTransferSteps(script, colPairs, oldTblNm);
            } else {
                ScriptUtil.addNotNullStep(script, this.schemaScriptBldr_.getTransferStep(this.tablePair_));
                ScriptUtil.addNotNullStep(script, this.getUpdateStep());
            }
        } else if (this.config_.isPsql()) {
            script = new BasicScript("Transfer " + oldForEngSuffix, "\n" + StrHelper.getSectionStringShort("Transfer " + oldForEngSuffix));
            String oldTblNm = this.chkEnquoteDotNote(this.getTempTblSrcDotNote());
            ScriptUtil.addNotNullStep(script, this.getCreateStep());
            ScriptUtil.addNotNullStep(script, this.getRepopulateComplete(colPairs, oldTblNm));
            this.addItemsSteps(script, true);
            ScriptUtil.addNotNullStep(script, this.getDropOldTransferStep(oldTblNm));
        } else {
            script = null;
        }
        return script;
    }

    private IStep getDropOldTransferStep(String oldTblForEngNm) {
        BasicStep step = new BasicStep("Drop Old Transfer Table " + oldTblForEngNm, "DROP TABLE " + oldTblForEngNm + this.getCascadeStr());
        step.setComment(step.getName());
        step.setLogEntry(step.getComment() + ": " + oldTblForEngNm);
        return step;
    }

    private IStep getCreateStep() {
        boolean columnRequired;
        boolean bl = columnRequired = this.dbmsId_ == 0 || this.dbmsId_ == 3;
        if (columnRequired && this.newTable_.size(Column.getClassName()) == 0) {
            return null;
        }
        String tblNm = this.getForEngNm(this.newTable_);
        String execText = "CREATE TABLE " + tblNm + "\n(\n" + this.getColumnDmoCsv(this.oldTable_, this.newTable_) + ")" + this.getTableOptsStr() + this.getInnoDbStr();
        BasicStep step = new BasicStep(App.getResource("table.build.structure.label"), execText);
        step.setLogEntry(ResMgr.getRes("added.label") + this.nameSuffix_);
        step.setComment(App.getRes("table.build.structure.label"));
        return step;
    }

    private String getTableOptsStr() {
        String opts = this.newTable_.getTableOptions();
        StringBuffer sb = new StringBuffer();
        if (opts.length() > 0) {
            if (!opts.substring(0, 1).equals(" ")) {
                sb.append(" ");
            }
            sb.append(opts);
        }
        return sb.toString();
    }

    private String getInnoDbStr() {
        String newOpts;
        String innoStr = "";
        if (this.dbmsId_ == 0 && this.isFkScriptingEnabled() && this.newTable_.getUsedInFk() && (newOpts = this.newTable_.getTableOptions().toLowerCase()).indexOf("innodb") < 0 && newOpts.indexOf("type") < 0 && newOpts.indexOf("engine") < 0) {
            innoStr = " " + this.getInnoEngineNm();
        }
        return innoStr;
    }

    private String getInnoEngineNm() {
        String nm = INNODB_TYPE_STR;
        Version version = this.config_.getVersion();
        if (version != null && version.getLevel1() > 4) {
            nm = INNODB_ENGINE_STR;
        }
        return nm;
    }

    private String getColumnDmoCsv(Table oldTable, Table newTable) {
        String dmoText = "";
        String className = Column.getClassName();
        ColumnScriptBuilder columnBuilder = this.getColumnScriptBldr(newTable);
        Object[] array = newTable.values(className).toArray();
        for (int i = 0; i < array.length; ++i) {
            boolean oldTableHasColumn;
            Column newColumn = (Column)array[i];
            Column oldColumn = null;
            String newColumnName = newColumn.getName();
            if (oldTable != null && (oldTableHasColumn = oldTable.getKeys(className).contains(newColumnName))) {
                oldColumn = oldTable.getColumn(newColumnName);
            }
            String comma = i < array.length - 1 ? "," : "";
            dmoText = dmoText + "\t" + columnBuilder.getDmoEmbedded(oldColumn, newColumn) + comma + "\n";
        }
        return dmoText;
    }

    private void addItemsSteps(IScript script, boolean tableRebuilt) {
        this.createStepBldrs();
        boolean supportsTrgs = this.config_.supportsTrigger();
        this.idxStepBldr.refreshSteps(this.oldTable_, this.newTable_, tableRebuilt);
        this.trgStepBldr.refreshSteps(this.oldTable_, this.newTable_, tableRebuilt);
        this.ucStepBldr.refreshSteps(this.oldTable_, this.newTable_, tableRebuilt);
        script.addAll(this.ucStepBldr.getRemoveSteps());
        script.addAll(this.idxStepBldr.getRemoveSteps());
        if (supportsTrgs) {
            script.addAll(this.trgStepBldr.getRemoveSteps());
        }
        Map pkMap = this.getPkSteps(tableRebuilt);
        ScriptUtil.addNotNullStep(script, (IStep)pkMap.get("Remove Script"));
        if (!tableRebuilt) {
            ScriptUtil.addNotNullStep(script, this.getRenameTableStep());
            script.addAll(this.getAlterColumnSteps());
        }
        ScriptUtil.addNotNullStep(script, (IStep)pkMap.get("Add Script"));
        script.addAll(this.getCmmSteps(tableRebuilt));
        script.addAll(this.ucStepBldr.getAddSteps());
        script.addAll(this.idxStepBldr.getAddSteps());
        if (supportsTrgs) {
            script.addAll(this.trgStepBldr.getAddSteps());
        }
    }

    private IStep getCreateAutoSequenceStep() {
        IStep step = null;
        return step;
    }

    private List<IStep> getCmmSteps(boolean tableRebuilt) {
        Table oldTableLocal = tableRebuilt ? null : this.oldTable_;
        List<IStep> steps = this.commentBldr_.getSteps(oldTableLocal, this.newTable_);
        ScriptUtil.addCmmToFirst(steps, "Add Comments");
        return steps;
    }

    private Map getPkSteps(boolean tableRebuilt) {
        PrimaryKeyScriptBuilder pkBuilder = new PrimaryKeyScriptBuilder(this.newTable_, this.config_);
        PrimaryKey newPk = this.newTable_.getPrimaryKey();
        Map<String, IStep> map = new HashMap<String, IStep>();
        if (tableRebuilt) {
            IStep step = pkBuilder.getStep(null, newPk);
            map.put("Add Script", step);
        } else {
            if (this.dbmsId_ == 2) {
                return new HashMap();
            }
            map = this.dbmsId_ == 0 ? pkBuilder.getPkAutoNumberSteps(this.oldTable_, this.newTable_) : pkBuilder.getUpdateSteps(this.oldTable_, this.newTable_);
        }
        return map;
    }

    private IStep getRenameTableStep() {
        IStep step = null;
        TablePair pair = this.renameScriptUtil_.getTablePair(this.newTable_.getSchema(), this.newTable_.getName());
        if (pair.getWasRenamed(this.tblCaseSens_)) {
            String newName = this.chkEnquoteSimple(pair.getDesignTable().getName());
            String oldForEngNm = this.chkEnquoteDotNote(this.getTempTblSrcDotNote());
            if (pair.getWasTransferred()) {
                String oldDotNote = this.schNewTbl_.getName() + "." + this.oldTable_.getName();
                oldForEngNm = this.chkEnquoteDotNote(oldDotNote);
            }
            step = this.getRenameStep(oldForEngNm, newName);
        }
        return step;
    }

    private IStep getRenameStep(String oldForEngNm, String newName) {
        IStep step;
        if (this.dbmsId_ != 2) {
            String execText = this.config_.getDbms().getRenameTableSql(oldForEngNm, newName);
            step = new BasicStep(FileHelper.getResource("rename.label"), execText);
            step.setComment(ResMgr.getRes("rename.label") + ": " + oldForEngNm);
            step.setLogEntry(step.getComment() + " " + ResMgr.getRes("to") + " " + newName);
        } else {
            step = this.getAccessRenameStep(oldForEngNm, newName);
        }
        return step;
    }

    private List<IStep> getAlterColumnSteps() {
        ArrayList<IStep> steps = new ArrayList<IStep>();
        IScriptBuilder columnScriptBuilder = this.getScriptBuilder(Column.getClassName());
        IAlterColumnCtrl alterColumnCtrl = BasicAlterColumnCtrlFactory.instance().getCtrl(this.config_, this.designDb_, this.svrDb_);
        if (alterColumnCtrl instanceof PsqlAlterColumnCtrl) {
            ((PsqlAlterColumnCtrl)alterColumnCtrl).setSeqScriptBldr(this.seqScriptBldr_);
        }
        List pairs = this.renameScriptUtil_.getColumnPairs(this.newTable_, true);
        for (ColumnPair pair : pairs) {
            Column colOld = pair.getSvrColumn();
            Column colNew = pair.getDesignColumn();
            if (colOld != null && colNew != null) {
                ITestResult alterableResult;
                boolean needsUpdate = columnScriptBuilder.needsUpdate(colOld, colNew);
                if (!needsUpdate || !(alterableResult = alterColumnCtrl.canAlterColumn(this.oldTable_, this.newTable_, colOld, colNew)).getPassed()) continue;
                String newNm = colNew.getName();
                String alterDmo = alterColumnCtrl.getAlterColumnDmo(this.newTable_, colOld, colNew);
                BasicStep alterStep = new BasicStep("Alter: " + newNm, alterDmo);
                steps.add(alterStep);
                continue;
            }
            IStep addRemoveStep = columnScriptBuilder.getStep(colOld, colNew);
            steps.add(addRemoveStep);
        }
        return steps;
    }

    private IStep getAccessRenameStep(String oldNm, String newNm) {
        BasicScript script = new BasicScript(FileHelper.getResource("rename.label"), FileHelper.getResource("rename.label"));
        BasicStep copyStep = new BasicStep(App.getResource("table.copy.label"), "SELECT * INTO " + newNm + " FROM " + oldNm);
        copyStep.setLogEntry(App.getRes("table.repopulate.label"));
        BasicStep dropStep = new BasicStep(App.getResource("remove.table.temp.label"), "DROP TABLE " + oldNm);
        dropStep.setLogEntry(dropStep.getName());
        script.add(copyStep);
        script.add(dropStep);
        return script;
    }

    private IStep getDropTempTableStep(String tempTblnm) {
        BasicStep step = new BasicStep(App.getResource("remove.table.temp.label"), "DROP TABLE " + tempTblnm + this.getCascadeStr());
        step.setComment(step.getName());
        step.setLogEntry(step.getComment() + ": " + tempTblnm);
        return step;
    }

    private IStep getRepopulateComplete(List colPairs, String fromTblNm) {
        if (this.dbmsId_ == 3 && this.newTable_.hasAutoNumberColumn()) {
            BasicScript script = new BasicScript(App.getRes("table.repopulate.label"), "");
            script.add(this.getRepopulateStep(colPairs, fromTblNm));
            return script;
        }
        return this.getRepopulateStep(colPairs, fromTblNm);
    }

    private IStep getRepopulateStep(List colPairs, String fromTblNm) {
        boolean enableIdInsert;
        Column oldAutoNumberCol = null;
        StringBuffer insertSb = new StringBuffer(89);
        StringBuffer selectSb = new StringBuffer(89);
        String tblNm = this.getForEngNm(this.newTable_);
        boolean bl = enableIdInsert = this.newTable_.hasAutoNumberColumn() && this.config_.isSqlSvr();
        if (enableIdInsert) {
            insertSb.append("SET IDENTITY_INSERT " + tblNm + " ON;\n");
        }
        insertSb.append("INSERT INTO " + tblNm + "\n\t (");
        selectSb.append("SELECT ");
        StringBuffer selectColSb = new StringBuffer(89);
        StringBuffer insertColSb = new StringBuffer(89);
        for (ColumnPair pair : colPairs) {
            Column oldCol = pair.getSvrColumn();
            Column newCol = pair.getDesignColumn();
            if (oldCol.getAutoNumber()) {
                oldAutoNumberCol = oldCol;
            }
            String formmattedOld = this.config_.getFormattedName(oldCol.getName());
            selectColSb.append(StrHelper.checkComma(selectColSb.toString()));
            selectColSb.append(formmattedOld);
            String formmattedNew = this.config_.getFormattedName(newCol.getName());
            insertColSb.append(StrHelper.checkComma(insertColSb.toString()));
            insertColSb.append(formmattedNew);
        }
        insertSb.append(insertColSb.toString());
        selectSb.append(selectColSb.toString());
        String selectStr = selectSb.toString();
        for (IDataConversion conversion : this.designDb_.values(DbDataConversion.getClassName())) {
            String collectorName = conversion.getCollector().getName();
            if (!collectorName.equals(this.newTableName_)) continue;
            String converteeName = conversion.getConvertedObject().getName();
            String conversionValue = conversion.getConversionValue().toString();
            Pattern p = Pattern.compile(converteeName);
            Matcher m = p.matcher(selectStr);
            selectStr = m.replaceAll(conversionValue);
        }
        insertSb.append(")\n");
        selectStr = selectStr + "\nFROM " + fromTblNm;
        if (oldAutoNumberCol != null) {
            selectStr = selectStr + "\nORDER BY " + this.config_.getFormattedName(oldAutoNumberCol.getName());
        }
        String execText = insertSb.toString() + selectStr;
        if (enableIdInsert) {
            execText = execText + ";\nSET IDENTITY_INSERT " + tblNm + " OFF";
        }
        BasicStep step = new BasicStep(App.getResource("table.repopulate.label"), execText);
        step.setComment(App.getRes("table.repopulate.label"));
        step.setLogEntry(step.getComment());
        return step;
    }

    private ITestResult isRebuildRequired() {
        DataEntryResult notRequiredRslt = new DataEntryResult(false);
        if (this.oldTable_ == null || this.newTable_ == null) {
            return notRequiredRslt;
        }
        ITestResult mySqlInnoRslt = this.mySqlInnoChanged();
        if (mySqlInnoRslt.getPassed()) {
            return mySqlInnoRslt;
        }
        IAlterColumnCtrl alterColumnCtrl = BasicAlterColumnCtrlFactory.instance().getCtrl(this.config_, this.designDb_, this.svrDb_);
        IScriptBuilder columnScriptBuilder = this.getScriptBuilder(Column.getClassName());
        List pairs = this.renameScriptUtil_.getColumnPairs(this.newTable_, false);
        boolean repopulateFlag = false;
        StringBuilder noAlterAllowedSb = new StringBuilder();
        for (ColumnPair pair : pairs) {
            ITestResult alterableResult;
            Column newCol;
            Column oldCol = pair.getSvrColumn();
            boolean needsUpdate = columnScriptBuilder.needsUpdate(oldCol, newCol = pair.getDesignColumn());
            if (!needsUpdate || (alterableResult = alterColumnCtrl.canAlterColumn(this.oldTable_, this.newTable_, oldCol, newCol)).getPassed()) continue;
            if (!noAlterAllowedSb.toString().isEmpty()) {
                noAlterAllowedSb.append("\n");
            }
            noAlterAllowedSb.append(alterableResult.getDetail());
            repopulateFlag = true;
        }
        return new DataEntryResult(repopulateFlag, "Alter Column Check Title", noAlterAllowedSb.toString());
    }

    private ITestResult mySqlInnoChanged() {
        if (this.config_.getDbmsId() == 0 && this.isFkScriptingEnabled()) {
            String tableOptsLc;
            boolean fkUsedOld = this.oldTable_.getUsedInFk();
            boolean fkUsedNew = this.newTable_.getUsedInFk();
            if (!fkUsedOld && fkUsedNew && (tableOptsLc = this.oldTable_.getTableOptions().toLowerCase()).indexOf("innodb") < 0) {
                return new DataEntryResult(true, "Table Rebuilt Required", "MySQL InnoDb foreign key changed.");
            }
        }
        return new DataEntryResult(false);
    }

    private IScriptBuilder getScriptBuilder(String mapName) {
        if (mapName.equals(Index.getClassName())) {
            IndexScriptBuilder bldr = new IndexScriptBuilder(this.newTable_, this.config_);
            bldr.setForEngOptMgr(this.forEngOptMgr_);
            bldr.setRenameScriptUtil(this.renameScriptUtil_);
            return bldr;
        }
        if (mapName.equals(Column.getClassName())) {
            return this.getColumnScriptBldr(this.newTable_);
        }
        if (mapName.equals(Trigger.getClassName())) {
            TriggerScriptBuilder bldr = new TriggerScriptBuilder(this.newTable_, this.config_);
            bldr.setForEngOptMgr(this.forEngOptMgr_);
            return bldr;
        }
        if (mapName.equals(UniqueConstraint.getClassName())) {
            return this.getUniqueConstraintScriptBldr(this.newTable_);
        }
        StrHelper.throwProgrammingException("TableScriptBuilder.getScriptBuild passed unsupported classname of: " + mapName);
        return null;
    }

    private ColumnScriptBuilder getColumnScriptBldr(Table table) {
        if (this.columnScriptBldr_ != null) {
            this.columnScriptBldr_.setTable(table);
        } else {
            this.columnScriptBldr_ = new ColumnScriptBuilder(table, this.config_);
        }
        return this.columnScriptBldr_;
    }

    private IScriptBuilder getUniqueConstraintScriptBldr(Table newTbl) {
        UniqueConstaintScriptBldr bldr = new UniqueConstaintScriptBldr(newTbl, this.config_);
        bldr.setForEngOptMgr(this.forEngOptMgr_);
        return bldr;
    }

    public IScript getRemoveManyScript(Collection tables, Schema schema) {
        String comment = FileHelper.getRes("remove.label") + " " + this.designDb_.getDisplayPlural(Table.getClassName()) + " in Schema: " + schema.getName();
        BasicScript script = new BasicScript(comment + " - " + schema.getName(), comment);
        for (Table table : tables) {
            IStep step = this.getStep(table, null);
            ScriptUtil.addNotNullStep(script, step);
        }
        if (script.hasSubSteps()) {
            return script;
        }
        return null;
    }

    private boolean isFkScriptingEnabled() {
        return BasicOptionMgr.getBoolValueSafe(this.forEngOptMgr_, "forward.engineer.foreignKeys", true);
    }

    private String escapeIfReserved(String nmIn) {
        SqlReservedWordGui sqlReserveds;
        String nmOut = nmIn;
        IStrEscapeCtrl escapeCtrl = this.config_.getDbms().getStrEscapeCtrl();
        if (escapeCtrl != null && (sqlReserveds = SqlReservedWordGui.instance()).isReserved(nmIn)) {
            nmOut = escapeCtrl.escapeStr(nmIn);
        }
        return nmOut;
    }
}

