/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.script.builder;

import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.interfaces.IScript;
import com.harrand.coreclasses.interfaces.IStep;
import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.coreclasses.interfaces.implementation.BasicScript;
import com.harrand.coreclasses.interfaces.implementation.BasicStep;
import com.harrand.coreclasses.option.IOptionMgr;
import com.harrand.coreclasses.script.IScriptBuilder;
import com.harrand.coregui.option.BasicOptionMgr;
import com.harrand.dbwrench.db.name.DbDisplayNmSvr;
import com.harrand.dbwrench.jdbc.JdbcConfig;
import com.harrand.dbwrench.naming.DbwNameBldrSvr;
import com.harrand.dbwrench.naming.SequenceNameBldr;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.Schema;
import com.harrand.dbwrench.object.Sequence;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrench.script.builder.CommentScriptBldr;
import com.harrand.dbwrench.script.builder.ScriptUtil;
import com.harrand.util.FileHelper;
import com.harrand.util.ResMgr;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;

public final class SequenceScriptBldr
implements IScriptBuilder {
    private DbDisplayNmSvr nmSvr = new DbDisplayNmSvr();
    private JdbcConfig config_;
    private CommentScriptBldr commentBldr_;
    private IOptionMgr forEngOptMgr_ = null;
    private Sequence oldSequence_;
    private Sequence newSequence_;
    private SequenceNameBldr seqNameBldr_;
    private List autoAddedSeqDotNotesLc_ = new ArrayList();
    private String newSequenceName_;
    private String className_;
    private String displayName_;
    private String nameSuffix_;

    public SequenceScriptBldr(JdbcConfig config) {
        this.config_ = config;
        this.commentBldr_ = new CommentScriptBldr(this.config_);
        this.className_ = Sequence.getClassName();
        this.displayName_ = this.nmSvr.getDisplayName(this.className_);
        this.seqNameBldr_ = (SequenceNameBldr)DbwNameBldrSvr.instance().getNameBldr("SequenceNameBldr");
    }

    @Override
    public void setForEngOptMgr(IOptionMgr optionMgr) {
        this.forEngOptMgr_ = optionMgr;
    }

    @Override
    public IStep getStep(Identifiable oldItem, Identifiable newItem) {
        if (!this.config_.supportsSequences()) {
            return null;
        }
        this.initObjs(oldItem, newItem);
        return this.buildStepDisp();
    }

    @Override
    public boolean needsUpdate(Identifiable idfA, Identifiable idfB) {
        if (!this.config_.supportsSequences()) {
            return false;
        }
        if (idfA == null && idfB == null) {
            return false;
        }
        if (idfA == null) {
            return true;
        }
        if (idfB == null) {
            return true;
        }
        this.initObjs(idfA, idfB);
        IStep updStep = this.getUpdateStep();
        return updStep != null;
    }

    private IStep buildStepDisp() {
        IStep step = null;
        if (!this.isScriptingEnabled()) {
            return null;
        }
        if (this.oldSequence_ == null && this.newSequence_ == null) {
            return null;
        }
        if (this.oldSequence_ == null) {
            step = this.getAddStep(this.newSequence_);
        } else if (this.newSequence_ == null) {
            step = this.getRemoveStep();
        } else if (this.needsUpdate(this.oldSequence_, this.newSequence_)) {
            step = this.getUpdateStep();
        }
        return step;
    }

    public JdbcConfig getConfig() {
        return this.config_;
    }

    private String getSimpleComment(Sequence seq) {
        String name = seq != null ? this.getForEngNm(seq) : "NULL";
        return this.displayName_ + ": " + name;
    }

    private String getForEngNm(Sequence seq) {
        String forEngSeqNm = this.config_.getForEngNm(seq);
        forEngSeqNm = StrHelper.removeDblQuoteDup(forEngSeqNm);
        return forEngSeqNm;
    }

    private IStep getAddStep(Sequence seq) {
        String cmdNm = ResMgr.getRes("add.label") + "  " + this.getSimpleComment(seq);
        IStep cmmStep = this.getCommentStep();
        IStep createStep = this.getCreateStep(seq);
        return ScriptUtil.getAsScriptIfNeeded(createStep, cmmStep, cmdNm);
    }

    private IStep getCreateStep(Sequence seq) {
        String startStr = this.getStartString(seq);
        String execText = "CREATE SEQUENCE " + this.getForEngNm(seq) + " INCREMENT BY " + seq.getIncrement() + startStr;
        BasicStep seqStep = new BasicStep(ResMgr.getRes("add.label") + " " + this.getSimpleComment(seq), execText);
        seqStep.setLogEntry(ResMgr.getRes("added.label") + " " + this.nameSuffix_);
        return seqStep;
    }

    public IStep getRemoveStep() {
        String oldName = this.getForEngNm(this.oldSequence_);
        String execText = "DROP SEQUENCE " + oldName;
        BasicStep step = new BasicStep(ResMgr.getRes("remove.label") + " " + oldName, execText);
        step.setLogEntry(ResMgr.getRes("dropped.label") + " " + this.displayName_ + ": " + this.nameSuffix_);
        return step;
    }

    private IStep getUpdateStep() {
        return this.getCommentStep();
    }

    private IStep getCommentStep() {
        return this.commentBldr_.getStep(this.oldSequence_, this.newSequence_, null);
    }

    public IScript getRemoveManyScript(Collection seqs, Schema schema) {
        if (!this.config_.supportsSequences()) {
            return null;
        }
        String comment = FileHelper.getRes("remove.label") + " " + this.nmSvr.getDisplayPlural(this.className_) + " in Schema: " + schema.getName();
        BasicScript script = new BasicScript(comment + " - " + schema.getName(), comment);
        for (Sequence sequence : seqs) {
            this.initObjs(sequence, null);
            IStep step = this.getRemoveStep();
            ScriptUtil.addNotNullStep(script, step);
        }
        if (script.hasSubSteps()) {
            return script;
        }
        return null;
    }

    private void initObjs(Identifiable oldItem, Identifiable newItem) {
        this.oldSequence_ = (Sequence)oldItem;
        this.newSequence_ = (Sequence)newItem;
        this.newSequenceName_ = this.newSequence_ != null ? this.newSequence_.getName() : "";
        this.nameSuffix_ = this.displayName_ + ": " + this.newSequenceName_;
    }

    private boolean isScriptingEnabled() {
        return BasicOptionMgr.getBoolValueSafe(this.forEngOptMgr_, "forward.engineer.sequences", true);
    }

    public boolean getTblSeqExistsOnSvr(Database svrDb, Table newTbl) {
        String parsedSeqNm = newTbl.getParsedSequenceNm();
        Schema schDesign = newTbl.getSchema();
        String schNm = schDesign.getName();
        String seqName = this.seqNameBldr_.getFormedName(newTbl);
        boolean seqExists = false;
        if (parsedSeqNm != null) {
            if (parsedSeqNm.indexOf(".") >= 0) {
                String[] parts = parsedSeqNm.split("\\.");
                schNm = parts[0];
                if (svrDb.contains(Schema.getClassName(), schNm)) {
                    schDesign = svrDb.getSchema(schNm);
                    seqName = parts[1];
                }
            } else {
                seqName = parsedSeqNm;
            }
        }
        if (svrDb.contains(Schema.getClassName(), schNm)) {
            Schema schSvr = svrDb.getSchema(schNm);
            seqExists = schSvr.contains(Sequence.getClassName(), seqName);
        }
        return seqExists;
    }

    public void addSeqStepsDisp(IScript script, Schema schOld, Schema schNew) {
        boolean caseSens = this.config_.supportsMixedCase();
        List newNames = StrHelper.checkLowerCaseSet(caseSens, schNew.getKeys(this.className_));
        ArrayList oldNames = schOld != null ? StrHelper.checkLowerCaseSet(caseSens, schOld.getKeys(this.className_)) : new ArrayList();
        TreeSet allNames = new TreeSet(oldNames);
        allNames.addAll(newNames);
        for (String name : allNames) {
            IStep subStep;
            boolean isNewSeq;
            Identifiable oldIdf = oldNames.contains(name) ? schOld.get(this.className_, name) : null;
            Identifiable newIdf = newNames.contains(name) ? schNew.get(this.className_, name) : null;
            boolean alreadyScripted = false;
            boolean bl = isNewSeq = oldIdf == null && newIdf != null;
            if (isNewSeq) {
                alreadyScripted = this.getSeqAlreadyScripted((Sequence)newIdf);
            }
            if (alreadyScripted || (subStep = this.getStep(oldIdf, newIdf)) == null) continue;
            script.add(subStep);
        }
    }

    public boolean getSeqAlreadyScripted(Sequence seq) {
        boolean alreadyScripted = false;
        String dotNote = seq.getDotNote();
        String seqDotNoteLc = dotNote.toLowerCase();
        if (this.autoAddedSeqDotNotesLc_.contains(seqDotNoteLc)) {
            alreadyScripted = true;
        }
        return alreadyScripted;
    }

    public void addAutoCreatedSeqDotNote(String dotNoteLc) {
        this.autoAddedSeqDotNotesLc_.add(dotNoteLc);
    }

    public void clearAutoAddedSeqDotNotes() {
        this.autoAddedSeqDotNotesLc_.clear();
    }

    private String getStartString(Sequence seq) {
        Long start = seq.getStart();
        if (start != null) {
            return " START " + start;
        }
        return "";
    }
}

