/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.script.builder;

import com.harrand.coreclasses.element.IIdfPair;
import com.harrand.coreclasses.element.StringPair;
import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.coreclasses.rename.Rename;
import com.harrand.coreclasses.rename.RenameContext;
import com.harrand.coreclasses.rename.RenameMgr;
import com.harrand.dbwrench.jdbc.JdbcConfig;
import com.harrand.dbwrench.object.Column;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.Schema;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrench.object.transfer.SchemaTransferHistory;
import com.harrand.dbwrench.script.pair.ColumnPair;
import com.harrand.dbwrench.script.pair.SchemaPair;
import com.harrand.dbwrench.script.pair.TablePair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class RenameScriptUtil {
    private RenameMgr renameMgr_;
    private List schPairs_ = new ArrayList();
    private JdbcConfig cnfg_;
    private Map tblPairsMap_ = null;
    private Map colPairsMap_ = new HashMap();
    private Database oldDb_ = null;
    private Database newDb_ = null;
    private boolean tblCaseSens_ = true;
    private boolean schCaseSens_ = true;
    private boolean colCaseSens_ = true;
    private String schClz_ = Schema.getClassName();
    private String tblClz_ = Table.getClassName();
    private String colClz_ = Column.getClassName();

    public void refreshMatches(Database oldDb, Database newDb, JdbcConfig config) {
        this.oldDb_ = oldDb;
        this.newDb_ = newDb;
        this.renameMgr_ = this.newDb_.getRenameMgr();
        this.schCaseSens_ = false;
        this.cnfg_ = config;
        this.tblCaseSens_ = this.cnfg_.supportsMixedCaseTableName();
        this.colCaseSens_ = this.cnfg_.supportsMixedCase();
        this.refreshMatchesDisp();
    }

    private void refreshMatchesDisp() {
        this.refreshSchemaMatches();
        if (this.cnfg_.supportsSchemas()) {
            this.refreshTableMatches();
        } else {
            this.refreshTableMatchesSimple();
        }
        this.refreshColumnMatches();
    }

    private void refreshSchemaMatches() {
        this.schPairs_ = new ArrayList();
        List oldSchNms = StrHelper.checkLowerCaseSet(this.schCaseSens_, this.oldDb_.getKeys(this.schClz_));
        List newSchNms = StrHelper.checkLowerCaseSet(this.schCaseSens_, this.newDb_.getKeys(this.schClz_));
        ArrayList<String> usedOldNms = new ArrayList<String>();
        ArrayList<String> usedNewNms = new ArrayList<String>();
        ArrayList commonSchNms = new ArrayList(oldSchNms);
        commonSchNms.retainAll(newSchNms);
        for (String schNm : commonSchNms) {
            this.schPairs_.add(new SchemaPair(this.oldDb_.getSchema(schNm), this.newDb_.getSchema(schNm)));
            usedOldNms.add(schNm);
            usedNewNms.add(schNm);
        }
        RenameContext schCtx = new RenameContext(this.schClz_, this.newDb_.getName(), this.newDb_.getMapName(), null, null);
        List schRenames = this.renameMgr_.getRenameMatches(schCtx, oldSchNms, newSchNms, this.schCaseSens_);
        for (Rename schRename : schRenames) {
            this.schPairs_.add(new SchemaPair(this.oldDb_.getSchema(schRename.getOldName()), this.newDb_.getSchema(schRename.getNewName())));
            usedOldNms.add(schRename.getOldName());
            usedNewNms.add(schRename.getNewName());
        }
        List unusedNmPairs = this.getUnusedNmPairs(oldSchNms, newSchNms, usedOldNms, usedNewNms, this.schCaseSens_);
        for (StringPair strPair : unusedNmPairs) {
            String oldNm = strPair.getStrA();
            String newNm = strPair.getStrB();
            Schema schOld = oldNm == null ? null : this.oldDb_.getSchema(oldNm);
            Schema schNew = newNm == null ? null : this.newDb_.getSchema(newNm);
            this.schPairs_.add(new SchemaPair(schOld, schNew));
        }
        Collections.sort(this.schPairs_);
    }

    private void refreshTableMatchesSimple() {
        this.tblPairsMap_ = new HashMap();
        for (Schema designSch : this.newDb_.values(Schema.getClassName())) {
            Schema svrSch = null;
            String designSchNm = designSch.getName();
            svrSch = this.oldDb_.contains(Schema.getClassName(), designSchNm) ? this.oldDb_.getSchema(designSchNm) : this.oldDb_.getSchema("schemaA");
            SchemaPair schPair = new SchemaPair(svrSch, designSch);
            this.matchTablesDisp(schPair);
        }
    }

    private void refreshTableMatches() {
        this.tblPairsMap_ = new HashMap();
        for (SchemaPair schPair : this.getSchemaPairs(true)) {
            this.matchTablesDisp(schPair);
        }
        ArrayList<Table> extraDesignTbls = new ArrayList<Table>();
        ArrayList<Table> extraSvrTbls = new ArrayList<Table>();
        for (TablePair pair : this.tblPairsMap_.values()) {
            Table tblSvr = pair.getSvrTable();
            Table tblDesign = pair.getDesignTable();
            if (tblDesign == null) {
                extraSvrTbls.add(tblSvr);
            }
            if (tblSvr != null) continue;
            extraDesignTbls.add(tblDesign);
        }
        this.matchTransferredTables(extraSvrTbls, extraDesignTbls);
    }

    private void matchTablesDisp(SchemaPair schPair) {
        Schema schOld = schPair.getSvrSchema();
        Schema schNew = schPair.getDesignSchema();
        ArrayList oldTblNms = schOld != null ? StrHelper.checkLowerCaseSet(this.tblCaseSens_, schOld.getKeys(this.tblClz_)) : new ArrayList();
        ArrayList newTblNms = schNew != null ? StrHelper.checkLowerCaseSet(this.tblCaseSens_, schNew.getKeys(this.tblClz_)) : new ArrayList();
        ArrayList<String> usedOldNms = new ArrayList<String>();
        ArrayList<String> usedNewNms = new ArrayList<String>();
        ArrayList commonTblNms = new ArrayList(oldTblNms);
        commonTblNms.retainAll(newTblNms);
        for (String commonNm : commonTblNms) {
            TablePair pair = new TablePair(schOld.getTable(commonNm), schNew.getTable(commonNm));
            this.tblPairsMap_.put(pair.getName(), pair);
            usedOldNms.add(commonNm);
            usedNewNms.add(commonNm);
        }
        if (schNew != null) {
            RenameContext tblCtx = new RenameContext(this.tblClz_, schNew.getName(), this.schClz_, null, null);
            List renames = this.renameMgr_.getRenameMatches(tblCtx, oldTblNms, newTblNms, this.tblCaseSens_);
            for (Rename rename : renames) {
                TablePair pair = new TablePair(schOld.getTable(rename.getOldName()), schNew.getTable(rename.getNewName()));
                this.tblPairsMap_.put(pair.getName(), pair);
                usedOldNms.add(rename.getOldName());
                usedNewNms.add(rename.getNewName());
            }
        }
        List unusedNmPairs = this.getUnusedNmPairs(oldTblNms, newTblNms, usedOldNms, usedNewNms, this.tblCaseSens_);
        for (StringPair strPair : unusedNmPairs) {
            String newNm;
            Table tblNew;
            String oldNm = strPair.getStrA();
            Table tblOld = oldNm == null ? null : schOld.getTable(oldNm);
            TablePair pair = new TablePair(tblOld, tblNew = (newNm = strPair.getStrB()) == null ? null : schNew.getTable(newNm));
            if (this.tblPairsMap_.containsKey(pair.getName())) continue;
            this.tblPairsMap_.put(pair.getName(), pair);
        }
    }

    public void matchTransferredTables(List extraSvrTbls, List extraDesignTbls) {
        for (Table tblDesign : extraDesignTbls) {
            SchemaTransferHistory history = tblDesign.getSchemaTransferHistory();
            if (history.getTransferCount() <= 0) continue;
            boolean found = false;
            for (Table tblSvr : extraSvrTbls) {
                ITestResult result = history.getIsTransferredMatch(tblSvr, this.getSchemaPairs(false));
                if (result.getPassed()) {
                    TablePair pair = new TablePair(tblSvr, tblDesign);
                    pair.setWasTransferred(true);
                    this.tblPairsMap_.put(pair.getName(), pair);
                    this.tblPairsMap_.remove(tblSvr.getDotNote());
                    found = true;
                }
                if (found) continue;
                found = this.getRenamedTransferredMatch(tblSvr, tblDesign);
            }
        }
    }

    private boolean getRenamedTransferredMatch(Table tblSvr, Table tblDesign) {
        String svrTblNm = tblSvr.getName();
        String designTblNm = tblDesign.getName();
        Iterator itTrans = tblDesign.getSchemaTransferHistory().getTransferPairs().iterator();
        boolean found = false;
        while (!found && itTrans.hasNext()) {
            List renames;
            StringPair strPair = (StringPair)itTrans.next();
            String schOld = strPair.getStrA();
            String tblNmOld = strPair.getStrB();
            RenameContext tblCtx = new RenameContext(this.tblClz_, schOld, this.schClz_, null, null);
            ArrayList<String> oldTblNms = new ArrayList<String>();
            ArrayList<String> newTblNms = new ArrayList<String>();
            if (this.tblCaseSens_) {
                oldTblNms.add(svrTblNm);
                newTblNms.add(designTblNm);
            } else {
                oldTblNms.add(svrTblNm.toLowerCase());
                newTblNms.add(designTblNm.toLowerCase());
            }
            if ((renames = this.renameMgr_.getRenameMatches(tblCtx, oldTblNms, newTblNms, this.tblCaseSens_)).isEmpty()) continue;
            TablePair pair = new TablePair(tblSvr, tblDesign);
            pair.setWasTransferred(true);
            this.tblPairsMap_.put(pair.getName(), pair);
            this.tblPairsMap_.remove(tblSvr.getDotNote());
            found = true;
        }
        return found;
    }

    private void refreshColumnMatches() {
        this.colPairsMap_ = new HashMap();
        for (TablePair tblPair : this.getTablePairs(false)) {
            Table svrTbl = tblPair.getSvrTable();
            Table designTbl = tblPair.getDesignTable();
            ArrayList<ColumnPair> colPairsLocal = new ArrayList<ColumnPair>();
            List oldColNms = StrHelper.checkLowerCaseSet(this.colCaseSens_, svrTbl.getKeys(this.colClz_));
            List newColNms = StrHelper.checkLowerCaseSet(this.colCaseSens_, designTbl.getKeys(this.colClz_));
            ArrayList<String> usedOldNms = new ArrayList<String>();
            ArrayList<String> usedNewNms = new ArrayList<String>();
            ArrayList commonNms = new ArrayList(oldColNms);
            commonNms.retainAll(newColNms);
            for (String colNm : commonNms) {
                ColumnPair colPair = new ColumnPair(designTbl, svrTbl.getColumn(colNm), designTbl.getColumn(colNm));
                colPairsLocal.add(colPair);
                usedOldNms.add(colNm);
                usedNewNms.add(colNm);
            }
            RenameContext ctx = new RenameContext(this.colClz_, designTbl.getName(), this.tblClz_, designTbl.getSchema().getName(), this.schClz_);
            List renames = this.renameMgr_.getRenameMatches(ctx, oldColNms, newColNms, this.colCaseSens_);
            for (Rename rename : renames) {
                ColumnPair colPair = new ColumnPair(designTbl, svrTbl.getColumn(rename.getOldName()), designTbl.getColumn(rename.getNewName()));
                colPairsLocal.add(colPair);
                usedOldNms.add(rename.getOldName());
                usedNewNms.add(rename.getNewName());
            }
            List unusedNmPairs = this.getUnusedNmPairs(oldColNms, newColNms, usedOldNms, usedNewNms, this.colCaseSens_);
            for (StringPair strPair : unusedNmPairs) {
                String oldNm = strPair.getStrA();
                String newNm = strPair.getStrB();
                Column colOld = oldNm == null ? null : svrTbl.getColumn(oldNm);
                Column colNew = newNm == null ? null : designTbl.getColumn(newNm);
                ColumnPair colPair = new ColumnPair(designTbl, colOld, colNew);
                colPairsLocal.add(colPair);
            }
            this.colPairsMap_.put(designTbl.getDotNote(), colPairsLocal);
        }
    }

    public List getUnusedNmPairs(List allOldNms, List allNewNms, List usedOldNms, List usedNewNms, boolean caseSens) {
        ArrayList<StringPair> strPairs = new ArrayList<StringPair>();
        List notUsedOldNms = StrHelper.checkLowerCase(caseSens, allOldNms);
        List usedOldNmsChecked = StrHelper.checkLowerCase(caseSens, usedOldNms);
        notUsedOldNms.removeAll(usedOldNmsChecked);
        for (String nm : notUsedOldNms) {
            strPairs.add(new StringPair(nm, null));
        }
        List notUsedNewNms = StrHelper.checkLowerCase(caseSens, allNewNms);
        List usedNewNmsChecked = StrHelper.checkLowerCase(caseSens, usedNewNms);
        notUsedNewNms.removeAll(usedNewNmsChecked);
        for (String nm : notUsedNewNms) {
            strPairs.add(new StringPair(null, nm));
        }
        return strPairs;
    }

    public List getSchemaPairs(boolean inclNulls) {
        return this.getPairsDisp(this.schPairs_, inclNulls);
    }

    public List getTablePairs(boolean inclNulls) {
        ArrayList tablePairs = new ArrayList(this.tblPairsMap_.values());
        Collections.sort(tablePairs);
        return this.getPairsDisp(tablePairs, inclNulls);
    }

    public List getColumnPairs(Table tbl, boolean inclNulls) {
        List pairsList = (List)this.colPairsMap_.get(tbl.getDotNote());
        if (pairsList != null) {
            return this.getPairsDisp(pairsList, inclNulls);
        }
        return new ArrayList();
    }

    private List getPairsDisp(List idfPairs, boolean inclNulls) {
        if (inclNulls) {
            return new ArrayList(idfPairs);
        }
        ArrayList<IIdfPair> nonNulls = new ArrayList<IIdfPair>();
        for (IIdfPair pair : idfPairs) {
            if (pair.getHasNull()) continue;
            nonNulls.add(pair);
        }
        return nonNulls;
    }

    public SchemaPair getSchemaPair(String schNm) {
        return (SchemaPair)this.getPairDisp(this.getSchemaPairs(true), schNm);
    }

    public ColumnPair getColumnPair(Table tbl, String colNm) {
        return (ColumnPair)this.getPairDisp(this.getColumnPairs(tbl, true), colNm);
    }

    public TablePair getTablePair(Schema sch, String tblNm) {
        return (TablePair)this.getPairDisp(this.getTablePairs(true), StrHelper.getDotNote(sch.getName(), tblNm));
    }

    private IIdfPair getPairDisp(List idfPairs, String idfNm) {
        IIdfPair pairFound = null;
        Iterator it = idfPairs.iterator();
        while (pairFound == null && it.hasNext()) {
            IIdfPair pair = (IIdfPair)it.next();
            String pairNm = pair.getName();
            if (!pairNm.equalsIgnoreCase(idfNm)) continue;
            pairFound = pair;
        }
        return pairFound;
    }
}

