/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.script.builder;

import com.harrand.coreclasses.interfaces.IScript;
import com.harrand.coreclasses.interfaces.IStep;
import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.coreclasses.interfaces.implementation.BasicScript;
import com.harrand.coreclasses.interfaces.implementation.BasicStep;
import com.harrand.coreclasses.option.IOptionMgr;
import com.harrand.coreclasses.script.IScriptBuilder;
import com.harrand.dbwrench.jdbc.JdbcConfig;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.ForeignKey;
import com.harrand.dbwrench.object.PrimaryKey;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrench.script.JdbcScriptCtrl;
import com.harrand.dbwrench.script.builder.ScriptUtil;
import com.harrand.util.FileHelper;
import com.harrand.util.ResMgr;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class PrimaryKeyScriptBuilder
implements IScriptBuilder {
    private JdbcConfig config_;
    private Table table_;
    private int dbmsId_;
    private PrimaryKey oldPrimaryKey_;
    private PrimaryKey newPrimaryKey_;
    private IOptionMgr forEngOptMgr_ = null;
    private String newPrimaryKeyName_;
    private String className_;
    private String displayName_;
    private String nameSuffix_;

    public PrimaryKeyScriptBuilder(Table table, JdbcConfig config) {
        this.table_ = table;
        this.config_ = config;
        this.dbmsId_ = this.config_.getDbmsId();
        this.className_ = PrimaryKey.getClassName();
        this.displayName_ = this.table_.getDisplayName(this.className_);
    }

    @Override
    public IStep getStep(Identifiable oldItem, Identifiable newItem) {
        this.oldPrimaryKey_ = (PrimaryKey)oldItem;
        this.newPrimaryKey_ = (PrimaryKey)newItem;
        this.newPrimaryKeyName_ = this.newPrimaryKey_ != null ? this.newPrimaryKey_.getName() : "";
        this.nameSuffix_ = this.displayName_ + ": " + this.newPrimaryKeyName_;
        return this.buildStepDisp();
    }

    @Override
    public void setForEngOptMgr(IOptionMgr optionMgr) {
        this.forEngOptMgr_ = optionMgr;
    }

    private IStep buildStepDisp() {
        IStep step = null;
        if (this.oldPrimaryKey_ == null && this.newPrimaryKey_ == null) {
            return null;
        }
        if (this.oldPrimaryKey_ == null) {
            step = this.getAddStep(this.newPrimaryKey_);
        } else if (this.newPrimaryKey_ == null) {
            step = this.getRemoveStep();
        } else if (this.needsUpdate(this.oldPrimaryKey_, this.newPrimaryKey_)) {
            step = this.getUpdateStep();
        }
        return step;
    }

    @Override
    public boolean needsUpdate(Identifiable idfA, Identifiable idfB) {
        String csvB;
        if (idfA == null && idfB == null) {
            return false;
        }
        if (idfA == null) {
            return true;
        }
        if (idfB == null) {
            return true;
        }
        PrimaryKey pkA = (PrimaryKey)idfA;
        PrimaryKey pkB = (PrimaryKey)idfB;
        String csvA = pkA.getColumnsCsv().toLowerCase();
        return !csvA.equals(csvB = pkB.getColumnsCsv().toLowerCase());
    }

    private boolean msSqlSvrNeedsUpdate(PrimaryKey pkA, PrimaryKey pkB) {
        String nameA = pkA.getName();
        String nameB = pkB.getName();
        String firstLetterA = nameA.substring(0, 0).toLowerCase();
        String firstLetterB = nameA.substring(0, 0).toLowerCase();
        String tailA = nameA.length() > 1 ? pkA.getName().substring(1, nameA.length() - 1) : "";
        String tailB = nameB.length() > 1 ? pkB.getName().substring(1, nameB.length() - 1) : "";
        String newA = firstLetterA + tailA;
        String newB = firstLetterB + tailB;
        return !newA.endsWith(newB);
    }

    public Map getUpdateSteps(Table oldTbl, Table newTbl) {
        PrimaryKey newPk;
        HashMap<String, IStep> steps = new HashMap<String, IStep>();
        PrimaryKey oldPk = oldTbl != null ? oldTbl.getPrimaryKey() : null;
        boolean needsUpd = this.needsUpdate(oldPk, newPk = newTbl != null ? newTbl.getPrimaryKey() : null);
        if (!needsUpd) {
            return steps;
        }
        if (oldPk != null) {
            IStep dropStep = this.getStep(oldPk, null);
            steps.put("Remove Script", dropStep);
        }
        if (newPk != null) {
            IStep addStep = this.getStep(null, newPk);
            steps.put("Add Script", addStep);
        }
        return steps;
    }

    private String getSimpleComment(PrimaryKey pk) {
        String name = pk != null ? pk.getName() : "NULL";
        return this.table_.getDisplayName(this.className_) + ": " + name;
    }

    private IStep getAddStep(PrimaryKey pk) {
        if (this.config_.getDbms().getId() == 0 && this.table_.hasAutoNumberColumn()) {
            return null;
        }
        String execText = "ALTER TABLE " + this.getForEngNm(this.table_) + " ADD CONSTRAINT " + this.getForEngNm(pk) + "\n\tPRIMARY KEY (" + this.config_.getFormattedCsv(pk.getKeyColumnNames()) + ")";
        String addStr = ResMgr.getRes("add.label");
        BasicStep step = new BasicStep(addStr + " " + this.getSimpleComment(pk), execText);
        step.setComment(addStr + " " + this.displayName_);
        step.setLogEntry(ResMgr.getRes("added.label") + " " + this.getSimpleComment(pk));
        return step;
    }

    public IStep getRemoveStep() {
        String oldName = this.oldPrimaryKey_.getName();
        String execText = "";
        execText = this.dbmsId_ == 0 ? "ALTER TABLE " + this.getForEngNm(this.table_) + " DROP PRIMARY KEY" : "ALTER TABLE " + this.getForEngNm(this.table_) + " DROP CONSTRAINT " + this.getForEngNm(this.oldPrimaryKey_);
        String removeStr = ResMgr.getRes("remove.label");
        String stepNm = removeStr + " " + oldName;
        BasicStep step = new BasicStep(stepNm, execText);
        step.setComment(removeStr + " " + this.displayName_);
        step.setLogEntry(ResMgr.getRes("dropped.label") + " " + this.displayName_ + ": " + oldName);
        return step;
    }

    private IStep getUpdateStep() {
        BasicScript script = new BasicScript(FileHelper.getResource("update.label") + this.nameSuffix_);
        script.add(this.getRemoveStep());
        ScriptUtil.addNotNullStep(script, this.getAddStep(this.newPrimaryKey_));
        return script;
    }

    private String getForEngNm(Identifiable idf) {
        return this.config_.getForEngNm(idf);
    }

    public Map getPkAutoNumberSteps(Table oldTbl, Table newTbl) {
        boolean oldHasAuto = oldTbl.hasAutoNumberColumn();
        boolean newHasAuto = newTbl.hasAutoNumberColumn();
        Table tblOldForward = !oldHasAuto ? oldTbl : null;
        Table tblNewForward = !newHasAuto ? newTbl : null;
        Map stepsMap = this.getUpdateSteps(tblOldForward, tblNewForward);
        return stepsMap;
    }

    public static List getMySqlPkDependentFks(JdbcConfig config, Database oldDb, Database newDb, Table oldTable, Table newTable) {
        List affectedFks = new ArrayList();
        if (config.getDbmsId() == 0) {
            PrimaryKeyScriptBuilder pkBldr = new PrimaryKeyScriptBuilder(newTable, config);
            PrimaryKey oldPk = oldTable.getPrimaryKey();
            PrimaryKey newPk = newTable.getPrimaryKey();
            if (oldPk != null) {
                IStep pkStep = pkBldr.getStep(oldPk, newPk);
                if (pkStep == null) {
                    return affectedFks;
                }
                String execText = "";
                if (pkStep instanceof IScript) {
                    IScript script = (IScript)pkStep;
                    JdbcScriptCtrl scriptCtrl = new JdbcScriptCtrl();
                    execText = scriptCtrl.asRunnableText(script);
                } else {
                    execText = (String)pkStep.getExecuteObject();
                }
                if (execText.indexOf("DROP PRIMARY KEY") >= 0) {
                    List svrFksAffected = PrimaryKeyScriptBuilder.getMySqlPkAffectedFks(oldDb, oldTable, 0);
                    svrFksAffected.addAll(PrimaryKeyScriptBuilder.getMySqlPkAffectedFks(oldDb, oldTable, 1));
                    affectedFks = svrFksAffected;
                }
            }
        }
        return affectedFks;
    }

    private static List getMySqlPkAffectedFks(Database db, Table tbl, int relationId) {
        ArrayList<ForeignKey> affectedFks = new ArrayList<ForeignKey>();
        PrimaryKey pk = tbl.getPrimaryKey();
        if (pk != null) {
            ArrayList pkColNms = pk.getKeyColumnNames();
            List tableFks = db.getFkUtil().getFksForTable(tbl, relationId);
            for (ForeignKey fk : tableFks) {
                ArrayList fkCols = new ArrayList();
                if (relationId == 0) {
                    fkCols.addAll(fk.getParentColumnsOld());
                } else {
                    fkCols.addAll(fk.getChildColumnsOld());
                }
                fkCols.retainAll(pkColNms);
                if (fkCols.isEmpty()) continue;
                affectedFks.add(fk);
            }
        }
        return affectedFks;
    }
}

