/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.script.builder;

import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.interfaces.IStep;
import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.coreclasses.interfaces.implementation.BasicScript;
import com.harrand.coreclasses.interfaces.implementation.BasicStep;
import com.harrand.coreclasses.option.IOptionMgr;
import com.harrand.coreclasses.script.IScriptBuilder;
import com.harrand.coregui.option.BasicOptionMgr;
import com.harrand.dbwrench.jdbc.JdbcConfig;
import com.harrand.dbwrench.object.Index;
import com.harrand.dbwrench.object.Schema;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrench.script.builder.RenameScriptUtil;
import com.harrand.dbwrench.script.pair.SchemaPair;
import com.harrand.util.FileHelper;
import com.harrand.util.ResMgr;

public final class IndexScriptBuilder
implements IScriptBuilder {
    private final JdbcConfig config_;
    private final Table table_;
    private Index oldIndex_;
    private Index newIndex_;
    private IOptionMgr forEngOptMgr_ = null;
    private RenameScriptUtil renameScriptUtil;
    private String newIndexName_;
    private final String className_;
    private final String displayName_;
    private String nameSuffix_;

    public IndexScriptBuilder(Table table, JdbcConfig config) {
        this.table_ = table;
        this.config_ = config;
        this.className_ = Index.getClassName();
        this.displayName_ = this.table_.getDisplayName(this.className_);
    }

    @Override
    public void setForEngOptMgr(IOptionMgr optionMgr) {
        this.forEngOptMgr_ = optionMgr;
    }

    void setRenameScriptUtil(RenameScriptUtil renameScriptUtil) {
        this.renameScriptUtil = renameScriptUtil;
    }

    @Override
    public IStep getStep(Identifiable oldItem, Identifiable newItem) {
        this.oldIndex_ = (Index)oldItem;
        this.newIndex_ = (Index)newItem;
        this.newIndexName_ = this.newIndex_ != null ? this.newIndex_.getName() : "";
        this.nameSuffix_ = this.table_.getDisplayName(this.className_) + ": " + this.newIndexName_;
        return this.buildStepDisp();
    }

    private IStep buildStepDisp() {
        IStep step = null;
        if (!this.isScriptingOn()) {
            return null;
        }
        if (this.oldIndex_ == null && this.newIndex_ == null) {
            return null;
        }
        if (this.oldIndex_ == null) {
            step = this.getAddStep(this.newIndex_);
        } else if (this.newIndex_ == null) {
            step = this.getRemoveStep();
        } else if (this.needsUpdate(this.oldIndex_, this.newIndex_)) {
            step = this.getUpdateStep();
        }
        return step;
    }

    @Override
    public boolean needsUpdate(Identifiable idfA, Identifiable idfB) {
        if (idfA == null && idfB == null) {
            return false;
        }
        if (idfA == null) {
            return true;
        }
        if (idfB == null) {
            return true;
        }
        String execTextA = (String)this.getAddStep((Index)idfA).getExecuteObject();
        String execTextB = (String)this.getAddStep((Index)idfB).getExecuteObject();
        if (this.getIsCaseSensitive()) {
            return !execTextA.equals(execTextB);
        }
        return !execTextA.equalsIgnoreCase(execTextB);
    }

    private boolean getIsCaseSensitive() {
        return this.config_.supportsMixedCase();
    }

    private String getSimpleComment(Index index) {
        String name = index != null ? index.getName() : "NULL";
        return this.table_.getDisplayName(this.className_) + ": " + name;
    }

    private String getForEngNm(Identifiable idf) {
        return this.config_.getForEngNm(idf);
    }

    private IStep getAddStep(Index index) {
        String clusteredText = "";
        if (this.config_.supportsClusteredIndex()) {
            clusteredText = index.getClusteredFlag() ? " CLUSTERED" : " NONCLUSTERED";
        }
        String uniqueText = index.getUnique() ? " UNIQUE " : "";
        String fullTextText = index.getFullText() ? " FULLTEXT  " : "";
        String spatialText = index.getSpatial() ? " SPATIAL " : "";
        String preColumnDdlText = this.getPreColumnDdlText(index);
        String postColumnDdlText = this.getPostColumnDdlText(index);
        String execText = "CREATE" + uniqueText + fullTextText + spatialText + clusteredText + " INDEX " + this.getForEngNm(index) + " ON " + this.getForEngNm(this.table_) + preColumnDdlText + " (" + this.config_.getFormattedIndexColumnNamesCsv(index) + ")" + postColumnDdlText;
        execText = this.replaceUses(execText);
        execText = execText.replaceAll("  ", " ");
        execText = execText.replaceAll("  ", " ");
        BasicStep step = new BasicStep(FileHelper.getResource("add.label") + " " + this.getSimpleComment(index), execText);
        step.setLogEntry(ResMgr.getRes("added.label") + " " + this.nameSuffix_);
        return step;
    }

    private IStep getRemoveStep() {
        String execText;
        String oldName = this.oldIndex_.getName();
        Table oldTable = this.oldIndex_.getTable();
        Schema schDesign = this.table_.getSchema();
        Schema schSrv = oldTable.getSchema();
        boolean isSchemaRenamed = this.getIsSchemaRenamed(schSrv, schDesign);
        Schema schemaToUse = isSchemaRenamed ? schDesign : schSrv;
        String schPrefix = schemaToUse.getDbHasManySchemas() || this.getAlwaysPrependSchema() ? this.getForEngNm(schemaToUse) + "." : "";
        switch (this.config_.getDbmsId()) {
            case 1: {
                execText = "DROP INDEX " + schPrefix + this.getForEngNm(this.oldIndex_);
                break;
            }
            case 4: {
                execText = "DROP INDEX " + this.getForEngNm(this.oldIndex_);
                break;
            }
            case 0: {
                execText = "DROP INDEX " + oldName + " ON " + this.getForEngNm(oldTable);
                break;
            }
            default: {
                execText = "DROP INDEX " + this.getForEngNm(this.table_) + "." + oldName;
            }
        }
        BasicStep step = new BasicStep(FileHelper.getRes("remove.label") + " " + oldName, execText);
        step.setLogEntry(ResMgr.getRes("dropped.label") + " " + this.displayName_ + ": " + oldName);
        return step;
    }

    private IStep getUpdateStep() {
        BasicScript script = new BasicScript(FileHelper.getResource("update.label") + this.nameSuffix_);
        script.add(this.getRemoveStep());
        script.add(this.getAddStep(this.newIndex_));
        return script;
    }

    private boolean getAlwaysPrependSchema() {
        return this.forEngOptMgr_.getBoolValue("forward.engineer.always.prepend.schema");
    }

    private boolean isScriptingOn() {
        return BasicOptionMgr.getBoolValueSafe(this.forEngOptMgr_, "forward.engineer.indexes", true);
    }

    private boolean getIsSchemaRenamed(Schema schSrv, Schema schDesign) {
        if (this.renameScriptUtil == null) {
            return false;
        }
        SchemaPair schPair = this.renameScriptUtil.getSchemaPair(schDesign.getName());
        return schPair.getWasRenamed(this.getIsCaseSensitive());
    }

    private String getPreColumnDdlText(Index index) {
        String optionText = index.getOptionText();
        if (this.config_.isPsql() && optionText.length() > 0) {
            return " " + index.getOptionText();
        }
        return "";
    }

    private String getPostColumnDdlText(Index index) {
        String optionText = index.getOptionText();
        if (!this.config_.isPsql() && optionText.length() > 0) {
            return " " + index.getOptionText();
        }
        return "";
    }

    private String replaceUses(String execText) {
        return StrHelper.replacAllIgnoreCase(execText, "uses", "USING");
    }
}

