/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.script.builder;

import com.harrand.coreclasses.element.StringPair;
import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.interfaces.IScript;
import com.harrand.coreclasses.interfaces.IStep;
import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.coreclasses.interfaces.implementation.BasicScript;
import com.harrand.coreclasses.interfaces.implementation.BasicStep;
import com.harrand.coreclasses.option.IOptionMgr;
import com.harrand.coreclasses.script.IScriptBuilder;
import com.harrand.coregui.option.BasicOptionMgr;
import com.harrand.dbwrench.jdbc.JdbcConfig;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.ForeignKey;
import com.harrand.dbwrench.object.Index;
import com.harrand.dbwrench.object.PrimaryKey;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrench.script.JdbcScriptCtrl;
import com.harrand.dbwrench.script.builder.CommentScriptBldr;
import com.harrand.dbwrench.script.builder.PrimaryKeyScriptBuilder;
import com.harrand.dbwrench.script.builder.RenameScriptUtil;
import com.harrand.dbwrench.script.builder.ScriptUtil;
import com.harrand.dbwrench.script.builder.TableScriptBuilder;
import com.harrand.dbwrench.script.misc.MySQL_DependentFkCtrl;
import com.harrand.dbwrench.script.pair.TablePair;
import com.harrand.dbwrench.security.App;
import com.harrand.util.FileHelper;
import com.harrand.util.ResMgr;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class ForeignKeyScriptBuilder
implements IScriptBuilder {
    private JdbcConfig config_;
    private int dbmsId_;
    private Database db_;
    private ForeignKey oldForeignKey_;
    private ForeignKey newForeignKey_;
    private String newForeignKeyName_;
    private IOptionMgr forEngOptMgr_ = null;
    private TableScriptBuilder tblScriptBldr_ = null;
    private RenameScriptUtil renameScriptUtil_ = new RenameScriptUtil();
    private CommentScriptBldr commentBldr_;
    private JdbcScriptCtrl scriptCtrl_ = new JdbcScriptCtrl();
    private String className_;
    private String nameSuffix_;
    private String displayName_;
    private String fkClz_ = "ForeignKey";
    private boolean caseSens_ = false;

    public ForeignKeyScriptBuilder(Database db, JdbcConfig config) {
        this.db_ = db;
        this.config_ = config;
        this.dbmsId_ = this.config_.getDbmsId();
        this.className_ = ForeignKey.getClassName();
        this.displayName_ = this.db_.getDisplayName(this.className_);
        this.tblScriptBldr_ = new TableScriptBuilder(this.db_, this.config_);
        this.commentBldr_ = new CommentScriptBldr(this.config_);
        this.caseSens_ = this.config_.supportsMixedCaseTableName();
    }

    public void setRenameScriptUtil(RenameScriptUtil renameScriptUtil) {
        this.renameScriptUtil_ = renameScriptUtil;
    }

    public void setTableScriptBldr(TableScriptBuilder tblScriptBldr) {
        this.tblScriptBldr_ = tblScriptBldr;
    }

    @Override
    public IStep getStep(Identifiable oldItem, Identifiable newItem) {
        this.oldForeignKey_ = (ForeignKey)oldItem;
        this.newForeignKey_ = (ForeignKey)newItem;
        this.newForeignKeyName_ = this.newForeignKey_ != null ? this.newForeignKey_.getName() : "";
        this.nameSuffix_ = this.getSimpleComment(this.newForeignKey_);
        return this.buildStepDisp();
    }

    private IStep buildStepDisp() {
        IStep step = null;
        if (!this.isFkScriptingEnabled()) {
            return null;
        }
        if (this.oldForeignKey_ == null && this.newForeignKey_ == null) {
            return null;
        }
        if (this.config_.supportsForeignKey()) {
            if (this.oldForeignKey_ == null) {
                step = this.getAddStep(this.newForeignKey_);
            } else if (this.newForeignKey_ == null) {
                step = this.getRemoveStep();
            } else if (this.needsUpdate(this.oldForeignKey_, this.newForeignKey_)) {
                step = this.getUpdateStep();
            }
        }
        return step;
    }

    @Override
    public boolean needsUpdate(Identifiable idfA, Identifiable idfB) {
        if (idfA == null && idfB == null) {
            return false;
        }
        if (idfA == null) {
            return true;
        }
        if (idfB == null) {
            return true;
        }
        String execTextA = (String)this.getAddStep((ForeignKey)idfA).getExecuteObject();
        String execTextB = (String)this.getAddStep((ForeignKey)idfB).getExecuteObject();
        boolean needsUpdate = false;
        needsUpdate = this.config_.supportsMixedCase() && this.dbmsId_ != 0 ? !execTextA.equals(execTextB) : !execTextA.equalsIgnoreCase(execTextB);
        return needsUpdate;
    }

    @Override
    public void setForEngOptMgr(IOptionMgr optionMgr) {
        this.forEngOptMgr_ = optionMgr;
    }

    private String getForEngNm(Identifiable idf) {
        return this.config_.getForEngNm(idf);
    }

    private String getSimpleComment(ForeignKey fk) {
        String fkName = fk != null ? fk.getName() : "NULL";
        return this.db_.getDisplayName(this.className_) + ": " + fkName;
    }

    private List getCommentStepsMany(Table svrTbl, Table desTbl, Collection fksDrop, boolean tblRebuilt) {
        ArrayList<IStep> steps = new ArrayList<IStep>();
        if (this.dbmsId_ == 0 || this.dbmsId_ == 2) {
            return steps;
        }
        if (!this.isFkScriptingEnabled()) {
            return steps;
        }
        for (ForeignKey fkNew : desTbl.values(this.fkClz_)) {
            IStep step;
            String fkName = fkNew.getName();
            ForeignKey fkOld = null;
            if (!tblRebuilt && svrTbl != null) {
                fkOld = svrTbl.contains(this.fkClz_, fkName) ? svrTbl.getForeignKey(fkName) : null;
            }
            Table childTable = fkNew.getChdTbl();
            boolean isDropped = false;
            Iterator itDrops = fksDrop.iterator();
            while (itDrops.hasNext() && !isDropped) {
                ForeignKey fkDrop = (ForeignKey)itDrops.next();
                String dropDotNote = fkDrop.getDotNote();
                String fkDotNote = fkNew.getDotNote();
                isDropped = fkDotNote.equalsIgnoreCase(dropDotNote);
            }
            if (isDropped) {
                fkOld = null;
            }
            if ((step = this.commentBldr_.getStep(fkOld, fkNew, childTable)) == null) continue;
            steps.add(step);
        }
        ScriptUtil.addCmmToFirst(steps, "Set Foreign Key Comments");
        return steps;
    }

    private IStep getAddStep(ForeignKey fk) {
        String nm = ResMgr.getRes("add.label") + " " + this.nameSuffix_;
        String execText = "ALTER TABLE " + this.getForEngNm(fk.getChdTbl()) + " ADD CONSTRAINT " + this.getForEngNm(fk) + "\n\tFOREIGN KEY (" + this.config_.getFormattedCsv(fk.getChildColumnsOld()) + ") REFERENCES " + this.getForEngNm(fk.getParTbl()) + " (" + this.config_.getFormattedCsv(fk.getParentColumnsOld()) + ")" + this.getDeleteActionStr(fk);
        BasicStep fkStep = new BasicStep(nm, execText.trim());
        fkStep.setComment(nm);
        fkStep.setLogEntry(ResMgr.getRes("added.label") + " " + this.nameSuffix_);
        return fkStep;
    }

    private IStep getRemoveStep() {
        String fkOldName = this.getForEngNm(this.oldForeignKey_);
        String constraintStr = this.config_.getDbmsId() == 0 ? "FOREIGN KEY" : "CONSTRAINT";
        String execText = "ALTER TABLE " + this.getForEngNm(this.oldForeignKey_.getChdTbl()) + " DROP " + constraintStr + " " + fkOldName;
        BasicStep step = new BasicStep(ResMgr.getRes("remove.label") + " " + fkOldName, execText);
        step.setLogEntry(ResMgr.getRes("dropped.label") + " " + this.displayName_ + ": " + fkOldName);
        return step;
    }

    private IStep getUpdateStep() {
        BasicScript script = new BasicScript(FileHelper.getResource("update.label") + " " + this.nameSuffix_);
        script.add(this.getRemoveStep());
        script.add(this.getAddStep(this.newForeignKey_));
        if (script.hasSubSteps()) {
            return script;
        }
        return null;
    }

    private String getDeleteActionStr(ForeignKey fk) {
        String str = "";
        if (!this.config_.isMsAccess()) {
            String onUpdStr = "ON UPDATE " + fk.getUpdateActionStr() + " ";
            String onDelStr = "ON DELETE " + fk.getDeleteActionStr();
            if (this.config_.isOracle()) {
                onUpdStr = "";
                int onDelId = fk.getDeleteActionId();
                if (onDelId == 3) {
                    onDelStr = "";
                }
            }
            str = "\n\t" + onUpdStr + onDelStr;
        }
        return str;
    }

    private List getFksNeedUpdateName(List commonFkNms, Table svrTbl, Table desTbl) {
        ArrayList<String> needUpdateNames = new ArrayList<String>();
        for (String fkName : commonFkNms) {
            ForeignKey fkNew;
            ForeignKey fkOld = svrTbl.getForeignKey(fkName);
            if (!this.needsUpdate(fkOld, fkNew = desTbl.getForeignKey(fkName))) continue;
            needUpdateNames.add(fkName);
        }
        return needUpdateNames;
    }

    public List getMysqlRandomNmPairs(Table svrTbl, Table desTbl) {
        ArrayList<StringPair> matchedPairs = new ArrayList<StringPair>();
        List newDbFks = desTbl.values(this.fkClz_);
        List oldDbFks = svrTbl.values(this.fkClz_);
        for (ForeignKey oldFk : oldDbFks) {
            boolean found = false;
            Iterator newIt = newDbFks.iterator();
            while (!found && newIt.hasNext()) {
                ForeignKey newFk = (ForeignKey)newIt.next();
                if (!newFk.equalsMySqlOld(oldFk)) continue;
                found = true;
                StringPair pair = new StringPair(oldFk.getName().toLowerCase(), newFk.getName().toLowerCase());
                matchedPairs.add(pair);
            }
        }
        return matchedPairs;
    }

    private boolean usesRandomNames(Database oldDb) {
        boolean usesRandom = false;
        List fks = oldDb.getFkUtil().getAllFks();
        List fkNms = StrHelper.getNamedNms(fks);
        Collections.sort(fkNms);
        if (!fkNms.isEmpty()) {
            String firstFk = (String)fkNms.get(0);
            usesRandom = firstFk.indexOf("0_") == 0;
        }
        return usesRandom;
    }

    public Map getUpdateScripts(Database oldDb, Database newDb) {
        HashMap<String, Object> scripts = new HashMap<String, Object>();
        if (!this.isFkScriptingEnabled()) {
            scripts.put("Remove Script", null);
            scripts.put("Add Script", null);
        }
        return this.getUpdateScriptsRegular(oldDb, newDb);
    }

    public Map getUpdateScriptsRegular(Database oldDb, Database newDb) {
        HashMap<String, IScript> scripts = new HashMap<String, IScript>();
        boolean usesRandomNms = this.usesRandomNames(oldDb);
        ArrayList removeFksRaw = new ArrayList();
        ArrayList addFksRaw = new ArrayList();
        ArrayList dependentFksDropRaw = new ArrayList();
        ArrayList dependentFksReAddRaw = new ArrayList();
        ArrayList cmmSteps = new ArrayList();
        this.tblScriptBldr_.setRenameScriptUtil(this.renameScriptUtil_);
        List tblPairs = this.renameScriptUtil_.getTablePairs(true);
        for (TablePair tblPair : tblPairs) {
            Table svrTbl = tblPair.getSvrTable();
            Table desTbl = tblPair.getDesignTable();
            List randomFkNmPairs = usesRandomNms && !tblPair.getHasNull() ? this.getMysqlRandomNmPairs(svrTbl, desTbl) : null;
            List fksDrop = new ArrayList();
            Map addDropFksMap = this.getAddDropFks(oldDb, tblPair, randomFkNmPairs);
            if (addDropFksMap != null) {
                fksDrop = (List)addDropFksMap.get("Remove Script");
                removeFksRaw.addAll(fksDrop);
                addFksRaw.addAll((List)addDropFksMap.get("Add Script"));
            }
            boolean tblRebuilt = false;
            if (!tblPair.getHasNull()) {
                Map dependentFksMap = this.getDependentFks(this.tblScriptBldr_, oldDb, newDb, svrTbl, desTbl, randomFkNmPairs);
                Collection collRemove = (Collection)dependentFksMap.get("Remove Script");
                Collection collReAdd = (Collection)dependentFksMap.get("Add Script");
                dependentFksDropRaw.addAll(collRemove);
                dependentFksReAddRaw.addAll(collReAdd);
                boolean bl = tblRebuilt = !collRemove.isEmpty();
            }
            if (desTbl == null) continue;
            cmmSteps.addAll(this.getCommentStepsMany(svrTbl, desTbl, fksDrop, tblRebuilt));
        }
        removeFksRaw.addAll(dependentFksDropRaw);
        addFksRaw.addAll(dependentFksReAddRaw);
        List removeFks = this.removeDupFks(oldDb, removeFksRaw);
        List addFks = this.removeDupFks(newDb, addFksRaw);
        IScript removeManyScript = this.getRemoveManyScript(removeFks);
        IScript addManyScript = this.getAddManyScript(addFks);
        scripts.put("Remove Script", removeManyScript);
        scripts.put("Add Script", addManyScript);
        if (!cmmSteps.isEmpty()) {
            BasicScript cmmScript = new BasicScript("Foreign Key Comments");
            for (IStep cmmStep : cmmSteps) {
                cmmScript.add(cmmStep);
            }
            if (addManyScript != null) {
                ScriptUtil.addNotNullStep(addManyScript, cmmScript);
            } else {
                scripts.put("Add Script", cmmScript);
            }
        }
        return scripts;
    }

    public Map getAddDropFks(Database oldDb, TablePair tblPair, List randomFkNmPairs) {
        HashMap<String, List> addDropFksMap = new HashMap<String, List>();
        Table svrTbl = tblPair.getSvrTable();
        Table desTbl = tblPair.getDesignTable();
        ArrayList svrFkNms = svrTbl != null ? new ArrayList(svrTbl.getKeys(this.fkClz_)) : new ArrayList();
        ArrayList desFkNms = desTbl != null ? new ArrayList(desTbl.getKeys(this.fkClz_)) : new ArrayList();
        List fksOld = this.checkLowerCaseSet(svrFkNms);
        List fksNew = this.checkLowerCaseSet(desFkNms);
        if (fksOld.isEmpty() && fksNew.isEmpty()) {
            return null;
        }
        ArrayList fksCommon = new ArrayList(fksNew);
        fksCommon.retainAll(fksOld);
        ArrayList fksNotNeeded = new ArrayList(fksOld);
        ArrayList fksNewAdd = new ArrayList(fksNew);
        if (randomFkNmPairs != null) {
            fksNotNeeded.removeAll(StringPair.getItemList(randomFkNmPairs, 1));
            fksNewAdd.removeAll(StringPair.getItemList(randomFkNmPairs, 2));
        } else {
            fksNotNeeded.removeAll(fksNew);
            fksNewAdd.removeAll(fksOld);
        }
        HashSet fksDrop = new HashSet(fksNotNeeded);
        HashSet fksAdd = new HashSet(fksNewAdd);
        List fkNamesNeedingUpdate = this.getFksNeedUpdateName(fksCommon, svrTbl, desTbl);
        fksDrop.addAll(fkNamesNeedingUpdate);
        fksAdd.addAll(fkNamesNeedingUpdate);
        List fksDropObj = this.getFksFromNames(svrTbl, new ArrayList(fksDrop));
        List fksAddObj = this.getFksFromNames(desTbl, new ArrayList(fksAdd));
        addDropFksMap.put("Remove Script", fksDropObj);
        addDropFksMap.put("Add Script", fksAddObj);
        return addDropFksMap;
    }

    private Map getDependentFks(TableScriptBuilder tblScriptBldr, Database oldDb, Database newDb, Table svrTbl, Table desTbl, List randomFkNmPairs) {
        boolean isRebuilt;
        HashMap dependentMap = new HashMap();
        dependentMap.put("Remove Script", new ArrayList());
        dependentMap.put("Add Script", new ArrayList());
        List<ForeignKey> dependentFksOld = new ArrayList();
        List dependentFksNew = new ArrayList();
        String forEngTblNmLc = this.config_.getForEngNm(desTbl).toLowerCase();
        IStep tableStep = tblScriptBldr.getStep(svrTbl, desTbl);
        String execText = this.getExecText(tableStep).toLowerCase();
        boolean bl = isRebuilt = execText.indexOf("create table " + forEngTblNmLc + "\n") >= 0;
        if (isRebuilt) {
            dependentFksOld.addAll(oldDb.getFkUtil().getFksForTable(svrTbl, 1));
            dependentFksOld.addAll(oldDb.getFkUtil().getFksForTable(svrTbl, 0));
            dependentMap.put("Remove Script", dependentFksOld);
        } else if (this.dbmsId_ == 0) {
            dependentFksOld = PrimaryKeyScriptBuilder.getMySqlPkDependentFks(this.config_, oldDb, newDb, svrTbl, desTbl);
            List<ForeignKey> indexDependentFks = MySQL_DependentFkCtrl.getIndexDependentFks(this.config_, oldDb, newDb, svrTbl, desTbl);
            dependentFksOld.addAll(indexDependentFks);
            dependentMap.put("Remove Script", dependentFksOld);
        }
        boolean usesRandomNms = randomFkNmPairs != null;
        dependentFksNew = this.getMatchingNewFks(newDb, dependentFksOld, usesRandomNms);
        dependentMap.put("Add Script", dependentFksNew);
        return dependentMap;
    }

    private List removeDupFks(Database db, List fks) {
        ArrayList<ForeignKey> noDupsList = new ArrayList<ForeignKey>();
        HashSet<String> dotNoteSet = new HashSet<String>();
        for (ForeignKey fk : fks) {
            dotNoteSet.add(fk.getDotNote());
        }
        for (String dotNote : dotNoteSet) {
            ForeignKey fkOut = db.getFkUtil().getFkFromDotNote(dotNote);
            noDupsList.add(fkOut);
        }
        Collections.sort(noDupsList);
        return noDupsList;
    }

    private List getFksFromNames(Table tbl, List fkNames) {
        ArrayList namesSorted = new ArrayList(fkNames);
        Collections.sort(namesSorted, String.CASE_INSENSITIVE_ORDER);
        ArrayList<ForeignKey> fks = new ArrayList<ForeignKey>();
        Iterator it = namesSorted.iterator();
        while (it.hasNext()) {
            fks.add(tbl.getForeignKey((String)it.next()));
        }
        return fks;
    }

    private List getMatchingNewFks(Database newDb, List oldFks, boolean usesRandomFkNms) {
        ArrayList<ForeignKey> matchedFks = new ArrayList<ForeignKey>();
        for (ForeignKey oldFk : oldFks) {
            List randomFkNmPairs;
            StringPair strPair;
            String findNm;
            ForeignKey matchedFk = null;
            Table oldChdTbl = oldFk.getChdTbl();
            TablePair tblPair = this.renameScriptUtil_.getTablePair(oldChdTbl.getSchema(), oldChdTbl.getName());
            if (tblPair == null || tblPair.getHasNull()) continue;
            Table svrTbl = tblPair.getSvrTable();
            Table desTbl = tblPair.getDesignTable();
            String oldFkNm = oldFk.getName();
            String string = findNm = this.caseSens_ ? oldFkNm : oldFkNm.toLowerCase();
            if (usesRandomFkNms && (strPair = StringPair.getMatch(randomFkNmPairs = this.getMysqlRandomNmPairs(svrTbl, desTbl), oldFkNm, 1)) != null) {
                findNm = strPair.getStrB();
            }
            if (!desTbl.contains(this.fkClz_, findNm)) continue;
            matchedFk = desTbl.getForeignKey(findNm);
            matchedFks.add(matchedFk);
        }
        return matchedFks;
    }

    private List getNamesFromFks(List fks) {
        ArrayList<String> names = new ArrayList<String>();
        for (ForeignKey fk : fks) {
            names.add(fk.getName());
        }
        return names;
    }

    private String getExecText(IStep step) {
        String execText = "";
        if (step != null) {
            if (step instanceof IScript) {
                execText = this.scriptCtrl_.asRunnableText((IScript)step);
            } else {
                Object execObj = step.getExecuteObject();
                if (execObj instanceof String) {
                    execText = execObj.toString();
                }
            }
        }
        if (!this.config_.supportsMixedCase()) {
            execText = execText.toLowerCase();
        }
        return execText;
    }

    private List checkLowerCaseSet(Collection names) {
        if (this.dbmsId_ == 0 || this.dbmsId_ == 1 || this.config_.isOracle()) {
            ArrayList<String> lcList = new ArrayList<String>();
            Iterator it = names.iterator();
            while (it.hasNext()) {
                String lcStr = ((String)it.next()).toLowerCase();
                lcList.add(lcStr);
            }
            return lcList;
        }
        return new ArrayList(names);
    }

    public IScript getRemoveManyScript(Collection fks) {
        String removeFksNm = App.getRes("foreignKey.remove.comment");
        BasicScript script = new BasicScript(removeFksNm, "\n" + StrHelper.getSectionStringShort(removeFksNm));
        for (ForeignKey fk : fks) {
            IStep step = this.getStep(fk, null);
            ScriptUtil.addNotNullStep(script, step);
        }
        if (script.hasSubSteps()) {
            return script;
        }
        return null;
    }

    public IScript getAddManyScript(List fks) {
        String addFksNm = App.getRes("foreignKey.add.comment");
        BasicScript script = new BasicScript(addFksNm, "\n" + StrHelper.getSectionStringShort(addFksNm));
        for (ForeignKey fk : fks) {
            IStep step = this.getStep(null, fk);
            ScriptUtil.addNotNullStep(script, step);
        }
        if (script.hasSubSteps()) {
            return script;
        }
        return null;
    }

    public boolean hasIndexOrPk(Table table, String columnsCsv) {
        String pkCsv;
        PrimaryKey pk;
        boolean found = false;
        for (Index idx : table.values(Index.getClassName())) {
            String idxColsCsv = idx.getIndexColumnDdlTextsCSV();
            if (!columnsCsv.equalsIgnoreCase(idxColsCsv)) continue;
            found = true;
        }
        if (!found && (pk = table.getPrimaryKey()) != null && columnsCsv.equalsIgnoreCase(pkCsv = pk.getColumnsCsv())) {
            found = true;
        }
        return found;
    }

    private boolean isFkScriptingEnabled() {
        return BasicOptionMgr.getBoolValueSafe(this.forEngOptMgr_, "forward.engineer.foreignKeys", true);
    }
}

