/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.script.builder;

import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.interfaces.IScript;
import com.harrand.coreclasses.interfaces.implementation.BasicScript;
import com.harrand.dbwrench.jdbc.JdbcConfig;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.Proc;
import com.harrand.dbwrench.object.Schema;
import com.harrand.dbwrench.object.View;
import com.harrand.dbwrench.script.JdbcScriptCtrl;
import com.harrand.dbwrench.script.builder.ProcScriptBldr;
import com.harrand.dbwrench.script.builder.ScriptUtil;
import com.harrand.dbwrench.script.builder.ViewScriptBuilder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class DependentItemBldr {
    private JdbcConfig config_;
    private JdbcScriptCtrl scriptCtrl_ = new JdbcScriptCtrl();

    public DependentItemBldr(JdbcConfig config) {
        this.config_ = config;
    }

    public void addRebuildItemsScript(IScript dbScript, Database newDatabase) {
        if (this.config_.getDbmsId() == 1) {
            ArrayList rebuiltTableNames = new ArrayList();
            this.setRebuiltTableNames(dbScript, rebuiltTableNames);
            String scriptExecText = this.scriptCtrl_.asRunnableText(dbScript);
            List dependentProcs = this.getDependentProcs(newDatabase, rebuiltTableNames, scriptExecText);
            List dependentViews = this.getDependentViews(newDatabase, rebuiltTableNames, scriptExecText);
            this.addRebuildProcScript(dbScript, dependentProcs, newDatabase);
            this.addRebuildViewScript(dbScript, dependentViews, newDatabase);
        }
    }

    public void setRebuiltTableNames(IScript dbScript, List rebuiltTableNames) {
        for (Object obj : dbScript.values()) {
            if (!(obj instanceof IScript)) continue;
            IScript subScript = (IScript)obj;
            String scriptName = subScript.getName();
            if (scriptName.indexOf("Rebuild Table:") >= 0) {
                String tableName = scriptName.split(" ")[2];
                rebuiltTableNames.add(tableName.trim());
                continue;
            }
            this.setRebuiltTableNames(subScript, rebuiltTableNames);
        }
    }

    private List getDependentProcs(Database newDatabase, List rebuiltTableNames, String dbScriptText) {
        ArrayList<Proc> dependentProcs = new ArrayList<Proc>();
        for (Schema schema : newDatabase.values(Schema.getClassName())) {
            for (Proc proc : schema.values(Proc.getClassName())) {
                String procName = this.getForEngNm(proc);
                ArrayList<String> ddlCmds = new ArrayList<String>();
                ddlCmds.add("CREATE OR REPLACE function " + procName);
                ddlCmds.add("CREATE function " + procName);
                ddlCmds.add("DROP function " + procName);
                boolean inPreviousDdl = this.hasPreviousDdl(dbScriptText, ddlCmds);
                if (inPreviousDdl || !this.getSrcRefsTable(proc.getSrc(), rebuiltTableNames)) continue;
                dependentProcs.add(proc);
            }
        }
        return dependentProcs;
    }

    private List getDependentViews(Database newDatabase, List rebuiltTableNames, String dbScriptText) {
        ArrayList<View> dependentViews = new ArrayList<View>();
        for (Schema schema : newDatabase.values(Schema.getClassName())) {
            for (View view : schema.values(View.getClassName())) {
                String sql;
                String viewName = this.getForEngNm(view);
                ArrayList<String> ddlCmds = new ArrayList<String>();
                ddlCmds.add("CREATE VIEW " + viewName);
                ddlCmds.add("DROP VIEW " + viewName);
                ddlCmds.add("CREATE VIEW " + schema.getName() + "." + viewName);
                ddlCmds.add("DROP VIEW " + schema.getName() + "." + viewName);
                boolean inPreviousDdl = this.hasPreviousDdl(dbScriptText, ddlCmds);
                if (inPreviousDdl || !this.getSrcRefsTable(sql = view.getSql(), rebuiltTableNames)) continue;
                dependentViews.add(view);
            }
        }
        return dependentViews;
    }

    private boolean getSrcRefsTable(String rawSrc, List rebuiltTableNames) {
        String cleanSrc = StrHelper.removePunctuation(rawSrc).toLowerCase();
        boolean found = false;
        Iterator itNames = rebuiltTableNames.iterator();
        while (!found && itNames.hasNext()) {
            String tableName = " " + (String)itNames.next() + " ";
            if (cleanSrc.indexOf(tableName.toLowerCase()) < 0) continue;
            found = true;
        }
        return found;
    }

    private void addRebuildProcScript(IScript dbScript, List dependentProcs, Database db) {
        ProcScriptBldr scriptBldr = new ProcScriptBldr(db, this.config_);
        String pluralName = db.getDisplayPlural(Proc.getClassName());
        String comment = "\n" + StrHelper.getSectionStringShort("Rebuild Dependent Procedures");
        BasicScript rebuildScript = new BasicScript("Dependent Procedures", comment);
        for (Proc proc : dependentProcs) {
            rebuildScript.add(scriptBldr.getStep(null, proc));
        }
        if (rebuildScript.hasSubSteps()) {
            ScriptUtil.addNotNullStep(dbScript, rebuildScript);
        }
    }

    private void addRebuildViewScript(IScript dbScript, List dependentViews, Database db) {
        ViewScriptBuilder scriptBldr = new ViewScriptBuilder(db, this.config_);
        String pluralName = db.getDisplayPlural(View.getClassName());
        String comment = "\n" + StrHelper.getSectionStringShort("Rebuild Dependent Views");
        BasicScript rebuildScript = new BasicScript("Dependent Views", comment);
        for (View view : dependentViews) {
            rebuildScript.add(scriptBldr.getStep(null, view));
        }
        if (rebuildScript.hasSubSteps()) {
            ScriptUtil.addNotNullStep(dbScript, rebuildScript);
        }
    }

    private boolean hasPreviousDdl(String dbScriptText, List ddlsCmds) {
        boolean found = false;
        Iterator it = ddlsCmds.iterator();
        while (it.hasNext() && !found) {
            String ddl = (String)it.next();
            if (dbScriptText.indexOf(ddl) < 0) continue;
            found = true;
        }
        return found;
    }

    private String getForEngNm(Proc proc) {
        boolean doDblQuote = this.config_.getDbms().checkDblQuotePsqlNm(proc.getName());
        if (doDblQuote) {
            return StrHelper.getDblEnquotedBracketNm(proc.getName());
        }
        return proc.getName();
    }

    private String getForEngNm(View view) {
        return this.config_.getForEngNmMaybeDotNoted(view);
    }
}

