/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.script.builder;

import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.interfaces.IStep;
import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.coreclasses.interfaces.implementation.BasicScript;
import com.harrand.coreclasses.interfaces.implementation.BasicStep;
import com.harrand.coreclasses.option.IOptionMgr;
import com.harrand.coreclasses.script.IScriptBuilder;
import com.harrand.dbwrench.db.auto.sequence.AutoSequenceGenerator;
import com.harrand.dbwrench.db.auto.sequence.AutonumberDefaultValueGenerator;
import com.harrand.dbwrench.jdbc.IDataType;
import com.harrand.dbwrench.jdbc.JdbcConfig;
import com.harrand.dbwrench.naming.DbwNameBldrSvr;
import com.harrand.dbwrench.naming.SequenceNameBldr;
import com.harrand.dbwrench.object.Column;
import com.harrand.dbwrench.object.Schema;
import com.harrand.dbwrench.object.Sequence;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrench.script.builder.CommentScriptBldr;
import com.harrand.dbwrench.script.converter.IDataTypeConverter;
import com.harrand.util.FileHelper;
import com.harrand.util.LogUtil;
import com.harrand.util.ResMgr;
import com.harrand.util.Validator;

public final class ColumnScriptBuilder
implements IScriptBuilder {
    private JdbcConfig config_;
    private IDataTypeConverter typeConverter_;
    private Table table_;
    private Column oldColumn_;
    private Column newColumn_;
    private CommentScriptBldr commentBldr_;
    private String newColumnName_;
    private String className_ = Column.getClassName();
    private String displayName_;
    private String nameSuffix_;

    public ColumnScriptBuilder(Table table, JdbcConfig config) {
        this.setTable(table);
        this.config_ = config;
        this.typeConverter_ = config.getDataTypeConverter();
        this.commentBldr_ = new CommentScriptBldr(this.config_);
    }

    public void setTable(Table table) {
        this.table_ = table;
        this.displayName_ = this.table_.getDisplayName(this.className_);
    }

    @Override
    public void setForEngOptMgr(IOptionMgr optionMgr) {
    }

    @Override
    public IStep getStep(Identifiable oldItem, Identifiable newItem) {
        this.oldColumn_ = (Column)oldItem;
        this.newColumn_ = (Column)newItem;
        this.newColumnName_ = this.newColumn_ != null ? this.newColumn_.getName() : "";
        this.nameSuffix_ = this.table_.getDisplayName(this.className_) + ": " + this.newColumnName_;
        return this.buildStepDisp();
    }

    private IStep buildStepDisp() {
        IStep step = null;
        if (this.oldColumn_ == null && this.newColumn_ == null) {
            return null;
        }
        if (this.oldColumn_ == null) {
            step = this.getAddStep(this.newColumn_);
        } else if (this.newColumn_ == null) {
            step = this.getRemoveStep();
        } else if (this.needsUpdate(this.oldColumn_, this.newColumn_)) {
            step = this.getUpdateStep();
        }
        return step;
    }

    private String getForEngNm(Identifiable idf) {
        return this.config_.getForEngNm(idf);
    }

    @Override
    public boolean needsUpdate(Identifiable idfA, Identifiable idfB) {
        Column columnA = (Column)idfA;
        Column columnB = (Column)idfB;
        boolean equivalent = true;
        try {
            equivalent = this.typeConverter_.isEquivalent(columnA, columnB);
        }
        catch (Exception e) {
            LogUtil.logErr("ColumnScriptBldr error for: " + StrHelper.getNullSafeDotNote(this.table_) + ", col: " + StrHelper.getNullSafeName(idfA) + ". Error: " + e.getMessage());
        }
        return !equivalent;
    }

    private IStep getAddStep(Column column) {
        boolean isAutoNumber = column.getAutoNumber();
        boolean hasDefault = Validator.isStringValid(column.getDefault());
        if (this.isPsql()) {
            if (hasDefault && !isAutoNumber) {
                return this.getAddStepPsqlDefault(column);
            }
            if (!column.getIsNullable() && !isAutoNumber) {
                return this.getAddStepPsqlNotNull(column);
            }
        }
        String tblNm = this.getForEngNm(this.table_);
        String execText = "ALTER TABLE " + tblNm + " " + "ADD " + this.getDmoEmbedded(null, column);
        BasicStep step = new BasicStep(ResMgr.getRes("add.label") + " " + this.nameSuffix_, execText);
        step.setLogEntry(ResMgr.getRes("added.label") + " " + this.nameSuffix_);
        return step;
    }

    private IStep getAddStepPsqlNotNull(Column column) {
        String tblNm = this.getForEngNm(this.table_);
        String colNameFormatted = this.config_.getFormattedName(column);
        StringBuffer sbExec = new StringBuffer("ALTER TABLE " + tblNm + " " + "ADD COLUMN " + colNameFormatted + " " + this.getTypeSizeText(column) + ";\n");
        sbExec.append("ALTER TABLE " + tblNm + " " + "ALTER COLUMN " + colNameFormatted + " " + "SET NOT NULL;\n");
        String execText = sbExec.toString();
        BasicStep step = new BasicStep(ResMgr.getRes("add.label") + this.nameSuffix_, execText);
        step.setLogEntry(ResMgr.getRes("added.label") + " " + this.nameSuffix_);
        step.setComment("PostgreSQL does not support adding NOT NULL columns in a single command line.");
        return step;
    }

    private IStep getAddStepPsqlDefault(Column column) {
        String tblNm = this.getForEngNm(this.table_);
        String colNameFormatted = this.config_.getFormattedName(column);
        StringBuffer sbExec = new StringBuffer("ALTER TABLE " + tblNm + " " + "ADD COLUMN " + colNameFormatted + " " + this.getTypeSizeText(column) + ";\n");
        sbExec.append("UPDATE " + tblNm + " SET " + colNameFormatted + " = " + this.getFormattedDefaultValue(column) + ";\n");
        sbExec.append("ALTER TABLE " + tblNm + " " + "ALTER COLUMN " + colNameFormatted + " " + "SET " + this.getDefaultText(column) + ";\n");
        if (!column.getIsNullable()) {
            sbExec.append("ALTER TABLE " + tblNm + " " + "ALTER COLUMN " + colNameFormatted + " " + "SET NOT NULL;\n");
        }
        String execText = sbExec.toString();
        BasicStep step = new BasicStep(ResMgr.getRes("add.label") + this.nameSuffix_, execText);
        step.setLogEntry(ResMgr.getRes("added.label") + " " + this.nameSuffix_);
        step.setComment("PostgreSQL does not support adding a column with a default value in a single command line.");
        return step;
    }

    private IStep getRemoveStep() {
        String tblNm = this.getForEngNm(this.table_);
        String oldName = this.oldColumn_.getName();
        String dropDefaultText = "";
        if (this.config_.isSqlSvr() && this.oldColumn_.getDefaultNm().length() > 0) {
            dropDefaultText = "ALTER TABLE " + tblNm + " " + "DROP CONSTRAINT " + this.oldColumn_.getDefaultNm() + ";\n";
        }
        String execText = dropDefaultText + "ALTER TABLE " + tblNm + " " + "DROP COLUMN " + this.config_.getFormattedName(this.oldColumn_);
        BasicStep step = new BasicStep(FileHelper.getRes("remove.label") + " " + oldName, execText);
        step.setLogEntry(ResMgr.getRes("dropped.label") + " " + this.displayName_ + ": " + oldName);
        return step;
    }

    private String getUniqueText(Column col) {
        if (col.getUnique()) {
            return "UNIQUE";
        }
        return "";
    }

    private IStep getUpdateStep() {
        String title = FileHelper.getRes("update.label");
        BasicScript script = new BasicScript(title + this.nameSuffix_);
        return script;
    }

    public String getDmoEmbedded(Column oldColumn, Column newColumn) {
        String colName = this.config_.getFormattedName(newColumn);
        String dmo = this.config_.getDbms().getId() == 2 && newColumn.getAutoNumber() ? colName + " " + this.getAutoNumberText(newColumn) : colName + " " + this.getTypeSizeText(newColumn) + " " + this.getAutoNumberText(newColumn) + " " + this.getUniqueText(newColumn) + " " + this.getDefaultText(newColumn) + this.getCommentText(newColumn) + " " + newColumn.getIsNullableDesc();
        dmo = dmo.replaceAll("   ", " ");
        dmo = dmo.replaceAll("  ", " ");
        return dmo.trim();
    }

    private String getAutoNumberText(Column column) {
        if (column.getAutoNumber()) {
            return this.config_.getAutoNumberSql(column, 1, 1);
        }
        return "";
    }

    private String getTypeSizeText(Column column) {
        return this.typeConverter_.getDataTypeDmo(column);
    }

    public String getDefaultText(Column column) {
        String text = "";
        String tempDefaultValue = null;
        String originalDefaultStr = column.getDefault();
        boolean hasOriginalDefault = Validator.isStringValid(originalDefaultStr);
        if (this.isPsql() && column.getAutoNumber() && !hasOriginalDefault) {
            Sequence sequence = this.getAutoNumberSequence(column.getTable());
            tempDefaultValue = new AutonumberDefaultValueGenerator().getNewDefaulValue(sequence);
            column.setDefaultValue(tempDefaultValue);
        }
        String defaultStr = column.getDefault();
        boolean hasDefault = Validator.isStringValid(defaultStr);
        if (this.config_.getDbmsId() != 2 && hasDefault) {
            text = "DEFAULT " + this.getFormattedDefaultValue(column);
        }
        if (tempDefaultValue != null) {
            column.setDefaultValue(originalDefaultStr);
        }
        return text;
    }

    public Sequence getAutoNumberSequence(Table table) {
        SequenceNameBldr seqNameBuilder = (SequenceNameBldr)DbwNameBldrSvr.instance().getNameBldr("SequenceNameBldr");
        String sequenceName = seqNameBuilder.getFormedName(table);
        Schema schema = table.getSchema();
        if (schema.contains(Sequence.getClassName(), sequenceName)) {
            return schema.getSequence(sequenceName);
        }
        return new AutoSequenceGenerator().getAutogeneratedSequence(table);
    }

    public String getCommentText(Column newColumn) {
        String dmo = "";
        if (this.config_.getDbmsId() == 0) {
            dmo = this.commentBldr_.getMySqlColumnCommentDmo(null, newColumn);
        }
        return dmo;
    }

    private String getFormattedDefaultValue(Column column) {
        boolean isOldMySql;
        String defaultStr = column.getDefault();
        IDataType dataType = column.getDataType();
        String valueStr = defaultStr;
        int dbmsId = this.config_.getDbmsId();
        boolean bl = isOldMySql = this.config_.isMySql() && !this.config_.isMySql5();
        if (Validator.isStringValid(defaultStr) && dbmsId != 2) {
            if (column.getDataType().getId() == 16 && this.isPsql()) {
                if (defaultStr.equals("1")) {
                    defaultStr = "TRUE";
                } else if (defaultStr.equals("0")) {
                    defaultStr = "FALSE";
                }
            }
            valueStr = defaultStr.indexOf("`") == 0 && defaultStr.length() > 1 ? defaultStr.substring(1) : (this.isTrueOrFalse(dataType, defaultStr) ? defaultStr : (defaultStr.indexOf("()") >= 0 && !isOldMySql ? defaultStr : (this.isPsql() && defaultStr.indexOf("('") >= 0 ? defaultStr : (this.config_.isMySql() && this.isMySqlNonBracketFunction(defaultStr) ? defaultStr : (this.isOracleFunction(defaultStr) ? defaultStr : (StrHelper.isHexStr(defaultStr) ? defaultStr : (StrHelper.isNumeric(defaultStr) ? defaultStr : StrHelper.encloseSingleQuotes(defaultStr))))))));
        }
        return valueStr;
    }

    private boolean isOracleFunction(String defaultStr) {
        if (!this.isOracle()) {
            return false;
        }
        return defaultStr.equalsIgnoreCase("sysdate") || defaultStr.equalsIgnoreCase("null");
    }

    private boolean isMySqlNonBracketFunction(String defaultText) {
        switch (defaultText.toUpperCase()) {
            case "CURRENT_DATE": 
            case "CURRENT_TIMESTAMP": 
            case "CURRENT_TIME": {
                return true;
            }
        }
        return false;
    }

    private boolean isPsql() {
        return this.config_.isPsql();
    }

    private boolean isMySql() {
        return this.config_.isMySql();
    }

    private boolean isOracle() {
        return this.config_.isOracle();
    }

    private boolean isTrueOrFalse(IDataType dataType, String defaultStr) {
        boolean isBoolean;
        boolean bl = isBoolean = dataType.getId() == 16;
        return !(!isBoolean || !this.isMySql() && !this.isPsql() || !defaultStr.equalsIgnoreCase("TRUE") && !defaultStr.equalsIgnoreCase("FALSE"));
    }
}

