/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.script.alterColumnCtrl.checker;

import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.dbwrench.object.Column;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.DbHelper;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrench.script.alterColumnCtrl.checker.BasicAlterColChecker;
import com.harrand.util.Validator;

public final class SqlSvrAlterColChecker
extends BasicAlterColChecker {
    public SqlSvrAlterColChecker(Database svrDb) {
        this.svrDb = svrDb;
    }

    @Override
    public ITestResult canAlterColumn(Table svrTable, Table table, Column oldCol, Column newCol) {
        this.reset();
        if (Validator.isStringValid(oldCol.getDefault())) {
            this.addReason("Server column has a default value.");
        }
        if (Validator.isStringValid(newCol.getDefault())) {
            this.addReason("Design column has a default value.");
        }
        if (newCol.getAutoNumber()) {
            this.addReason("Is an autonumbered column.");
        }
        if (DbHelper.isColumnInPk(table, oldCol)) {
            this.addReason("Server column is in a primary key.");
        }
        if (DbHelper.isColumnInIndexes(table, oldCol)) {
            this.addReason("Server column is in index.");
        }
        if (DbHelper.isColumnInFks(this.svrDb, table, oldCol)) {
            this.addReason("Server column is in a foreign key.");
        }
        return super.getCanAlterResult(oldCol, newCol);
    }
}

