/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.script.alterColumnCtrl.checker;

import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.dbwrench.object.Column;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrench.script.alterColumnCtrl.checker.BasicAlterColChecker;
import com.harrand.dbwrench.script.alterColumnCtrl.checker.ColumnUsage;
import com.harrand.util.MathUtil;

public class PSqlAlterColChecker
extends BasicAlterColChecker {
    @Override
    public ITestResult canAlterColumn(Table svrTable, Table table, Column oldCol, Column newCol) {
        this.reset();
        Database db = table.getSchema().getDb();
        if (oldCol.getDataTypeId() != newCol.getDataTypeId()) {
            if (ColumnUsage.isColumnInAForeignKey(db, oldCol)) {
                this.addReason("Data type changed of a column used in a foreign key");
            }
            if (ColumnUsage.isColumnInAView(db, oldCol)) {
                this.addReason("Data type changed of a column used in a view");
            }
        }
        if (!MathUtil.isEquivalent(oldCol.getLength(), newCol.getLength())) {
            if (ColumnUsage.isColumnInAForeignKey(db, oldCol)) {
                this.addReason("Length changed of a column used in a foreign key");
            }
            if (ColumnUsage.isColumnInAView(db, oldCol)) {
                this.addReason("Length changed of a column used in a view");
            }
        }
        if (!MathUtil.isEquivalent(oldCol.getScale(), newCol.getScale())) {
            if (ColumnUsage.isColumnInAForeignKey(db, oldCol)) {
                this.addReason("Scale changed of a column used in a foreign key");
            }
            if (ColumnUsage.isColumnInAView(db, oldCol)) {
                this.addReason("Scale changed of a column used in a view");
            }
        }
        if (!MathUtil.isEquivalent(oldCol.getIsArray(), newCol.getIsArray())) {
            this.addReason("Data type 'is array' setting changed.");
        }
        return super.getCanAlterResult(oldCol, newCol);
    }
}

