/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.script.alterColumnCtrl;

import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.dbwrench.jdbc.JdbcConfig;
import com.harrand.dbwrench.object.Column;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrench.script.alterColumnCtrl.IAlterColumnCtrl;
import com.harrand.dbwrench.script.alterColumnCtrl.checker.PSqlAlterColChecker;
import com.harrand.dbwrench.script.builder.ColumnScriptBuilder;
import com.harrand.dbwrench.script.builder.SequenceScriptBldr;
import com.harrand.dbwrench.script.converter.PostgreSqlDataTypeConverter;
import java.util.Objects;

public final class PsqlAlterColumnCtrl
implements IAlterColumnCtrl {
    private final JdbcConfig config_;
    private final Database svrDb_;
    private final PostgreSqlDataTypeConverter typeConverter_;
    private SequenceScriptBldr seqScriptBldr_;

    public PsqlAlterColumnCtrl(JdbcConfig config, Database db, Database svrDb) {
        this.config_ = config;
        this.svrDb_ = svrDb;
        this.typeConverter_ = (PostgreSqlDataTypeConverter)this.config_.getDataTypeConverter();
    }

    @Override
    public ITestResult canAlterColumn(Table oldTable, Table newTable, Column oldCol, Column newCol) {
        PSqlAlterColChecker alterColChecker = new PSqlAlterColChecker();
        return alterColChecker.canAlterColumn(null, newTable, oldCol, newCol);
    }

    @Override
    public String getAlterColumnDmo(Table table, Column oldColumn, Column newColumn) {
        String dmoDefault;
        String dmoAutoNum;
        String dmoNull;
        String dmoDataType;
        StringBuilder sb = new StringBuilder();
        String dmoRename = this.getRenameColumnDmo(table, oldColumn, newColumn.getName());
        if (dmoRename.length() > 0) {
            sb.append(dmoRename);
        }
        if ((dmoDataType = this.getAlterDataType(table, oldColumn, newColumn)).length() > 0) {
            if (sb.length() > 0) {
                sb.append(";\n");
            }
            sb.append(dmoDataType);
        }
        if ((dmoNull = this.getAlterNullDmo(table, oldColumn, newColumn)).length() > 0) {
            if (sb.length() > 0) {
                sb.append(";\n");
            }
            sb.append(dmoNull);
        }
        if ((dmoAutoNum = this.getAlterAutoNumDmo(table, oldColumn, newColumn)).length() > 0) {
            if (sb.length() > 0) {
                sb.append(";\n");
            }
            sb.append(dmoAutoNum);
        }
        if ((dmoDefault = this.getAlterDefaultDmo(table, oldColumn, newColumn)).length() > 0) {
            if (sb.length() > 0) {
                sb.append(";\n");
            }
            sb.append(dmoDefault);
        }
        return sb.toString();
    }

    public void setSeqScriptBldr(SequenceScriptBldr seqScriptBldr) {
        this.seqScriptBldr_ = seqScriptBldr;
    }

    private String getAlterDataType(Table table, Column oldColumn, Column newColumn) {
        boolean isScaleChanged;
        String dmo = "";
        boolean isTypeChanged = oldColumn.getDataTypeId() != newColumn.getDataTypeId();
        boolean isLengthChanged = !Objects.equals(oldColumn.getLength(), newColumn.getLength());
        boolean bl = isScaleChanged = !Objects.equals(oldColumn.getScale(), newColumn.getLength());
        if (isTypeChanged || isLengthChanged || isScaleChanged) {
            dmo = "ALTER TABLE " + this.getForEngNm(table) + " " + "ALTER COLUMN" + " " + this.getFormattedName(newColumn.getName()) + " TYPE " + this.typeConverter_.getDataTypeDmo(newColumn);
        }
        return dmo;
    }

    private String getRenameColumnDmo(Table table, Column oldColumn, String newName) {
        String dmo = "";
        boolean checkCase = this.config_.supportsMixedCase();
        boolean isSame = StrHelper.isSame(oldColumn.getName(), newName, checkCase);
        if (!isSame) {
            String tblName = this.getForEngNm(table);
            String oldColNm = this.getForEngNm(oldColumn);
            String newColNm = this.getFormattedName(newName);
            dmo = "ALTER TABLE " + tblName + " RENAME " + oldColNm + " TO " + newColNm;
        }
        return dmo;
    }

    public String getFormattedName(String newName) {
        return this.config_.getFormattedName(newName);
    }

    private String getAlterNullDmo(Table table, Column oldColumn, Column newColumn) {
        StringBuffer sb = new StringBuffer("");
        if (oldColumn.getIsNullable() != newColumn.getIsNullable()) {
            sb.append(this.getAlterBaseDmo(table, newColumn));
            String nullDmo = newColumn.getIsNullable() ? "DROP NOT NULL" : "SET NOT NULL";
            sb.append(nullDmo);
        }
        return sb.toString();
    }

    private String getAlterDefaultDmo(Table table, Column oldColumn, Column newColumn) {
        StringBuffer sb = new StringBuffer("");
        String standardDefault = this.typeConverter_.getStandardizeDefault(oldColumn, newColumn);
        ColumnScriptBuilder columnScriptBldr_ = new ColumnScriptBuilder(table, this.config_);
        String newDefault = newColumn.getDefault();
        if (!standardDefault.equals(newDefault)) {
            sb.append(this.getAlterBaseDmo(table, newColumn));
            String defDmo = newDefault.length() == 0 ? "DROP DEFAULT" : "SET " + columnScriptBldr_.getDefaultText(newColumn);
            sb.append(defDmo);
        }
        return sb.toString();
    }

    private String getAlterAutoNumDmo(Table table, Column oldColumn, Column newColumn) {
        StringBuffer sb = new StringBuffer("");
        return sb.toString();
    }

    private String getAlterBaseDmo(Table table, Column newColumn) {
        StringBuffer sb = new StringBuffer("ALTER TABLE ");
        sb.append(this.getForEngNm(table) + " ");
        sb.append("ALTER COLUMN " + this.getForEngNm(newColumn) + " ");
        return sb.toString();
    }

    private String getForEngNm(Identifiable idf) {
        return this.config_.getForEngNm(idf);
    }
}

