/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.script.alterColumnCtrl;

import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.dbwrench.jdbc.IDataType;
import com.harrand.dbwrench.jdbc.JdbcConfig;
import com.harrand.dbwrench.object.Column;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrench.script.alterColumnCtrl.IAlterColumnCtrl;
import com.harrand.dbwrench.script.alterColumnCtrl.checker.OracleAlterColChecker;
import com.harrand.dbwrench.script.builder.ColumnScriptBuilder;
import com.harrand.dbwrench.script.converter.OracleDataTypeConverter;
import com.harrand.util.MathUtil;
import com.harrand.util.Validator;

public class OracleAlterColumnCtrl
implements IAlterColumnCtrl {
    private JdbcConfig config;
    private Database designDb_;
    private Database svrDb_;
    private OracleDataTypeConverter dataTypeConverter_ = new OracleDataTypeConverter();
    private ColumnScriptBuilder colScriptBldr;
    private Column oldColumn;
    private Column newColumn;
    private String defaultNote = "";

    public OracleAlterColumnCtrl(JdbcConfig config, Database designDb, Database svrDb) {
        this.config = config;
        this.designDb_ = designDb;
        this.svrDb_ = svrDb;
    }

    @Override
    public ITestResult canAlterColumn(Table oldTable, Table newTable, Column oldCol, Column newCol) {
        OracleAlterColChecker alterColChecker = new OracleAlterColChecker(this.designDb_, this.svrDb_);
        return alterColChecker.canAlterColumn(oldTable, newTable, oldCol, newCol);
    }

    @Override
    public String getAlterColumnDmo(Table designTable, Column oldColumn, Column newColumn) {
        this.colScriptBldr = new ColumnScriptBuilder(designTable, this.config);
        this.oldColumn = oldColumn;
        this.newColumn = newColumn;
        String dataTypeModifyStr = this.getDataTypeModifyStr();
        String nullModifyStr = this.getNullModifyStr();
        String defaultModifyStr = this.getDefaultModifyStr();
        boolean hasAlterableChanges = this.getHasAlterableChanges(dataTypeModifyStr, nullModifyStr, defaultModifyStr);
        String alterColStr = "";
        if (hasAlterableChanges) {
            alterColStr = "ALTER TABLE " + this.getForEngNm(designTable) + " MODIFY (" + this.getForEngNm(newColumn) + dataTypeModifyStr + defaultModifyStr + nullModifyStr + ")" + this.defaultNote;
        }
        return alterColStr;
    }

    private String getDataTypeModifyStr() {
        boolean lengthChanged;
        String modifyStr = "";
        IDataType oldDataType = this.oldColumn.getDataType();
        IDataType newDataType = this.newColumn.getDataType();
        boolean typeChanged = oldDataType.getId() != newDataType.getId();
        int compareValue = MathUtil.compareNullables(this.oldColumn.getLength(), this.newColumn.getLength());
        boolean bl = lengthChanged = compareValue != 0;
        if (typeChanged || lengthChanged) {
            modifyStr = " " + this.dataTypeConverter_.getDataTypeDmo(this.newColumn);
        }
        return modifyStr;
    }

    private String getForEngNm(Identifiable idf) {
        return this.config.getForEngNm(idf);
    }

    private String getNullModifyStr() {
        boolean changed;
        String modifyStr = "";
        boolean bl = changed = this.oldColumn.getIsNullable() != this.newColumn.getIsNullable();
        if (changed) {
            modifyStr = " " + this.newColumn.getIsNullableDesc();
        }
        return modifyStr;
    }

    private String getDefaultModifyStr() {
        boolean changed;
        String modifyStr = "";
        String newDefault = this.newColumn.getDefault();
        boolean bl = changed = !this.oldColumn.getDefault().equals(newDefault);
        if (changed) {
            boolean defaultRemoved = !Validator.isStringValid(newDefault);
            String defaultDmo = this.colScriptBldr.getDefaultText(this.newColumn);
            if (defaultRemoved) {
                defaultDmo = "DEFAULT NULL";
                this.defaultNote = "\n/* Oracle can not completely remove a column DEFAULT value, the best it can do is set it to NULL.\nIf you haven't done so, you should set the design DEFAULT value to NULL to sync with the oracle server database.*/";
            }
            modifyStr = " " + defaultDmo;
        }
        return modifyStr;
    }

    private boolean getHasAlterableChanges(String dataTypeModifyStr, String nullModifyStr, String defaultModifyStr) {
        return !nullModifyStr.isEmpty() || !dataTypeModifyStr.isEmpty() || !defaultModifyStr.isEmpty();
    }
}

