/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.script.alterColumnCtrl;

import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.dbwrench.jdbc.JdbcConfig;
import com.harrand.dbwrench.object.Column;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrench.script.alterColumnCtrl.IAlterColumnCtrl;
import com.harrand.dbwrench.script.alterColumnCtrl.checker.MySqlAlterColChecker;
import com.harrand.dbwrench.script.builder.ColumnScriptBuilder;

public final class MySqlAlterColumnCtrl
implements IAlterColumnCtrl {
    private JdbcConfig config_;
    private Database db_;
    private ColumnScriptBuilder colScriptBldr_ = null;

    public MySqlAlterColumnCtrl(JdbcConfig config, Database db) {
        this.config_ = config;
        this.db_ = db;
    }

    private void updateColScriptBldr(Table table) {
        if (this.colScriptBldr_ == null) {
            this.colScriptBldr_ = new ColumnScriptBuilder(table, this.config_);
        } else {
            this.colScriptBldr_.setTable(table);
        }
    }

    @Override
    public ITestResult canAlterColumn(Table oldTable, Table newTable, Column oldCol, Column newCol) {
        this.updateColScriptBldr(newTable);
        MySqlAlterColChecker alterColChecker = new MySqlAlterColChecker(this.db_);
        return alterColChecker.canAlterColumn(null, newTable, oldCol, newCol);
    }

    @Override
    public String getAlterColumnDmo(Table table, Column oldColumn, Column newColumn) {
        this.updateColScriptBldr(table);
        StringBuffer sb = new StringBuffer("ALTER TABLE ");
        sb.append(this.config_.getFormattedName(table) + " ");
        sb.append("CHANGE COLUMN " + this.config_.getFormattedName(oldColumn) + " ");
        String colDmo = this.colScriptBldr_.getDmoEmbedded(oldColumn, newColumn);
        sb.append(colDmo);
        return sb.toString();
    }

    private String getRenameColumnDmo(Table table, Column oldColumn, String newName) {
        this.updateColScriptBldr(table);
        String tblName = this.config_.getFormattedName(table);
        String oldColNm = this.config_.getFormattedName(oldColumn);
        String newColNm = this.config_.getFormattedName(newName);
        StringBuffer sb = new StringBuffer("ALTER TABLE ");
        sb.append(tblName + " ");
        sb.append("CHANGE COLUMN " + oldColNm + " ");
        String colDmo = this.colScriptBldr_.getDmoEmbedded(oldColumn, oldColumn);
        sb.append(colDmo.replaceFirst(oldColumn.getName(), newColNm));
        return sb.toString();
    }
}

