/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.script;

import com.harrand.coreclasses.dataEntry.DataEntryResult;
import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.dbwrench.security.App;
import java.sql.Connection;

public class TransactionCtrl {
    private boolean isInRollback_ = false;
    private boolean userAlerted_ = false;
    private boolean useTransaction_ = false;
    private String errMsg_ = null;
    private String sqlStr_ = null;
    public static final int MAX_ERR_LEN = 1000;
    public static final int MAX_SQL_LEN = 300;

    public TransactionCtrl() {
        this.reset();
    }

    public void setError(String errorMsg, String errorSql) {
        if (this.getUseTransaction()) {
            this.isInRollback_ = true;
            this.userAlerted_ = false;
            this.errMsg_ = errorMsg;
            this.sqlStr_ = errorSql;
        }
    }

    public ITestResult rollback(Connection conn) {
        DataEntryResult result = new DataEntryResult(true, "Rollback Completed", App.getRes("engineer.forward.milestone.rollback.complete"));
        try {
            conn.rollback();
        }
        catch (Exception e) {
            result = new DataEntryResult(true, "Error During Rollback", e.getMessage());
        }
        return result;
    }

    public void reset() {
        this.isInRollback_ = false;
        this.userAlerted_ = false;
    }

    public boolean getUseTransaction() {
        return this.useTransaction_;
    }

    public boolean getIsInRollback() {
        return this.isInRollback_;
    }

    public boolean getUserAlerted() {
        return this.userAlerted_;
    }

    public String getErrMsg() {
        return this.errMsg_;
    }

    public String getSqlStr() {
        return this.sqlStr_;
    }

    public void setUseTranaction(boolean useTransaction) {
        this.useTransaction_ = useTransaction;
    }

    public void setUserAlerted(boolean userAlerted) {
        this.userAlerted_ = userAlerted;
    }
}

