/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.option;

import com.harrand.coreclasses.option.BooleanOption;
import com.harrand.coreclasses.option.IOption;
import com.harrand.coreclasses.option.IOptionMgr;
import com.harrand.coreclasses.option.IOptionMgrSvr;
import com.harrand.coreclasses.option.IntegerOption;
import com.harrand.coreclasses.option.TextOption;
import com.harrand.coreclasses.security.IUser;
import com.harrand.coreclasses.xml.abstractions.IXmlable;
import com.harrand.coregui.option.BasicOptionMgr;
import com.harrand.coregui.option.BasicOptionMgrSvr;
import com.harrand.coregui.option.UserOptionMgr;
import com.harrand.dbwrench.diagram.relation.notation.erNotation.DbwErNotationFactory;
import com.harrand.dbwrench.diagram.table.fill.RectangleFillFactory;
import com.harrand.dbwrench.jdbc.BasicTypesSvr;
import com.harrand.dbwrench.jdbc.DataType;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class DbwOptionMgrSvr
implements IOptionMgrSvr {
    private final BasicOptionMgrSvr basicOptionMgrSvr_ = new BasicOptionMgrSvr();
    private final IUser user_;
    public static final String DB_EXPLORER_OPT_MGR = "db.explorer.option.mgr";
    public static final String FOR_ENG_OPT_MGR = "forward.engineer.option.mgr";
    public static final String DB_OPT_MGR = "db.option.mgr";
    public static final String DIAGRAM_OPT_MGR = "diagram.option.mgr";
    public static final String DT_OPT_MGR = "data.type.opt.mgr";
    public static final String TBL_DATA_VW_OPT_MGR = "tbl.data.view.opt.mgr";
    public static final String CONN_OPT_MGR = "conn.opt.mgr";
    public static final String PSQL_OPT_MGR = "psql.opt.mgr";
    public static final String SHOW_PROC_FOLDER = "db.explorer.show.proc.folder";
    public static final String SHOW_SEQUENCE_FOLDER = "db.explorer.show.sequence.folder";
    public static final String SHOW_CUSTOM_TYPE_FOLDER = "db.explorer.show.custom.type.folder";
    public static final String DEFAULT_COLUMNS_TO_NULL = "db.explorer.default.columns.to.null";
    public static final String AUTOSAVE = "db.explorer.autosave";
    public static final String FOR_ENG_FKS = "forward.engineer.foreignKeys";
    public static final String FOR_ENG_SCHS = "forward.engineer.schemas";
    public static final String FOR_ENG_SEQS = "forward.engineer.sequences";
    public static final String FOR_ENG_PROCS = "forward.engineer.procs";
    public static final String FOR_ENG_TRGS = "forward.engineer.triggers";
    public static final String FOR_ENG_IDXS = "forward.engineer.indexes";
    public static final String FOR_ENG_VIEWS = "forward.engineer.views";
    public static final String FOR_ENG_UC = "forward.engineer.unique.constraints";
    public static final String FOR_ENG_FILT_CONNS = "forward.engineer.filter.conn";
    public static final String FOR_ENG_ALWAYS_PREPEND_SCHEMA = "forward.engineer.always.prepend.schema";
    public static final String FOR_ENG_USE_TXN = "forward.engineer.z.use.transactions";
    public static final String TABLE_DEFAULT_USER_SORT = "table.default.sort.user";
    public static final String DIAGRAM_DEF_FONT_SIZE = "diagram.default.font.size";
    public static final String DIAGRAM_DEF_STRATEGY = "diagram.default.strategy";
    public static final String DIAGRAM_ER_NOTATION = "diagram.er.notation";
    public static final String DIAGRAM_DB_TABLE_RECTANGLE_FILL = "diagram.db.table.rectangle.fill";
    public static final String DIAGRAM_AUTO_SCRL_SPD = "diagram.auto.scroll.speed";
    public static final String DIAGRAM_QUICK_FK_SHOW_DIA_TBL_ONLY = "diagram.quick.fk.dia.tbls.only";
    public static final String DIAGRAM_SHOW_ALL_COLS = "diagram.show.all.cols";
    public static final String DIAGRAM_SHOW_AUTONUM = "diagram.show.autonum";
    public static final String DIAGRAM_SHOW_CMM = "diagram.show.comment";
    public static final String DIAGRAM_SHOW_DATATYPE = "diagram.show.datatype";
    public static final String DIAGRAM_SHOW_DEFAULT = "diagram.show.default";
    public static final String DIAGRAM_SHOW_ENUM = "diagram.show.enum";
    public static final String DIAGRAM_SHOW_FK_COLS = "diagram.show.fk.cols";
    public static final String DIAGRAM_SHOW_FK_NMS = "diagram.show.fk.nms";
    public static final String DIAGRAM_SHOW_LENGTH = "diagram.show.length";
    public static final String DIAGRAM_SHOW_NM = "diagram.show.name";
    public static final String DIAGRAM_SHOW_NULL = "diagram.show.null";
    public static final String DIAGRAM_SHOW_PK_COLS = "diagram.show.pk.cols";
    public static final String DIAGRAM_SHOW_SCHEMA = "diagram.show.schema";
    public static final String DIAGRAM_SHOW_SIGNED = "diagram.show.signed";
    public static final String DIAGRAM_DO_NOT_SHOW_SELECT_PARENT_MSG = "diagram.do.not.show.select.parent.msg";
    public static final String DT_AUTO_ENABLE = "dt.auto.enable.rev.eng";
    public static final String SPLIT_POS_DB_EXP_NV = "split.pos.db.exp.nv";
    public static final String SPLIT_POS_DB_EXP_PROP = "split.pos.db.exp.prop";
    public static final String SPLIT_POS_DB_EXP_TREE = "split.pos.db.exp.tree";
    public static final String SPLIT_POS_FOR_ENG_TREE = "split.pos.for.eng.tree";
    public static final String SPLIT_POS_FOR_ENG_LOG = "split.pos.for.eng.log";
    public static final String TBL_DATA_VW_CBO_FK = "tbl.data.vw.cbo.fk";
    public static final String PSQL_ENCLOSE_QUOTES = "psql.enclose.quotes";
    public static final String CONN_LAST_IDX = "last.conn.idx";

    public DbwOptionMgrSvr(IUser user) {
        this.user_ = user;
        this.loadDefaultOptionMgrs();
    }

    public void addOptionMgr(String key, IOptionMgr optionMgr) {
        this.basicOptionMgrSvr_.addOptionMgr(key, optionMgr);
    }

    @Override
    public IOptionMgr getOptionMgr(String key) {
        return this.basicOptionMgrSvr_.getOptionMgr(key);
    }

    public static DbwOptionMgrSvr fromXml(Element elmMgrs, IUser user) {
        UserOptionMgr optionMgr;
        int i;
        DbwOptionMgrSvr newMgrSvr = new DbwOptionMgrSvr(user);
        if (elmMgrs == null) {
            return newMgrSvr;
        }
        NodeList nodes = elmMgrs.getElementsByTagName(UserOptionMgr.clazz());
        for (i = 0; i < nodes.getLength(); ++i) {
            optionMgr = UserOptionMgr.fromXml((Element)nodes.item(i), user);
            String mgrName = optionMgr.getName();
            newMgrSvr.addOptionMgr(optionMgr.getName(), optionMgr);
            DbwOptionMgrSvr.addMissingOpts(user, newMgrSvr, optionMgr);
        }
        nodes = elmMgrs.getElementsByTagName(BasicOptionMgr.clazz());
        for (i = 0; i < nodes.getLength(); ++i) {
            optionMgr = UserOptionMgr.fromXml((Element)nodes.item(i), user);
            newMgrSvr.addOptionMgr(optionMgr.getName(), optionMgr);
            DbwOptionMgrSvr.addMissingOpts(user, newMgrSvr, optionMgr);
        }
        return newMgrSvr;
    }

    @Override
    public Element asXmlElement() {
        return this.basicOptionMgrSvr_.asXmlElement();
    }

    @Override
    public void setName(String newName) {
    }

    @Override
    public String getName() {
        return "DbwOptionMgrSvr";
    }

    private void loadDefaultOptionMgrs() {
        this.basicOptionMgrSvr_.addOptionMgr(DB_EXPLORER_OPT_MGR, this.getDefaultDbExplorerMgr());
        this.basicOptionMgrSvr_.addOptionMgr(FOR_ENG_OPT_MGR, this.getDefaultForEngMgr());
        this.basicOptionMgrSvr_.addOptionMgr(DB_OPT_MGR, this.getDefaultDbOptionMgr());
        this.basicOptionMgrSvr_.addOptionMgr(DIAGRAM_OPT_MGR, this.getDefaultDiagramMgr());
        this.basicOptionMgrSvr_.addOptionMgr(DT_OPT_MGR, this.getDefaultDataTypeOptionMgr());
        this.basicOptionMgrSvr_.addOptionMgr("splitter.pos.opt.mgr", this.getDefaultSplitPosOptionMgr());
        this.basicOptionMgrSvr_.addOptionMgr(TBL_DATA_VW_OPT_MGR, this.getDefaultTableDataViewerOptionMgr());
        this.basicOptionMgrSvr_.addOptionMgr(CONN_OPT_MGR, this.getDefaultConnectionOptionMgr());
        this.basicOptionMgrSvr_.addOptionMgr(PSQL_OPT_MGR, this.getDefaultPsqlOptMgr());
    }

    private IOptionMgr getDefaultDbExplorerMgr() {
        ArrayList<BooleanOption> options = new ArrayList<BooleanOption>();
        options.add(new BooleanOption(SHOW_PROC_FOLDER, true));
        options.add(new BooleanOption(SHOW_SEQUENCE_FOLDER, false));
        options.add(new BooleanOption(SHOW_CUSTOM_TYPE_FOLDER, false));
        options.add(new BooleanOption(DEFAULT_COLUMNS_TO_NULL, true));
        options.add(new BooleanOption(AUTOSAVE, true));
        UserOptionMgr optionMgr_ = new UserOptionMgr(DB_EXPLORER_OPT_MGR, options, this.user_);
        return optionMgr_;
    }

    private IOptionMgr getDefaultForEngMgr() {
        ArrayList<BooleanOption> options = new ArrayList<BooleanOption>();
        options.add(new BooleanOption(FOR_ENG_IDXS, true));
        options.add(new BooleanOption(FOR_ENG_FKS, true));
        options.add(new BooleanOption(FOR_ENG_SCHS, true));
        options.add(new BooleanOption(FOR_ENG_SEQS, true));
        options.add(new BooleanOption(FOR_ENG_PROCS, true));
        options.add(new BooleanOption(FOR_ENG_VIEWS, true));
        options.add(new BooleanOption(FOR_ENG_TRGS, true));
        options.add(new BooleanOption(FOR_ENG_UC, true));
        options.add(new BooleanOption(FOR_ENG_FILT_CONNS, false));
        options.add(new BooleanOption(FOR_ENG_USE_TXN, true));
        options.add(new BooleanOption(FOR_ENG_ALWAYS_PREPEND_SCHEMA, true));
        UserOptionMgr optionMgr_ = new UserOptionMgr(FOR_ENG_OPT_MGR, options, this.user_);
        return optionMgr_;
    }

    private IOptionMgr getDefaultDbOptionMgr() {
        ArrayList<BooleanOption> options = new ArrayList<BooleanOption>();
        options.add(new BooleanOption(TABLE_DEFAULT_USER_SORT, true));
        UserOptionMgr optionMgr_ = new UserOptionMgr(DB_OPT_MGR, options, this.user_);
        return optionMgr_;
    }

    private IOptionMgr getDefaultPsqlOptMgr() {
        ArrayList<BooleanOption> options = new ArrayList<BooleanOption>();
        options.add(new BooleanOption(PSQL_ENCLOSE_QUOTES, true));
        UserOptionMgr optionMgr_ = new UserOptionMgr(PSQL_OPT_MGR, options, this.user_);
        return optionMgr_;
    }

    private IOptionMgr getDefaultDiagramMgr() {
        ArrayList<IXmlable> options = new ArrayList<IXmlable>();
        int defaultFontSize = 11;
        options.add(new IntegerOption(DIAGRAM_DEF_FONT_SIZE, defaultFontSize));
        options.add(new TextOption(DIAGRAM_ER_NOTATION, DbwErNotationFactory.getInstance().getDefaultNotation().getName()));
        options.add(new IntegerOption(DIAGRAM_DEF_STRATEGY, 3));
        options.add(new TextOption(DIAGRAM_DB_TABLE_RECTANGLE_FILL, RectangleFillFactory.getInstance().getDefaultRectangleFill().getName()));
        options.add(new BooleanOption(DIAGRAM_SHOW_ALL_COLS, true));
        options.add(new BooleanOption(DIAGRAM_SHOW_AUTONUM, false));
        options.add(new BooleanOption(DIAGRAM_SHOW_CMM, false));
        options.add(new BooleanOption(DIAGRAM_SHOW_DATATYPE, true));
        options.add(new BooleanOption(DIAGRAM_SHOW_DEFAULT, false));
        options.add(new BooleanOption(DIAGRAM_SHOW_ENUM, false));
        options.add(new BooleanOption(DIAGRAM_SHOW_FK_COLS, true));
        options.add(new BooleanOption(DIAGRAM_SHOW_FK_NMS, true));
        options.add(new BooleanOption(DIAGRAM_SHOW_LENGTH, true));
        options.add(new BooleanOption(DIAGRAM_SHOW_NM, true));
        options.add(new BooleanOption(DIAGRAM_SHOW_NULL, false));
        options.add(new BooleanOption(DIAGRAM_SHOW_PK_COLS, true));
        options.add(new BooleanOption(DIAGRAM_SHOW_SCHEMA, false));
        options.add(new BooleanOption(DIAGRAM_SHOW_SIGNED, false));
        options.add(new IntegerOption(DIAGRAM_AUTO_SCRL_SPD, 4));
        options.add(new BooleanOption(DIAGRAM_QUICK_FK_SHOW_DIA_TBL_ONLY, false));
        options.add(new BooleanOption(DIAGRAM_DO_NOT_SHOW_SELECT_PARENT_MSG, false));
        UserOptionMgr optionMgr_ = new UserOptionMgr(DIAGRAM_OPT_MGR, options, this.user_);
        return optionMgr_;
    }

    private static void addMissingOpts(IUser user, DbwOptionMgrSvr newMgrSvr, IOptionMgr optionMgr) {
        String mgrName = optionMgr.getName();
        DbwOptionMgrSvr defaultMgrSvr = new DbwOptionMgrSvr(user);
        if (mgrName.equals(DB_EXPLORER_OPT_MGR) || mgrName.equals(FOR_ENG_OPT_MGR) || mgrName.equals(DIAGRAM_OPT_MGR) || mgrName.equals("editor.option.mgr") || mgrName.equals(DT_OPT_MGR) || mgrName.equals(TABLE_DEFAULT_USER_SORT)) {
            IOptionMgr genericMgr = defaultMgrSvr.getOptionMgr(mgrName);
            List xmlOptNames = optionMgr.getAllOptionNames();
            ArrayList<IOption> missingOptions = new ArrayList<IOption>();
            for (IOption defaultOpt : genericMgr.getAllOptions()) {
                if (xmlOptNames.contains(defaultOpt.getName())) continue;
                missingOptions.add(defaultOpt);
            }
            if (!missingOptions.isEmpty()) {
                ArrayList<IOption> allOptions = new ArrayList<IOption>(optionMgr.getAllOptions());
                allOptions.addAll(missingOptions);
                optionMgr = new UserOptionMgr(mgrName, allOptions, user);
                newMgrSvr.addOptionMgr(optionMgr.getName(), optionMgr);
            }
        }
    }

    private IOptionMgr getDefaultDataTypeOptionMgr() {
        ArrayList<BooleanOption> options = new ArrayList<BooleanOption>();
        this.addDataTypeOption(options, -5, true);
        this.addDataTypeOption(options, -2, true);
        this.addDataTypeOption(options, -7, true);
        this.addDataTypeOption(options, 2004, true);
        this.addDataTypeOption(options, 16, true);
        this.addDataTypeOption(options, 1, true);
        this.addDataTypeOption(options, 783, false);
        this.addDataTypeOption(options, 91, true);
        this.addDataTypeOption(options, 3, true);
        this.addDataTypeOption(options, 8, true);
        this.addDataTypeOption(options, 6, true);
        this.addDataTypeOption(options, 4, true);
        this.addDataTypeOption(options, 780, true);
        this.addDataTypeOption(options, 2, true);
        this.addDataTypeOption(options, 7, true);
        this.addDataTypeOption(options, 5, true);
        this.addDataTypeOption(options, 92, true);
        this.addDataTypeOption(options, 93, true);
        this.addDataTypeOption(options, -6, true);
        this.addDataTypeOption(options, -3, true);
        this.addDataTypeOption(options, 12, true);
        this.addDataTypeOption(options, 703, true);
        this.addDataTypeOption(options, 700, true);
        this.addDataTypeOption(options, 704, true);
        this.addDataTypeOption(options, 701, true);
        this.addDataTypeOption(options, 702, true);
        this.addDataTypeOption(options, 706, false);
        this.addDataTypeOption(options, 707, false);
        this.addDataTypeOption(options, 708, false);
        this.addDataTypeOption(options, 709, false);
        this.addDataTypeOption(options, 710, false);
        this.addDataTypeOption(options, 711, false);
        this.addDataTypeOption(options, 712, false);
        this.addDataTypeOption(options, 721, false);
        this.addDataTypeOption(options, 722, false);
        this.addDataTypeOption(options, 784, false);
        this.addDataTypeOption(options, 723, false);
        this.addDataTypeOption(options, 730, false);
        this.addDataTypeOption(options, 724, false);
        this.addDataTypeOption(options, 729, false);
        this.addDataTypeOption(options, 782, false);
        this.addDataTypeOption(options, 725, false);
        this.addDataTypeOption(options, 726, false);
        this.addDataTypeOption(options, 728, false);
        this.addDataTypeOption(options, 740, false);
        this.addDataTypeOption(options, 760, false);
        this.addDataTypeOption(options, 761, false);
        this.addDataTypeOption(options, 762, false);
        this.addDataTypeOption(options, 763, false);
        this.addDataTypeOption(options, 764, false);
        this.addDataTypeOption(options, 765, false);
        this.addDataTypeOption(options, 766, false);
        this.addDataTypeOption(options, 767, false);
        this.addDataTypeOption(options, 768, false);
        this.addDataTypeOption(options, 769, false);
        this.addDataTypeOption(options, 771, false);
        this.addDataTypeOption(options, 770, false);
        this.addDataTypeOption(options, 785, false);
        this.addDataTypeOption(options, 772, false);
        this.addDataTypeOption(options, 773, false);
        this.addDataTypeOption(options, 731, false);
        this.addDataTypeOption(options, 781, true);
        this.addDataTypeOption(options, 799, false);
        this.addDataTypeOption(options, 798, false);
        this.addDataTypeOption(options, 774, true);
        this.addDataTypeOption(options, 775, false);
        this.addDataTypeOption(options, 776, false);
        this.addDataTypeOption(options, 777, false);
        this.addDataTypeOption(options, 778, false);
        this.addDataTypeOption(options, 779, false);
        this.addDataTypeOption(options, 786, true);
        this.addDataTypeOption(options, 787, true);
        options.add(new BooleanOption(DT_AUTO_ENABLE, true));
        UserOptionMgr optionMgr_ = new UserOptionMgr(DT_OPT_MGR, options, this.user_);
        return optionMgr_;
    }

    private IOptionMgr getDefaultSplitPosOptionMgr() {
        ArrayList options = new ArrayList();
        this.addSplitPosOption(options, SPLIT_POS_DB_EXP_NV, 465);
        this.addSplitPosOption(options, SPLIT_POS_DB_EXP_PROP, 350);
        this.addSplitPosOption(options, SPLIT_POS_DB_EXP_TREE, 180);
        this.addSplitPosOption(options, SPLIT_POS_FOR_ENG_TREE, 210);
        this.addSplitPosOption(options, SPLIT_POS_FOR_ENG_LOG, 280);
        this.addSplitPosOption(options, "split.pos.sql.comm.rslt", 210);
        UserOptionMgr optionMgr_ = new UserOptionMgr("splitter.pos.opt.mgr", options, this.user_);
        return optionMgr_;
    }

    private IOptionMgr getDefaultConnectionOptionMgr() {
        ArrayList<IntegerOption> options = new ArrayList<IntegerOption>();
        options.add(new IntegerOption(CONN_LAST_IDX, -1));
        UserOptionMgr optionMgr_ = new UserOptionMgr(CONN_OPT_MGR, options, this.user_);
        return optionMgr_;
    }

    private void addSplitPosOption(List options, String optNm, int value) {
        options.add(new IntegerOption(optNm, value));
    }

    private IOptionMgr getDefaultTableDataViewerOptionMgr() {
        ArrayList<BooleanOption> options = new ArrayList<BooleanOption>();
        options.add(new BooleanOption(TBL_DATA_VW_CBO_FK, true));
        UserOptionMgr optionMgr_ = new UserOptionMgr(TBL_DATA_VW_OPT_MGR, options, this.user_);
        return optionMgr_;
    }

    private void addDataTypeOption(List options, int dataTypeId, boolean enabled) {
        DataType type = BasicTypesSvr.instance().getType(dataTypeId);
        String idStr = Integer.toString(dataTypeId);
        options.add(new BooleanOption(idStr, type.getDesc(), enabled));
    }
}

