/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.object;

import com.harrand.coreclasses.element.IUniqueNm;
import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.interfaces.IConfirmRemove;
import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.coreclasses.text.escape.IStrEscapeCtrl;
import com.harrand.dbwrench.element.BaseSchemaObj;
import com.harrand.dbwrench.element.ISchemaObj;
import com.harrand.dbwrench.object.Schema;
import com.harrand.dbwrench.security.App;
import com.harrand.util.LogUtil;
import com.harrand.util.Validator;

public final class View
implements Identifiable,
ISchemaObj,
IUniqueNm,
IConfirmRemove {
    private final String name_;
    private final String sql_;
    private final BaseSchemaObj baseSchemeObj_ = new BaseSchemaObj();
    public static final String HD_NAME = "Name";
    public static final String HD_SQL = "SQL";

    public View(String name, String sql) throws Exception {
        View.validateInput(name, sql);
        this.name_ = name;
        this.sql_ = sql;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof View)) {
            return false;
        }
        View other = (View)o;
        if (!other.getName().equals(this.getName())) {
            return false;
        }
        return other.getSql().equals(this.getSql());
    }

    @Override
    public boolean getConfirmRemove() {
        return false;
    }

    public static String getClassName() {
        return "View";
    }

    @Override
    public String getName() {
        return this.name_;
    }

    @Override
    public void setName(String newName) {
        StrHelper.throwProgExcept("View.setName() not implemented.");
    }

    @Override
    public String getDisplayClzNm() {
        return this.getMapName();
    }

    @Override
    public String getDisplayClzPlural() {
        return this.getDisplayClzNm() + "s";
    }

    @Override
    public String getMapName() {
        return View.getClassName();
    }

    public String getSql() {
        return this.sql_;
    }

    public String toString() {
        return View.getClassName() + ": " + this.getName();
    }

    public String getSqlMaxLength(int maxLength) {
        String limitedSql = this.getSql();
        if (limitedSql.length() > maxLength) {
            limitedSql = limitedSql.substring(0, maxLength - 4) + " ...";
        }
        return limitedSql;
    }

    public String getDotNote() {
        return this.baseSchemeObj_.getDotNote(this);
    }

    public static void validateInput(String name, String sql) throws IllegalArgumentException {
        if (!Validator.isStringValid(name)) {
            throw new IllegalArgumentException(App.getResource("err.view.invalid.name"));
        }
        if (!Validator.isStringValid(sql)) {
            throw new IllegalArgumentException(App.getResource("err.view.sql.empty.msg"));
        }
    }

    @Override
    public Schema getSchema() {
        return this.baseSchemeObj_.getSchema();
    }

    @Override
    public void setSchema(Schema schema) {
        this.baseSchemeObj_.setSchema(schema);
    }

    @Override
    public String getForEngNm(String itemNm, boolean dbmsSupportsSchemas, boolean dblEnquoteOn, IStrEscapeCtrl strEscapeCtrl) {
        return this.baseSchemeObj_.getForEngNm(itemNm, dbmsSupportsSchemas, dblEnquoteOn, strEscapeCtrl);
    }

    @Override
    public ISchemaObj getDupSchemaNull() {
        try {
            View dupView = new View(this.getName(), this.getSql());
            return dupView;
        }
        catch (Exception e) {
            LogUtil.logErr("ViewDup err: " + e.getMessage());
            return null;
        }
    }

    @Override
    public String getUniqueNm() {
        return View.getClassName() + "." + this.getDotNote();
    }
}

