/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.object;

import com.harrand.coreclasses.element.IUniqueNm;
import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.interfaces.ICommentReadable;
import com.harrand.coreclasses.interfaces.IConfirmRemove;
import com.harrand.coreclasses.interfaces.IDotNotable;
import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.coreclasses.text.escape.IStrEscapeCtrl;
import com.harrand.dbwrench.element.BaseSchemaObj;
import com.harrand.dbwrench.element.ISchemaObj;
import com.harrand.dbwrench.object.Schema;
import com.harrand.util.LogUtil;
import com.harrand.util.Validator;

public final class Proc
implements Identifiable,
ICommentReadable,
ISchemaObj,
IDotNotable,
IUniqueNm,
IConfirmRemove {
    private String name_;
    private String src_;
    private String comment_;
    private BaseSchemaObj baseSchemeObj_ = new BaseSchemaObj();
    public static final String HD_NAME = "Name";
    public static final String HD_SRC = "Src";

    public Proc(String src, String comment, String defaultName) {
        this.src_ = src;
        this.name_ = defaultName;
        this.comment_ = comment != null ? comment : "";
        this.parseName();
        String parsedCmm = this.parseMySqlCmm();
        if (Validator.isStringValid(parsedCmm)) {
            this.comment_ = parsedCmm;
        }
    }

    public String getSrc() {
        return this.src_;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof Proc)) {
            return false;
        }
        Proc other = (Proc)o;
        if (!other.getName().equals(this.getName())) {
            return false;
        }
        if (!other.getComment().equals(this.getComment())) {
            return false;
        }
        return other.getSrc().equals(this.getSrc());
    }

    private void checkSchemaMatches() {
        String schNm;
        String extractedSchNm = this.extractSchemaNm();
        if (extractedSchNm != null && !extractedSchNm.equalsIgnoreCase(schNm = this.getSchema().getName())) {
            String errProcNm = "(" + schNm + ") '" + this.getName() + "'";
            LogUtil.logErr("Warning: The schema specified in the procedure source does \n\tnot match the schema to which the procedure was added.\n\t" + errProcNm);
        }
    }

    private String extractSchemaNm() {
        String schNm = null;
        String[] strs = this.name_.split("\\.");
        if (strs.length > 1) {
            String schNmRaw = strs[0];
            schNm = schNmRaw.replaceAll("\"", "");
            schNm = schNm.replaceAll("\\[", "");
            schNm = schNm.replaceAll("\\]", "");
        }
        return schNm;
    }

    private void parseName() {
        String parsedName = this.parseForPsql();
        if (parsedName == null) {
            parsedName = this.parseForSqlSvrMySql();
        }
        if (parsedName == null) {
            parsedName = this.parseForOracle();
        }
        if (parsedName == null) {
            parsedName = this.parseForMySql();
        }
        if (parsedName != null) {
            this.name_ = parsedName;
        }
    }

    private String parseByItemNm(String itemNm) {
        String createText;
        String parsedName = null;
        String noCmmSrc = StrHelper.removeComments(this.getSrc());
        String lcText = noCmmSrc.toLowerCase();
        int createStart = this.getIndexOf(lcText, createText = itemNm);
        if (createStart < 0) {
            createText = "create " + itemNm;
            createStart = this.getIndexOf(lcText, createText);
        }
        if (createStart < 0) {
            createText = "replace " + itemNm;
            createStart = this.getIndexOf(lcText, createText);
        }
        int start = createStart >= 0 ? createStart + createText.length() : -1;
        int end = StrHelper.getClosingBracketPos(lcText, start);
        if (start > 0 && end > start) {
            parsedName = noCmmSrc.substring(start + 1, end + 1);
            parsedName = parsedName.trim();
            parsedName = StrHelper.removeFormatting(parsedName);
            parsedName = parsedName.replaceAll("\"", "");
        }
        return parsedName;
    }

    private String parseForPsql() {
        return this.parseByItemNm("Function".toLowerCase());
    }

    private String parseForMySql() {
        String parsedNm = null;
        parsedNm = this.parseByItemNm("Procedure".toLowerCase());
        if (parsedNm == null) {
            this.parseByItemNm("Function".toLowerCase());
        }
        return parsedNm;
    }

    private String parseForSqlSvrMySql() {
        int returnIdx;
        int start;
        int spaceIdx;
        String createText;
        String parsedName = null;
        String noCmmSrc = StrHelper.removeComments(this.getSrc());
        String lcText = (noCmmSrc = noCmmSrc.replaceAll("\\(", " ")).toLowerCase();
        int createStart = this.getIndexOf(lcText, createText = "create procedure");
        if (createStart < 0) {
            createText = "create proc";
            createStart = this.getIndexOf(lcText, createText);
        }
        if ((spaceIdx = lcText.indexOf(" ", (start = createStart >= 0 ? createStart + createText.length() : -1) + 1)) < 0) {
            spaceIdx = lcText.length();
        }
        if ((returnIdx = lcText.indexOf("\n", start + 1)) < 0) {
            returnIdx = lcText.length();
        }
        int end = Math.min(spaceIdx, returnIdx);
        if (start > 0 && end > start) {
            parsedName = noCmmSrc.substring(start + 1, end);
        }
        return parsedName;
    }

    private String parseForOracle() {
        String nm = this.parseByItemNm("Procedure".toLowerCase());
        if (nm != null) {
            nm = this.removeArgs(nm);
            nm = this.removeSchemaNm(nm);
        }
        return nm;
    }

    public String parseMySqlCmm() {
        int demarcLn;
        int cmmStart;
        int cmmEnd;
        String demarc = "comment '";
        String cmm = "";
        String srcLC = this.getSrc().toLowerCase();
        int demarcIdx = srcLC.indexOf(demarc);
        if (demarcIdx > 0 && (cmmEnd = srcLC.indexOf("'", cmmStart = demarcIdx + (demarcLn = demarc.length()))) > cmmStart) {
            cmm = this.getSrc().substring(cmmStart, cmmEnd);
        }
        return cmm;
    }

    private int getIndexOf(String srcStr, String findStr) {
        int startIdx = srcStr.indexOf(findStr + " ");
        if (startIdx == -1) {
            startIdx = srcStr.indexOf(findStr + "\n");
        }
        return startIdx;
    }

    @Override
    public boolean getConfirmRemove() {
        return false;
    }

    @Override
    public String getMapName() {
        return Proc.getClassName();
    }

    @Override
    public String getName() {
        return this.name_;
    }

    @Override
    public void setName(String newName) {
    }

    public static String getClassName() {
        return "Proc";
    }

    @Override
    public String getDisplayClzNm() {
        return this.getMapName();
    }

    @Override
    public String getDisplayClzPlural() {
        return this.getDisplayClzNm() + "s";
    }

    @Override
    public String getDotNote() {
        String dotNote = this.getName().indexOf(".") >= 0 ? this.getName() : this.baseSchemeObj_.getDotNote(this);
        return dotNote;
    }

    public String toString() {
        return Proc.getClassName() + ": " + this.getName() + "\nCmm: " + this.getComment() + "\nSrc:\n" + this.getSrc();
    }

    @Override
    public String getComment() {
        return this.comment_;
    }

    @Override
    public Schema getSchema() {
        return this.baseSchemeObj_.getSchema();
    }

    @Override
    public void setSchema(Schema schema) {
        this.baseSchemeObj_.setSchema(schema);
        this.checkSchemaMatches();
    }

    @Override
    public String getForEngNm(String itemNm, boolean dbmsSupportsSchemas, boolean dblEnquoteOn, IStrEscapeCtrl strEscapeCtrl) {
        return this.baseSchemeObj_.getForEngNm(itemNm, dbmsSupportsSchemas, dblEnquoteOn, strEscapeCtrl);
    }

    @Override
    public ISchemaObj getDupSchemaNull() {
        Proc dup = new Proc(this.getSrc(), this.getComment(), "");
        return dup;
    }

    @Override
    public String getUniqueNm() {
        return Proc.getClassName() + "." + this.getDotNote();
    }

    private String removeArgs(String nm) {
        String argLess = nm;
        int start = nm.indexOf("(");
        if (start > 0) {
            int len = nm.length();
            argLess = nm.substring(0, start).trim();
        }
        return argLess;
    }

    private String removeSchemaNm(String fullNm) {
        String schLess = fullNm;
        int start = fullNm.indexOf(".");
        if (start > 0) {
            schLess = fullNm.substring(start + 1).trim();
        }
        return schLess;
    }
}

