/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.object;

import com.harrand.coreclasses.nb.CentralLookup;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.dbwrench.object.Database;
import java.util.ArrayList;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.Utilities;

public class LookupUtil {
    public static void postDb(Database db) {
        Lookup.Template template = new Lookup.Template(Database.class);
        Object oldDbObj = null;
        CentralLookup cl = CentralLookup.getDefault();
        Lookup.Item item = cl.lookupItem(template);
        if (item != null) {
            oldDbObj = item.getInstance();
        }
        if (oldDbObj != null) {
            Database oldDb = (Database)oldDbObj;
            cl.remove(oldDb);
        }
        cl.add(db);
    }

    public static Database findDb() {
        Database db = null;
        Lookup.Template template = new Lookup.Template(Database.class);
        CentralLookup cl = CentralLookup.getDefault();
        Lookup.Item item = cl.lookupItem(template);
        if (item != null) {
            Object obj = item.getInstance();
            db = obj != null ? (Database)obj : null;
        }
        return db;
    }

    public static Database getLookupDb() {
        return (Database)CentralLookup.getDefault().lookup(Database.class);
    }

    public static final boolean isDbLookupUpdate(UpdateChain chain) {
        return chain.hasClassName(CentralLookup.class.getName()) || chain.hasClassName(Database.class.getName());
    }

    public static boolean hasDbChanged(Database oldDb) {
        Database currentDb = LookupUtil.getLookupDb();
        boolean areSame = false;
        areSame = currentDb != null ? currentDb.equals(oldDb) : oldDb == null;
        return !areSame;
    }

    public static final boolean isNewDbSet(Database oldDb, Database newDb) {
        boolean newSet = false;
        if (newDb != null) {
            newSet = !newDb.equals(oldDb);
        }
        return newSet;
    }

    public static Lookup.Result createLookupResult(Class objClass) {
        Lookup.Template template = new Lookup.Template(objClass);
        return Utilities.actionsGlobalContext().lookup(template);
    }

    public static Object getFirstInstance(LookupEvent evt) {
        Object obj = null;
        Lookup.Result r = (Lookup.Result)evt.getSource();
        int count = r.allItems().size();
        if (count > 0) {
            obj = new ArrayList(r.allInstances()).get(0);
        }
        return obj;
    }
}

