/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.object;

import com.harrand.coreclasses.interfaces.IConfirmRemove;
import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.dbwrench.element.ITableObj;
import com.harrand.dbwrench.object.Column;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrench.object.index.IIndexColumn;
import com.harrand.dbwrench.security.App;
import com.harrand.util.LogUtil;
import java.util.ArrayList;
import java.util.List;

public final class Index
implements Identifiable,
ITableObj,
IConfirmRemove {
    private String name_;
    private Table table_ = null;
    private boolean clusteredFlag_;
    private boolean unique_;
    private boolean fullText;
    private boolean spatial;
    private String optionText = "";
    private List<IIndexColumn> indexColumns = new ArrayList<IIndexColumn>();
    public static final String CLZ = "Index";
    public static final String HD_NAME = "Name";
    public static final String HD_COLUMNS = "Columns";
    public static final String HD_CLUSTERED = "Clustered";
    public static final String HD_UNIQUE = "Unique";
    public static final String HD_ID = "ID";
    public static final String HD_COLUMN_NAME = "ColumnName";
    public static final String LBL_USED_COLUMNS = App.getResource("index.columns.used.label");
    public static final String LBL_NOT_USED_COLUMNS = App.getResource("index.columns.unused.label");

    public Index(String theName, IIndexColumn column, boolean theClusteredFlag, boolean unique) throws Exception {
        ArrayList<IIndexColumn> columns = new ArrayList<IIndexColumn>();
        columns.add(column);
        this.initValues(theName, columns, theClusteredFlag, unique);
    }

    public Index(String theName, List<IIndexColumn> indexColumns, boolean theClusteredFlag, boolean unique) throws Exception {
        this.initValues(theName, indexColumns, theClusteredFlag, unique);
    }

    public Index clone() {
        Index clone = null;
        try {
            clone = new Index(this.getName(), this.getIndexColumns(), this.getClusteredFlag(), this.getUnique());
            clone.setFullText(this.getFullText());
            clone.setSpatial(this.getSpatial());
            clone.setOptionText(this.getOptionText());
        }
        catch (Exception ex) {
            LogUtil.logErr("Could not close index: " + this.getName() + ". Error: " + ex.getMessage());
        }
        return clone;
    }

    public Index getRenameDup(String newName) {
        Index dupIdx = this.clone();
        dupIdx.setName(newName);
        return dupIdx;
    }

    private void initValues(String theName, List<IIndexColumn> indexColumns, boolean theClusteredFlag, boolean unique) throws Exception {
        Index.isNameValid(theName);
        Index.isColumnNamesValid(indexColumns);
        this.name_ = theName;
        this.setIndexColumns(indexColumns);
        this.clusteredFlag_ = theClusteredFlag;
        this.unique_ = unique;
    }

    public void setIndexColumns(List<IIndexColumn> indexColumns) {
        this.indexColumns = indexColumns;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof Index)) {
            return false;
        }
        Index other = (Index)o;
        if (!other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getClusteredFlag() != this.getClusteredFlag()) {
            return false;
        }
        if (other.getUnique() != this.getUnique()) {
            return false;
        }
        if (!other.getIndexColumns().equals(this.getIndexColumns())) {
            return false;
        }
        if (other.getFullText() != this.getFullText()) {
            return false;
        }
        if (other.getSpatial() != this.getSpatial()) {
            return false;
        }
        return other.getOptionText().equals(this.getOptionText());
    }

    @Override
    public boolean getConfirmRemove() {
        return false;
    }

    public static String getClassName() {
        return CLZ;
    }

    public static String getClassNamePack() {
        return Index.getClassName();
    }

    public static String getClassAbbr() {
        return "idx";
    }

    @Override
    public String getName() {
        return this.name_;
    }

    @Override
    public void setName(String newName) {
        this.name_ = newName;
    }

    @Override
    public String getMapName() {
        return Index.getClassName();
    }

    public boolean getClusteredFlag() {
        return this.clusteredFlag_;
    }

    public boolean getUnique() {
        return this.unique_;
    }

    public int getColumnCount() {
        return this.indexColumns.size();
    }

    @Override
    public String getDisplayClzNm() {
        return this.getMapName();
    }

    @Override
    public String getDisplayClzPlural() {
        return this.getDisplayClzNm() + "es";
    }

    public IIndexColumn getIndexColumn(int i) {
        return this.indexColumns.get(i);
    }

    public boolean getClusteredFlag_() {
        return this.clusteredFlag_;
    }

    public void setClusteredFlag_(boolean clusteredFlag_) {
        this.clusteredFlag_ = clusteredFlag_;
    }

    public boolean getFullText() {
        return this.fullText;
    }

    public void setFullText(boolean fullText) {
        this.fullText = fullText;
    }

    public String getOptionText() {
        return this.optionText;
    }

    public void setOptionText(String optionText) {
        this.optionText = optionText;
    }

    public boolean getSpatial() {
        return this.spatial;
    }

    public void setSpatial(boolean spatial) {
        this.spatial = spatial;
    }

    public void setUnique(boolean unique) {
        this.unique_ = unique;
    }

    public String toString() {
        return this.getName() + ": " + this.getIndexColumnDdlTextsCSV() + ": Clustered = " + this.getClusteredFlag() + ", Unique = " + this.getUnique();
    }

    public List<Column> getColumns() {
        ArrayList<Column> columns = new ArrayList<Column>();
        for (IIndexColumn indexColumn : this.getIndexColumns()) {
            if (!(indexColumn instanceof Column)) continue;
            columns.add((Column)indexColumn);
        }
        return columns;
    }

    public List<IIndexColumn> getIndexColumns() {
        return new ArrayList<IIndexColumn>(this.indexColumns);
    }

    public List<String> getIndexColumnNames() {
        ArrayList<String> columnNames = new ArrayList<String>();
        for (IIndexColumn indexColumn : this.getIndexColumns()) {
            columnNames.add(indexColumn.getInIndexDdl());
        }
        return columnNames;
    }

    public boolean containsColumnName(String columnName) {
        return this.getIndexColumnNames().contains(columnName);
    }

    public Index getRenamedColumnInstance(String oldColumnName, Column newColumn) {
        int spot = this.getIndexColumnNames().indexOf(oldColumnName);
        IIndexColumn indexColumn = this.indexColumns.get(spot);
        this.indexColumns.remove(indexColumn);
        this.indexColumns.add(spot, newColumn);
        return this;
    }

    @Override
    public Table getTable() {
        return this.table_;
    }

    @Override
    public void setTable(Table tbl) {
        this.table_ = tbl;
    }

    @Override
    public ITableObj getDup() {
        return this.getRenameDup(this.getName());
    }

    public String getIndexColumnDdlTextsCSV() {
        StringBuilder buffer = new StringBuilder();
        for (IIndexColumn indexColumn : this.getIndexColumns()) {
            if (indexColumn == null) continue;
            if (buffer.length() > 0) {
                buffer.append(", ");
            }
            buffer.append(indexColumn.getInIndexDdl());
        }
        return buffer.toString();
    }

    public static int getTotalDbCount(Database db) {
        int count = 0;
        for (Table table : db.getAllTables()) {
            count += table.size(Index.getClassName());
        }
        return count;
    }

    public static void isNameValid(String theName) throws IllegalArgumentException {
        if (theName.length() <= 0) {
            throw new IllegalArgumentException(Index.getMsgInvalidName(theName));
        }
    }

    public static void isColumnNamesValid(List<IIndexColumn> indexColumns) throws IllegalArgumentException {
        if (indexColumns.size() <= 0) {
            throw new IllegalArgumentException(Index.getMsgInvalidColumnNames(indexColumns));
        }
    }

    private static String getMsgInvalidName(String theName) {
        return "The index name can not be an empty string.";
    }

    private static String getMsgInvalidColumnNames(List theColumnNames) {
        return "At least one column must be specified for an index, but " + theColumnNames.size() + " column were supplied";
    }
}

